/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.engine.script.internal;

import org.eclipse.birt.report.engine.api.EngineException;
import org.eclipse.birt.report.engine.api.script.eventhandler.IDynamicTextEventHandler;
import org.eclipse.birt.report.engine.api.script.instance.IDynamicTextInstance;
import org.eclipse.birt.report.engine.content.IContent;
import org.eclipse.birt.report.engine.executor.ExecutionContext;
import org.eclipse.birt.report.engine.ir.ReportItemDesign;
import org.eclipse.birt.report.engine.script.internal.ScriptExecutor;
import org.eclipse.birt.report.engine.script.internal.element.DynamicText;
import org.eclipse.birt.report.engine.script.internal.instance.DynamicTextInstance;
import org.eclipse.birt.report.engine.script.internal.instance.RunningState;
import org.eclipse.birt.report.model.api.TextDataHandle;

public class DynamicTextScriptExecutor
extends ScriptExecutor {
    public static void handleOnPrepare(TextDataHandle textDataHandle, ExecutionContext context) {
        try {
            DynamicText text = new DynamicText(textDataHandle);
            IDynamicTextEventHandler eh = DynamicTextScriptExecutor.getEventHandler(textDataHandle, context);
            if (eh != null) {
                eh.onPrepare(text, context.getReportContext());
            }
        }
        catch (Exception e) {
            DynamicTextScriptExecutor.addException(context, e);
        }
    }

    public static void handleOnCreate(IContent content, ExecutionContext context) {
        ReportItemDesign textItemDesign = (ReportItemDesign)content.getGenerateBy();
        if (!DynamicTextScriptExecutor.needOnCreate(textItemDesign)) {
            return;
        }
        try {
            IDynamicTextInstance text = DynamicTextScriptExecutor.createDynamicTextInstance(content, context, RunningState.CREATE);
            if (DynamicTextScriptExecutor.handleScript(text, textItemDesign.getOnCreate(), context).didRun()) {
                return;
            }
            IDynamicTextEventHandler eh = DynamicTextScriptExecutor.getEventHandler(textItemDesign, context);
            if (eh != null) {
                eh.onCreate(text, context.getReportContext());
            }
        }
        catch (Exception e) {
            DynamicTextScriptExecutor.addException(context, e, textItemDesign.getHandle());
        }
    }

    public static void handleOnRender(IContent content, ExecutionContext context) {
        ReportItemDesign textItemDesign = (ReportItemDesign)content.getGenerateBy();
        if (!DynamicTextScriptExecutor.needOnRender(textItemDesign)) {
            return;
        }
        try {
            IDynamicTextInstance text = DynamicTextScriptExecutor.createDynamicTextInstance(content, context, RunningState.RENDER);
            if (DynamicTextScriptExecutor.handleScript(text, textItemDesign.getOnRender(), context).didRun()) {
                return;
            }
            IDynamicTextEventHandler eh = DynamicTextScriptExecutor.getEventHandler(textItemDesign, context);
            if (eh != null) {
                eh.onRender(text, context.getReportContext());
            }
        }
        catch (Exception e) {
            DynamicTextScriptExecutor.addException(context, e, textItemDesign.getHandle());
        }
    }

    public static void handleOnPageBreak(IContent content, ExecutionContext context) {
        ReportItemDesign textItemDesign = (ReportItemDesign)content.getGenerateBy();
        if (!DynamicTextScriptExecutor.needOnPageBreak(textItemDesign, context)) {
            return;
        }
        try {
            IDynamicTextInstance text = DynamicTextScriptExecutor.createDynamicTextInstance(content, context, RunningState.PAGEBREAK);
            if (DynamicTextScriptExecutor.handleScript(text, textItemDesign.getOnPageBreak(), context).didRun()) {
                return;
            }
            IDynamicTextEventHandler eh = DynamicTextScriptExecutor.getEventHandler(textItemDesign, context);
            if (eh != null) {
                eh.onPageBreak(text, context.getReportContext());
            }
        }
        catch (Exception e) {
            DynamicTextScriptExecutor.addException(context, e, textItemDesign.getHandle());
        }
    }

    private static IDynamicTextInstance createDynamicTextInstance(IContent content, ExecutionContext context, RunningState runningState) {
        return new DynamicTextInstance(content, context, runningState);
    }

    private static IDynamicTextEventHandler getEventHandler(ReportItemDesign design, ExecutionContext context) {
        try {
            return (IDynamicTextEventHandler)DynamicTextScriptExecutor.getInstance(design, context);
        }
        catch (ClassCastException e) {
            DynamicTextScriptExecutor.addClassCastException(context, e, design.getHandle(), IDynamicTextEventHandler.class);
        }
        catch (EngineException e) {
            DynamicTextScriptExecutor.addException(context, e, design.getHandle());
        }
        return null;
    }

    private static IDynamicTextEventHandler getEventHandler(TextDataHandle handle, ExecutionContext context) {
        try {
            return (IDynamicTextEventHandler)DynamicTextScriptExecutor.getInstance(handle, context);
        }
        catch (ClassCastException e) {
            DynamicTextScriptExecutor.addClassCastException(context, e, handle, IDynamicTextEventHandler.class);
        }
        catch (EngineException e) {
            DynamicTextScriptExecutor.addException(context, e, handle);
        }
        return null;
    }
}

