/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.tutti.ui.swing.updater;

import fr.ifremer.tutti.ui.swing.updater.DeleteHelper;
import fr.ifremer.tutti.ui.swing.updater.UpdateModule;
import java.io.File;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.nio.file.attribute.PosixFilePermission;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashSet;
import java.util.List;

public class UpdaterFileSystemPathes {
    private static final String BACKUP_DIRECTORY_NAME = "OLD";
    private static final String UPDATE_DIRECTORY_NAME = "NEW";
    private static final String LAUNCHER_DIRECTORY_NAME = "launcher";
    private static final String EMBEDDED_DIRECTORY_NAME = "embedded";
    private static final String UPDATE_RUNTIME_CMD = "update_runtime";
    private static final String BATCH_WINDOWS_EXTENSION = ".bat";
    private static final String EXE_WINDOWS_EXTENSION = ".exe";
    private static final String BATCH_UNIX_EXTENSION = ".sh";
    private static final String VERSION_FILENAME = "version.appup";
    private final Path baseDir;
    private final boolean windowsOS;
    private final String backupDate;

    public UpdaterFileSystemPathes(Path baseDir) {
        this.baseDir = baseDir;
        this.windowsOS = System.getProperty("os.name").startsWith("Windows");
        this.backupDate = new SimpleDateFormat("yyyyMMddHHmmss").format(new Date());
    }

    public Path getUpdateDirectory() {
        Path updateDirectory = this.baseDir.resolve(UPDATE_DIRECTORY_NAME);
        return updateDirectory;
    }

    public Path getUpdateModulePath(UpdateModule updateModule) {
        Path modulePath = this.getUpdateDirectory().resolve(updateModule.name());
        return modulePath;
    }

    public boolean isUpdateModuleExists(UpdateModule updateModule) {
        Path updateModulePath = this.getUpdateModulePath(updateModule);
        boolean isDirectory = Files.isDirectory(updateModulePath, new LinkOption[0]);
        return isDirectory;
    }

    public String getUpdateModuleVersion(UpdateModule updateModule) throws IOException {
        Path updateModulePath = this.getUpdateModulePath(updateModule);
        String version = this.getVersion(updateModulePath);
        return version;
    }

    public Path getModulePath(UpdateModule updateModule) {
        Path modulePath = this.baseDir.resolve(updateModule.name());
        return modulePath;
    }

    public boolean isModuleExists(UpdateModule updateModule) {
        Path modulePath = this.getModulePath(updateModule);
        boolean isDirectory = Files.isDirectory(modulePath, new LinkOption[0]);
        return isDirectory;
    }

    public String getModuleVersion(UpdateModule updateModule) throws IOException {
        Path modulePath = this.getModulePath(updateModule);
        String version = this.getVersion(modulePath);
        return version;
    }

    public Path getUpdaterScriptPath() {
        String scriptFilename = UPDATE_RUNTIME_CMD + (this.windowsOS ? BATCH_WINDOWS_EXTENSION : BATCH_UNIX_EXTENSION);
        Path runtimeUpdater = this.baseDir.resolve(scriptFilename);
        return runtimeUpdater;
    }

    public void cleanObsoleteFiles() throws IOException {
        Path applicationDirectoryPath = this.getModulePath(UpdateModule.tutti);
        if (this.windowsOS) {
            DeleteHelper.deleteFiles(this.baseDir, "*.sh");
        } else {
            DeleteHelper.deleteFiles(this.baseDir, "*.bat");
            DeleteHelper.deleteFiles(this.baseDir, "*.exe");
        }
        DeleteHelper.deleteFiles(applicationDirectoryPath, "*.sh");
        DeleteHelper.deleteFiles(applicationDirectoryPath, "*.bat");
        DeleteHelper.deleteFiles(applicationDirectoryPath, "*.exe");
        DeleteHelper.deleteDirectory(applicationDirectoryPath.resolve(LAUNCHER_DIRECTORY_NAME));
        DeleteHelper.deleteDirectory(applicationDirectoryPath.resolve(EMBEDDED_DIRECTORY_NAME));
    }

    public void makeExecutable(Path path) throws IOException {
        if (!this.windowsOS) {
            HashSet<PosixFilePermission> perms = new HashSet<PosixFilePermission>();
            perms.add(PosixFilePermission.OWNER_READ);
            perms.add(PosixFilePermission.OWNER_WRITE);
            perms.add(PosixFilePermission.OWNER_EXECUTE);
            perms.add(PosixFilePermission.GROUP_READ);
            perms.add(PosixFilePermission.GROUP_WRITE);
            perms.add(PosixFilePermission.GROUP_EXECUTE);
            perms.add(PosixFilePermission.OTHERS_READ);
            perms.add(PosixFilePermission.OTHERS_EXECUTE);
            Files.setPosixFilePermissions(path, perms);
        }
    }

    public void removeOlderBackup(UpdateModule updateModule) throws IOException {
        String moduleName = updateModule.name();
        Path backupDirectory = this.getBackupDirectory();
        System.out.println(String.format("%s Clean backup directory %s", updateModule.getModuleLoggerName(), backupDirectory + File.separator + moduleName + "-*"));
        DeleteHelper.deleteDirectories(backupDirectory, moduleName + "-*");
    }

    public void backupModule(UpdateModule updateModule, String version) throws IOException {
        Path modulePath = this.getModulePath(updateModule);
        String moduleName = updateModule.name();
        Path backupDirectory = this.getBackupDirectory();
        Path backupModulePath = backupDirectory.resolve(String.format("%s-%s-%s", moduleName, version, this.backupDate));
        System.out.println(String.format("%s Backup old version %s to %s", updateModule.getModuleLoggerName(), version, backupModulePath));
        Files.move(modulePath, backupModulePath, new CopyOption[0]);
    }

    private Path getBackupDirectory() throws IOException {
        Path backupDirectory = this.baseDir.resolve(BACKUP_DIRECTORY_NAME);
        if (!Files.isDirectory(backupDirectory, new LinkOption[0])) {
            Files.createDirectory(backupDirectory, new FileAttribute[0]);
        }
        return backupDirectory;
    }

    private String getVersion(Path path) throws IOException {
        Path versionFile = path.resolve(VERSION_FILENAME);
        List<String> lines = Files.readAllLines(versionFile, StandardCharsets.UTF_8);
        if (lines == null || lines.isEmpty()) {
            throw new IOException(versionFile.toString() + " is empty");
        }
        return lines.get(0);
    }
}

