/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.tutti.ui.swing.launcher;

import fr.ifremer.tutti.ui.swing.launcher.ExitCode;
import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class JavaCommand {
    private static final String DEBUG_JAVA_OPTS = "-agentlib:jdwp=transport=dt_socket,server=y,suspend=y,address=%s";
    private final int debugPort;
    private final Path javaCommand;
    private final List<String> preJarArguments;
    private final List<String> postJarArguments;
    private Path jarPath;
    private boolean inheritIO;
    private boolean debug;
    private Path logFile;

    static JavaCommand create(Path basedir, int debugPort) {
        return new JavaCommand(basedir, debugPort);
    }

    static JavaCommand create(Path basedir) {
        return new JavaCommand(basedir, 8000);
    }

    protected JavaCommand(Path javaCommand, int debugPort) {
        this.javaCommand = javaCommand;
        this.debugPort = debugPort;
        this.preJarArguments = new ArrayList<String>();
        this.postJarArguments = new ArrayList<String>();
    }

    public JavaCommand setInheritIO(boolean inheritIO) {
        this.inheritIO = inheritIO;
        return this;
    }

    public JavaCommand setDebug(boolean debug) {
        this.debug = debug;
        return this;
    }

    public JavaCommand setJarPath(Path jarPath) {
        this.jarPath = jarPath;
        return this;
    }

    public JavaCommand setLogFile(Path logFile) {
        this.logFile = logFile;
        return this;
    }

    public JavaCommand addArgument(Object argument) {
        List<String> whereToAdd = this.jarPath == null ? this.preJarArguments : this.postJarArguments;
        whereToAdd.add(argument.toString());
        return this;
    }

    public JavaCommand addArguments(Object argument, Object ... arguments) {
        List<String> whereToAdd = this.jarPath == null ? this.preJarArguments : this.postJarArguments;
        whereToAdd.add(argument.toString());
        for (Object argument1 : arguments) {
            whereToAdd.add(argument1.toString());
        }
        return this;
    }

    public JavaCommand addArguments(Collection<?> arguments) {
        List<String> whereToAdd = this.jarPath == null ? this.preJarArguments : this.postJarArguments;
        for (Object argument : arguments) {
            whereToAdd.add(argument.toString());
        }
        return this;
    }

    public ExitCode execute() throws IOException, InterruptedException {
        if (this.jarPath == null) {
            throw new IllegalStateException("No jarPath given, can't execute.");
        }
        ArrayList<String> command = new ArrayList<String>();
        command.add(this.javaCommand.toString());
        command.addAll(this.preJarArguments);
        if (this.debug) {
            command.add(String.format(DEBUG_JAVA_OPTS, this.debugPort));
        }
        command.add("-jar");
        command.add(this.jarPath.toString());
        command.addAll(this.postJarArguments);
        ProcessBuilder pb = new ProcessBuilder(command);
        if (this.inheritIO) {
            pb.inheritIO();
        }
        if (this.logFile != null) {
            File updaterLogFile = this.logFile.toFile();
            pb.redirectOutput(ProcessBuilder.Redirect.to(updaterLogFile));
            pb.redirectError(ProcessBuilder.Redirect.appendTo(updaterLogFile));
        }
        System.out.println("Starts java command: " + command);
        int exitCode = pb.start().waitFor();
        return ExitCode.valueOf(exitCode);
    }
}

