/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.chart.model.attribute;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.Enumerator;

public enum TriggerFlow implements Enumerator
{
    CAPTURE_LITERAL(0, "Capture", "Capture"),
    BUBBLE_LITERAL(1, "Bubble", "Bubble"),
    BUBBLE_AND_STOP_LITERAL(2, "BubbleAndStop", "BubbleAndStop");

    public static final int CAPTURE = 0;
    public static final int BUBBLE = 1;
    public static final int BUBBLE_AND_STOP = 2;
    private static final TriggerFlow[] VALUES_ARRAY;
    public static final List<TriggerFlow> VALUES;
    private final int value;
    private final String name;
    private final String literal;

    static {
        VALUES_ARRAY = new TriggerFlow[]{CAPTURE_LITERAL, BUBBLE_LITERAL, BUBBLE_AND_STOP_LITERAL};
        VALUES = Collections.unmodifiableList(Arrays.asList(VALUES_ARRAY));
    }

    public static TriggerFlow get(String literal) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            TriggerFlow result = VALUES_ARRAY[i];
            if (result.toString().equals(literal)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static TriggerFlow getByName(String name) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            TriggerFlow result = VALUES_ARRAY[i];
            if (result.getName().equals(name)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static TriggerFlow get(int value) {
        switch (value) {
            case 0: {
                return CAPTURE_LITERAL;
            }
            case 1: {
                return BUBBLE_LITERAL;
            }
            case 2: {
                return BUBBLE_AND_STOP_LITERAL;
            }
        }
        return null;
    }

    private TriggerFlow(int value, String name, String literal) {
        this.value = value;
        this.name = name;
        this.literal = literal;
    }

    public int getValue() {
        return this.value;
    }

    public String getName() {
        return this.name;
    }

    public String getLiteral() {
        return this.literal;
    }

    public String toString() {
        return this.literal;
    }
}

