package fr.ifremer.tutti.ui.swing.content.operation.catches.species.create;

/*
 * #%L
 * Tutti :: UI
 * $Id:$
 * $HeadURL:$
 * %%
 * Copyright (C) 2012 - 2015 Ifremer
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-3.0.html>.
 * #L%
 */

import fr.ifremer.tutti.persistence.entities.data.SampleCategoryModelEntry;
import fr.ifremer.tutti.persistence.entities.referential.CaracteristicQualitativeValue;
import fr.ifremer.tutti.persistence.entities.referential.Species;
import fr.ifremer.tutti.ui.swing.TuttiHelpBroker;
import fr.ifremer.tutti.ui.swing.content.operation.catches.EditCatchesUI;
import fr.ifremer.tutti.ui.swing.util.TuttiUI;
import fr.ifremer.tutti.ui.swing.util.TuttiUIUtil;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.GridBagConstraints;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JTextField;
import javax.swing.ListSelectionModel;
import jaxx.runtime.JAXXBinding;
import jaxx.runtime.JAXXContext;
import jaxx.runtime.JAXXObject;
import jaxx.runtime.JAXXObjectDescriptor;
import jaxx.runtime.JAXXUtil;
import jaxx.runtime.JAXXValidator;
import jaxx.runtime.SwingUtil;
import jaxx.runtime.binding.DefaultJAXXBinding;
import jaxx.runtime.context.DefaultJAXXContext;
import jaxx.runtime.swing.Table;
import jaxx.runtime.swing.editor.bean.BeanFilterableComboBox;
import jaxx.runtime.swing.help.JAXXHelpUI;
import jaxx.runtime.validator.swing.SwingValidator;
import jaxx.runtime.validator.swing.SwingValidatorUtil;
import jaxx.runtime.validator.swing.meta.Validator;
import jaxx.runtime.validator.swing.meta.ValidatorField;
import jaxx.runtime.validator.swing.ui.ImageValidationUI;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jdesktop.swingx.JXTable;
import org.nuiton.jaxx.widgets.number.NumberEditor;
import static jaxx.runtime.SwingUtil.getStringValue;
import static org.nuiton.i18n.I18n.t;

public class CreateSpeciesBatchUI extends JPanel implements JAXXHelpUI<TuttiHelpBroker>, TuttiUI<CreateSpeciesBatchUIModel, CreateSpeciesBatchUIHandler>, JAXXObject, JAXXValidator {

    /*-----------------------------------------------------------------------*/
    /*------------------ Constants for all public bindings ------------------*/
    /*-----------------------------------------------------------------------*/

    public static final String BINDING_BATCH_COUNT_FIELD_NUMBER_VALUE = "batchCountField.numberValue";
    public static final String BINDING_BATCH_WEIGHT_FIELD_NUMBER_VALUE = "batchWeightField.numberValue";
    public static final String BINDING_CATEGORY_COMBO_BOX_DATA = "categoryComboBox.data";
    public static final String BINDING_CATEGORY_COMBO_BOX_ENABLED = "categoryComboBox.enabled";
    public static final String BINDING_CATEGORY_COMBO_BOX_SELECTED_ITEM = "categoryComboBox.selectedItem";
    public static final String BINDING_CATEGORY_PANEL_VISIBLE = "categoryPanel.visible";
    public static final String BINDING_SAMPLE_CATEGORY_COMBO_BOX_SELECTED_ITEM = "sampleCategoryComboBox.selectedItem";
    public static final String BINDING_SAMPLE_WEIGHT_FIELD_TEXT = "sampleWeightField.text";
    public static final String BINDING_SAVE_AND_CLOSE_BUTTON_ENABLED = "saveAndCloseButton.enabled";
    public static final String BINDING_SAVE_AND_CONTINUE_BUTTON_ENABLED = "saveAndContinueButton.enabled";
    public static final String BINDING_SPECIES_COMBO_BOX_DATA = "speciesComboBox.data";
    public static final String BINDING_SPECIES_COMBO_BOX_SELECTED_ITEM = "speciesComboBox.selectedItem";
    public static final String BINDING_TABLE_ENABLED = "table.enabled";

    /*-----------------------------------------------------------------------*/
    /*------------------------- Other static fields -------------------------*/
    /*-----------------------------------------------------------------------*/

    private static final String $jaxxObjectDescriptor = "H4sIAAAAAAAAAL1Z3W/URhDfhFzIFyUfJaR8qIEChQK+0AoEohSSkIMLR0Dc8aEGNd2zN8mCz3btdbjIouqf0D+hfe9Lpb71qepDn/vQl6r/QlX1oa9VZ9c+2+uzzz4BRcKQ3ZnZmd/MzsxOvvsTlRwbHXuG223Fdg1GW0RZXXzy5F7zGVHZTeKoNrWYaSP/z8AgGlxH41q47jD03nqNs5cD9vKy2bJMgxgx7qs1NOawXZ0424Qwho7KHKrjlOvh9tW25dodqaFSaVK/+fuvwa+1r74dRKhtgXaHwZT5PK7IkqEaGqQaQ9Nw0g4u69jYAjVsamyBvvv42rKOHWcNt8gX6Eu0t4aGLWyDMIaOFzdZyBD8bYuhQ6pNMCN1i6iUOEuYqdsN07qPDaIz9HjTVuimTVrEVpjLGFVcqjgvQCFFNQ0G8hXTIjZm1DQUlfMSR3F8UYovWFnukv+wallCgWGGSi1T4yc9fUMn3eXio+NGd7BONQxwMHRWcky4EZxa599HncVIwnDTNp8TYD+TrXGD/3gbzl0StBHzNNiySbdc344A5DlJj0ACburCx6Mh70RgbQ03Odc0D4d2QL4qFjnhgZB+f0APodA0l8w2QxdTDiIa5TY3CTaUJfhUqM4AZji9wydLncSa1kEYrATXoBlJE381wdTkznhM6NY2CzU9lE1ToUSHa3DWtLcUwwUFDUWo/oJqW4Q5sNZqAupr4p8VYUHCdiFs2QRTs86LkYjj+PJJmWTGwS0LgICg2jLt3SxJszJZHLejMuU+NaAJPC/7UCzKPj+khkKTccMpDvKPEkXIidU6gYTAA3YB9JKkhzuc+EK3SrJ1EcGkmmVXRDPlI5Dm4AyiwMOyig3SjnwRMe5nPBzrqm3qOjedoYOyZeGODEdJ8DF0mIfRM6gQz5lp+UxtZfVJeMWuhxwjJ3wnLPCfFxLXT8WGSvQovOf5ZyXcP+DgHbJoaOApRg2XZBJOdwh100mhstFh6ZpCKVKiUhTVioF1VLJdWIYEst5dvR7All+35hJ1iwsUu//Ozvz24x8/VOLF6kAqaazWQhGxbJ6JGeVH7/crlcuoXr6LravraNQhOhRqUYiPpChWD7ZBOThvirMrnF25jZ1tEFHa+/tPP89+/useNFhBY7qJtQrm9FU0yrZtQMHUtbZ1/YbQaOLFCHwn4e8gQ0M8iTG01xMl5SUkeyB+8YA4vMAPMdslbYDjSAocoU7N0V/+mal/f6MDyQCo+E4meQRL6VM0TA2dGkRU8KA4p1bsccshrmZGRTitLCMozLPp6TgoJg/E91EXDkNpOGCXmfdNywWpZW8bG5oO2RMyqZ9VTp9RqLPYIYkn1dNn0lDkpQWWBHWnBixkiK0DYVyiTw9y2y7X/6nAmP/vM27yRJw0x9ABuOAb21BjGTrmHfcLcHcro3CK4ymn9Wx8rHyQR3Se5iq8j5jyEpX2JQcKchlDpzL12uR5rtPAMDTOTFNvUKsh2D4oxqYwaOxCFMo9UJDZsjGReowCKEz4l51oVUZaDL3thxyPgeB4EUFD0EJh6LGj3cUdTHWR1WNkI0Fi2YXYDYF5ndYlO6I8AyHE9u5Qh4oqci3Ftvlj1+YNV9fnT52aD3eXwr4CCK75BKnqyN1AfzE356U3HVHonc+DS+JPRuCFvrjlQLyU7yqZO9tjaR1YHlB7usLycMx1krxk2L2VBOUNmJTRLeZZVZLcP+0lu+XI8XnJI8YJFm9AP+//8NCgsHAuNZFHQR/RCvDkqFGKHy2HzEe5+MZZs8HtemgUuFXj/msCnnq8tM158kX2ZSUDZVwC8VWsYGjMP7+xa8Hx+7wKtDxMUXkzkGui8Hy/xSrx7okC50wR5QVj0u95uSbilN3+YTHAfM4eeT3x2itwl/b5oN/HDNor6F9mvepaY+PSxs3qrWqjvnF/sdFYebD2MhkdB73UNC8Hx1gcqFcwNREa+72qATkDbmZ2cCQftf3FxrSXfOtFwfF+jvZqRiE5W5BPDoyLuWh1+ISZPWJDft/m4TECFZ8YvDGBx+m76c4OazoI533wTaKatj9RKm1iHfrkZP2JNT71YEOuQA4w+2/VjoSgZToQcWbVrEknIVLu2DsCXz+yXYOB/krYjNc1D4iiLS9q4qyvu4iV+zhbjtorBbuEmMk98O0eqhTofDqp3OPGismxyFynEw1Qp6qJ992GarYsl/GQD953/4NBhdJTKX4dK71uUfFOnN9awU5Ngw+HGTrp1agTyAwWdaVeXbtVW9mor9RWlhvVe2vp13QmFAUxTbZsOEvjRXzZ1E1bWaotLt95GadawurzDtWwl/ky8CdXBdDJbfmwOFaJhraQ5TewZelUFaPERbHP0B0ve5odyPABCsSAufFzfDFBYYL8Ry9cNu4apGUaVIW+qLh6SivkKtpadsso3Fp2s/ZId8nBd557huPBOxUEL3XErxT8ZzHLyTeBeonBIrQF/kaV/2IEDfHtLsgv9yk0E/dc3yUFSeBfzgc/yZ/tgfQJ6+tyw7miivKxbSEfXOxHYqYDFvqSUriLSmPOhj5lZl08O2UPwQIl/Ml6AtPhzmoC1dzr4vNl4pmbKwP+wrM1ma3HbC3+C4QCo6dhHe+aLm9vPubN4HyTGhqk40+6ZA/w71gBiSN8MMwfE0AxwNLlHMmVw5l3e0g4X0iC00NC+ZV1uPLKOlRAwn8VwgeejCAAAA==";
    private static final Log log = LogFactory.getLog(CreateSpeciesBatchUI.class);
    private static final long serialVersionUID = 1L;

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Internal states ---------------------------*/
    /*-----------------------------------------------------------------------*/

    protected List<Object> $activeBindings = new ArrayList<Object>();
    protected Map<String, Object> $bindingSources = new HashMap<String, Object>();
    protected final Map<String, JAXXBinding> $bindings = new TreeMap<String, JAXXBinding>();
    protected Map<String, Object> $objectMap = new HashMap<String, Object>();
    protected Map<?, ?> $previousValues = new HashMap<Object, Object>();
    private boolean allComponentsCreated;
    protected final JAXXContext delegateContext = new DefaultJAXXContext();

    /*-----------------------------------------------------------------------*/
    /*------------------------ Protected components  ------------------------*/
    /*-----------------------------------------------------------------------*/

    protected JButton addSpeciesButton;
    @ValidatorField( validatorId = "validator",  propertyName = "batchCount",  editorName = "batchCountField")
    protected NumberEditor batchCountField;
    protected JLabel batchCountLabel;
    @ValidatorField( validatorId = "validator",  propertyName = "batchWeight",  editorName = "batchWeightField")
    protected NumberEditor batchWeightField;
    protected JLabel batchWeightLabel;
    protected TuttiHelpBroker broker;
    protected JButton cancelButton;
    @ValidatorField( validatorId = "validator",  propertyName = "selectedCategory",  editorName = "categoryComboBox")
    protected BeanFilterableComboBox<SampleCategoryModelEntry> categoryComboBox;
    protected Table categoryConfigurationPanel;
    protected JLabel categoryLabel;
    protected JPanel categoryPanel;
    protected Table configurationPanel;
    protected CreateSpeciesBatchUI createSpeciesBatchTopPanel = this;
    protected final CreateSpeciesBatchUIHandler handler = createHandler();
    protected CreateSpeciesBatchUIModel model;
    @ValidatorField( validatorId = "validator",  propertyName = "sampleCategory",  editorName = "sampleCategoryComboBox")
    protected BeanFilterableComboBox<CaracteristicQualitativeValue> sampleCategoryComboBox;
    protected JLabel sampleCategoryLabel;
    @ValidatorField( validatorId = "validator",  propertyName = "sampleWeight",  editorName = "sampleWeightField")
    protected JTextField sampleWeightField;
    protected JLabel sampleWeightLabel;
    protected JButton saveAndCloseButton;
    protected JButton saveAndContinueButton;
    @ValidatorField( validatorId = "validator",  propertyName = "species",  editorName = "speciesComboBox")
    protected BeanFilterableComboBox<Species> speciesComboBox;
    protected JLabel speciesLabel;
    protected JXTable table;
    protected JScrollPane tableScrollPane;
    @Validator( validatorId = "validator")
    protected SwingValidator<CreateSpeciesBatchUIModel> validator;
    protected List<String> validatorIds = new ArrayList<String>();

    /*-----------------------------------------------------------------------*/
    /*------------------------- Private components  -------------------------*/
    /*-----------------------------------------------------------------------*/

    private JPanel $JPanel0;
    private JSeparator $JSeparator0;

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Constructors  ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public CreateSpeciesBatchUI(EditCatchesUI parentUI) {
        TuttiUIUtil.setParentUI(this, parentUI);
            $initialize();
    }

    public CreateSpeciesBatchUI() {
        $initialize();
    }

    public CreateSpeciesBatchUI(JAXXContext parentContext) {
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public CreateSpeciesBatchUI(LayoutManager param0, boolean param1) {
        super(param0 ,param1);
        $initialize();
    }

    public CreateSpeciesBatchUI(JAXXContext parentContext, LayoutManager param1, boolean param2) {
        super(param1 ,param2);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public CreateSpeciesBatchUI(LayoutManager param0) {
        super(param0);
        $initialize();
    }

    public CreateSpeciesBatchUI(JAXXContext parentContext, LayoutManager param1) {
        super(param1);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public CreateSpeciesBatchUI(boolean param0) {
        super(param0);
        $initialize();
    }

    public CreateSpeciesBatchUI(JAXXContext parentContext, boolean param1) {
        super(param1);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Statics methods ---------------------------*/
    /*-----------------------------------------------------------------------*/

    public static JAXXObjectDescriptor $getJAXXObjectDescriptor() {
        return JAXXUtil.decodeCompressedJAXXObjectDescriptor($jaxxObjectDescriptor);
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------- JAXXObject implementation ----------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    public void applyDataBinding(String $binding) {
        if (allComponentsCreated && $bindings.containsKey($binding)) {
            getDataBinding($binding).applyDataBinding();
        }
        processDataBinding($binding);
    }

    @Override
    public void firePropertyChange(String propertyName, Object oldValue, Object newValue) {
        super.firePropertyChange(propertyName, oldValue, newValue);
    }

    @Override
    public Map<String, Object> get$objectMap() {
        return $objectMap;
    }

    @Override
    public JAXXBinding getDataBinding(String bindingId) {
        return $bindings.get(bindingId);
    }

    @Override
    public JAXXBinding[] getDataBindings() {
        return $bindings.values().toArray(new JAXXBinding[$bindings.size()]);
    }

    @Override
    public Object getObjectById(String id) {
        return $objectMap.get(id);
    }

    @Override
    public void processDataBinding(String $binding, boolean $force) {
        if (!$force && $activeBindings.contains($binding)) { 
            return;
        }
        $activeBindings.add($binding);
        try {
            if (allComponentsCreated && $bindings.containsKey($binding)) {
                getDataBinding($binding).processDataBinding();
            }
        } finally {
            $activeBindings.remove($binding);
        }
    }

    @Override
    public void processDataBinding(String $binding) {
        processDataBinding($binding, false);
    }

    @Override
    public void registerDataBinding(JAXXBinding binding) {
        $bindings.put(binding.getId(), binding);
    }

    @Override
    public void removeDataBinding(String $binding) {
        if (allComponentsCreated && $bindings.containsKey($binding)) {
            getDataBinding($binding).removeDataBinding();
        }
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- JAXXContext implementation  ---------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    public <T> T getContextValue(Class<T> clazz) {
        return delegateContext.getContextValue(clazz, null);
    }

    @Override
    public <T> T getContextValue(Class<T> clazz, String name) {
        return delegateContext.getContextValue(clazz, name);
    }

    @Override
    public JAXXContext getDelegateContext() {
        return delegateContext;
    }

    @Override
    public <O extends Container> O getParentContainer(Class<O> clazz) {
        return SwingUtil.getParentContainer(this, clazz);
    }

    @Override
    public <O extends Container> O getParentContainer(Object source, Class<O> clazz) {
        return SwingUtil.getParentContainer(source, clazz);
    }

    @Override
    public <T> void removeContextValue(Class<T> clazz) {
        delegateContext.removeContextValue(clazz, null);
    }

    @Override
    public <T> void removeContextValue(Class<T> clazz, String name) {
        delegateContext.removeContextValue(clazz, name);
    }

    @Override
    public <T> void setContextValue(T o) {
        delegateContext.setContextValue(o, null);
    }

    @Override
    public <T> void setContextValue(T o, String name) {
        delegateContext.setContextValue(o, name);
    }

    /*-----------------------------------------------------------------------*/
    /*-------------------- JAXXValidator implementation  --------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    public SwingValidator<?> getValidator(String validatorId) {
        return (SwingValidator<?>) (validatorIds.contains(validatorId) ? getObjectById(validatorId) : null);
    }

    @Override
    public List<String> getValidatorIds() {
        return validatorIds;
    }

    @Override
    public void registerValidatorFields() {
        SwingValidatorUtil.detectValidatorFields(this);
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Event methods ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public void doActionPerformed__on__cancelButton(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        handler.cancel();
    }

    public void doActionPerformed__on__saveAndCloseButton(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        handler.saveAndClose();
    }

    public void doActionPerformed__on__saveAndContinueButton(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        handler.saveAndContinue();
    }

    /*-----------------------------------------------------------------------*/
    /*----------------------- Public acessor methods  -----------------------*/
    /*-----------------------------------------------------------------------*/

    public JButton getAddSpeciesButton() {
        return addSpeciesButton;
    }

    public NumberEditor getBatchCountField() {
        return batchCountField;
    }

    public JLabel getBatchCountLabel() {
        return batchCountLabel;
    }

    public NumberEditor getBatchWeightField() {
        return batchWeightField;
    }

    public JLabel getBatchWeightLabel() {
        return batchWeightLabel;
    }

    public TuttiHelpBroker getBroker() {
        return broker;
    }

    public JButton getCancelButton() {
        return cancelButton;
    }

    public BeanFilterableComboBox<SampleCategoryModelEntry> getCategoryComboBox() {
        return categoryComboBox;
    }

    public Table getCategoryConfigurationPanel() {
        return categoryConfigurationPanel;
    }

    public JLabel getCategoryLabel() {
        return categoryLabel;
    }

    public JPanel getCategoryPanel() {
        return categoryPanel;
    }

    public Table getConfigurationPanel() {
        return configurationPanel;
    }

    public CreateSpeciesBatchUIHandler getHandler() {
        return handler;
    }

    public CreateSpeciesBatchUIModel getModel() {
        return model;
    }

    public BeanFilterableComboBox<CaracteristicQualitativeValue> getSampleCategoryComboBox() {
        return sampleCategoryComboBox;
    }

    public JLabel getSampleCategoryLabel() {
        return sampleCategoryLabel;
    }

    public JTextField getSampleWeightField() {
        return sampleWeightField;
    }

    public JLabel getSampleWeightLabel() {
        return sampleWeightLabel;
    }

    public JButton getSaveAndCloseButton() {
        return saveAndCloseButton;
    }

    public JButton getSaveAndContinueButton() {
        return saveAndContinueButton;
    }

    public BeanFilterableComboBox<Species> getSpeciesComboBox() {
        return speciesComboBox;
    }

    public JLabel getSpeciesLabel() {
        return speciesLabel;
    }

    public JXTable getTable() {
        return table;
    }

    public JScrollPane getTableScrollPane() {
        return tableScrollPane;
    }

    public SwingValidator<CreateSpeciesBatchUIModel> getValidator() {
        return validator;
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Other methods ----------------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    public void registerHelpId(TuttiHelpBroker broker, Component component, String helpId) {
        broker.installUI(component, helpId);
    }

    @Override
    public void showHelp(String helpId) {
        getBroker().showHelp(this, helpId);
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Protected acessors methods  ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected JPanel get$JPanel0() {
        return $JPanel0;
    }

    protected JSeparator get$JSeparator0() {
        return $JSeparator0;
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Components creation methods ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected void addChildrenToCategoryConfigurationPanel() {
        if (!allComponentsCreated) {
            return;
        }
        categoryConfigurationPanel.add($JSeparator0, new GridBagConstraints(0, 0, 2, 1, 0.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        categoryConfigurationPanel.add(categoryLabel, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 17, 1, new Insets(3, 3, 3, 3), 0, 0));
        categoryConfigurationPanel.add(SwingUtil.boxComponentWithJxLayer(categoryComboBox), new GridBagConstraints(1, 1, 1, 1, 1.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        categoryConfigurationPanel.add(sampleWeightLabel, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 17, 1, new Insets(3, 3, 3, 3), 0, 0));
        categoryConfigurationPanel.add(SwingUtil.boxComponentWithJxLayer(sampleWeightField), new GridBagConstraints(1, 2, 1, 1, 1.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
    }

    protected void addChildrenToCategoryPanel() {
        if (!allComponentsCreated) {
            return;
        }
        categoryPanel.add(categoryConfigurationPanel, BorderLayout.NORTH);
        categoryPanel.add(tableScrollPane, BorderLayout.CENTER);
    }

    protected void addChildrenToConfigurationPanel() {
        if (!allComponentsCreated) {
            return;
        }
        configurationPanel.add(speciesLabel, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 1, new Insets(3, 3, 3, 3), 0, 0));
        configurationPanel.add(SwingUtil.boxComponentWithJxLayer(speciesComboBox), new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        configurationPanel.add(addSpeciesButton, new GridBagConstraints(2, 0, 1, 1, 0.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        configurationPanel.add(batchWeightLabel, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 17, 1, new Insets(3, 3, 3, 3), 0, 0));
        configurationPanel.add(SwingUtil.boxComponentWithJxLayer(batchWeightField), new GridBagConstraints(1, 1, 2, 1, 1.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        configurationPanel.add(batchCountLabel, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 17, 1, new Insets(3, 3, 3, 3), 0, 0));
        configurationPanel.add(SwingUtil.boxComponentWithJxLayer(batchCountField), new GridBagConstraints(1, 2, 2, 1, 1.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        configurationPanel.add(sampleCategoryLabel, new GridBagConstraints(0, 3, 1, 1, 0.0, 0.0, 17, 1, new Insets(3, 3, 3, 3), 0, 0));
        configurationPanel.add(SwingUtil.boxComponentWithJxLayer(sampleCategoryComboBox), new GridBagConstraints(1, 3, 2, 1, 1.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
    }

    protected void addChildrenToCreateSpeciesBatchTopPanel() {
        if (!allComponentsCreated) {
            return;
        }
        add(configurationPanel, BorderLayout.NORTH);
        add(categoryPanel, BorderLayout.CENTER);
        add($JPanel0, BorderLayout.SOUTH);
    }

    protected void addChildrenToTableScrollPane() {
        if (!allComponentsCreated) {
            return;
        }
        tableScrollPane.getViewport().add(table);
    }

    protected void addChildrenToValidator() {
        if (!allComponentsCreated) {
            return;
        }
        validator.setUiClass(ImageValidationUI.class);
        validator.setBean(model);
    }

    protected void createAddSpeciesButton() {
        $objectMap.put("addSpeciesButton", addSpeciesButton = new JButton());
        
        addSpeciesButton.setName("addSpeciesButton");
        addSpeciesButton.setText(t("tutti.createSpeciesBatch.action.addSpecies"));
        addSpeciesButton.setToolTipText(t("tutti.createSpeciesBatch.action.addSpecies.tip"));
        addSpeciesButton.putClientProperty("applicationAction", fr.ifremer.tutti.ui.swing.action.SelectSpeciesForSpeciesBatchAction.class);
        addSpeciesButton.putClientProperty("help", "tutti.createSpeciesBatch.action.addSpecies.help");
    }

    protected void createBatchCountField() {
        $objectMap.put("batchCountField", batchCountField = new NumberEditor(this));
        
        batchCountField.setName("batchCountField");
        batchCountField.setProperty("batchCount");
        batchCountField.setShowReset(true);
        batchCountField.putClientProperty("help", "tutti.createSpeciesBatch.field.batchCount.help");
    }

    protected void createBatchCountLabel() {
        $objectMap.put("batchCountLabel", batchCountLabel = new JLabel());
        
        batchCountLabel.setName("batchCountLabel");
        batchCountLabel.setText(t("tutti.createSpeciesBatch.field.batchCount"));
        batchCountLabel.setToolTipText(t("tutti.createSpeciesBatch.field.batchCount.tip"));
        batchCountLabel.putClientProperty("help", "tutti.createSpeciesBatch.field.batchCount.help");
    }

    protected void createBatchWeightField() {
        $objectMap.put("batchWeightField", batchWeightField = new NumberEditor(this));
        
        batchWeightField.setName("batchWeightField");
        batchWeightField.setProperty("batchWeight");
        batchWeightField.setShowReset(true);
        batchWeightField.putClientProperty("help", "tutti.createSpeciesBatch.field.batchWeight.help");
    }

    protected void createBatchWeightLabel() {
        $objectMap.put("batchWeightLabel", batchWeightLabel = new JLabel());
        
        batchWeightLabel.setName("batchWeightLabel");
        batchWeightLabel.setText(t("tutti.createSpeciesBatch.field.batchWeight"));
        batchWeightLabel.setToolTipText(t("tutti.createSpeciesBatch.field.batchWeight.tip"));
        batchWeightLabel.putClientProperty("help", "tutti.createSpeciesBatch.field.batchWeight.help");
        batchWeightLabel.putClientProperty("addWeightUnit", handler.getConfig().getSpeciesWeightUnit());
    }

    protected void createBroker() {
        $objectMap.put("broker", broker = new TuttiHelpBroker("tutti.createSpeciesBatch.help"));
    }

    protected void createCancelButton() {
        $objectMap.put("cancelButton", cancelButton = new JButton());
        
        cancelButton.setName("cancelButton");
        cancelButton.setText(t("tutti.createSpeciesBatch.action.cancel"));
        cancelButton.setToolTipText(t("tutti.createSpeciesBatch.action.cancel.tip"));
        cancelButton.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__cancelButton"));
        cancelButton.putClientProperty("help", "tutti.createSpeciesBatch.action.cancel.help");
    }

    protected void createCategoryComboBox() {
        $objectMap.put("categoryComboBox", categoryComboBox = new BeanFilterableComboBox<SampleCategoryModelEntry>(this));
        
        categoryComboBox.setName("categoryComboBox");
        categoryComboBox.setShowDecorator(false);
        categoryComboBox.setSortable(false);
        categoryComboBox.setProperty("selectedCategory");
        categoryComboBox.setShowReset(false);
        categoryComboBox.putClientProperty("help", "tutti.createSpeciesBatch.field.categoryField.help");
    }

    protected void createCategoryConfigurationPanel() {
        $objectMap.put("categoryConfigurationPanel", categoryConfigurationPanel = new Table());
        
        categoryConfigurationPanel.setName("categoryConfigurationPanel");
    }

    protected void createCategoryLabel() {
        $objectMap.put("categoryLabel", categoryLabel = new JLabel());
        
        categoryLabel.setName("categoryLabel");
        categoryLabel.setText(t("tutti.createSpeciesBatch.field.category"));
        categoryLabel.setToolTipText(t("tutti.createSpeciesBatch.field.category.tip"));
        categoryLabel.putClientProperty("help", "tutti.createSpeciesBatch.field.categoryField.help");
    }

    protected void createCategoryPanel() {
        $objectMap.put("categoryPanel", categoryPanel = new JPanel());
        
        categoryPanel.setName("categoryPanel");
        categoryPanel.setLayout(new BorderLayout());
    }

    protected void createConfigurationPanel() {
        $objectMap.put("configurationPanel", configurationPanel = new Table());
        
        configurationPanel.setName("configurationPanel");
    }

    protected CreateSpeciesBatchUIHandler createHandler() {
        return new CreateSpeciesBatchUIHandler();
    }

    protected void createModel() {
        $objectMap.put("model", model = getContextValue(CreateSpeciesBatchUIModel.class));
    }

    protected void createSampleCategoryComboBox() {
        $objectMap.put("sampleCategoryComboBox", sampleCategoryComboBox = new BeanFilterableComboBox<CaracteristicQualitativeValue>(this));
        
        sampleCategoryComboBox.setName("sampleCategoryComboBox");
        sampleCategoryComboBox.setProperty("sampleCategory");
        sampleCategoryComboBox.setShowReset(true);
        sampleCategoryComboBox.putClientProperty("help", "tutti.createSpeciesBatch.field.sampleCategory.help");
    }

    protected void createSampleCategoryLabel() {
        $objectMap.put("sampleCategoryLabel", sampleCategoryLabel = new JLabel());
        
        sampleCategoryLabel.setName("sampleCategoryLabel");
        sampleCategoryLabel.setText(t("tutti.createSpeciesBatch.field.sampleCategory"));
        sampleCategoryLabel.setToolTipText(t("tutti.createSpeciesBatch.field.sampleCategory.tip"));
        sampleCategoryLabel.putClientProperty("help", "tutti.createSpeciesBatch.field.sampleCategory.help");
    }

    protected void createSampleWeightField() {
        $objectMap.put("sampleWeightField", sampleWeightField = new JTextField());
        
        sampleWeightField.setName("sampleWeightField");
        sampleWeightField.setColumns(15);
        sampleWeightField.putClientProperty("help", "tutti.createSpeciesBatch.field.sampleWeightField.help");
        sampleWeightField.putClientProperty("computed", true);
    }

    protected void createSampleWeightLabel() {
        $objectMap.put("sampleWeightLabel", sampleWeightLabel = new JLabel());
        
        sampleWeightLabel.setName("sampleWeightLabel");
        sampleWeightLabel.setText(t("tutti.createSpeciesBatch.field.sampleWeight"));
        sampleWeightLabel.setToolTipText(t("tutti.createSpeciesBatch.field.sampleWeight.tip"));
        sampleWeightLabel.putClientProperty("help", "tutti.createSpeciesBatch.field.sampleWeightField.help");
        sampleWeightLabel.putClientProperty("addWeightUnit", handler.getConfig().getSpeciesWeightUnit());
    }

    protected void createSaveAndCloseButton() {
        $objectMap.put("saveAndCloseButton", saveAndCloseButton = new JButton());
        
        saveAndCloseButton.setName("saveAndCloseButton");
        saveAndCloseButton.setText(t("tutti.createSpeciesBatch.action.saveAndClose"));
        saveAndCloseButton.setToolTipText(t("tutti.createSpeciesBatch.action.saveAndClose.tip"));
        saveAndCloseButton.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__saveAndCloseButton"));
        saveAndCloseButton.putClientProperty("help", "tutti.createSpeciesBatch.action.saveAndClose.help");
    }

    protected void createSaveAndContinueButton() {
        $objectMap.put("saveAndContinueButton", saveAndContinueButton = new JButton());
        
        saveAndContinueButton.setName("saveAndContinueButton");
        saveAndContinueButton.setText(t("tutti.createSpeciesBatch.action.saveAndContinue"));
        saveAndContinueButton.setToolTipText(t("tutti.createSpeciesBatch.action.saveAndContinue.tip"));
        saveAndContinueButton.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__saveAndContinueButton"));
        saveAndContinueButton.putClientProperty("help", "tutti.createSpeciesBatch.action.saveAndContinue.help");
    }

    protected void createSpeciesComboBox() {
        $objectMap.put("speciesComboBox", speciesComboBox = new BeanFilterableComboBox<Species>(this));
        
        speciesComboBox.setName("speciesComboBox");
        speciesComboBox.setProperty("species");
        speciesComboBox.setShowReset(true);
        speciesComboBox.putClientProperty("help", "tutti.createSpeciesBatch.field.species.help");
    }

    protected void createSpeciesLabel() {
        $objectMap.put("speciesLabel", speciesLabel = new JLabel());
        
        speciesLabel.setName("speciesLabel");
        speciesLabel.setText(t("tutti.createSpeciesBatch.field.species"));
        speciesLabel.setToolTipText(t("tutti.createSpeciesBatch.field.species.tip"));
        speciesLabel.putClientProperty("help", "tutti.createSpeciesBatch.field.species.help");
    }

    protected void createTable() {
        $objectMap.put("table", table = new JXTable());
        
        table.setName("table");
        table.setSortable(false);
    }

    protected void createTableScrollPane() {
        $objectMap.put("tableScrollPane", tableScrollPane = new JScrollPane());
        
        tableScrollPane.setName("tableScrollPane");
    }

    protected void createValidator() {
        $objectMap.put("validator", validator = SwingValidator.newValidator(CreateSpeciesBatchUIModel.class, null));
    }

    /*-----------------------------------------------------------------------*/
    /*------------------------ Internal jaxx methods ------------------------*/
    /*-----------------------------------------------------------------------*/

    private void $completeSetup() {
        allComponentsCreated = true;
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        addChildrenToCreateSpeciesBatchTopPanel();
        addChildrenToValidator();
        addChildrenToConfigurationPanel();
        addChildrenToCategoryPanel();
        addChildrenToCategoryConfigurationPanel();
        addChildrenToTableScrollPane();
        // inline complete setup of $JPanel0
        $JPanel0.add(cancelButton);
        $JPanel0.add(saveAndContinueButton);
        $JPanel0.add(saveAndCloseButton);
        
        // apply 13 data bindings
        JAXXUtil.applyDataBinding(this, $bindings.keySet());
        
        // apply 34 property setters
        speciesComboBox.setBeanType(Species.class);
        sampleCategoryComboBox.setBeanType(CaracteristicQualitativeValue.class);
        categoryComboBox.setBeanType(SampleCategoryModelEntry.class);
        speciesLabel.setLabelFor(speciesComboBox);
        speciesComboBox.setBean(model);
        addSpeciesButton.setMnemonic(SwingUtil.getFirstCharAt(t("tutti.createSpeciesBatch.action.addSpecies.mnemonic"),'Z'));
        batchWeightLabel.setLabelFor(batchWeightField);
        batchWeightField.setBean(model);
        batchWeightField.setAutoPopup(handler.getConfig().isAutoPopupNumberEditor());
        batchWeightField.setShowPopupButton(handler.getConfig().isShowNumberEditorButton());
        batchWeightField.setNumberType(Float.class);
        batchCountLabel.setLabelFor(batchCountField);
        batchCountField.setBean(model);
        batchCountField.setAutoPopup(handler.getConfig().isAutoPopupNumberEditor());
        batchCountField.setNumberPattern(INT_6_DIGITS_PATTERN);
        batchCountField.setShowPopupButton(handler.getConfig().isShowNumberEditorButton());
        batchCountField.setNumberType(Integer.class);
        sampleCategoryLabel.setLabelFor(sampleCategoryComboBox);
        sampleCategoryComboBox.setBean(model);
        categoryLabel.setLabelFor(categoryComboBox);
        categoryComboBox.setBean(model);
        sampleWeightLabel.setLabelFor(sampleWeightField);
        table.setSelectionMode(ListSelectionModel.SINGLE_SELECTION);
        table.setSelectionForeground(Color.BLACK);
        table.setSelectionBackground(null);
        cancelButton.setIcon(SwingUtil.createActionIcon("cancel"));
        cancelButton.setMnemonic(SwingUtil.getFirstCharAt(t("tutti.createSpeciesBatch.action.cancel.mnemonic"),'Z'));
        saveAndContinueButton.setIcon(SwingUtil.createActionIcon("save"));
        saveAndContinueButton.setMnemonic(SwingUtil.getFirstCharAt(t("tutti.createSpeciesBatch.action.saveAndContinue.mnemonic"),'Z'));
        saveAndCloseButton.setIcon(SwingUtil.createActionIcon("save"));
        saveAndCloseButton.setMnemonic(SwingUtil.getFirstCharAt(t("tutti.createSpeciesBatch.action.saveAndClose.mnemonic"),'Z'));
        // late initializer
        // help broker setup
        TuttiHelpBroker _broker = getBroker();
        registerHelpId(_broker, createSpeciesBatchTopPanel, "tutti.createSpeciesBatch.help");
        registerHelpId(_broker, speciesLabel, "tutti.createSpeciesBatch.field.species.help");
        registerHelpId(_broker, speciesComboBox, "tutti.createSpeciesBatch.field.species.help");
        registerHelpId(_broker, addSpeciesButton, "tutti.createSpeciesBatch.action.addSpecies.help");
        registerHelpId(_broker, batchWeightLabel, "tutti.createSpeciesBatch.field.batchWeight.help");
        registerHelpId(_broker, batchWeightField, "tutti.createSpeciesBatch.field.batchWeight.help");
        registerHelpId(_broker, batchCountLabel, "tutti.createSpeciesBatch.field.batchCount.help");
        registerHelpId(_broker, batchCountField, "tutti.createSpeciesBatch.field.batchCount.help");
        registerHelpId(_broker, sampleCategoryLabel, "tutti.createSpeciesBatch.field.sampleCategory.help");
        registerHelpId(_broker, sampleCategoryComboBox, "tutti.createSpeciesBatch.field.sampleCategory.help");
        registerHelpId(_broker, categoryLabel, "tutti.createSpeciesBatch.field.categoryField.help");
        registerHelpId(_broker, categoryComboBox, "tutti.createSpeciesBatch.field.categoryField.help");
        registerHelpId(_broker, sampleWeightLabel, "tutti.createSpeciesBatch.field.sampleWeightField.help");
        registerHelpId(_broker, sampleWeightField, "tutti.createSpeciesBatch.field.sampleWeightField.help");
        registerHelpId(_broker, cancelButton, "tutti.createSpeciesBatch.action.cancel.help");
        registerHelpId(_broker, saveAndContinueButton, "tutti.createSpeciesBatch.action.saveAndContinue.help");
        registerHelpId(_broker, saveAndCloseButton, "tutti.createSpeciesBatch.action.saveAndClose.help");
        _broker.prepareUI(this);
        // register 1 validator(s)
        validatorIds = SwingValidatorUtil.detectValidators(this);
        SwingValidatorUtil.installUI(this);
    }

    private void $initialize() {
        if (allComponentsCreated) {
            return;
        }
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        handler.beforeInit(this);
        $objectMap.put("createSpeciesBatchTopPanel", createSpeciesBatchTopPanel);
        createModel();
        createValidator();
        createBroker();
        createConfigurationPanel();
        createSpeciesLabel();
        createSpeciesComboBox();
        createAddSpeciesButton();
        createBatchWeightLabel();
        createBatchWeightField();
        createBatchCountLabel();
        createBatchCountField();
        createSampleCategoryLabel();
        createSampleCategoryComboBox();
        createCategoryPanel();
        createCategoryConfigurationPanel();
        // inline creation of $JSeparator0
        $objectMap.put("$JSeparator0", $JSeparator0 = new JSeparator());
        
        $JSeparator0.setName("$JSeparator0");
        createCategoryLabel();
        createCategoryComboBox();
        createSampleWeightLabel();
        createSampleWeightField();
        createTableScrollPane();
        createTable();
        // inline creation of $JPanel0
        $objectMap.put("$JPanel0", $JPanel0 = new JPanel());
        
        $JPanel0.setName("$JPanel0");
        $JPanel0.setLayout(new GridLayout(1, 0));
        createCancelButton();
        createSaveAndContinueButton();
        createSaveAndCloseButton();
        // inline creation of createSpeciesBatchTopPanel
        setName("createSpeciesBatchTopPanel");
        setLayout(new BorderLayout());
        createSpeciesBatchTopPanel.putClientProperty("help", "tutti.createSpeciesBatch.help");
        
        // registers 13 data bindings
        $registerDefaultBindings();
        $completeSetup();
        handler.afterInit(this);
    }

    private void $registerDefaultBindings() {
        // register 13 data bindings
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_SPECIES_COMBO_BOX_SELECTED_ITEM, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("species", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    speciesComboBox.setSelectedItem(model.getSpecies());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("species", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_SPECIES_COMBO_BOX_DATA, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("availableSpecies", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    speciesComboBox.setData(model.getAvailableSpecies());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("availableSpecies", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_BATCH_WEIGHT_FIELD_NUMBER_VALUE, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("batchWeight", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    batchWeightField.setNumberValue(model.getBatchWeight());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("batchWeight", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_BATCH_COUNT_FIELD_NUMBER_VALUE, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("batchCount", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    batchCountField.setNumberValue(model.getBatchCount());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("batchCount", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_SAMPLE_CATEGORY_COMBO_BOX_SELECTED_ITEM, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("sampleCategory", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    sampleCategoryComboBox.setSelectedItem(model.getSampleCategory());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("sampleCategory", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_CATEGORY_PANEL_VISIBLE, true, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("species", this);
                }
                if (model != null) {
                    model.addPropertyChangeListener("batchCount", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    categoryPanel.setVisible(model.getSpecies() != null && model.getBatchCount() == null);
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("species", this);
                }
                if (model != null) {
                    model.removePropertyChangeListener("batchCount", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_CATEGORY_COMBO_BOX_ENABLED, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("batchCount", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    categoryComboBox.setEnabled(model.getBatchCount() == null);
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("batchCount", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_CATEGORY_COMBO_BOX_SELECTED_ITEM, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("selectedCategory", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    categoryComboBox.setSelectedItem(model.getSelectedCategory());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("selectedCategory", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_CATEGORY_COMBO_BOX_DATA, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("category", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    categoryComboBox.setData(model.getCategory());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("category", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_SAMPLE_WEIGHT_FIELD_TEXT, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("sampleWeight", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    SwingUtil.setText(sampleWeightField, getStringValue(model.getSampleWeight()));
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("sampleWeight", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_TABLE_ENABLED, true, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("selectedCategory", this);
                }
                if (model != null) {
                    model.addPropertyChangeListener("batchCount", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    table.setEnabled(model.getSelectedCategory() != null && model.getBatchCount() == null);
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("selectedCategory", this);
                }
                if (model != null) {
                    model.removePropertyChangeListener("batchCount", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_SAVE_AND_CONTINUE_BUTTON_ENABLED, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("valid", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    saveAndContinueButton.setEnabled(model.isValid());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("valid", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_SAVE_AND_CLOSE_BUTTON_ENABLED, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("valid", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    saveAndCloseButton.setEnabled(model.isValid());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("valid", this);
                }
            }
        });
    }

}