package fr.ifremer.tutti.ui.swing.content.operation.catches.accidental.create;

/*
 * #%L
 * Tutti :: UI
 * $Id:$
 * $HeadURL:$
 * %%
 * Copyright (C) 2012 - 2015 Ifremer
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-3.0.html>.
 * #L%
 */

import fr.ifremer.tutti.persistence.entities.referential.Caracteristic;
import fr.ifremer.tutti.persistence.entities.referential.CaracteristicQualitativeValue;
import fr.ifremer.tutti.persistence.entities.referential.Species;
import fr.ifremer.tutti.ui.swing.TuttiHelpBroker;
import fr.ifremer.tutti.ui.swing.content.operation.catches.EditCatchesUI;
import fr.ifremer.tutti.ui.swing.util.TuttiUI;
import fr.ifremer.tutti.ui.swing.util.TuttiUIUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.GridBagConstraints;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import jaxx.runtime.JAXXBinding;
import jaxx.runtime.JAXXContext;
import jaxx.runtime.JAXXObject;
import jaxx.runtime.JAXXObjectDescriptor;
import jaxx.runtime.JAXXUtil;
import jaxx.runtime.JAXXValidator;
import jaxx.runtime.SwingUtil;
import jaxx.runtime.binding.DefaultJAXXBinding;
import jaxx.runtime.context.DefaultJAXXContext;
import jaxx.runtime.swing.Table;
import jaxx.runtime.swing.editor.bean.BeanFilterableComboBox;
import jaxx.runtime.swing.help.JAXXHelpUI;
import jaxx.runtime.validator.swing.SwingValidator;
import jaxx.runtime.validator.swing.SwingValidatorUtil;
import jaxx.runtime.validator.swing.meta.Validator;
import jaxx.runtime.validator.swing.meta.ValidatorField;
import jaxx.runtime.validator.swing.ui.ImageValidationUI;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.jaxx.widgets.number.NumberEditor;
import static org.nuiton.i18n.I18n.t;

public class CreateAccidentalBatchUI extends JPanel implements JAXXHelpUI<TuttiHelpBroker>, TuttiUI<CreateAccidentalBatchUIModel, CreateAccidentalBatchUIHandler>, JAXXObject, JAXXValidator {

    /*-----------------------------------------------------------------------*/
    /*------------------ Constants for all public bindings ------------------*/
    /*-----------------------------------------------------------------------*/

    public static final String BINDING_ACCIDENTAL_DEAD_OR_ALIVE_COMBO_BOX_SELECTED_ITEM = "accidentalDeadOrAliveComboBox.selectedItem";
    public static final String BINDING_ACCIDENTAL_GENDER_COMBO_BOX_SELECTED_ITEM = "accidentalGenderComboBox.selectedItem";
    public static final String BINDING_ACCIDENTAL_LENGTH_STEP_CARACTERISTIC_COMBO_BOX_SELECTED_ITEM = "accidentalLengthStepCaracteristicComboBox.selectedItem";
    public static final String BINDING_ACCIDENTAL_SIZE_FIELD_NUMBER_VALUE = "accidentalSizeField.numberValue";
    public static final String BINDING_ACCIDENTAL_SPECIES_COMBO_BOX_SELECTED_ITEM = "accidentalSpeciesComboBox.selectedItem";
    public static final String BINDING_ACCIDENTAL_WEIGHT_FIELD_NUMBER_VALUE = "accidentalWeightField.numberValue";
    public static final String BINDING_SAVE_AND_CLOSE_BUTTON_ENABLED = "saveAndCloseButton.enabled";
    public static final String BINDING_SAVE_AND_CONTINUE_BUTTON_ENABLED = "saveAndContinueButton.enabled";

    /*-----------------------------------------------------------------------*/
    /*------------------------- Other static fields -------------------------*/
    /*-----------------------------------------------------------------------*/

    private static final String $jaxxObjectDescriptor = "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";
    private static final Log log = LogFactory.getLog(CreateAccidentalBatchUI.class);
    private static final long serialVersionUID = 1L;

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Internal states ---------------------------*/
    /*-----------------------------------------------------------------------*/

    protected List<Object> $activeBindings = new ArrayList<Object>();
    protected Map<String, Object> $bindingSources = new HashMap<String, Object>();
    protected final Map<String, JAXXBinding> $bindings = new TreeMap<String, JAXXBinding>();
    protected Map<String, Object> $objectMap = new HashMap<String, Object>();
    protected Map<?, ?> $previousValues = new HashMap<Object, Object>();
    private boolean allComponentsCreated;
    protected final JAXXContext delegateContext = new DefaultJAXXContext();

    /*-----------------------------------------------------------------------*/
    /*------------------------ Protected components  ------------------------*/
    /*-----------------------------------------------------------------------*/

    @ValidatorField( validatorId = "validator",  propertyName = "deadOrAlive",  editorName = "accidentalDeadOrAliveComboBox")
    protected BeanFilterableComboBox<CaracteristicQualitativeValue> accidentalDeadOrAliveComboBox;
    protected JLabel accidentalDeadOrAliveLabel;
    @ValidatorField( validatorId = "validator",  propertyName = "gender",  editorName = "accidentalGenderComboBox")
    protected BeanFilterableComboBox<CaracteristicQualitativeValue> accidentalGenderComboBox;
    protected JLabel accidentalGenderLabel;
    @ValidatorField( validatorId = "validator",  propertyName = "lengthStepCaracteristic",  editorName = "accidentalLengthStepCaracteristicComboBox")
    protected BeanFilterableComboBox<Caracteristic> accidentalLengthStepCaracteristicComboBox;
    protected JLabel accidentalLengthStepCaracteristicLabel;
    @ValidatorField( validatorId = "validator",  propertyName = "size",  editorName = "accidentalSizeField")
    protected NumberEditor accidentalSizeField;
    protected JLabel accidentalSizeLabel;
    @ValidatorField( validatorId = "validator",  propertyName = "species",  editorName = "accidentalSpeciesComboBox")
    protected BeanFilterableComboBox<Species> accidentalSpeciesComboBox;
    protected JLabel accidentalSpeciesLabel;
    @ValidatorField( validatorId = "validator",  propertyName = "weight",  editorName = "accidentalWeightField")
    protected NumberEditor accidentalWeightField;
    protected JLabel accidentalWeightLabel;
    protected TuttiHelpBroker broker;
    protected JButton cancelButton;
    protected Table configurationPanel;
    protected CreateAccidentalBatchUI createAccidentalBatchTopPanel = this;
    protected final CreateAccidentalBatchUIHandler handler = createHandler();
    protected CreateAccidentalBatchUIModel model;
    protected JButton saveAndCloseButton;
    protected JButton saveAndContinueButton;
    @Validator( validatorId = "validator")
    protected SwingValidator<CreateAccidentalBatchUIModel> validator;
    protected List<String> validatorIds = new ArrayList<String>();

    /*-----------------------------------------------------------------------*/
    /*------------------------- Private components  -------------------------*/
    /*-----------------------------------------------------------------------*/

    private JPanel $JPanel0;

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Constructors  ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public CreateAccidentalBatchUI(EditCatchesUI parentUI) {
        TuttiUIUtil.setParentUI(this, parentUI);
            $initialize();
    }

    public CreateAccidentalBatchUI(LayoutManager param0, boolean param1) {
        super(param0 ,param1);
        $initialize();
    }

    public CreateAccidentalBatchUI(JAXXContext parentContext, LayoutManager param1, boolean param2) {
        super(param1 ,param2);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public CreateAccidentalBatchUI() {
        $initialize();
    }

    public CreateAccidentalBatchUI(JAXXContext parentContext) {
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public CreateAccidentalBatchUI(LayoutManager param0) {
        super(param0);
        $initialize();
    }

    public CreateAccidentalBatchUI(JAXXContext parentContext, LayoutManager param1) {
        super(param1);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public CreateAccidentalBatchUI(boolean param0) {
        super(param0);
        $initialize();
    }

    public CreateAccidentalBatchUI(JAXXContext parentContext, boolean param1) {
        super(param1);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Statics methods ---------------------------*/
    /*-----------------------------------------------------------------------*/

    public static JAXXObjectDescriptor $getJAXXObjectDescriptor() {
        return JAXXUtil.decodeCompressedJAXXObjectDescriptor($jaxxObjectDescriptor);
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------- JAXXObject implementation ----------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    public void applyDataBinding(String $binding) {
        if (allComponentsCreated && $bindings.containsKey($binding)) {
            getDataBinding($binding).applyDataBinding();
        }
        processDataBinding($binding);
    }

    @Override
    public void firePropertyChange(String propertyName, Object oldValue, Object newValue) {
        super.firePropertyChange(propertyName, oldValue, newValue);
    }

    @Override
    public Map<String, Object> get$objectMap() {
        return $objectMap;
    }

    @Override
    public JAXXBinding getDataBinding(String bindingId) {
        return $bindings.get(bindingId);
    }

    @Override
    public JAXXBinding[] getDataBindings() {
        return $bindings.values().toArray(new JAXXBinding[$bindings.size()]);
    }

    @Override
    public Object getObjectById(String id) {
        return $objectMap.get(id);
    }

    @Override
    public void processDataBinding(String $binding, boolean $force) {
        if (!$force && $activeBindings.contains($binding)) { 
            return;
        }
        $activeBindings.add($binding);
        try {
            if (allComponentsCreated && $bindings.containsKey($binding)) {
                getDataBinding($binding).processDataBinding();
            }
        } finally {
            $activeBindings.remove($binding);
        }
    }

    @Override
    public void processDataBinding(String $binding) {
        processDataBinding($binding, false);
    }

    @Override
    public void registerDataBinding(JAXXBinding binding) {
        $bindings.put(binding.getId(), binding);
    }

    @Override
    public void removeDataBinding(String $binding) {
        if (allComponentsCreated && $bindings.containsKey($binding)) {
            getDataBinding($binding).removeDataBinding();
        }
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- JAXXContext implementation  ---------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    public <T> T getContextValue(Class<T> clazz) {
        return delegateContext.getContextValue(clazz, null);
    }

    @Override
    public <T> T getContextValue(Class<T> clazz, String name) {
        return delegateContext.getContextValue(clazz, name);
    }

    @Override
    public JAXXContext getDelegateContext() {
        return delegateContext;
    }

    @Override
    public <O extends Container> O getParentContainer(Class<O> clazz) {
        return SwingUtil.getParentContainer(this, clazz);
    }

    @Override
    public <O extends Container> O getParentContainer(Object source, Class<O> clazz) {
        return SwingUtil.getParentContainer(source, clazz);
    }

    @Override
    public <T> void removeContextValue(Class<T> clazz) {
        delegateContext.removeContextValue(clazz, null);
    }

    @Override
    public <T> void removeContextValue(Class<T> clazz, String name) {
        delegateContext.removeContextValue(clazz, name);
    }

    @Override
    public <T> void setContextValue(T o) {
        delegateContext.setContextValue(o, null);
    }

    @Override
    public <T> void setContextValue(T o, String name) {
        delegateContext.setContextValue(o, name);
    }

    /*-----------------------------------------------------------------------*/
    /*-------------------- JAXXValidator implementation  --------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    public SwingValidator<?> getValidator(String validatorId) {
        return (SwingValidator<?>) (validatorIds.contains(validatorId) ? getObjectById(validatorId) : null);
    }

    @Override
    public List<String> getValidatorIds() {
        return validatorIds;
    }

    @Override
    public void registerValidatorFields() {
        SwingValidatorUtil.detectValidatorFields(this);
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Event methods ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public void doActionPerformed__on__cancelButton(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        handler.cancel();
    }

    public void doActionPerformed__on__saveAndCloseButton(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        handler.saveAndClose();
    }

    public void doActionPerformed__on__saveAndContinueButton(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        handler.saveAndContinue();
    }

    /*-----------------------------------------------------------------------*/
    /*----------------------- Public acessor methods  -----------------------*/
    /*-----------------------------------------------------------------------*/

    public BeanFilterableComboBox<CaracteristicQualitativeValue> getAccidentalDeadOrAliveComboBox() {
        return accidentalDeadOrAliveComboBox;
    }

    public JLabel getAccidentalDeadOrAliveLabel() {
        return accidentalDeadOrAliveLabel;
    }

    public BeanFilterableComboBox<CaracteristicQualitativeValue> getAccidentalGenderComboBox() {
        return accidentalGenderComboBox;
    }

    public JLabel getAccidentalGenderLabel() {
        return accidentalGenderLabel;
    }

    public BeanFilterableComboBox<Caracteristic> getAccidentalLengthStepCaracteristicComboBox() {
        return accidentalLengthStepCaracteristicComboBox;
    }

    public JLabel getAccidentalLengthStepCaracteristicLabel() {
        return accidentalLengthStepCaracteristicLabel;
    }

    public NumberEditor getAccidentalSizeField() {
        return accidentalSizeField;
    }

    public JLabel getAccidentalSizeLabel() {
        return accidentalSizeLabel;
    }

    public BeanFilterableComboBox<Species> getAccidentalSpeciesComboBox() {
        return accidentalSpeciesComboBox;
    }

    public JLabel getAccidentalSpeciesLabel() {
        return accidentalSpeciesLabel;
    }

    public NumberEditor getAccidentalWeightField() {
        return accidentalWeightField;
    }

    public JLabel getAccidentalWeightLabel() {
        return accidentalWeightLabel;
    }

    public TuttiHelpBroker getBroker() {
        return broker;
    }

    public JButton getCancelButton() {
        return cancelButton;
    }

    public Table getConfigurationPanel() {
        return configurationPanel;
    }

    public CreateAccidentalBatchUIHandler getHandler() {
        return handler;
    }

    public CreateAccidentalBatchUIModel getModel() {
        return model;
    }

    public JButton getSaveAndCloseButton() {
        return saveAndCloseButton;
    }

    public JButton getSaveAndContinueButton() {
        return saveAndContinueButton;
    }

    public SwingValidator<CreateAccidentalBatchUIModel> getValidator() {
        return validator;
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Other methods ----------------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    public void registerHelpId(TuttiHelpBroker broker, Component component, String helpId) {
        broker.installUI(component, helpId);
    }

    @Override
    public void showHelp(String helpId) {
        getBroker().showHelp(this, helpId);
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Protected acessors methods  ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected JPanel get$JPanel0() {
        return $JPanel0;
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Components creation methods ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected void addChildrenToConfigurationPanel() {
        if (!allComponentsCreated) {
            return;
        }
        configurationPanel.add(accidentalSpeciesLabel, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 1, new Insets(3, 3, 3, 3), 0, 0));
        configurationPanel.add(SwingUtil.boxComponentWithJxLayer(accidentalSpeciesComboBox), new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        configurationPanel.add(accidentalGenderLabel, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 17, 1, new Insets(3, 3, 3, 3), 0, 0));
        configurationPanel.add(SwingUtil.boxComponentWithJxLayer(accidentalGenderComboBox), new GridBagConstraints(1, 1, 1, 1, 1.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        configurationPanel.add(accidentalWeightLabel, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 17, 1, new Insets(3, 3, 3, 3), 0, 0));
        configurationPanel.add(SwingUtil.boxComponentWithJxLayer(accidentalWeightField), new GridBagConstraints(1, 2, 2, 1, 1.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        configurationPanel.add(accidentalSizeLabel, new GridBagConstraints(0, 3, 1, 1, 0.0, 0.0, 17, 1, new Insets(3, 3, 3, 3), 0, 0));
        configurationPanel.add(SwingUtil.boxComponentWithJxLayer(accidentalSizeField), new GridBagConstraints(1, 3, 2, 1, 1.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        configurationPanel.add(accidentalLengthStepCaracteristicLabel, new GridBagConstraints(0, 4, 1, 1, 0.0, 0.0, 17, 1, new Insets(3, 3, 3, 3), 0, 0));
        configurationPanel.add(SwingUtil.boxComponentWithJxLayer(accidentalLengthStepCaracteristicComboBox), new GridBagConstraints(1, 4, 2, 1, 1.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        configurationPanel.add(accidentalDeadOrAliveLabel, new GridBagConstraints(0, 5, 1, 1, 0.0, 0.0, 17, 1, new Insets(3, 3, 3, 3), 0, 0));
        configurationPanel.add(SwingUtil.boxComponentWithJxLayer(accidentalDeadOrAliveComboBox), new GridBagConstraints(1, 5, 1, 1, 1.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
    }

    protected void addChildrenToCreateAccidentalBatchTopPanel() {
        if (!allComponentsCreated) {
            return;
        }
        add(configurationPanel, BorderLayout.CENTER);
        add($JPanel0, BorderLayout.SOUTH);
    }

    protected void addChildrenToValidator() {
        if (!allComponentsCreated) {
            return;
        }
        validator.setUiClass(ImageValidationUI.class);
        validator.setBean(model);
    }

    protected void createAccidentalDeadOrAliveComboBox() {
        $objectMap.put("accidentalDeadOrAliveComboBox", accidentalDeadOrAliveComboBox = new BeanFilterableComboBox<CaracteristicQualitativeValue>(this));
        
        accidentalDeadOrAliveComboBox.setName("accidentalDeadOrAliveComboBox");
        accidentalDeadOrAliveComboBox.setProperty("deadOrAlive");
        accidentalDeadOrAliveComboBox.setShowReset(true);
        accidentalDeadOrAliveComboBox.putClientProperty("help", "tutti.createAccidentalBatch.field.accidentalDeadOrAlive.help");
    }

    protected void createAccidentalDeadOrAliveLabel() {
        $objectMap.put("accidentalDeadOrAliveLabel", accidentalDeadOrAliveLabel = new JLabel());
        
        accidentalDeadOrAliveLabel.setName("accidentalDeadOrAliveLabel");
        accidentalDeadOrAliveLabel.setText(t("tutti.createAccidentalBatch.field.accidentalDeadOrAlive"));
        accidentalDeadOrAliveLabel.setToolTipText(t("tutti.createAccidentalBatch.field.accidentalDeadOrAlive.tip"));
        accidentalDeadOrAliveLabel.putClientProperty("help", "tutti.createAccidentalBatch.field.accidentalDeadOrAlive.help");
    }

    protected void createAccidentalGenderComboBox() {
        $objectMap.put("accidentalGenderComboBox", accidentalGenderComboBox = new BeanFilterableComboBox<CaracteristicQualitativeValue>(this));
        
        accidentalGenderComboBox.setName("accidentalGenderComboBox");
        accidentalGenderComboBox.setProperty("gender");
        accidentalGenderComboBox.setShowReset(true);
        accidentalGenderComboBox.putClientProperty("help", "tutti.createAccidentalBatch.field.accidentalGender.help");
    }

    protected void createAccidentalGenderLabel() {
        $objectMap.put("accidentalGenderLabel", accidentalGenderLabel = new JLabel());
        
        accidentalGenderLabel.setName("accidentalGenderLabel");
        accidentalGenderLabel.setText(t("tutti.createAccidentalBatch.field.accidentalGender"));
        accidentalGenderLabel.setToolTipText(t("tutti.createAccidentalBatch.field.accidentalGender.tip"));
        accidentalGenderLabel.putClientProperty("help", "tutti.createAccidentalBatch.field.accidentalGender.help");
    }

    protected void createAccidentalLengthStepCaracteristicComboBox() {
        $objectMap.put("accidentalLengthStepCaracteristicComboBox", accidentalLengthStepCaracteristicComboBox = new BeanFilterableComboBox<Caracteristic>(this));
        
        accidentalLengthStepCaracteristicComboBox.setName("accidentalLengthStepCaracteristicComboBox");
        accidentalLengthStepCaracteristicComboBox.setProperty("lengthStepCaracteristic");
        accidentalLengthStepCaracteristicComboBox.setShowReset(true);
        accidentalLengthStepCaracteristicComboBox.putClientProperty("help", "tutti.createAccidentalBatch.field.accidentalLengthStepCaracteristic.help");
    }

    protected void createAccidentalLengthStepCaracteristicLabel() {
        $objectMap.put("accidentalLengthStepCaracteristicLabel", accidentalLengthStepCaracteristicLabel = new JLabel());
        
        accidentalLengthStepCaracteristicLabel.setName("accidentalLengthStepCaracteristicLabel");
        accidentalLengthStepCaracteristicLabel.setText(t("tutti.createAccidentalBatch.field.accidentalLengthStepCaracteristic"));
        accidentalLengthStepCaracteristicLabel.setToolTipText(t("tutti.createAccidentalBatch.field.accidentalLengthStepCaracteristic.tip"));
        accidentalLengthStepCaracteristicLabel.putClientProperty("help", "tutti.createAccidentalBatch.field.accidentalLengthStepCaracteristic.help");
    }

    protected void createAccidentalSizeField() {
        $objectMap.put("accidentalSizeField", accidentalSizeField = new NumberEditor(this));
        
        accidentalSizeField.setName("accidentalSizeField");
        accidentalSizeField.setProperty("size");
        accidentalSizeField.setShowReset(true);
        accidentalSizeField.putClientProperty("help", "tutti.createAccidentalBatch.field.accidentalSize.help");
    }

    protected void createAccidentalSizeLabel() {
        $objectMap.put("accidentalSizeLabel", accidentalSizeLabel = new JLabel());
        
        accidentalSizeLabel.setName("accidentalSizeLabel");
        accidentalSizeLabel.setText(t("tutti.createAccidentalBatch.field.accidentalSize"));
        accidentalSizeLabel.setToolTipText(t("tutti.createAccidentalBatch.field.accidentalSize.tip"));
        accidentalSizeLabel.putClientProperty("help", "tutti.createAccidentalBatch.field.accidentalSize.help");
    }

    protected void createAccidentalSpeciesComboBox() {
        $objectMap.put("accidentalSpeciesComboBox", accidentalSpeciesComboBox = new BeanFilterableComboBox<Species>(this));
        
        accidentalSpeciesComboBox.setName("accidentalSpeciesComboBox");
        accidentalSpeciesComboBox.setProperty("species");
        accidentalSpeciesComboBox.setShowReset(true);
        accidentalSpeciesComboBox.putClientProperty("help", "tutti.createAccidentalBatch.field.accidentalSpecies.help");
    }

    protected void createAccidentalSpeciesLabel() {
        $objectMap.put("accidentalSpeciesLabel", accidentalSpeciesLabel = new JLabel());
        
        accidentalSpeciesLabel.setName("accidentalSpeciesLabel");
        accidentalSpeciesLabel.setText(t("tutti.createAccidentalBatch.field.accidentalSpecies"));
        accidentalSpeciesLabel.setToolTipText(t("tutti.createAccidentalBatch.field.accidentalSpecies.tip"));
        accidentalSpeciesLabel.putClientProperty("help", "tutti.createAccidentalBatch.field.accidentalSpecies.help");
    }

    protected void createAccidentalWeightField() {
        $objectMap.put("accidentalWeightField", accidentalWeightField = new NumberEditor(this));
        
        accidentalWeightField.setName("accidentalWeightField");
        accidentalWeightField.setProperty("weight");
        accidentalWeightField.setShowReset(true);
        accidentalWeightField.putClientProperty("help", "tutti.createAccidentalBatch.field.accidentalWeight.help");
    }

    protected void createAccidentalWeightLabel() {
        $objectMap.put("accidentalWeightLabel", accidentalWeightLabel = new JLabel());
        
        accidentalWeightLabel.setName("accidentalWeightLabel");
        accidentalWeightLabel.setText(t("tutti.createAccidentalBatch.field.accidentalWeight"));
        accidentalWeightLabel.setToolTipText(t("tutti.createAccidentalBatch.field.accidentalWeight.tip"));
        accidentalWeightLabel.putClientProperty("help", "tutti.createAccidentalBatch.field.accidentalWeight.help");
        accidentalWeightLabel.putClientProperty("addWeightUnit", handler.getConfig().getAccidentalCatchWeightUnit());
    }

    protected void createBroker() {
        $objectMap.put("broker", broker = new TuttiHelpBroker("tutti.createAccidentalBatch.help"));
    }

    protected void createCancelButton() {
        $objectMap.put("cancelButton", cancelButton = new JButton());
        
        cancelButton.setName("cancelButton");
        cancelButton.setText(t("tutti.createAccidentalBatch.action.cancel"));
        cancelButton.setToolTipText(t("tutti.createAccidentalBatch.action.cancel.tip"));
        cancelButton.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__cancelButton"));
        cancelButton.putClientProperty("help", "tutti.createAccidentalBatch.action.cancel.help");
    }

    protected void createConfigurationPanel() {
        $objectMap.put("configurationPanel", configurationPanel = new Table());
        
        configurationPanel.setName("configurationPanel");
    }

    protected CreateAccidentalBatchUIHandler createHandler() {
        return new CreateAccidentalBatchUIHandler();
    }

    protected void createModel() {
        $objectMap.put("model", model = getContextValue(CreateAccidentalBatchUIModel.class));
    }

    protected void createSaveAndCloseButton() {
        $objectMap.put("saveAndCloseButton", saveAndCloseButton = new JButton());
        
        saveAndCloseButton.setName("saveAndCloseButton");
        saveAndCloseButton.setText(t("tutti.createAccidentalBatch.action.saveAndClose"));
        saveAndCloseButton.setToolTipText(t("tutti.createAccidentalBatch.action.saveAndClose.tip"));
        saveAndCloseButton.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__saveAndCloseButton"));
        saveAndCloseButton.putClientProperty("help", "tutti.createAccidentalBatch.action.saveAndClose.help");
    }

    protected void createSaveAndContinueButton() {
        $objectMap.put("saveAndContinueButton", saveAndContinueButton = new JButton());
        
        saveAndContinueButton.setName("saveAndContinueButton");
        saveAndContinueButton.setText(t("tutti.createAccidentalBatch.action.saveAndContinue"));
        saveAndContinueButton.setToolTipText(t("tutti.createAccidentalBatch.action.saveAndContinue.tip"));
        saveAndContinueButton.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__saveAndContinueButton"));
        saveAndContinueButton.putClientProperty("help", "tutti.createAccidentalBatch.action.saveAndContinue.help");
    }

    protected void createValidator() {
        $objectMap.put("validator", validator = SwingValidator.newValidator(CreateAccidentalBatchUIModel.class, null));
    }

    /*-----------------------------------------------------------------------*/
    /*------------------------ Internal jaxx methods ------------------------*/
    /*-----------------------------------------------------------------------*/

    private void $completeSetup() {
        allComponentsCreated = true;
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        addChildrenToCreateAccidentalBatchTopPanel();
        addChildrenToValidator();
        addChildrenToConfigurationPanel();
        // inline complete setup of $JPanel0
        $JPanel0.add(cancelButton);
        $JPanel0.add(saveAndContinueButton);
        $JPanel0.add(saveAndCloseButton);
        
        // apply 8 data bindings
        JAXXUtil.applyDataBinding(this, $bindings.keySet());
        
        // apply 31 property setters
        accidentalSpeciesComboBox.setBeanType(Species.class);
        accidentalGenderComboBox.setBeanType(CaracteristicQualitativeValue.class);
        accidentalLengthStepCaracteristicComboBox.setBeanType(Caracteristic.class);
        accidentalDeadOrAliveComboBox.setBeanType(CaracteristicQualitativeValue.class);
        accidentalSpeciesLabel.setLabelFor(accidentalSpeciesComboBox);
        accidentalSpeciesComboBox.setBean(model);
        accidentalGenderLabel.setLabelFor(accidentalGenderComboBox);
        accidentalGenderComboBox.setBean(model);
        accidentalWeightLabel.setLabelFor(accidentalWeightField);
        accidentalWeightField.setBean(model);
        accidentalWeightField.setAutoPopup(handler.getConfig().isAutoPopupNumberEditor());
        accidentalWeightField.setShowPopupButton(handler.getConfig().isShowNumberEditorButton());
        accidentalWeightField.setNumberType(Float.class);
        accidentalSizeLabel.setLabelFor(accidentalSizeField);
        accidentalSizeField.setBean(model);
        accidentalSizeField.setAutoPopup(handler.getConfig().isAutoPopupNumberEditor());
        accidentalSizeField.setNumberPattern(DECIMAL3_PATTERN);
        accidentalSizeField.setShowPopupButton(handler.getConfig().isShowNumberEditorButton());
        accidentalSizeField.setNumberType(Float.class);
        accidentalLengthStepCaracteristicLabel.setLabelFor(accidentalLengthStepCaracteristicComboBox);
        accidentalLengthStepCaracteristicComboBox.setBean(model);
        accidentalDeadOrAliveLabel.setLabelFor(accidentalDeadOrAliveComboBox);
        accidentalDeadOrAliveComboBox.setBean(model);
        cancelButton.setIcon(SwingUtil.createActionIcon("cancel"));
        cancelButton.setMnemonic(SwingUtil.getFirstCharAt(t("tutti.createAccidentalBatch.action.cancel.mnemonic"),'Z'));
        saveAndContinueButton.setIcon(SwingUtil.createActionIcon("save"));
        saveAndContinueButton.setMnemonic(SwingUtil.getFirstCharAt(t("tutti.createAccidentalBatch.action.saveAndContinue.mnemonic"),'Z'));
        saveAndCloseButton.setIcon(SwingUtil.createActionIcon("save"));
        saveAndCloseButton.setMnemonic(SwingUtil.getFirstCharAt(t("tutti.createAccidentalBatch.action.saveAndClose.mnemonic"),'Z'));
        // late initializer
        // help broker setup
        TuttiHelpBroker _broker = getBroker();
        registerHelpId(_broker, createAccidentalBatchTopPanel, "tutti.createIndividualObservationBatch.help");
        registerHelpId(_broker, accidentalSpeciesLabel, "tutti.createAccidentalBatch.field.accidentalSpecies.help");
        registerHelpId(_broker, accidentalSpeciesComboBox, "tutti.createAccidentalBatch.field.accidentalSpecies.help");
        registerHelpId(_broker, accidentalGenderLabel, "tutti.createAccidentalBatch.field.accidentalGender.help");
        registerHelpId(_broker, accidentalGenderComboBox, "tutti.createAccidentalBatch.field.accidentalGender.help");
        registerHelpId(_broker, accidentalWeightLabel, "tutti.createAccidentalBatch.field.accidentalWeight.help");
        registerHelpId(_broker, accidentalWeightField, "tutti.createAccidentalBatch.field.accidentalWeight.help");
        registerHelpId(_broker, accidentalSizeLabel, "tutti.createAccidentalBatch.field.accidentalSize.help");
        registerHelpId(_broker, accidentalSizeField, "tutti.createAccidentalBatch.field.accidentalSize.help");
        registerHelpId(_broker, accidentalLengthStepCaracteristicLabel, "tutti.createAccidentalBatch.field.accidentalLengthStepCaracteristic.help");
        registerHelpId(_broker, accidentalLengthStepCaracteristicComboBox, "tutti.createAccidentalBatch.field.accidentalLengthStepCaracteristic.help");
        registerHelpId(_broker, accidentalDeadOrAliveLabel, "tutti.createAccidentalBatch.field.accidentalDeadOrAlive.help");
        registerHelpId(_broker, accidentalDeadOrAliveComboBox, "tutti.createAccidentalBatch.field.accidentalDeadOrAlive.help");
        registerHelpId(_broker, cancelButton, "tutti.createAccidentalBatch.action.cancel.help");
        registerHelpId(_broker, saveAndContinueButton, "tutti.createAccidentalBatch.action.saveAndContinue.help");
        registerHelpId(_broker, saveAndCloseButton, "tutti.createAccidentalBatch.action.saveAndClose.help");
        _broker.prepareUI(this);
        // register 1 validator(s)
        validatorIds = SwingValidatorUtil.detectValidators(this);
        SwingValidatorUtil.installUI(this);
    }

    private void $initialize() {
        if (allComponentsCreated) {
            return;
        }
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        handler.beforeInit(this);
        $objectMap.put("createAccidentalBatchTopPanel", createAccidentalBatchTopPanel);
        createModel();
        createValidator();
        createBroker();
        createConfigurationPanel();
        createAccidentalSpeciesLabel();
        createAccidentalSpeciesComboBox();
        createAccidentalGenderLabel();
        createAccidentalGenderComboBox();
        createAccidentalWeightLabel();
        createAccidentalWeightField();
        createAccidentalSizeLabel();
        createAccidentalSizeField();
        createAccidentalLengthStepCaracteristicLabel();
        createAccidentalLengthStepCaracteristicComboBox();
        createAccidentalDeadOrAliveLabel();
        createAccidentalDeadOrAliveComboBox();
        // inline creation of $JPanel0
        $objectMap.put("$JPanel0", $JPanel0 = new JPanel());
        
        $JPanel0.setName("$JPanel0");
        $JPanel0.setLayout(new GridLayout(1, 0));
        createCancelButton();
        createSaveAndContinueButton();
        createSaveAndCloseButton();
        // inline creation of createAccidentalBatchTopPanel
        setName("createAccidentalBatchTopPanel");
        setLayout(new BorderLayout());
        createAccidentalBatchTopPanel.putClientProperty("help", "tutti.createIndividualObservationBatch.help");
        
        // registers 8 data bindings
        $registerDefaultBindings();
        $completeSetup();
        handler.afterInit(this);
    }

    private void $registerDefaultBindings() {
        // register 8 data bindings
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_ACCIDENTAL_SPECIES_COMBO_BOX_SELECTED_ITEM, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("species", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    accidentalSpeciesComboBox.setSelectedItem(model.getSpecies());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("species", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_ACCIDENTAL_GENDER_COMBO_BOX_SELECTED_ITEM, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("gender", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    accidentalGenderComboBox.setSelectedItem(model.getGender());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("gender", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_ACCIDENTAL_WEIGHT_FIELD_NUMBER_VALUE, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("weight", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    accidentalWeightField.setNumberValue(model.getWeight());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("weight", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_ACCIDENTAL_SIZE_FIELD_NUMBER_VALUE, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("size", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    accidentalSizeField.setNumberValue(model.getSize());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("size", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_ACCIDENTAL_LENGTH_STEP_CARACTERISTIC_COMBO_BOX_SELECTED_ITEM, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("lengthStepCaracteristic", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    accidentalLengthStepCaracteristicComboBox.setSelectedItem(model.getLengthStepCaracteristic());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("lengthStepCaracteristic", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_ACCIDENTAL_DEAD_OR_ALIVE_COMBO_BOX_SELECTED_ITEM, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("deadOrAlive", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    accidentalDeadOrAliveComboBox.setSelectedItem(model.getDeadOrAlive());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("deadOrAlive", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_SAVE_AND_CONTINUE_BUTTON_ENABLED, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("valid", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    saveAndContinueButton.setEnabled(model.isValid());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("valid", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_SAVE_AND_CLOSE_BUTTON_ENABLED, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("valid", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    saveAndCloseButton.setEnabled(model.isValid());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("valid", this);
                }
            }
        });
    }

}