/*
 * Decompiled with CFR 0.152.
 */
package liquibase.ext.logging.slf4j;

import liquibase.changelog.ChangeSet;
import liquibase.changelog.DatabaseChangeLog;
import liquibase.logging.core.AbstractLogger;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Slf4jLogger
extends AbstractLogger {
    private static final int PRIORITY = 5;
    private Logger logger;
    private String changeLogName = null;
    private String changeSetName = null;

    public void setName(String name) {
        this.logger = LoggerFactory.getLogger((String)name);
    }

    public void setLogLevel(String logLevel, String logFile) {
    }

    public void setChangeLog(DatabaseChangeLog databaseChangeLog) {
        this.changeLogName = databaseChangeLog == null ? null : databaseChangeLog.getFilePath();
    }

    public void setChangeSet(ChangeSet changeSet) {
        this.changeSetName = changeSet == null ? null : changeSet.toString(false);
    }

    public void severe(String message) {
        if (this.logger.isErrorEnabled()) {
            this.logger.error(this.buildMessage(message));
        }
    }

    public void severe(String message, Throwable throwable) {
        if (this.logger.isErrorEnabled()) {
            this.logger.error(this.buildMessage(message), throwable);
        }
    }

    public void warning(String message) {
        if (this.logger.isWarnEnabled()) {
            this.logger.warn(this.buildMessage(message));
        }
    }

    public void warning(String message, Throwable throwable) {
        if (this.logger.isWarnEnabled()) {
            this.logger.warn(this.buildMessage(message), throwable);
        }
    }

    public void info(String message) {
        if (this.logger.isInfoEnabled()) {
            this.logger.info(this.buildMessage(message));
        }
    }

    public void info(String message, Throwable throwable) {
        if (this.logger.isInfoEnabled()) {
            this.logger.info(this.buildMessage(message), throwable);
        }
    }

    public void debug(String message) {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug(this.buildMessage(message));
        }
    }

    public void debug(String message, Throwable throwable) {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug(this.buildMessage(message), throwable);
        }
    }

    public int getPriority() {
        return 5;
    }

    private String buildMessage(String message) {
        StringBuilder msg = new StringBuilder();
        if (this.changeLogName != null) {
            msg.append(this.changeLogName).append(": ");
        }
        if (this.changeSetName != null) {
            msg.append(this.changeSetName.replace(this.changeLogName + "::", "")).append(": ");
        }
        msg.append(message);
        return msg.toString();
    }
}

