/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.boot.registry.internal;

import java.util.List;
import java.util.Map;
import org.hibernate.boot.registry.BootstrapServiceRegistry;
import org.hibernate.boot.registry.StandardServiceInitiator;
import org.hibernate.boot.registry.StandardServiceRegistry;
import org.hibernate.service.Service;
import org.hibernate.service.internal.AbstractServiceRegistryImpl;
import org.hibernate.service.internal.ProvidedService;
import org.hibernate.service.spi.Configurable;
import org.hibernate.service.spi.ServiceBinding;
import org.hibernate.service.spi.ServiceInitiator;

public class StandardServiceRegistryImpl
extends AbstractServiceRegistryImpl
implements StandardServiceRegistry {
    private final Map configurationValues;

    public StandardServiceRegistryImpl(BootstrapServiceRegistry bootstrapServiceRegistry, List<StandardServiceInitiator> serviceInitiators, List<ProvidedService> providedServices, Map<?, ?> configurationValues) {
        this(true, bootstrapServiceRegistry, serviceInitiators, providedServices, configurationValues);
    }

    public StandardServiceRegistryImpl(boolean autoCloseRegistry, BootstrapServiceRegistry bootstrapServiceRegistry, List<StandardServiceInitiator> serviceInitiators, List<ProvidedService> providedServices, Map<?, ?> configurationValues) {
        super(bootstrapServiceRegistry, autoCloseRegistry);
        this.configurationValues = configurationValues;
        for (ServiceInitiator serviceInitiator : serviceInitiators) {
            this.createServiceBinding(serviceInitiator);
        }
        for (ProvidedService providedService : providedServices) {
            this.createServiceBinding(providedService);
        }
    }

    @Override
    public <R extends Service> R initiateService(ServiceInitiator<R> serviceInitiator) {
        return ((StandardServiceInitiator)serviceInitiator).initiateService(this.configurationValues, this);
    }

    @Override
    public <R extends Service> void configureService(ServiceBinding<R> serviceBinding) {
        if (Configurable.class.isInstance(serviceBinding.getService())) {
            ((Configurable)serviceBinding.getService()).configure(this.configurationValues);
        }
    }
}

