/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.adagio.synchro.socket;

import fr.ifremer.adagio.synchro.socket.SynchroWorkerThread;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.net.ServerSocket;
import java.net.Socket;
import javax.net.ssl.SSLServerSocketFactory;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.http.HttpConnectionFactory;
import org.apache.http.HttpServerConnection;
import org.apache.http.impl.DefaultBHttpServerConnection;
import org.apache.http.impl.DefaultBHttpServerConnectionFactory;
import org.apache.http.protocol.HttpService;

public class SynchroRequestListenerThread
extends Thread {
    private static final Log log = LogFactory.getLog(SynchroRequestListenerThread.class);
    private final HttpConnectionFactory<DefaultBHttpServerConnection> connFactory = DefaultBHttpServerConnectionFactory.INSTANCE;
    private final ServerSocket serversocket;
    private final HttpService httpService;

    public SynchroRequestListenerThread(int port, HttpService httpService, SSLServerSocketFactory sf) throws IOException {
        this.serversocket = sf != null ? sf.createServerSocket(port) : new ServerSocket(port);
        this.httpService = httpService;
    }

    @Override
    public void run() {
        log.debug((Object)("Listening on port " + this.serversocket.getLocalPort()));
        while (!Thread.interrupted()) {
            try {
                Socket socket = this.serversocket.accept();
                log.debug((Object)("Incoming connection from " + socket.getInetAddress()));
                HttpServerConnection conn = (HttpServerConnection)this.connFactory.createConnection(socket);
                SynchroWorkerThread t = new SynchroWorkerThread(this.httpService, conn);
                t.setDaemon(true);
                t.start();
            }
            catch (InterruptedIOException ex) {
                break;
            }
            catch (IOException e) {
                log.error((Object)("I/O error initialising connection thread: " + e.getMessage()));
                break;
            }
        }
    }
}

