/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.model.api;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.birt.report.model.api.DesignElementHandle;
import org.eclipse.birt.report.model.api.FactoryPropertyHandle;
import org.eclipse.birt.report.model.api.SharedStyleHandle;
import org.eclipse.birt.report.model.api.StyleHandle;
import org.eclipse.birt.report.model.api.core.IDesignElement;
import org.eclipse.birt.report.model.api.metadata.IElementDefn;
import org.eclipse.birt.report.model.api.metadata.IElementPropertyDefn;
import org.eclipse.birt.report.model.core.DesignElement;
import org.eclipse.birt.report.model.core.Module;
import org.eclipse.birt.report.model.core.PropertySearchStrategy;
import org.eclipse.birt.report.model.core.StyleElement;
import org.eclipse.birt.report.model.core.StyledElement;
import org.eclipse.birt.report.model.elements.Style;
import org.eclipse.birt.report.model.metadata.ElementPropertyDefn;
import org.eclipse.birt.report.model.metadata.MetaDataDictionary;
import org.eclipse.birt.report.model.util.ModelUtil;
import org.eclipse.birt.report.model.util.StructureContextUtil;

public class FactoryElementHandle {
    private static final String INHERIT_STYLE_NAME = "inherit-style";
    private static final String RELATED_CONTAINER_STYLE_NAME = "related-container-style";
    private DesignElementHandle elementHandle;

    FactoryElementHandle(DesignElementHandle elementHandle) {
        assert (elementHandle != null);
        this.elementHandle = elementHandle;
    }

    public List<StyleHandle> getAllFactoryStyles() {
        if (this.elementHandle == null) {
            return Collections.emptyList();
        }
        DesignElement element = this.elementHandle.getElement();
        if (!(element instanceof StyledElement)) {
            return Collections.emptyList();
        }
        Module module = this.elementHandle.getModule();
        IElementDefn styleDefn = MetaDataDictionary.getInstance().getStyle();
        IDesignElement inheritStyle = null;
        IDesignElement relatedContainerStyle = null;
        List<StyleElement> selfSelectors = null;
        List<StyleElement> slotSelectors = null;
        PropertySearchStrategy.PropertyValueInfo valueInfo = null;
        Object value = null;
        boolean readSelectos = false;
        List<IElementPropertyDefn> props = styleDefn.getProperties();
        int i = 0;
        while (i < props.size()) {
            ElementPropertyDefn prop = (ElementPropertyDefn)props.get(i);
            if (prop.isStyleProperty()) {
                Object clonedValue;
                if (!readSelectos) {
                    valueInfo = PropertySearchStrategy.getInstance().createPropertyValueInfo();
                    value = element.getPropertySearchStrategy().getPropertyFromSelfSelector(module, element, prop, valueInfo);
                    selfSelectors = valueInfo.getSelectorStyles();
                    valueInfo = PropertySearchStrategy.getInstance().createPropertyValueInfo();
                    value = element.getPropertySearchStrategy().getPropertyFromSlotSelector(module, element, prop, valueInfo);
                    slotSelectors = valueInfo.getSelectorStyles();
                    readSelectos = true;
                }
                if ((value = element.getPropertySearchStrategy().getPropertyFromParent(module, element, prop)) != null) {
                    if (inheritStyle == null) {
                        inheritStyle = new Style(INHERIT_STYLE_NAME);
                    }
                    clonedValue = ModelUtil.copyValue(prop, value);
                    ((DesignElement)inheritStyle).setProperty(prop, clonedValue);
                    if (prop.getTypeCode() == 16) {
                        StructureContextUtil.setStructureContext(prop, clonedValue, element);
                    }
                }
                if ((value = element.getPropertySearchStrategy().getPropertyRelatedToContainer(module, element, prop)) != null) {
                    if (relatedContainerStyle == null) {
                        relatedContainerStyle = new Style(RELATED_CONTAINER_STYLE_NAME);
                    }
                    clonedValue = ModelUtil.copyValue(prop, value);
                    ((DesignElement)relatedContainerStyle).setProperty(prop, clonedValue);
                    if (prop.getTypeCode() == 16) {
                        StructureContextUtil.setStructureContext(prop, clonedValue, element);
                    }
                }
            }
            ++i;
        }
        ArrayList<StyleHandle> styles = new ArrayList<StyleHandle>();
        SharedStyleHandle sharedStyle = this.elementHandle.getStyle();
        if (sharedStyle != null) {
            styles.add(sharedStyle);
        }
        if (inheritStyle != null) {
            styles.add((StyleHandle)inheritStyle.getHandle(module));
        }
        if (selfSelectors != null) {
            int i2 = 0;
            while (i2 < selfSelectors.size()) {
                styles.add((StyleHandle)selfSelectors.get(i2).getHandle(module));
                ++i2;
            }
        }
        if (slotSelectors != null) {
            int i3 = 0;
            while (i3 < slotSelectors.size()) {
                styles.add((StyleHandle)((StyleElement)slotSelectors.get(i3)).getHandle(module));
                ++i3;
            }
        }
        if (relatedContainerStyle != null) {
            styles.add((StyleHandle)relatedContainerStyle.getHandle(module));
        }
        return styles;
    }

    public FactoryPropertyHandle getFactoryPropertyHandle(String propName) {
        return this.elementHandle.getFactoryPropertyHandle(propName);
    }
}

