/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.tutti.ui.swing.action;

import com.google.common.collect.Lists;
import com.google.common.collect.Multimap;
import fr.ifremer.tutti.persistence.entities.TuttiEntities;
import fr.ifremer.tutti.persistence.entities.data.BatchContainer;
import fr.ifremer.tutti.persistence.entities.data.BenthosBatch;
import fr.ifremer.tutti.persistence.entities.data.CatchBatch;
import fr.ifremer.tutti.persistence.entities.data.FishingOperation;
import fr.ifremer.tutti.persistence.entities.data.SampleCategory;
import fr.ifremer.tutti.persistence.entities.data.SpeciesAbleBatch;
import fr.ifremer.tutti.persistence.entities.data.SpeciesBatch;
import fr.ifremer.tutti.service.PersistenceService;
import fr.ifremer.tutti.service.catches.TuttiWeightComputingException;
import fr.ifremer.tutti.service.catches.WeightCleaningService;
import fr.ifremer.tutti.service.catches.WeightComputingService;
import fr.ifremer.tutti.ui.swing.action.AbstractTuttiAction;
import fr.ifremer.tutti.ui.swing.content.operation.catches.EditCatchesUI;
import fr.ifremer.tutti.ui.swing.content.operation.catches.EditCatchesUIHandler;
import fr.ifremer.tutti.ui.swing.content.operation.catches.EditCatchesUIModel;
import fr.ifremer.tutti.ui.swing.content.operation.catches.benthos.BenthosBatchRowModel;
import fr.ifremer.tutti.ui.swing.content.operation.catches.species.SpeciesBatchRowModel;
import fr.ifremer.tutti.ui.swing.util.TuttiUIUtil;
import java.awt.Component;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JOptionPane;
import javax.swing.JTable;
import javax.swing.SwingUtilities;
import org.nuiton.i18n.I18n;

public class ComputeBatchWeightsAction
extends AbstractTuttiAction<EditCatchesUIModel, EditCatchesUI, EditCatchesUIHandler> {
    protected final WeightCleaningService cleaningService = this.getContext().getWeightCleaningService();

    public ComputeBatchWeightsAction(EditCatchesUIHandler handler) {
        super(handler, true);
    }

    public boolean prepareAction() throws Exception {
        boolean doAction = super.prepareAction();
        if (doAction) {
            FishingOperation fishingOperation = ((EditCatchesUIModel)this.getModel()).getFishingOperation();
            Multimap errors = this.cleaningService.checkFishingOperation(fishingOperation.getId());
            if (errors.isEmpty()) {
                this.sendMessage(I18n._((String)"tutti.editCatchBatch.action.computeWeights.no.double.weight.detected", (Object[])new Object[0]));
            } else {
                String errorsStr = this.cleaningService.errorsToString(errors);
                String htmlMessage = I18n._((String)"tutti.editCatchBatch.action.computeWeights.double.weight.detected", (Object[])new Object[]{errorsStr});
                JOptionPane.showMessageDialog((Component)this.getContext().getActionUI(), htmlMessage, I18n._((String)"tutti.editCatchBatch.action.computeWeights.double.weight.detected.title", (Object[])new Object[0]), 2);
            }
        }
        return doAction;
    }

    @Override
    public void doAction() throws Exception {
        int answer;
        String htmlMessage;
        BatchContainer computedMarineLitterBatches;
        Float totalBenthosSortedWeight;
        BatchContainer computedBenthosBatches;
        Float totalSpeciesSortedWeight;
        BatchContainer computedSpeciesBatches;
        PersistenceService persistenceService = this.getContext().getPersistenceService();
        WeightComputingService weightComputingService = this.getContext().getWeightComputingService();
        EditCatchesUIModel model = (EditCatchesUIModel)this.getModel();
        model.setLoadingData(true);
        String operationId = model.getFishingOperation().getId();
        try {
            computedSpeciesBatches = weightComputingService.getComputedSpeciesBatches(operationId);
            totalSpeciesSortedWeight = this.computeSpeciesBatches(persistenceService, (BatchContainer<SpeciesBatch>)computedSpeciesBatches);
        }
        catch (TuttiWeightComputingException e) {
            ((EditCatchesUI)this.getUI()).getTabPane().setSelectedIndex(1);
            int index = e.getIndex();
            SpeciesBatchRowModel row = (SpeciesBatchRowModel)((EditCatchesUI)this.getUI()).getSpeciesTabContent().getModel().getRows().get(index);
            int column = "sampleCategoryWeight".equals(e.getProperty()) ? this.getFinestCategoryColumn(row.getFinestCategory().getCategoryId()) : 6;
            TuttiUIUtil.doSelectCell((JTable)((EditCatchesUI)this.getUI()).getSpeciesTabContent().getTable(), (int)index, (int)column);
            throw e;
        }
        try {
            computedBenthosBatches = weightComputingService.getComputedBenthosBatches(operationId);
            totalBenthosSortedWeight = this.computeBenthosBatches(persistenceService, (BatchContainer<BenthosBatch>)computedBenthosBatches);
        }
        catch (TuttiWeightComputingException e) {
            ((EditCatchesUI)this.getUI()).getTabPane().setSelectedIndex(2);
            int index = e.getIndex();
            BenthosBatchRowModel row = (BenthosBatchRowModel)((EditCatchesUI)this.getUI()).getBenthosTabContent().getModel().getRows().get(index);
            int column = "sampleCategoryWeight".equals(e.getProperty()) ? this.getFinestCategoryColumn(row.getFinestCategory().getCategoryId()) : 6;
            TuttiUIUtil.doSelectCell((JTable)((EditCatchesUI)this.getUI()).getBenthosTabContent().getTable(), (int)index, (int)column);
            throw e;
        }
        try {
            computedMarineLitterBatches = weightComputingService.getComputedMarineLitterBatches(operationId, model.getMarineLitterTotalWeight());
        }
        catch (TuttiWeightComputingException e) {
            ((EditCatchesUI)this.getUI()).getTabPane().setSelectedIndex(3);
            TuttiUIUtil.doSelectCell((JTable)((EditCatchesUI)this.getUI()).getMarineLitterTabContent().getTable(), (int)e.getIndex(), (int)3);
            throw e;
        }
        Float rate = this.getConfig().getDifferenceRateBetweenSortedAndTotalWeights();
        if (model.getSpeciesTotalSortedWeight() != null && model.getSpeciesTotalSortedWeight().floatValue() >= totalSpeciesSortedWeight.floatValue() && model.getSpeciesTotalSortedWeight().floatValue() < (1.0f + rate.floatValue() / 100.0f) * totalSpeciesSortedWeight.floatValue()) {
            ((EditCatchesUI)this.getUI()).getTabPane().setSelectedIndex(1);
            htmlMessage = String.format("<html>%s<hr/><br/>%s</html>", I18n._((String)"tutti.editCatchBatch.action.computeWeights.replaceTotalSortedWeight.message.species", (Object[])new Object[]{rate}), I18n._((String)"tutti.editCatchBatch.action.computeWeights.replaceTotalSortedWeight.help", (Object[])new Object[0]));
            answer = JOptionPane.showConfirmDialog((Component)this.getContext().getActionUI(), htmlMessage, I18n._((String)"tutti.editCatchBatch.action.computeWeights.replaceTotalSortedWeight.title", (Object[])new Object[0]), 0, 3);
            if (answer == 1) {
                model.setSpeciesTotalSortedWeight(null);
                model.setSpeciesTotalSortedComputedWeight(totalSpeciesSortedWeight);
            }
        }
        if (model.getBenthosTotalSortedWeight() != null && model.getBenthosTotalSortedWeight().floatValue() >= totalBenthosSortedWeight.floatValue() && model.getBenthosTotalSortedWeight().floatValue() < (1.0f + rate.floatValue() / 100.0f) * totalBenthosSortedWeight.floatValue()) {
            ((EditCatchesUI)this.getUI()).getTabPane().setSelectedIndex(2);
            htmlMessage = String.format("<html>%s<hr/><br/>%s</html>", I18n._((String)"tutti.editCatchBatch.action.computeWeights.replaceTotalSortedWeight.message.benthos", (Object[])new Object[]{rate}), I18n._((String)"tutti.editCatchBatch.action.computeWeights.replaceTotalSortedWeight.help", (Object[])new Object[0]));
            answer = JOptionPane.showConfirmDialog((Component)this.getContext().getActionUI(), htmlMessage, I18n._((String)"tutti.editCatchBatch.action.computeWeights.replaceTotalSortedWeight.title", (Object[])new Object[0]), 0, 3);
            if (answer == 1) {
                model.setBenthosTotalSortedWeight(null);
                model.setBenthosTotalSortedComputedWeight(totalBenthosSortedWeight);
            }
        }
        boolean modified = model.isModify();
        CatchBatch catchBatch = model.toEntity();
        weightComputingService.computeCatchBatchWeights(catchBatch, computedSpeciesBatches, computedBenthosBatches, computedMarineLitterBatches);
        model.fromEntity(catchBatch);
        model.setLoadingData(false);
        model.setModify(modified);
    }

    public void postSuccessAction() {
        super.postSuccessAction();
        ((EditCatchesUI)this.getUI()).repaint();
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                ((EditCatchesUI)ComputeBatchWeightsAction.this.getUI()).getComputeSpeciesBatchButton().requestFocus();
            }
        });
    }

    protected Float computeSpeciesBatches(PersistenceService persistenceService, BatchContainer<SpeciesBatch> computedSpeciesBatches) {
        Float totalSortedWeight = Float.valueOf(0.0f);
        if (computedSpeciesBatches != null) {
            ArrayList rows = Lists.newArrayList();
            List children = computedSpeciesBatches.getChildren();
            for (SpeciesBatch batch : children) {
                SpeciesBatchRowModel row = ((EditCatchesUI)this.getUI()).getSpeciesTabContent().getHandler().loadBatch(batch, null, rows);
                if (!persistenceService.isVracBatch((SpeciesAbleBatch)row)) continue;
                SampleCategory<?> sampleCategory = row.getFirstSampleCategory();
                Float weight = (Float)TuttiEntities.getValueOrComputedValue((Number)sampleCategory.getCategoryWeight(), (Number)sampleCategory.getComputedWeight());
                totalSortedWeight = Float.valueOf(totalSortedWeight.floatValue() + weight.floatValue());
            }
            ((EditCatchesUI)this.getUI()).getSpeciesTabContent().getModel().setRows(rows);
        }
        return totalSortedWeight;
    }

    protected Float computeBenthosBatches(PersistenceService persistenceService, BatchContainer<BenthosBatch> computedBenthosBatches) {
        Float totalSortedWeight = Float.valueOf(0.0f);
        if (computedBenthosBatches != null) {
            ArrayList rows = Lists.newArrayList();
            List children = computedBenthosBatches.getChildren();
            for (BenthosBatch batch : children) {
                BenthosBatchRowModel row = ((EditCatchesUI)this.getUI()).getBenthosTabContent().getHandler().loadBatch(batch, null, rows);
                if (!persistenceService.isVracBatch((SpeciesAbleBatch)row)) continue;
                SampleCategory<?> sampleCategory = row.getFirstSampleCategory();
                Float weight = (Float)TuttiEntities.getValueOrComputedValue((Number)sampleCategory.getCategoryWeight(), (Number)sampleCategory.getComputedWeight());
                totalSortedWeight = Float.valueOf(totalSortedWeight.floatValue() + weight.floatValue());
            }
            ((EditCatchesUI)this.getUI()).getBenthosTabContent().getModel().setRows(rows);
        }
        return totalSortedWeight;
    }

    protected int getFinestCategoryColumn(Integer categoryId) {
        int column = 1;
        List samplingOrderIds = this.getConfig().getSamplingOrderIds();
        int index = samplingOrderIds.indexOf(categoryId);
        if (index > -1) {
            column += index + 1;
        }
        return column;
    }
}

