/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.tutti.persistence.test;

import com.google.common.collect.Sets;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.junit.runner.Description;
import org.junit.runner.notification.Failure;
import org.junit.runner.notification.RunListener;

public final class TuttiRunListener
extends RunListener {
    private static final Log log = LogFactory.getLog(TuttiRunListener.class);
    protected static final Set<Failure> failures = Sets.newHashSet();

    public static synchronized void beforeClass(Description description) {
        if (log.isDebugEnabled()) {
            log.debug((Object)("Start to listen test " + description));
        }
        Iterator<Failure> iterator = failures.iterator();
        String className = description.getClassName();
        while (iterator.hasNext()) {
            Failure failure = iterator.next();
            if (!className.equals(failure.getDescription().getClassName())) continue;
            iterator.remove();
        }
    }

    public static synchronized Set<Failure> getFailuresForClass(String className) {
        HashSet result = Sets.newHashSet();
        for (Failure failure : failures) {
            if (!className.equals(failure.getDescription().getClassName())) continue;
            result.add(failure);
        }
        return result;
    }

    public void testFailure(Failure failure) throws Exception {
        if (log.isDebugEnabled()) {
            log.debug((Object)("Adding failure: " + failure + ", for description: " + failure.getDescription()));
        }
        failures.add(failure);
        super.testFailure(failure);
    }

    public void testAssumptionFailure(Failure failure) {
        if (log.isDebugEnabled()) {
            log.debug((Object)("Adding assumptionFailure: " + failure + ", for description: " + failure.getDescription()));
        }
        failures.add(failure);
        super.testAssumptionFailure(failure);
    }
}

