/*
 * Decompiled with CFR 0.152.
 */
package liquibase.database.structure.type;

import java.sql.Time;
import java.sql.Timestamp;
import java.util.Date;
import liquibase.database.Database;
import liquibase.database.structure.type.DataType;
import liquibase.statement.DatabaseFunction;

public class DateType
extends DataType {
    public DateType() {
        super("DATE", 0, 0);
    }

    public DateType(String dataTypeName) {
        super(dataTypeName, 0, 0);
    }

    public String convertObjectToString(Object value, Database database) {
        if (value == null) {
            return null;
        }
        if (value.toString().equalsIgnoreCase("null")) {
            return "null";
        }
        if (value instanceof DatabaseFunction) {
            return ((DatabaseFunction)value).getValue();
        }
        if (value.toString().equals("CURRENT_TIMESTAMP()")) {
            return database.getCurrentDateTimeFunction();
        }
        if (value instanceof Timestamp) {
            return database.getDateLiteral((Timestamp)value);
        }
        if (value instanceof java.sql.Date) {
            return database.getDateLiteral((java.sql.Date)value);
        }
        if (value instanceof Time) {
            return database.getDateLiteral((Time)value);
        }
        if (value instanceof Date) {
            return database.getDateLiteral((Date)value);
        }
        return "'" + ((String)value).replaceAll("'", "''") + "'";
    }
}

