/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.tutti.ui.swing.action;

import com.google.common.base.Preconditions;
import fr.ifremer.tutti.persistence.entities.protocol.TuttiProtocol;
import fr.ifremer.tutti.service.protocol.ProtocolImportExportService;
import fr.ifremer.tutti.ui.swing.action.AbstractTuttiAction;
import fr.ifremer.tutti.ui.swing.content.protocol.EditProtocolUI;
import fr.ifremer.tutti.ui.swing.content.protocol.EditProtocolUIHandler;
import fr.ifremer.tutti.ui.swing.content.protocol.EditProtocolUIModel;
import java.io.File;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.i18n.I18n;

public class ImportProtocolCaracteristicAction
extends AbstractTuttiAction<EditProtocolUIModel, EditProtocolUI, EditProtocolUIHandler> {
    private static final Log log = LogFactory.getLog(ImportProtocolCaracteristicAction.class);
    private File file;

    public ImportProtocolCaracteristicAction(EditProtocolUIHandler handler) {
        super(handler, true);
    }

    public boolean prepareAction() throws Exception {
        boolean doAction = super.prepareAction();
        if (doAction) {
            this.file = this.chooseFile(I18n._((String)"tutti.editProtocol.title.choose.caracteristicImportFile", (Object[])new Object[0]), I18n._((String)"tutti.editProtocol.action.chooseProtocolCaracteristicFile", (Object[])new Object[0]), new String[]{"^.*\\.csv", I18n._((String)"tutti.common.file.csv", (Object[])new Object[0])});
            doAction = this.file != null;
        }
        return doAction;
    }

    public void releaseAction() {
        this.file = null;
        super.releaseAction();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void doAction() throws Exception {
        Preconditions.checkNotNull((Object)this.file);
        if (log.isInfoEnabled()) {
            log.info((Object)("Will import protocol caracteristic file: " + this.file));
        }
        EditProtocolUIModel model = (EditProtocolUIModel)this.getModel();
        TuttiProtocol protocol = (TuttiProtocol)model.toBean();
        ProtocolImportExportService service = this.getContext().getTuttiProtocolImportExportService();
        service.importProtocolCaracteristic(this.file, protocol, model.getAllCaracteristic());
        ((EditProtocolUIHandler)this.handler).addDoubleListListeners();
        try {
            model.fromBean(protocol);
        }
        finally {
            ((EditProtocolUIHandler)this.handler).removeDoubleListListeners();
        }
        this.sendMessage(I18n._((String)"tutti.flash.info.caracteristic.imported.in.protocol", (Object[])new Object[]{this.file}));
    }
}

