/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.tutti.ui.swing.content.operation.catches.benthos;

import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import fr.ifremer.shared.application.swing.table.AbstractApplicationTableModel;
import fr.ifremer.shared.application.swing.table.ColumnIdentifier;
import fr.ifremer.shared.application.type.WeightUnit;
import fr.ifremer.tutti.persistence.entities.data.SampleCategory;
import fr.ifremer.tutti.persistence.entities.data.SampleCategoryModel;
import fr.ifremer.tutti.persistence.entities.referential.Species;
import fr.ifremer.tutti.ui.swing.content.operation.catches.SampleCategoryAble;
import fr.ifremer.tutti.ui.swing.content.operation.catches.SampleCategoryColumnIdentifier;
import fr.ifremer.tutti.ui.swing.content.operation.catches.benthos.BenthosBatchRowModel;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.swing.table.TableColumn;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jdesktop.swingx.table.TableColumnModelExt;
import org.nuiton.i18n.I18n;

public class BenthosBatchTableModel
extends AbstractApplicationTableModel<BenthosBatchRowModel> {
    private static final long serialVersionUID = 1L;
    private static final Log log = LogFactory.getLog(BenthosBatchTableModel.class);
    public static final ColumnIdentifier<BenthosBatchRowModel> SPECIES = ColumnIdentifier.newId((String)"speciesRow", (String)I18n.n_((String)"tutti.editBenthosBatch.table.header.species", (Object[])new Object[0]), (String)I18n.n_((String)"tutti.editBenthosBatch.table.header.species.tip", (Object[])new Object[0]));
    public static final ColumnIdentifier<BenthosBatchRowModel> WEIGHT = ColumnIdentifier.newId((String)"computedOrNotWeight", (String)I18n.n_((String)"tutti.editBenthosBatch.table.header.weight", (Object[])new Object[0]), (String)I18n.n_((String)"tutti.editBenthosBatch.table.header.weight.tip", (Object[])new Object[0]));
    public static final ColumnIdentifier<BenthosBatchRowModel> COMPUTED_NUMBER = ColumnIdentifier.newId((String)"computedOrNotNumber", (String)I18n.n_((String)"tutti.editBenthosBatch.table.header.computedNumber", (Object[])new Object[0]), (String)I18n.n_((String)"tutti.editBenthosBatch.table.header.computedNumber.tip", (Object[])new Object[0]));
    public static final ColumnIdentifier<BenthosBatchRowModel> COMMENT = ColumnIdentifier.newId((String)"comment", (String)I18n.n_((String)"tutti.editBenthosBatch.table.header.comment", (Object[])new Object[0]), (String)I18n.n_((String)"tutti.editBenthosBatch.table.header.comment.tip", (Object[])new Object[0]));
    public static final ColumnIdentifier<BenthosBatchRowModel> ATTACHMENT = ColumnIdentifier.newReadOnlyId((String)"attachment", (String)I18n.n_((String)"tutti.editBenthosBatch.table.header.file", (Object[])new Object[0]), (String)I18n.n_((String)"tutti.editBenthosBatch.table.header.file.tip", (Object[])new Object[0]));
    public static final ColumnIdentifier<BenthosBatchRowModel> SPECIES_TO_CONFIRM = ColumnIdentifier.newId((String)"speciesToConfirm", (String)I18n.n_((String)"tutti.editBenthosBatch.table.header.toConfirm", (Object[])new Object[0]), (String)I18n.n_((String)"tutti.editBenthosBatch.table.header.toConfirm.tip", (Object[])new Object[0]));
    protected final Set<ColumnIdentifier<BenthosBatchRowModel>> frequencyCols;
    protected final Set<SampleCategoryColumnIdentifier<BenthosBatchRowModel>> sampleCols;
    protected final SampleCategoryModel sampleCategoryModel;
    protected final WeightUnit weightUnit;

    public BenthosBatchTableModel(WeightUnit weightUnit, SampleCategoryModel sampleCategoryModel, TableColumnModelExt columnModel) {
        super(columnModel, false, false);
        this.weightUnit = weightUnit;
        this.sampleCategoryModel = sampleCategoryModel;
        this.setNoneEditableCols(new ColumnIdentifier[]{SPECIES});
        this.frequencyCols = Sets.newHashSet();
        this.frequencyCols.add(COMPUTED_NUMBER);
        this.frequencyCols.add(WEIGHT);
        this.sampleCols = Sets.newHashSet();
        Enumeration columns = columnModel.getColumns();
        while (columns.hasMoreElements()) {
            TableColumn tableColumn = (TableColumn)columns.nextElement();
            Object identifier = tableColumn.getIdentifier();
            if (!(identifier instanceof SampleCategoryColumnIdentifier)) continue;
            SampleCategoryColumnIdentifier categoryColumnIdentifier = (SampleCategoryColumnIdentifier)((Object)identifier);
            this.sampleCols.add(categoryColumnIdentifier);
        }
    }

    protected void collectShell(BenthosBatchRowModel row, Set<BenthosBatchRowModel> collectedRows) {
        super.collectShell((Serializable)row, collectedRows);
        if (!row.isChildBatchsEmpty()) {
            for (BenthosBatchRowModel child : row.getChildBatch()) {
                this.collectShell(child, collectedRows);
            }
        }
    }

    public BenthosBatchRowModel createNewRow() {
        BenthosBatchRowModel result = new BenthosBatchRowModel(this.weightUnit, this.sampleCategoryModel);
        result.setValid(false);
        return result;
    }

    public void setValueAt(Object aValue, int rowIndex, int columnIndex, ColumnIdentifier<BenthosBatchRowModel> propertyName, BenthosBatchRowModel entry) {
        if (this.sampleCols.contains(propertyName)) {
            SampleCategoryColumnIdentifier sampleCategoryColumnIdentifier = (SampleCategoryColumnIdentifier)propertyName;
            sampleCategoryColumnIdentifier.setWeightValue(entry, aValue);
            Integer sampleCategoryId = sampleCategoryColumnIdentifier.getSampleCategoryId();
            if (log.isDebugEnabled()) {
                log.debug((Object)("Sample category: " + sampleCategoryId + " modified at row: " + rowIndex));
            }
            SampleCategory<?> sampleCategory = entry.getSampleCategoryById(sampleCategoryId);
            SampleCategoryAble firstAncestor = entry.getFirstAncestor((SampleCategory)sampleCategory);
            int firstRowIndex = this.getRowIndex((Serializable)((Object)firstAncestor));
            if (log.isDebugEnabled()) {
                log.debug((Object)("First ancestor row: " + firstRowIndex));
            }
            this.updateShell((BenthosBatchRowModel)firstAncestor, columnIndex);
        } else {
            super.setValueAt(aValue, rowIndex, columnIndex, propertyName, (Serializable)entry);
        }
    }

    protected boolean isCellEditable(int rowIndex, int columnIndex, ColumnIdentifier<BenthosBatchRowModel> propertyName) {
        boolean result = super.isCellEditable(rowIndex, columnIndex, propertyName);
        if (result) {
            if (this.frequencyCols.contains(propertyName)) {
                BenthosBatchRowModel entry = (BenthosBatchRowModel)this.getEntry(rowIndex);
                result = entry.isBatchLeaf();
            } else if (this.sampleCols.contains(propertyName)) {
                SampleCategory value;
                BenthosBatchRowModel entry = (BenthosBatchRowModel)this.getEntry(rowIndex);
                Species species = entry.getSpecies();
                result = species == null ? false : (value = (SampleCategory)propertyName.getValue((Object)entry)).getCategoryValue() != null;
            }
        }
        return result;
    }

    public Integer getNextEditableFrequencyRow(Integer rowIndex) {
        Integer result = null;
        int max = this.getRowCount();
        for (int i = rowIndex.intValue(); i < max; ++i) {
            BenthosBatchRowModel entry = (BenthosBatchRowModel)this.getEntry(i);
            if (!entry.isBatchLeaf()) continue;
            result = i;
            break;
        }
        return result;
    }

    public final int getNextChildRowIndex(BenthosBatchRowModel row) {
        int parentRowIndex = this.getRowIndex(row);
        Preconditions.checkState((parentRowIndex != -1 ? 1 : 0) != 0);
        int result = parentRowIndex;
        if (!row.isChildBatchsEmpty()) {
            BenthosBatchRowModel lastChild = row.getChildBatch().get(row.sizeChildBatchs() - 1);
            HashSet childs = Sets.newHashSet();
            childs.add(lastChild);
            lastChild.collectShell(childs);
            for (BenthosBatchRowModel child : childs) {
                int childRowIndex = this.getRowIndex(child);
                result = Math.max(childRowIndex, result);
            }
        }
        return ++result;
    }

    public Integer getSampleCategoryId(int columnIndex) {
        Integer result = null;
        ColumnIdentifier identifier = this.getIdentifier(columnIndex);
        if (this.sampleCols.contains(identifier)) {
            SampleCategoryColumnIdentifier sampleId = (SampleCategoryColumnIdentifier)identifier;
            result = sampleId.getSampleCategoryId();
        }
        return result;
    }

    public void updateSampleCategorieValue(BenthosBatchRowModel row, int columnIndex, Serializable newValue) {
        SampleCategoryColumnIdentifier identifier = (SampleCategoryColumnIdentifier)this.getIdentifier(columnIndex);
        identifier.setCategoryValue(row, newValue);
        this.updateShell(row, columnIndex);
    }

    public BenthosBatchRowModel getPreviousSibling(BenthosBatchRowModel row) {
        List<BenthosBatchRowModel> childBatch;
        int i;
        BenthosBatchRowModel result = null;
        BenthosBatchRowModel parentBatch = row.getParentBatch();
        if (parentBatch != null && (i = (childBatch = parentBatch.getChildBatch()).indexOf(row)) > 0) {
            result = childBatch.get(i - 1);
        }
        return result;
    }

    public void updateShell(Set<BenthosBatchRowModel> shell, int columnIndex) {
        for (BenthosBatchRowModel batchRowModel : shell) {
            int currentRowIndex = this.getRowIndex(batchRowModel);
            if (log.isDebugEnabled()) {
                log.debug((Object)("Update shell row: " + currentRowIndex));
            }
            this.fireTableCellUpdated(currentRowIndex, columnIndex);
        }
    }

    public List<Species> getSpeciesList() {
        ArrayList result = Lists.newArrayList();
        for (BenthosBatchRowModel row : this.rows) {
            if (!row.isBatchRoot()) continue;
            result.add(row.getSpecies());
        }
        return result;
    }

    protected void updateShell(BenthosBatchRowModel entry, int columnIndex) {
        HashSet shell = Sets.newHashSet();
        entry.collectShell(shell);
        shell.add(entry);
        this.updateShell(shell, columnIndex);
    }
}

