/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.tutti.ui.swing.util.action;

import com.google.common.base.Preconditions;
import fr.ifremer.tutti.TuttiTechnicalException;
import fr.ifremer.tutti.ui.swing.content.AbstractMainUITuttiAction;
import fr.ifremer.tutti.ui.swing.util.AbstractTuttiUIHandler;
import fr.ifremer.tutti.ui.swing.util.action.AbstractTuttiAction;
import fr.ifremer.tutti.ui.swing.util.action.TuttiActionException;
import fr.ifremer.tutti.ui.swing.util.action.TuttiUIAction;
import javax.swing.AbstractButton;
import javax.swing.Action;
import org.apache.commons.lang3.reflect.ConstructorUtils;
import org.nuiton.i18n.I18n;

public class TuttiActionHelper {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <A extends AbstractTuttiAction> void runInternalAction(A action) {
        Throwable error = null;
        try {
            action.doAction();
            action.postSuccessAction();
        }
        catch (Throwable e) {
            error = e;
            throw TuttiActionException.propagateError(action, e);
        }
        finally {
            try {
                if (error != null) {
                    action.postFailedAction(error);
                }
            }
            finally {
                action.releaseAction();
            }
        }
    }

    public static <A extends AbstractTuttiAction> void runInternalAction(AbstractTuttiUIHandler handler, Class<A> actionName) {
        A action = TuttiActionHelper.createLogicAction(handler, actionName);
        TuttiActionHelper.runInternalAction(action);
    }

    public static <A extends AbstractTuttiAction> void runAction(A action) {
        TuttiUIAction<A> uiAction = TuttiActionHelper.createUIAction(null, action);
        uiAction.actionPerformed(null);
    }

    public static void runAction(AbstractButton button) {
        button.getAction().actionPerformed(null);
    }

    public static <A extends AbstractTuttiAction> void runActionAndWait(A action) {
        TuttiUIAction<A> uiAction = TuttiActionHelper.createUIAction(null, action);
        uiAction.launchActionAndWait();
    }

    public static <A extends AbstractTuttiAction> void runActionAndWait(AbstractTuttiUIHandler handler, Class<A> actionName) {
        A logicAction = TuttiActionHelper.createLogicAction(handler, actionName);
        TuttiActionHelper.runActionAndWait(logicAction);
    }

    public static <A extends AbstractTuttiAction> TuttiUIAction<A> createUIAction(AbstractTuttiUIHandler handler, Class<A> actionName) {
        return TuttiActionHelper.createUIAction(handler, null, actionName);
    }

    public static <A extends AbstractTuttiAction> TuttiUIAction<A> createUIAction(AbstractTuttiUIHandler handler, AbstractButton abstractButton, Class<A> actionName) {
        try {
            A logicAction = TuttiActionHelper.createLogicAction(handler, actionName);
            TuttiUIAction<A> result = TuttiActionHelper.createUIAction(abstractButton, logicAction);
            return result;
        }
        catch (Exception e) {
            throw new TuttiTechnicalException(I18n._((String)"tutti.action.create.error", (Object[])new Object[]{actionName}), e);
        }
    }

    public static <A extends AbstractTuttiAction> TuttiUIAction<A> createUIAction(AbstractButton abstractButton, A logicAction) {
        TuttiUIAction<A> result = new TuttiUIAction<A>(abstractButton, logicAction);
        return result;
    }

    public static <A extends AbstractTuttiAction> A createLogicAction(AbstractTuttiUIHandler handler, Class<A> actionName) {
        try {
            if (AbstractMainUITuttiAction.class.isAssignableFrom(actionName) && handler.getContext().getMainUI() != null) {
                handler = handler.getContext().getMainUI().getHandler();
            }
            AbstractTuttiAction result = (AbstractTuttiAction)((Object)ConstructorUtils.invokeConstructor(actionName, (Object[])new Object[]{handler}));
            return (A)((Object)result);
        }
        catch (Exception e) {
            throw new TuttiTechnicalException(I18n._((String)"tutti.action.create.error", (Object[])new Object[]{actionName}), e);
        }
    }

    public static <A extends AbstractTuttiAction> A getLogicAction(AbstractButton b) {
        Action action = b.getAction();
        Preconditions.checkNotNull((Object)action);
        Preconditions.checkState((boolean)(action instanceof TuttiUIAction));
        return ((TuttiUIAction)action).getLogicAction();
    }
}

