/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.tutti.ui.swing.content.home;

import com.google.common.base.Preconditions;
import com.google.common.collect.Sets;
import fr.ifremer.tutti.persistence.TuttiPersistence;
import fr.ifremer.tutti.persistence.entities.data.SampleCategoryModel;
import fr.ifremer.tutti.persistence.entities.protocol.TuttiProtocol;
import fr.ifremer.tutti.persistence.entities.protocol.TuttiProtocols;
import fr.ifremer.tutti.persistence.entities.referential.Caracteristic;
import fr.ifremer.tutti.service.protocol.ProtocolImportExportService;
import fr.ifremer.tutti.ui.swing.TuttiScreen;
import fr.ifremer.tutti.ui.swing.content.AbstractChangeScreenAction;
import fr.ifremer.tutti.ui.swing.content.MainUIHandler;
import java.io.File;
import java.util.HashSet;
import javax.swing.JOptionPane;
import javax.swing.UIManager;
import jaxx.runtime.JAXXContext;
import jaxx.runtime.context.JAXXContextEntryDef;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.i18n.I18n;

public class ImportProtocolAction
extends AbstractChangeScreenAction {
    private static final Log log = LogFactory.getLog(ImportProtocolAction.class);
    public static final JAXXContextEntryDef<TuttiProtocol> IMPORT_PROTOCOL_ENTRY = new JAXXContextEntryDef("importProtocol", TuttiProtocol.class);
    protected TuttiProtocol protocol;

    public ImportProtocolAction(MainUIHandler handler) {
        super(handler, true, TuttiScreen.EDIT_PROTOCOL);
    }

    @Override
    public boolean prepareAction() throws Exception {
        IMPORT_PROTOCOL_ENTRY.removeContextValue((JAXXContext)this.getContext().getMainUI());
        boolean doAction = super.prepareAction();
        File file = null;
        if (doAction) {
            file = this.chooseFile(I18n._((String)"tutti.selectCruise.title.choose.importFile", (Object[])new Object[0]), I18n._((String)"tutti.selectCruise.action.importProtocol", (Object[])new Object[0]), "^.+\\.tuttiProtocol$", I18n._((String)"tutti.common.file.protocol", (Object[])new Object[0]));
            boolean bl = doAction = file != null;
        }
        if (doAction) {
            if (log.isInfoEnabled()) {
                log.info((Object)("Will import protocol file: " + file));
            }
            ProtocolImportExportService service = this.getContext().getTuttiProtocolImportExportService();
            this.protocol = service.importProtocol(file);
            this.protocol.setId((String)null);
            this.sendMessage(I18n._((String)"tutti.importProtocol.action.success", (Object[])new Object[]{this.protocol.getName()}));
            SampleCategoryModel sampleCategoryModel = this.getDataContext().getSampleCategoryModel();
            HashSet badCategories = Sets.newHashSet();
            TuttiProtocols.checkSampleCategories(sampleCategoryModel, this.protocol, badCategories);
            if (!badCategories.isEmpty()) {
                if (log.isWarnEnabled()) {
                    log.warn((Object)("There is some bad categories: " + badCategories));
                }
                String message = TuttiProtocols.getBadCategoriesMessage(badCategories, this.getDecorator(Caracteristic.class, null), (TuttiPersistence)this.getContext().getPersistenceService());
                String htmlMessage = String.format("<html>%s<hr/><br/>%s</html>", message, I18n._((String)"tutti.common.askBeforeImportProtocol.help", (Object[])new Object[0]));
                int response = JOptionPane.showOptionDialog(this.getContext().getActionUI(), htmlMessage, I18n._((String)"tutti.common.askBeforeEditProtocol.title", (Object[])new Object[0]), 0, 2, UIManager.getIcon("warning"), new Object[]{I18n._((String)"tutti.option.cleanAndImport", (Object[])new Object[0]), I18n._((String)"tutti.option.import", (Object[])new Object[0]), I18n._((String)"tutti.option.cancel", (Object[])new Object[0])}, I18n._((String)"tutti.option.cancel", (Object[])new Object[0]));
                switch (response) {
                    case 0: {
                        if (log.isInfoEnabled()) {
                            log.info((Object)"Clean and Import");
                        }
                        TuttiProtocols.removeBadCategories(sampleCategoryModel, this.protocol);
                        break;
                    }
                    case 1: {
                        if (!log.isInfoEnabled()) break;
                        log.info((Object)"Import with no cleaning");
                        break;
                    }
                    default: {
                        doAction = false;
                    }
                }
            }
        }
        return doAction;
    }

    @Override
    public void doAction() throws Exception {
        Preconditions.checkNotNull((Object)this.protocol);
        IMPORT_PROTOCOL_ENTRY.setContextValue((JAXXContext)this.getContext().getMainUI(), (Object)this.protocol);
        this.protocol = null;
        this.createProgressionModelIfRequired(4);
        this.getContext().setProtocolId(null);
        super.doAction();
    }
}

