/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.tutti.service.catches.multipost;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.io.Files;
import fr.ifremer.tutti.TuttiIOUtil;
import fr.ifremer.tutti.TuttiTechnicalException;
import fr.ifremer.tutti.persistence.entities.CaracteristicMap;
import fr.ifremer.tutti.persistence.entities.data.AccidentalBatch;
import fr.ifremer.tutti.persistence.entities.data.AttachementObjectTypeEnum;
import fr.ifremer.tutti.persistence.entities.data.Attachment;
import fr.ifremer.tutti.persistence.entities.data.BatchContainer;
import fr.ifremer.tutti.persistence.entities.data.BenthosBatch;
import fr.ifremer.tutti.persistence.entities.data.CatchBatch;
import fr.ifremer.tutti.persistence.entities.data.FishingOperation;
import fr.ifremer.tutti.persistence.entities.data.IndividualObservationBatch;
import fr.ifremer.tutti.persistence.entities.data.MarineLitterBatch;
import fr.ifremer.tutti.persistence.entities.data.SampleCategoryModel;
import fr.ifremer.tutti.persistence.entities.data.SampleCategoryModelEntry;
import fr.ifremer.tutti.persistence.entities.data.SpeciesBatch;
import fr.ifremer.tutti.persistence.entities.data.SpeciesBatchFrequency;
import fr.ifremer.tutti.persistence.entities.referential.Caracteristic;
import fr.ifremer.tutti.persistence.entities.referential.CaracteristicQualitativeValue;
import fr.ifremer.tutti.persistence.entities.referential.CaracteristicType;
import fr.ifremer.tutti.service.AbstractTuttiService;
import fr.ifremer.tutti.service.DecoratorService;
import fr.ifremer.tutti.service.PersistenceService;
import fr.ifremer.tutti.service.TuttiServiceContext;
import fr.ifremer.tutti.service.catches.multipost.AbstractFishingOperationRow;
import fr.ifremer.tutti.service.catches.multipost.AccidentalCatchRow;
import fr.ifremer.tutti.service.catches.multipost.AccidentalCatchRowModel;
import fr.ifremer.tutti.service.catches.multipost.AttachmentRow;
import fr.ifremer.tutti.service.catches.multipost.AttachmentRowModel;
import fr.ifremer.tutti.service.catches.multipost.CaracteristicRow;
import fr.ifremer.tutti.service.catches.multipost.CaracteristicRowModel;
import fr.ifremer.tutti.service.catches.multipost.CatchFrequencyRow;
import fr.ifremer.tutti.service.catches.multipost.CatchFrequencyRowModel;
import fr.ifremer.tutti.service.catches.multipost.CatchRow;
import fr.ifremer.tutti.service.catches.multipost.CatchRowModel;
import fr.ifremer.tutti.service.catches.multipost.CatchWeightsRow;
import fr.ifremer.tutti.service.catches.multipost.CatchWeightsRowModel;
import fr.ifremer.tutti.service.catches.multipost.FishingOperationRow;
import fr.ifremer.tutti.service.catches.multipost.FishingOperationRowModel;
import fr.ifremer.tutti.service.catches.multipost.IndividualObservationRow;
import fr.ifremer.tutti.service.catches.multipost.IndividualObservationRowModel;
import fr.ifremer.tutti.service.catches.multipost.MarineLitterRow;
import fr.ifremer.tutti.service.catches.multipost.MarineLitterRowModel;
import fr.ifremer.tutti.service.catches.multipost.MarineLitterWeightRow;
import fr.ifremer.tutti.service.catches.multipost.MarineLitterWeightRowModel;
import java.io.File;
import java.io.Serializable;
import java.io.Writer;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.commons.io.IOUtils;
import org.nuiton.csv.Export;
import org.nuiton.csv.ExportModel;
import org.nuiton.i18n.I18n;

public class MultiPostExportService
extends AbstractTuttiService {
    public static final String BATCHES_KEY = "batchesKey";
    protected static final String ATTACHMENTS_DIRECTORY = "attachments";
    protected static final String ATTACHMENTS_FILE = "attachments.csv";
    protected static final String SPECIES_FILE = "species.csv";
    protected static final String BENTHOS_FILE = "benthos.csv";
    protected static final String MARINE_LITTER_FILE = "marineLitter.csv";
    protected static final String INDIVIDUAL_OBSERVATION_FILE = "individualObservation.csv";
    protected static final String ACCIDENTAL_CATCHES_FILE = "accidentalCatches.csv";
    protected static final String FREQUENCIES_FILE = "frequencies.csv";
    protected static final String CARACTERISTIC_FILE = "caracteristics.csv";
    protected static final String WEIGHTS_FILE = "weights.csv";
    protected PersistenceService persistenceService;
    protected DecoratorService decoratorService;
    protected char csvSeparator;
    protected SampleCategoryModel sampleCategoryModel;
    protected Map<String, CaracteristicQualitativeValue> sampleCategoryValueMap;

    @Override
    public void setServiceContext(TuttiServiceContext context) {
        super.setServiceContext(context);
        this.persistenceService = this.getService(PersistenceService.class);
        this.decoratorService = this.getService(DecoratorService.class);
        this.csvSeparator = context.getConfig().getCsvSeparator();
        this.sampleCategoryModel = context.getSampleCategoryModel();
        this.sampleCategoryValueMap = Maps.newTreeMap();
        for (SampleCategoryModelEntry sampleCategoryModelEntry : this.sampleCategoryModel.getCategory()) {
            Caracteristic caracteristic = sampleCategoryModelEntry.getCaracteristic();
            if (caracteristic.getCaracteristicType() != CaracteristicType.QUALITATIVE) continue;
            List qualitativeValue = caracteristic.getQualitativeValue();
            for (CaracteristicQualitativeValue value : qualitativeValue) {
                this.sampleCategoryValueMap.put(value.getId(), value);
            }
        }
    }

    public void exportSpecies(File file, FishingOperation operation) {
        String operationId = operation.getId();
        if (this.persistenceService.isFishingOperationWithCatchBatch(operationId)) {
            BatchContainer<SpeciesBatch> speciesBatchContainer = this.persistenceService.getRootSpeciesBatch(operationId, null);
            ArrayList rows = Lists.newArrayList();
            ArrayList frequencyRows = Lists.newArrayList();
            ArrayList attachmentRows = Lists.newArrayList();
            for (SpeciesBatch batch : speciesBatchContainer.getChildren()) {
                this.createSpeciesRow(batch, null, rows, frequencyRows, attachmentRows);
            }
            CatchBatch catchBatch = this.persistenceService.getCatchBatchFromFishingOperation(operationId);
            CatchWeightsRow weights = new CatchWeightsRow();
            weights.setTotalSortedWeight(catchBatch.getSpeciesTotalSortedWeight());
            weights.setInertWeight(catchBatch.getSpeciesTotalInertWeight());
            weights.setLivingNotItemizedWeight(catchBatch.getSpeciesTotalLivingNotItemizedWeight());
            this.exportOperation(weights, operation);
            this.exportCatches(file, SPECIES_FILE, weights, rows, frequencyRows, attachmentRows);
        }
    }

    public void exportBenthos(File file, FishingOperation operation) {
        String operationId = operation.getId();
        if (this.persistenceService.isFishingOperationWithCatchBatch(operationId)) {
            BatchContainer<BenthosBatch> benthosBatchContainer = this.persistenceService.getRootBenthosBatch(operationId, null);
            ArrayList rows = Lists.newArrayList();
            ArrayList frequencyRows = Lists.newArrayList();
            ArrayList attachmentRows = Lists.newArrayList();
            for (BenthosBatch batch : benthosBatchContainer.getChildren()) {
                this.createBenthosRow(batch, null, rows, frequencyRows, attachmentRows);
            }
            CatchBatch catchBatch = this.persistenceService.getCatchBatchFromFishingOperation(operationId);
            CatchWeightsRow weights = new CatchWeightsRow();
            weights.setTotalSortedWeight(catchBatch.getBenthosTotalSortedWeight());
            weights.setInertWeight(catchBatch.getBenthosTotalInertWeight());
            weights.setLivingNotItemizedWeight(catchBatch.getBenthosTotalLivingNotItemizedWeight());
            this.exportOperation(weights, operation);
            this.exportCatches(file, BENTHOS_FILE, weights, rows, frequencyRows, attachmentRows);
        }
    }

    public void exportMarineLitter(File file, FishingOperation operation) {
        String operationId = operation.getId();
        if (this.persistenceService.isFishingOperationWithCatchBatch(operationId)) {
            BatchContainer<MarineLitterBatch> marineLitterBatchContainer = this.persistenceService.getRootMarineLitterBatch(operationId);
            ArrayList rows = Lists.newArrayList();
            ArrayList attachmentRows = Lists.newArrayList();
            for (MarineLitterBatch batch : marineLitterBatchContainer.getChildren()) {
                MarineLitterRow row = new MarineLitterRow();
                String id = this.context.generateId(MarineLitterRow.class);
                row.setBatchId(id);
                row.setCategory(batch.getMarineLitterCategory());
                row.setSizeCategory(batch.getMarineLitterSizeCategory());
                row.setNumber(batch.getNumber());
                row.setWeight(batch.getWeight());
                row.setComment(batch.getComment());
                rows.add(row);
                this.addAttachments(id, batch.getIdAsInt(), AttachementObjectTypeEnum.BATCH, attachmentRows);
            }
            File directory = Files.createTempDir();
            ArrayList file2zip = Lists.newArrayList();
            MarineLitterRowModel marineLitterRowModel = new MarineLitterRowModel(this.csvSeparator);
            File marineLitterFile = new File(directory, MARINE_LITTER_FILE);
            file2zip.add(marineLitterFile);
            this.export(marineLitterFile, (ExportModel)marineLitterRowModel, rows, I18n.n_((String)"tutti.service.multipost.export.batches.error", (Object[])new Object[0]));
            CatchBatch catchBatch = this.persistenceService.getCatchBatchFromFishingOperation(operationId);
            MarineLitterWeightRow weight = new MarineLitterWeightRow();
            weight.setTotalWeight(catchBatch.getMarineLitterTotalWeight());
            this.exportOperation(weight, operation);
            MarineLitterWeightRowModel weightModel = new MarineLitterWeightRowModel(this.csvSeparator);
            File weightFile = new File(directory, WEIGHTS_FILE);
            file2zip.add(weightFile);
            this.export(weightFile, (ExportModel)weightModel, Lists.newArrayList((Object[])new MarineLitterWeightRow[]{weight}), I18n.n_((String)"tutti.service.multipost.export.weight.error", (Object[])new Object[0]));
            this.exportAttachmentsAndCreateZip(file, directory, file2zip, attachmentRows);
        }
    }

    public void exportIndividualObservation(File file, FishingOperation operation) {
        List<IndividualObservationBatch> individualObservations = this.persistenceService.getAllIndividualObservationBatch(operation.getId());
        ArrayList rows = Lists.newArrayList();
        ArrayList caracteristicRows = Lists.newArrayList();
        ArrayList attachmentRows = Lists.newArrayList();
        for (IndividualObservationBatch batch : individualObservations) {
            IndividualObservationRow row = new IndividualObservationRow();
            String id = this.context.generateId(IndividualObservationRow.class);
            row.setBatchId(id);
            row.setSpecies(batch.getSpecies());
            row.setWeight(batch.getWeight());
            row.setSize(batch.getSize());
            row.setLengthStepCaracteristic(batch.getLengthStepCaracteristic());
            row.setComment(batch.getComment());
            rows.add(row);
            CaracteristicMap caracteristicMap = batch.getCaracteristics();
            for (Caracteristic caracteristic : caracteristicMap.keySet()) {
                CaracteristicRow caracteristicRow = new CaracteristicRow();
                caracteristicRow.setBatchId(id);
                caracteristicRow.setCaracteristic(caracteristic);
                caracteristicRow.setValue((Serializable)caracteristicMap.get((Object)caracteristic));
                caracteristicRows.add(caracteristicRow);
            }
            this.addAttachments(id, batch.getIdAsInt(), AttachementObjectTypeEnum.SAMPLE, attachmentRows);
        }
        File directory = Files.createTempDir();
        ArrayList file2zip = Lists.newArrayList();
        IndividualObservationRowModel csvModel = new IndividualObservationRowModel(this.csvSeparator);
        File individualObservationFile = new File(directory, INDIVIDUAL_OBSERVATION_FILE);
        file2zip.add(individualObservationFile);
        this.export(individualObservationFile, (ExportModel)csvModel, rows, I18n.n_((String)"tutti.service.multipost.export.batches.error", (Object[])new Object[0]));
        CaracteristicRowModel caracteristicCsvModel = new CaracteristicRowModel(this.csvSeparator);
        File caracteristicFile = new File(directory, CARACTERISTIC_FILE);
        file2zip.add(caracteristicFile);
        this.export(caracteristicFile, (ExportModel)caracteristicCsvModel, caracteristicRows, I18n.n_((String)"tutti.service.multipost.export.batches.error", (Object[])new Object[0]));
        FishingOperationRow foRow = new FishingOperationRow();
        this.exportOperation(foRow, operation);
        FishingOperationRowModel foRowModel = new FishingOperationRowModel(this.csvSeparator);
        File weightFile = new File(directory, WEIGHTS_FILE);
        file2zip.add(weightFile);
        this.export(weightFile, (ExportModel)foRowModel, Lists.newArrayList((Object[])new FishingOperationRow[]{foRow}), I18n.n_((String)"tutti.service.multipost.export.operation.error", (Object[])new Object[0]));
        this.exportAttachmentsAndCreateZip(file, directory, file2zip, attachmentRows);
    }

    public void exportAccidentalCatch(File file, FishingOperation operation) {
        List<AccidentalBatch> accidentalCatches = this.persistenceService.getAllAccidentalBatch(operation.getId());
        ArrayList rows = Lists.newArrayList();
        ArrayList caracteristicRows = Lists.newArrayList();
        ArrayList attachmentRows = Lists.newArrayList();
        for (AccidentalBatch batch : accidentalCatches) {
            AccidentalCatchRow row = new AccidentalCatchRow();
            String id = this.context.generateId(AccidentalCatchRow.class);
            row.setBatchId(id);
            row.setSpecies(batch.getSpecies());
            row.setGender(batch.getGender());
            row.setWeight(batch.getWeight());
            row.setSize(batch.getSize());
            row.setLengthStepCaracteristic(batch.getLengthStepCaracteristic());
            row.setDeadOrAlive(batch.getDeadOrAlive());
            row.setComment(batch.getComment());
            rows.add(row);
            CaracteristicMap caracteristicMap = batch.getCaracteristics();
            for (Caracteristic caracteristic : caracteristicMap.keySet()) {
                CaracteristicRow caracteristicRow = new CaracteristicRow();
                caracteristicRow.setBatchId(id);
                caracteristicRow.setCaracteristic(caracteristic);
                caracteristicRow.setValue((Serializable)caracteristicMap.get((Object)caracteristic));
                caracteristicRows.add(caracteristicRow);
            }
            this.addAttachments(id, batch.getIdAsInt(), AttachementObjectTypeEnum.SAMPLE, attachmentRows);
        }
        AccidentalCatchRowModel csvModel = new AccidentalCatchRowModel(this.csvSeparator);
        File directory = Files.createTempDir();
        ArrayList file2zip = Lists.newArrayList();
        File accidentalCatchesFile = new File(directory, ACCIDENTAL_CATCHES_FILE);
        file2zip.add(accidentalCatchesFile);
        this.export(accidentalCatchesFile, (ExportModel)csvModel, rows, I18n.n_((String)"tutti.service.multipost.export.batches.error", (Object[])new Object[0]));
        CaracteristicRowModel caracteristicCsvModel = new CaracteristicRowModel(this.csvSeparator);
        File caracteristicFile = new File(directory, CARACTERISTIC_FILE);
        file2zip.add(caracteristicFile);
        this.export(caracteristicFile, (ExportModel)caracteristicCsvModel, caracteristicRows, I18n.n_((String)"tutti.service.multipost.export.batches.error", (Object[])new Object[0]));
        FishingOperationRow foRow = new FishingOperationRow();
        this.exportOperation(foRow, operation);
        FishingOperationRowModel foRowModel = new FishingOperationRowModel(this.csvSeparator);
        File weightFile = new File(directory, WEIGHTS_FILE);
        file2zip.add(weightFile);
        this.export(weightFile, (ExportModel)foRowModel, Lists.newArrayList((Object[])new FishingOperationRow[]{foRow}), I18n.n_((String)"tutti.service.multipost.export.operation.error", (Object[])new Object[0]));
        this.exportAttachmentsAndCreateZip(file, directory, file2zip, attachmentRows);
    }

    protected void exportCatches(File file, String batchFile, CatchWeightsRow weights, List<CatchRow> rows, List<CatchFrequencyRow> frequencyRows, List<AttachmentRow> attachmentRows) {
        CatchRowModel csvModel = new CatchRowModel(this.csvSeparator);
        CatchFrequencyRowModel csvFrequencyModel = new CatchFrequencyRowModel(this.csvSeparator);
        CatchWeightsRowModel catchWeightsModel = new CatchWeightsRowModel(this.csvSeparator);
        File directory = Files.createTempDir();
        ArrayList file2zip = Lists.newArrayList();
        File weightsFile = new File(directory, WEIGHTS_FILE);
        file2zip.add(weightsFile);
        this.export(weightsFile, (ExportModel)catchWeightsModel, Lists.newArrayList((Object[])new CatchWeightsRow[]{weights}), I18n.n_((String)"tutti.service.multipost.export.weights.error", (Object[])new Object[0]));
        File speciesFile = new File(directory, batchFile);
        file2zip.add(speciesFile);
        this.export(speciesFile, (ExportModel)csvModel, (List)rows, I18n.n_((String)"tutti.service.multipost.export.batches.error", (Object[])new Object[0]));
        File frequencyFile = new File(directory, FREQUENCIES_FILE);
        file2zip.add(frequencyFile);
        this.export(frequencyFile, (ExportModel)csvFrequencyModel, (List)frequencyRows, I18n.n_((String)"tutti.service.multipost.export.frequencies.error", (Object[])new Object[0]));
        this.exportAttachmentsAndCreateZip(file, directory, file2zip, attachmentRows);
    }

    protected void createSpeciesRow(SpeciesBatch batch, String parentId, List<CatchRow> rows, List<CatchFrequencyRow> frequencyRows, List<AttachmentRow> attachmentRows) {
        CatchRow row = new CatchRow();
        String id = this.context.generateId(CatchRow.class);
        row.setId(id);
        row.setParentId(parentId);
        row.setSpecies(batch.getSpecies());
        row.setCategoryId(batch.getSampleCategoryId());
        row.setCategoryValue(batch.getSampleCategoryValue());
        row.setCategoryWeight(batch.getSampleCategoryWeight());
        row.setWeight(batch.getWeight());
        row.setNumber(batch.getNumber());
        row.setComment(batch.getComment());
        row.setToConfirm(batch.isSpeciesToConfirm());
        rows.add(row);
        this.addFrequencies(id, batch.getId(), frequencyRows);
        this.addAttachments(id, batch.getIdAsInt(), AttachementObjectTypeEnum.BATCH, attachmentRows);
        for (SpeciesBatch child : batch.getChildBatchs()) {
            this.createSpeciesRow(child, id, rows, frequencyRows, attachmentRows);
        }
    }

    protected void createBenthosRow(BenthosBatch batch, String parentId, List<CatchRow> rows, List<CatchFrequencyRow> frequencyRows, List<AttachmentRow> attachmentRows) {
        CatchRow row = new CatchRow();
        String id = this.context.generateId(CatchRow.class);
        row.setId(id);
        row.setParentId(parentId);
        row.setSpecies(batch.getSpecies());
        row.setCategoryId(batch.getSampleCategoryId());
        row.setCategoryValue(batch.getSampleCategoryValue());
        row.setCategoryWeight(batch.getSampleCategoryWeight());
        row.setWeight(batch.getWeight());
        row.setNumber(batch.getNumber());
        row.setComment(batch.getComment());
        row.setToConfirm(batch.isSpeciesToConfirm());
        rows.add(row);
        this.addFrequencies(id, batch.getId(), frequencyRows);
        this.addAttachments(id, batch.getIdAsInt(), AttachementObjectTypeEnum.BATCH, attachmentRows);
        for (BenthosBatch child : batch.getChildBatchs()) {
            this.createBenthosRow(child, id, rows, frequencyRows, attachmentRows);
        }
    }

    protected void exportOperation(AbstractFishingOperationRow afoRow, FishingOperation operation) {
        afoRow.setStationNumber(operation.getStationNumber());
        afoRow.setOperationNumber(operation.getFishingOperationNumber());
        afoRow.setMultirigAggregation(operation.getMultirigAggregation());
        afoRow.setDate(operation.getGearShootingStartDate());
    }

    protected void addFrequencies(String rowId, String batchId, List<CatchFrequencyRow> frequencyRows) {
        List<SpeciesBatchFrequency> frequencies = this.persistenceService.getAllSpeciesBatchFrequency(batchId);
        for (SpeciesBatchFrequency frequency : frequencies) {
            CatchFrequencyRow frequencyRow = new CatchFrequencyRow();
            frequencyRow.setBatchId(rowId);
            frequencyRow.setLengthStepCaracteristic(frequency.getLengthStepCaracteristic());
            frequencyRow.setLengthStep(frequency.getLengthStep());
            frequencyRow.setNumber(frequency.getNumber());
            frequencyRow.setWeight(frequency.getWeight());
            frequencyRows.add(frequencyRow);
        }
    }

    protected void addAttachments(String batchId, int objectId, AttachementObjectTypeEnum objectType, List<AttachmentRow> attachmentRows) {
        List<Attachment> attachments = this.persistenceService.getAllAttachments(objectType, objectId);
        for (Attachment attachment : attachments) {
            AttachmentRow attachmentRow = new AttachmentRow();
            attachmentRow.setBatchId(batchId);
            attachmentRow.setName(attachment.getName());
            attachmentRow.setComment(attachment.getComment());
            attachmentRow.setFile(this.persistenceService.getAttachmentFile(attachment.getId()));
            attachmentRows.add(attachmentRow);
        }
    }

    protected <R> void export(File file, ExportModel<R> exportModel, List<R> rows, String errorMessage) {
        Writer writer = TuttiIOUtil.newWriter((File)file, (String)I18n.n_((String)"tutti.service.multipost.export.file.writer.error", (Object[])new Object[0]));
        try {
            Export export = Export.newExport(exportModel, rows);
            export.write(writer);
            writer.close();
        }
        catch (Exception e) {
            throw new TuttiTechnicalException(I18n._((String)errorMessage, (Object[])new Object[]{file}), (Throwable)e);
        }
        finally {
            IOUtils.closeQuietly((Writer)writer);
        }
    }

    protected void exportAttachments(File directory, List<File> file2zip, List<AttachmentRow> attachmentRows) {
        AttachmentRowModel csvAttachmentModel = new AttachmentRowModel(this.csvSeparator);
        File attachmentDirectory = new File(directory, ATTACHMENTS_DIRECTORY);
        TuttiIOUtil.forceMkdir((File)attachmentDirectory, (String)I18n._((String)"tutti.service.multipost.attachment.mkdir.error", (Object[])new Object[]{attachmentDirectory}));
        file2zip.add(attachmentDirectory);
        for (AttachmentRow attachmentRow : attachmentRows) {
            File attachmentFile = attachmentRow.getFile();
            File destFile = new File(attachmentDirectory, attachmentFile.getName());
            TuttiIOUtil.copyFile((File)attachmentFile, (File)destFile, (String)I18n._((String)"tutti.service.multipost.attachment.copy.error", (Object[])new Object[]{attachmentFile}));
            file2zip.add(destFile);
        }
        File attachmentFile = new File(directory, ATTACHMENTS_FILE);
        file2zip.add(attachmentFile);
        this.export(attachmentFile, (ExportModel)csvAttachmentModel, (List)attachmentRows, I18n.n_((String)"tutti.service.multipost.export.attachments.error", (Object[])new Object[0]));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void exportAttachmentsAndCreateZip(File file, File directory, List<File> file2zip, List<AttachmentRow> attachmentRows) {
        this.exportAttachments(directory, file2zip, attachmentRows);
        try {
            TuttiIOUtil.zip((File)directory, (File)file, file2zip, (String)I18n.n_((String)"tutti.service.multipost.export.error", (Object[])new Object[0]));
        }
        catch (Throwable throwable) {
            TuttiIOUtil.deleteDirectory((File)directory, (String)I18n._((String)"tutti.service.multipost.export.deleteTempDirectory.error", (Object[])new Object[]{file}));
            throw throwable;
        }
        TuttiIOUtil.deleteDirectory((File)directory, (String)I18n._((String)"tutti.service.multipost.export.deleteTempDirectory.error", (Object[])new Object[]{file}));
    }
}

