package fr.ifremer.tutti.ui.swing.content.operation.catches.species;

/*
 * #%L
 * Tutti :: UI
 * $Id: ImportPupitriAction.java 1247 2013-09-28 12:15:25Z tchemit $
 * $HeadURL: http://svn.forge.codelutin.com/svn/tutti/tags/tutti-2.8.1/tutti-ui-swing/src/main/java/fr/ifremer/tutti/ui/swing/content/operation/catches/species/ImportPupitriAction.java $
 * %%
 * Copyright (C) 2012 - 2013 Ifremer
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 3 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-3.0.html>.
 * #L%
 */

import com.google.common.base.Joiner;
import com.google.common.collect.Lists;
import fr.ifremer.tutti.persistence.entities.data.CatchBatch;
import fr.ifremer.tutti.persistence.entities.data.FishingOperation;
import fr.ifremer.tutti.persistence.entities.data.SampleCategoryModel;
import fr.ifremer.tutti.persistence.service.TuttiEnumerationFile;
import fr.ifremer.tutti.service.PersistenceService;
import fr.ifremer.tutti.service.pupitri.PupitriImportExportService;
import fr.ifremer.tutti.ui.swing.content.operation.EditFishingOperationAction;
import fr.ifremer.tutti.ui.swing.content.operation.catches.EditCatchesUIModel;
import fr.ifremer.tutti.ui.swing.util.AbstractTuttiUIHandler;
import fr.ifremer.tutti.ui.swing.util.action.AbstractTuttiAction;
import fr.ifremer.tutti.ui.swing.util.action.TuttiActionHelper;

import javax.swing.JOptionPane;
import javax.swing.UIManager;
import java.io.File;
import java.util.List;

import static org.nuiton.i18n.I18n._;

/**
 * @author tchemit <chemit@codelutin.com>
 * @since 1.0
 */
public class ImportPupitriAction extends AbstractTuttiAction<SpeciesBatchUIModel, SpeciesBatchUI, SpeciesBatchUIHandler> {

    protected File importedTrunkFile;

    protected File importedCarrouselFile;

    protected ImportPupitriPopupUI importPupitriDialog;

//    protected TuttiProtocol currentProtocol;

    protected PersistenceService persistenceService;

    protected EditFishingOperationAction editAction;

    public ImportPupitriAction(SpeciesBatchUIHandler handler) {
        super(handler, false);
        persistenceService = getContext().getPersistenceService();
        importPupitriDialog = new ImportPupitriPopupUI(handler.getContext());
    }

    public EditFishingOperationAction getEditAction() {
        if (editAction == null) {
            editAction = TuttiActionHelper.createLogicAction(getHandler().getParentUi().getHandler().getParentHandler(),
                                                             EditFishingOperationAction.class);
        }
        return editAction;
    }

    @Override
    public boolean prepareAction() throws Exception {
        boolean result = true;

        // must check that sample category model is compatible for pupitri import
        // means need some categories

        TuttiEnumerationFile enumerationFile = persistenceService.getEnumerationFile();
        SampleCategoryModel sampleCategoryModel = getDataContext().getSampleCategoryModel();

        List<String> missingCategories = Lists.newArrayList();
        if (!sampleCategoryModel.containsCategoryId(enumerationFile.PMFM_ID_SIZE_CATEGORY)) {
            missingCategories.add("<li>" + persistenceService.getSizeCategoryCaracteristic().getParameterName() + "</li>");
        }
        if (!sampleCategoryModel.containsCategoryId(enumerationFile.PMFM_ID_SEX)) {
            missingCategories.add("<li>" + persistenceService.getSexCaracteristic().getParameterName() + "</li>");
        }
        if (!missingCategories.isEmpty()) {
            result = false;
            JOptionPane.showMessageDialog(
                    getContext().getActionUI(),
                    _("tutti.editSpeciesBatch.action.importPupitri.invalidSampleCategoryModel.message", Joiner.on("").join(missingCategories)),
                    _("tutti.editSpeciesBatch.action.importPupitri.invalidSampleCategoryModel.title"),
                    JOptionPane.ERROR_MESSAGE,
                    UIManager.getIcon("error")
            );
        }
        if (result) {
//            currentProtocol = getDataContext().getProtocol();

            SpeciesBatchUIModel speciesBatchUIModel = getUI().getModel();
            if (speciesBatchUIModel.getRowCount() > 0) {
                String htmlMessage = String.format(
                        AbstractTuttiUIHandler.CONFIRMATION_FORMAT,
                        _("tutti.editSpeciesBatch.action.importPupitri.existingData.message"),
                        _("tutti.editSpeciesBatch.action.importPupitri.existingData.help"));

                int answer = JOptionPane.showConfirmDialog(getContext().getActionUI(),
                                                           htmlMessage,
                                                           _("tutti.editSpeciesBatch.action.importPupitri.existingData.title"),
                                                           JOptionPane.OK_CANCEL_OPTION,
                                                           JOptionPane.WARNING_MESSAGE);

                result = answer == JOptionPane.OK_OPTION;
            }
        }

        if (result) {
            importPupitriDialog.open();
            importedTrunkFile = importPupitriDialog.getTrunkFile().getSelectedFile();
            importedCarrouselFile = importPupitriDialog.getCarrouselFile().getSelectedFile();
            result = importedTrunkFile != null
                     && importedCarrouselFile != null;
        }

        return result;
    }

    @Override
    public void doAction() throws Exception {
        PupitriImportExportService pupitriImportExportService =
                getContext().getTuttiPupitriImportExportService();

        EditCatchesUIModel model = getUI().getHandler().getParentUi().getModel();

        FishingOperation operation = model.getFishingOperation();
        CatchBatch catchBatch = model.toEntity();

        // import
        int rejectedSpeciesNb =
                pupitriImportExportService.importPupitri(importedTrunkFile,
                                                         importedCarrouselFile,
                                                         operation,
                                                         catchBatch);

        getEditAction().loadCatchBatch(operation);

        sendMessage(_("tutti.editSpeciesBatch.action.importPupitri.success",
                      getModel().getRootNumber(), rejectedSpeciesNb));
    }

    @Override
    public void releaseAction() {
        super.releaseAction();
        importedTrunkFile = null;
        importedCarrouselFile = null;
//        currentProtocol = null;
    }

}
