/*
 * Decompiled with CFR 0.152.
 */
package org.andromda.cartridges.spring.metafacades;

import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import org.andromda.cartridges.spring.SpringProfile;
import org.andromda.cartridges.spring.metafacades.SpringGlobals;
import org.andromda.cartridges.spring.metafacades.SpringServiceOperationLogic;
import org.andromda.metafacades.uml.ClassifierFacade;
import org.andromda.metafacades.uml.MetafacadeUtils;
import org.andromda.metafacades.uml.ParameterFacade;
import org.andromda.metafacades.uml.UMLProfile;
import org.andromda.utils.StringUtilsHelper;
import org.apache.commons.lang.BooleanUtils;
import org.apache.commons.lang.ObjectUtils;
import org.apache.commons.lang.StringUtils;

public class SpringServiceOperationLogicImpl
extends SpringServiceOperationLogic {
    private static final String SERVICE_OPERATION_TRANSACTION_TYPE = "serviceOperationTransactionType";
    private static final String EJB_SERVICE_OPERATION_TRANSACTION_TYPE = "ejbServiceOperationTransactionType";
    private static final String MESSAGE_LISTENER_CONTAINER_SUFFIX = "ListenerContainer";

    public SpringServiceOperationLogicImpl(Object metaObject, String context) {
        super(metaObject, context);
    }

    protected boolean handleIsWebserviceExposed() {
        return this.hasStereotype(UMLProfile.STEREOTYPE_WEBSERVICE_OPERATION);
    }

    protected String handleGetImplementationName() {
        return this.getImplementationOperationName(StringUtils.capitalize((String)this.getName()));
    }

    protected String handleGetImplementationSignature() {
        String signature = this.isIncomingMessageOperation() ? this.getIncomingMessageImplementationSignature() : (this.isOutgoingMessageOperation() ? this.getOutgoingMessageImplementationSignature() : this.getImplementationOperationName(StringUtils.capitalize((String)this.getSignature())));
        return signature;
    }

    public String getCall() {
        String call = this.isIncomingMessageOperation() && this.getArguments().isEmpty() ? this.getName() + "(message)" : super.getCall();
        return call;
    }

    public String getSignature(String modifier) {
        String signature = this.isIncomingMessageOperation() && this.getArguments().isEmpty() ? this.getIncomingMessageSignature(modifier) : super.getSignature(modifier);
        return signature;
    }

    public String getSignature(boolean withArgumentNames) {
        String signature = this.isIncomingMessageOperation() && this.getArguments().isEmpty() ? this.getIncomingMessageSignature(null) : super.getSignature(withArgumentNames);
        return signature;
    }

    public String getSignature() {
        return this.getSignature(true);
    }

    protected String handleGetImplementationCall() {
        return this.getImplementationOperationName(StringUtils.capitalize((String)this.getCall()));
    }

    private String getImplementationOperationName(String replacement) {
        return StringUtils.trimToEmpty((String)String.valueOf(this.getConfiguredProperty("implementationOperationNamePattern"))).replaceAll("\\{0\\}", replacement);
    }

    public String handleGetTransactionType() {
        String transactionType = (String)this.findTaggedValue(SpringProfile.TAGGEDVALUE_TRANSACTION_TYPE);
        if (StringUtils.isBlank((String)transactionType)) {
            transactionType = (String)this.getOwner().findTaggedValue(SpringProfile.TAGGEDVALUE_TRANSACTION_TYPE);
        }
        if (StringUtils.isBlank((String)transactionType)) {
            transactionType = String.valueOf(this.getConfiguredProperty(SERVICE_OPERATION_TRANSACTION_TYPE));
        }
        return transactionType;
    }

    protected String handleGetEjbTransactionType() {
        String transactionType = (String)this.findTaggedValue(SpringProfile.TAGGEDVALUE_EJB_TRANSACTION_TYPE);
        if (StringUtils.isBlank((String)transactionType)) {
            transactionType = (String)this.getOwner().findTaggedValue(SpringProfile.TAGGEDVALUE_EJB_TRANSACTION_TYPE);
        }
        if (StringUtils.isBlank((String)transactionType)) {
            transactionType = String.valueOf(this.getConfiguredProperty(EJB_SERVICE_OPERATION_TRANSACTION_TYPE));
        }
        return transactionType;
    }

    protected String handleGetThrowsClause() {
        StringBuffer throwsClause = null;
        if (this.isExceptionsPresent()) {
            throwsClause = new StringBuffer(this.getExceptionList());
        }
        if (throwsClause != null) {
            throwsClause.insert(0, "throws ");
        }
        return throwsClause != null ? throwsClause.toString() : null;
    }

    protected String handleGetThrowsClause(String initialExceptions) {
        StringBuffer throwsClause = new StringBuffer(initialExceptions);
        if (this.getThrowsClause() != null) {
            throwsClause.insert(0, ", ");
            throwsClause.insert(0, this.getThrowsClause());
        } else {
            throwsClause.insert(0, "throws ");
        }
        return throwsClause.toString();
    }

    protected String handleGetOutgoingMessageImplementationCall() {
        return this.getMessageImplementationCall("session");
    }

    private String getMessageImplementationCall(String firstArgument) {
        StringBuffer buffer = new StringBuffer();
        buffer.append(StringUtils.capitalize((String)this.getName()));
        buffer.append("(");
        boolean outgoingMessageOperation = this.isOutgoingMessageOperation();
        if (outgoingMessageOperation || this.isIncomingMessageOperation() && this.getArguments().isEmpty()) {
            buffer.append(firstArgument);
        }
        String argumentNames = this.getArgumentNames();
        if (outgoingMessageOperation && StringUtils.isNotBlank((String)argumentNames)) {
            buffer.append(", ");
        }
        if (StringUtils.isNotBlank((String)argumentNames)) {
            buffer.append(argumentNames);
        }
        buffer.append(")");
        return this.getImplementationOperationName(buffer.toString());
    }

    protected String handleGetOutgoingMessageImplementationSignature() {
        return this.getMessagingImplementationSignature("javax.jms.Session session");
    }

    private String getMessagingImplementationSignature(String firstArgument) {
        return this.getMessagingOperationSignature(this.getImplementationName(), firstArgument, null);
    }

    private String getIncomingMessageSignature(String modifier) {
        return this.getMessagingOperationSignature(this.getName(), "javax.jms.Message message", modifier);
    }

    private String getMessagingOperationSignature(String operationName, String firstArgument, String modifier) {
        StringBuffer signature = new StringBuffer(operationName);
        signature.append("(");
        if (StringUtils.isNotBlank((String)modifier)) {
            signature.append(modifier).append(" ");
        }
        Collection arguments = this.getArguments();
        boolean outgoingMessageOperation = this.isOutgoingMessageOperation();
        if (outgoingMessageOperation || this.isIncomingMessageOperation() && arguments.isEmpty()) {
            signature.append(firstArgument);
        }
        String argumentList = MetafacadeUtils.getTypedArgumentList((Collection)this.getArguments(), (boolean)true, (String)modifier);
        if (outgoingMessageOperation && StringUtils.isNotBlank((String)argumentList)) {
            signature.append(", ");
        }
        if (StringUtils.isNotBlank((String)argumentList)) {
            signature.append(argumentList);
        }
        signature.append(")");
        return signature.toString();
    }

    protected String handleGetIncomingMessageImplementationCall() {
        return this.getMessageImplementationCall("message");
    }

    protected String handleGetIncomingMessageImplementationSignature() {
        return this.getMessagingImplementationSignature("javax.jms.Message message");
    }

    protected String handleGetImplementationReturnTypeName() {
        ClassifierFacade returnType;
        String returnTypeName = this.isOutgoingMessageOperation() ? "javax.jms.Message" : ((returnType = this.getReturnType()) != null ? returnType.getFullyQualifiedName() : null);
        return returnTypeName;
    }

    protected String handleGetFullyQualifiedMessageListenerName() {
        StringBuffer name = new StringBuffer();
        String packageName = this.getPackageName();
        if (StringUtils.isNotBlank((String)packageName)) {
            name.append(packageName).append('.');
        }
        name.append(this.getMessageListenerName());
        return name.toString();
    }

    protected String handleGetMessageListenerName() {
        return this.getOwner().getName() + StringUtilsHelper.upperCamelCaseName((String)this.getName());
    }

    protected String handleGetMessageListenerBeanName() {
        return StringUtils.uncapitalize((String)this.getMessageListenerName());
    }

    protected String handleGetMessageListenerContainerReferenceName() {
        return this.getName() + MESSAGE_LISTENER_CONTAINER_SUFFIX;
    }

    protected String handleGetMessageListenerContainerBeanName() {
        return this.getMessageListenerBeanName() + MESSAGE_LISTENER_CONTAINER_SUFFIX;
    }

    protected String handleGetSessionAcknowledgeMode() {
        String mode = null;
        Object value = this.findTaggedValue(SpringProfile.TAGGEDVALUEVALUE_MESSAGING_SESSION_ACKNOWLEDGE_MODE);
        if (value != null) {
            mode = ObjectUtils.toString((Object)value);
        }
        return mode;
    }

    protected boolean handleIsOptimizeAcknowledge() {
        return BooleanUtils.toBoolean((String)ObjectUtils.toString((Object)this.findTaggedValue(SpringProfile.TAGGEDVALUEVALUE_ACTIVEMQ_OPTIMIZE_ACKNOWLEDGE)));
    }

    protected boolean handleIsNullMessageConverterRequired() {
        boolean result = false;
        Collection arguments = this.getArguments();
        if (arguments != null && arguments.size() == 1) {
            ParameterFacade parameter = (ParameterFacade)arguments.iterator().next();
            String parameterType = parameter.getType().getFullyQualifiedName();
            HashSet jmsMessageTypes = new HashSet();
            Collections.addAll(jmsMessageTypes, SpringGlobals.JMS_MESSAGE_TYPES);
            result = jmsMessageTypes.contains(parameterType);
        }
        return result;
    }
}

