/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.tutti.service.sumatra;

import com.google.common.base.Charsets;
import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.io.Files;
import fr.ifremer.tutti.TuttiTechnicalException;
import fr.ifremer.tutti.persistence.entities.TuttiEntities;
import fr.ifremer.tutti.persistence.entities.data.BatchContainer;
import fr.ifremer.tutti.persistence.entities.data.BenthosBatch;
import fr.ifremer.tutti.persistence.entities.data.Cruise;
import fr.ifremer.tutti.persistence.entities.data.FishingOperation;
import fr.ifremer.tutti.persistence.entities.data.SpeciesAbleBatch;
import fr.ifremer.tutti.persistence.entities.data.SpeciesBatch;
import fr.ifremer.tutti.persistence.entities.referential.Species;
import fr.ifremer.tutti.service.AbstractTuttiService;
import fr.ifremer.tutti.service.PersistenceService;
import fr.ifremer.tutti.service.TuttiServiceContext;
import fr.ifremer.tutti.service.catches.WeightComputingService;
import fr.ifremer.tutti.service.sumatra.CatchRow;
import fr.ifremer.tutti.service.sumatra.CatchRowModel;
import java.io.BufferedWriter;
import java.io.File;
import java.io.Writer;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import org.apache.commons.io.IOUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.csv.Export;
import org.nuiton.csv.ExportModel;
import org.nuiton.i18n.I18n;

public class CatchesSumatraExportService
extends AbstractTuttiService {
    private static final Log log = LogFactory.getLog(CatchesSumatraExportService.class);
    protected PersistenceService persistenceService;
    protected WeightComputingService weightComputingService;

    @Override
    public void setServiceContext(TuttiServiceContext context) {
        super.setServiceContext(context);
        this.persistenceService = this.getService(PersistenceService.class);
        this.weightComputingService = this.getService(WeightComputingService.class);
    }

    public void exportCruiseForSumatra(File file, String cruiseId) {
        Preconditions.checkNotNull((Object)cruiseId, (Object)"Cannot export a null cruise");
        Preconditions.checkNotNull((Object)file, (Object)"Cannot export to a null file");
        if (log.isInfoEnabled()) {
            log.info((Object)("Will export cruise " + cruiseId + " to file: " + file));
        }
        Cruise cruise = this.persistenceService.getCruise(cruiseId);
        Preconditions.checkNotNull((Object)cruise, (Object)("Cruise [" + cruiseId + "] not found"));
        CatchRowModel csvModel = new CatchRowModel(this.context.getConfig().getCsvSeparator());
        ArrayList rows = Lists.newArrayList();
        List<FishingOperation> operations = this.persistenceService.getAllFishingOperation(cruiseId);
        if (operations != null) {
            for (FishingOperation operation : operations) {
                Float weight;
                BatchContainer<SpeciesBatch> speciesBatchContainer = this.weightComputingService.getComputedSpeciesBatches(operation);
                LinkedHashMap rowMap = Maps.newLinkedHashMap();
                if (speciesBatchContainer != null) {
                    List speciesBatches = speciesBatchContainer.getChildren();
                    for (SpeciesBatch batch : speciesBatches) {
                        Species sp = batch.getSpecies();
                        int number = Math.round(this.computeNumber((SpeciesAbleBatch)batch, 1.0f));
                        weight = (Float)TuttiEntities.getValueOrComputedValue((Number)batch.getSampleCategoryWeight(), (Number)batch.getSampleCategoryComputedWeight());
                        CatchRow row = (CatchRow)rowMap.get(sp);
                        if (row == null) {
                            row = new CatchRow();
                            row.setFishingOperation(operation);
                            row.setSpecies(sp);
                            row.setWeight(weight);
                            row.setNumber(number);
                        } else {
                            row.setWeight(Float.valueOf(row.getWeight().floatValue() + weight.floatValue()));
                            row.setNumber(row.getNumber() + number);
                        }
                        rowMap.put(sp, row);
                    }
                    rows.addAll(rowMap.values());
                }
                BatchContainer<BenthosBatch> benthosBatchContainer = this.weightComputingService.getComputedBenthosBatches(operation);
                rowMap.clear();
                if (benthosBatchContainer != null) {
                    List benthosBatches = benthosBatchContainer.getChildren();
                    for (BenthosBatch batch : benthosBatches) {
                        Species sp = batch.getSpecies();
                        weight = (Float)TuttiEntities.getValueOrComputedValue((Number)batch.getSampleCategoryWeight(), (Number)batch.getSampleCategoryComputedWeight());
                        int number = Math.round(this.computeNumber((SpeciesAbleBatch)batch, 1.0f));
                        CatchRow row = (CatchRow)rowMap.get(sp);
                        if (row == null) {
                            row = new CatchRow();
                            row.setFishingOperation(operation);
                            row.setSpecies(sp);
                            row.setWeight(weight);
                            row.setNumber(number);
                        } else {
                            row.setWeight(Float.valueOf(row.getWeight().floatValue() + weight.floatValue()));
                            row.setNumber(row.getNumber() + number);
                        }
                        rowMap.put(sp, row);
                    }
                }
                rows.addAll(rowMap.values());
            }
        }
        BufferedWriter writer = null;
        try {
            writer = Files.newWriter((File)file, (Charset)Charsets.UTF_8);
            Export export = Export.newExport((ExportModel)csvModel, (Iterable)rows);
            export.write((Writer)writer);
            writer.close();
        }
        catch (Exception e) {
            throw new TuttiTechnicalException(I18n._((String)"tutti.service.sumatra.export.error", (Object[])new Object[]{file}), (Throwable)e);
        }
        finally {
            IOUtils.closeQuietly((Writer)writer);
        }
    }

    protected float computeNumber(SpeciesAbleBatch batch, float rf) {
        float result;
        float weight = ((Float)TuttiEntities.getValueOrComputedValue((Number)batch.getSampleCategoryWeight(), (Number)batch.getSampleCategoryComputedWeight())).floatValue();
        if (batch.isChildBatchsEmpty()) {
            Float subweight;
            Integer number = (Integer)TuttiEntities.getValueOrComputedValue((Number)batch.getNumber(), (Number)batch.getComputedNumber());
            if (number == null) {
                number = 0;
            }
            if ((subweight = (Float)TuttiEntities.getValueOrComputedValue((Number)batch.getWeight(), (Number)batch.getComputedWeight())) != null) {
                rf *= weight / subweight.floatValue();
            }
            result = number.floatValue() * rf;
        } else {
            float totalWeight = 0.0f;
            for (SpeciesAbleBatch child : batch.getChildBatchs()) {
                totalWeight += ((Float)TuttiEntities.getValueOrComputedValue((Number)child.getSampleCategoryWeight(), (Number)child.getSampleCategoryComputedWeight())).floatValue();
            }
            result = 0.0f;
            float rf2 = rf * weight / totalWeight;
            for (SpeciesAbleBatch child : batch.getChildBatchs()) {
                result += this.computeNumber(child, rf2);
            }
        }
        return result;
    }
}

