/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.tutti.ui.swing.content.operation.catches.benthos;

import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import fr.ifremer.tutti.persistence.entities.data.AttachementObjectTypeEnum;
import fr.ifremer.tutti.persistence.entities.data.Attachment;
import fr.ifremer.tutti.persistence.entities.data.BenthosBatch;
import fr.ifremer.tutti.persistence.entities.data.BenthosBatchFrequency;
import fr.ifremer.tutti.persistence.entities.data.BenthosBatchs;
import fr.ifremer.tutti.persistence.entities.data.FishingOperation;
import fr.ifremer.tutti.persistence.entities.data.SampleCategory;
import fr.ifremer.tutti.persistence.entities.data.SampleCategoryModel;
import fr.ifremer.tutti.persistence.entities.data.SampleCategoryModelEntry;
import fr.ifremer.tutti.persistence.entities.referential.Species;
import fr.ifremer.tutti.service.WeightUnit;
import fr.ifremer.tutti.ui.swing.content.operation.catches.SampleCategoryAble;
import fr.ifremer.tutti.ui.swing.content.operation.catches.benthos.frequency.BenthosFrequencyRowModel;
import fr.ifremer.tutti.ui.swing.util.AbstractTuttiBeanUIModel;
import fr.ifremer.tutti.ui.swing.util.TuttiComputedOrNotData;
import fr.ifremer.tutti.ui.swing.util.TuttiUIUtil;
import fr.ifremer.tutti.ui.swing.util.attachment.AttachmentModelAware;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.ObjectUtils;
import org.nuiton.util.beans.Binder;
import org.nuiton.util.beans.BinderFactory;

public class BenthosBatchRowModel
extends AbstractTuttiBeanUIModel<BenthosBatch, BenthosBatchRowModel>
implements BenthosBatch,
AttachmentModelAware,
SampleCategoryAble<BenthosBatchRowModel> {
    private static final long serialVersionUID = 1L;
    public static final String PROPERTY_SPECIES_TO_CONFIRM = "speciesToConfirm";
    public static final String PROPERTY_SPECIES = "species";
    public static final String PROPERTY_SAMPLE_CATEGORY = "sampleCategory";
    public static final String PROPERTY_SAMPLE_CATEGORY_VALUE = "sampleCategoryValue";
    public static final String PROPERTY_SAMPLE_CATEGORY_WEIGHT = "sampleCategoryWeight";
    public static final String PROPERTY_SAMPLE_CATEGORY_COMPUTED_WEIGHT = "sampleCategoryComputedWeight";
    public static final String PROPERTY_WEIGHT = "weight";
    public static final String PROPERTY_NUMBER = "number";
    public static final String PROPERTY_FREQUENCY = "frequency";
    public static final String PROPERTY_COMPUTED_NUMBER = "computedOrNotNumber";
    public static final String PROPERTY_COMPUTED_WEIGHT = "computedOrNotWeight";
    public static final String PROPERTY_PARENT_BATCH = "parentBatch";
    public static final String PROPERTY_CHILD_BATCH = "childBatch";
    public static final String PROPERTY_BATCH_LEAF = "batchLeaf";
    public static final String PROPERTY_BATCH_ROOT = "batchRoot";
    protected Species species;
    protected final SampleCategory<?>[] categories;
    protected boolean speciesToConfirm;
    protected TuttiComputedOrNotData<Float> computedOrNotWeight = new TuttiComputedOrNotData();
    protected TuttiComputedOrNotData<Integer> computedOrNotNumber = new TuttiComputedOrNotData();
    protected String comment;
    protected final List<Attachment> attachment = Lists.newArrayList();
    protected List<BenthosFrequencyRowModel> frequency = Lists.newArrayList();
    protected BenthosBatchRowModel parentBatch;
    protected List<BenthosBatchRowModel> childBatch;
    protected final SampleCategoryModel sampleCategoryModel;
    protected final WeightUnit weightUnit;
    protected static final Binder<BenthosBatch, BenthosBatchRowModel> fromBeanBinder = BinderFactory.newBinder(BenthosBatch.class, BenthosBatchRowModel.class);
    protected static final Binder<BenthosBatchRowModel, BenthosBatch> toBeanBinder = BinderFactory.newBinder(BenthosBatchRowModel.class, BenthosBatch.class);

    public BenthosBatchRowModel(WeightUnit weightUnit, SampleCategoryModel sampleCategoryModel) {
        super(BenthosBatch.class, fromBeanBinder, toBeanBinder);
        this.weightUnit = weightUnit;
        this.sampleCategoryModel = sampleCategoryModel;
        this.categories = new SampleCategory[sampleCategoryModel.getNbSampling()];
        for (int i = 0; i < this.categories.length; ++i) {
            SampleCategoryModelEntry entry = sampleCategoryModel.getCategoryByIndex(i);
            SampleCategory category = SampleCategory.newSample(entry);
            this.categories[i] = category;
        }
        this.computedOrNotWeight.addPropagateListener(PROPERTY_WEIGHT, this);
        this.computedOrNotWeight.addPropagateListener(PROPERTY_COMPUTED_WEIGHT, this);
        this.computedOrNotNumber.addPropagateListener(PROPERTY_NUMBER, this);
        this.computedOrNotNumber.addPropagateListener(PROPERTY_COMPUTED_NUMBER, this);
    }

    public BenthosBatchRowModel(WeightUnit weightUnit, SampleCategoryModel sampleCategoryModel, BenthosBatch entity, List<BenthosBatchFrequency> frequencies) {
        this(weightUnit, sampleCategoryModel);
        this.fromEntity(entity);
        List<BenthosFrequencyRowModel> frequencyRows = BenthosFrequencyRowModel.fromEntity(weightUnit, frequencies);
        this.frequency.addAll(frequencyRows);
        Collections.sort(this.frequency);
    }

    @Override
    protected BenthosBatch newEntity() {
        return BenthosBatchs.newBenthosBatch();
    }

    @Override
    public void fromEntity(BenthosBatch entity) {
        super.fromEntity(entity);
        this.setWeight(this.weightUnit.fromEntity(this.getWeight()));
    }

    @Override
    public BenthosBatch toEntity() {
        BenthosBatch result = (BenthosBatch)super.toEntity();
        result.setWeight(this.weightUnit.toEntity(this.getWeight()));
        SampleCategory sampleCategory = this.getFinestCategory();
        Preconditions.checkNotNull((Object)sampleCategory);
        Preconditions.checkNotNull((Object)sampleCategory.getCategoryId());
        Preconditions.checkNotNull(sampleCategory.getCategoryValue());
        result.setSampleCategoryId(sampleCategory.getCategoryId());
        result.setSampleCategoryValue((Serializable)sampleCategory.getCategoryValue());
        Float categoryWeight = sampleCategory.getCategoryWeight();
        result.setSampleCategoryWeight(this.weightUnit.toEntity(categoryWeight));
        return result;
    }

    @Override
    public Integer getCategoryIndex(Integer id) {
        Integer result = null;
        for (SampleCategory<?> category : this.categories) {
            if (category == null || !id.equals(category.getCategoryId())) continue;
            result = category.getCategoryDef().getOrder();
            break;
        }
        return result;
    }

    @Override
    public void setSampleCategory(SampleCategory sampleCategory) {
        int index = sampleCategory.getCategoryDef().getOrder();
        SampleCategory<?> oldCategory = this.categories[index];
        Object oldValue = oldCategory.getCategoryValue();
        Float oldWeight = oldCategory.getCategoryWeight();
        Float oldComputedWeight = oldCategory.getComputedWeight();
        this.categories[index] = sampleCategory;
        this.fireIndexedPropertyChange(PROPERTY_SAMPLE_CATEGORY, index, oldCategory, sampleCategory);
        this.fireIndexedPropertyChange(PROPERTY_SAMPLE_CATEGORY_VALUE, index, oldValue, sampleCategory.getCategoryValue());
        this.fireIndexedPropertyChange(PROPERTY_SAMPLE_CATEGORY_WEIGHT, index, oldWeight, sampleCategory.getCategoryWeight());
        this.fireIndexedPropertyChange(PROPERTY_SAMPLE_CATEGORY_COMPUTED_WEIGHT, index, oldComputedWeight, sampleCategory.getComputedWeight());
    }

    @Override
    public SampleCategory<?> getFirstSampleCategory() {
        return this.categories[0];
    }

    @Override
    public SampleCategory getFinestCategory() {
        SampleCategory<?> result = null;
        for (int i = this.categories.length - 1; i > -1; --i) {
            SampleCategory<?> category = this.categories[i];
            if (category == null || !category.isValid()) continue;
            result = category;
            break;
        }
        return result;
    }

    @Override
    public SampleCategory<?> getSampleCategoryById(Integer sampleCategoryId) {
        Integer index = this.getCategoryIndex(sampleCategoryId);
        SampleCategory<?> result = index == null ? null : this.categories[index];
        return result;
    }

    @Override
    public SampleCategory<?> getSampleCategoryByIndex(int sampleCategoryIndex) {
        SampleCategory<?> result = this.categories[sampleCategoryIndex];
        return result;
    }

    @Override
    public void setSampleCategoryValue(Integer sampleCategoryId, Serializable value) {
        SampleCategory<?> sampleCategory = this.getSampleCategoryById(sampleCategoryId);
        TuttiUIUtil.setProperty(sampleCategory, "categoryValue", value);
        this.firePropertyChange(PROPERTY_SAMPLE_CATEGORY_VALUE, null, sampleCategory);
    }

    @Override
    public void setSampleCategoryWeight(Integer sampleCategoryId, Object value) {
        SampleCategory<?> sampleCategory = this.getSampleCategoryById(sampleCategoryId);
        TuttiUIUtil.setProperty(sampleCategory, "categoryWeight", value);
        this.firePropertyChange(PROPERTY_SAMPLE_CATEGORY_WEIGHT, null, sampleCategory);
    }

    @Override
    public BenthosBatchRowModel getFirstAncestor(SampleCategory<?> entrySampleCategory) {
        BenthosBatchRowModel parentBatch;
        SampleCategory<?> parentSampleCategory;
        SampleCategoryAble<BenthosBatchRowModel> result = this;
        if (this.getParentBatch() != null && ObjectUtils.equals(entrySampleCategory, parentSampleCategory = (parentBatch = this.getParentBatch()).getSampleCategoryById(entrySampleCategory.getCategoryId()))) {
            result = parentBatch.getFirstAncestor((SampleCategory)entrySampleCategory);
        }
        return result;
    }

    @Override
    public Iterator<SampleCategory<?>> iterator() {
        return Arrays.asList(this.categories).iterator();
    }

    @Override
    public Species getSpecies() {
        return this.species;
    }

    @Override
    public void setSpecies(Species species) {
        Species oldCategory = this.getSpecies();
        this.species = species;
        this.firePropertyChange(PROPERTY_SPECIES, oldCategory, species);
    }

    @Override
    public BenthosBatchRowModel getParentBatch() {
        return this.parentBatch;
    }

    public void setParentBatch(BenthosBatchRowModel parentBatch) {
        BenthosBatchRowModel oldValue = this.getParentBatch();
        this.parentBatch = parentBatch;
        this.firePropertyChange(PROPERTY_PARENT_BATCH, oldValue, parentBatch);
        this.firePropertyChange(PROPERTY_BATCH_ROOT, null, this.isBatchRoot());
    }

    public List<BenthosBatchRowModel> getChildBatch() {
        return this.childBatch;
    }

    public void setChildBatch(List<BenthosBatchRowModel> childBatch) {
        this.childBatch = childBatch;
        this.firePropertyChange(PROPERTY_CHILD_BATCH, null, childBatch);
        this.firePropertyChange(PROPERTY_BATCH_LEAF, null, this.isBatchLeaf());
    }

    public boolean isBatchLeaf() {
        return CollectionUtils.isEmpty(this.childBatch);
    }

    public boolean isBatchRoot() {
        return this.parentBatch == null;
    }

    @Override
    public String getComment() {
        return this.comment;
    }

    @Override
    public void setComment(String comment) {
        String oldValue = this.getComment();
        this.comment = comment;
        this.firePropertyChange("comment", oldValue, comment);
    }

    @Override
    public AttachementObjectTypeEnum getObjectType() {
        return AttachementObjectTypeEnum.BATCH;
    }

    @Override
    public Integer getObjectId() {
        return this.getIdAsInt();
    }

    @Override
    public List<Attachment> getAttachment() {
        return this.attachment;
    }

    @Override
    public void addAllAttachment(Collection<Attachment> attachments) {
        this.attachment.addAll(attachments);
        this.firePropertyChange("attachment", null, this.getAttachment());
    }

    @Override
    public void addAttachment(Attachment attachment) {
        this.attachment.add(attachment);
        this.firePropertyChange("attachment", null, this.getAttachment());
    }

    @Override
    public void removeAllAttachment(Collection<Attachment> attachments) {
        this.attachment.removeAll(attachments);
        this.firePropertyChange("attachment", null, this.getAttachment());
    }

    @Override
    public void removeAttachment(Attachment attachment) {
        this.attachment.remove(attachment);
        this.firePropertyChange("attachment", null, this.getAttachment());
    }

    public BenthosBatchRowModel getFirstAncestor(Integer sampleCategoryId) {
        SampleCategory<?> sampleCategory = this.getSampleCategoryById(sampleCategoryId);
        SampleCategoryAble firstAncestor = this.getFirstAncestor((SampleCategory)sampleCategory);
        return firstAncestor;
    }

    @Override
    public boolean isSpeciesToConfirm() {
        return this.speciesToConfirm;
    }

    @Override
    public void setSpeciesToConfirm(boolean speciesToConfirm) {
        Boolean oldValue = this.isSpeciesToConfirm();
        this.speciesToConfirm = speciesToConfirm;
        this.firePropertyChange(PROPERTY_SPECIES_TO_CONFIRM, oldValue, speciesToConfirm);
    }

    @Override
    public Float getWeight() {
        return this.computedOrNotWeight.getData();
    }

    @Override
    public void setWeight(Float weight) {
        this.computedOrNotWeight.setData(weight);
    }

    @Override
    public Integer getNumber() {
        return this.computedOrNotNumber.getData();
    }

    @Override
    public void setNumber(Integer number) {
        this.computedOrNotNumber.setData(number);
    }

    public List<BenthosFrequencyRowModel> getFrequency() {
        return this.frequency;
    }

    public void setFrequency(List<BenthosFrequencyRowModel> frequency) {
        this.frequency = frequency;
        this.firePropertyChange(PROPERTY_FREQUENCY, null, frequency);
    }

    @Override
    public Integer getComputedNumber() {
        return this.computedOrNotNumber.getComputedData();
    }

    @Override
    public void setComputedNumber(Integer computedNumber) {
        this.computedOrNotNumber.setComputedData(computedNumber);
    }

    @Override
    public Float getComputedWeight() {
        return this.computedOrNotWeight.getComputedData();
    }

    @Override
    public void setComputedWeight(Float computedWeight) {
        this.computedOrNotWeight.setComputedData(computedWeight);
    }

    public TuttiComputedOrNotData<Integer> getComputedOrNotNumber() {
        return this.computedOrNotNumber;
    }

    public void setComputedOrNotNumber(TuttiComputedOrNotData<Integer> computedOrNotNumber) {
        this.computedOrNotNumber = computedOrNotNumber;
    }

    public TuttiComputedOrNotData<Float> getComputedOrNotWeight() {
        return this.computedOrNotWeight;
    }

    public void setComputedOrNotWeight(TuttiComputedOrNotData<Float> computedOrNotWeight) {
        this.computedOrNotWeight = computedOrNotWeight;
    }

    @Override
    public Integer getSampleCategoryId() {
        return null;
    }

    @Override
    public void setSampleCategoryId(Integer sampleCategoryId) {
    }

    @Override
    public Serializable getSampleCategoryValue() {
        return null;
    }

    @Override
    public void setSampleCategoryValue(Serializable sampleCategoryValue) {
    }

    @Override
    public Float getSampleCategoryWeight() {
        return null;
    }

    @Override
    public void setSampleCategoryWeight(Float sampleCategoryWeight) {
    }

    @Override
    public Float getSampleCategoryComputedWeight() {
        return null;
    }

    @Override
    public void setSampleCategoryComputedWeight(Float sampleCategoryComputedWeight) {
    }

    @Override
    public BenthosBatch getChildBatchs(int index) {
        return this.childBatch.get(index);
    }

    @Override
    public boolean isChildBatchsEmpty() {
        return this.childBatch.isEmpty();
    }

    @Override
    public int sizeChildBatchs() {
        return this.childBatch.size();
    }

    @Override
    public void addChildBatchs(BenthosBatch childBatchs) {
    }

    @Override
    public void addAllChildBatchs(Collection<BenthosBatch> childBatchs) {
    }

    @Override
    public boolean removeChildBatchs(BenthosBatch childBatchs) {
        return false;
    }

    @Override
    public boolean removeAllChildBatchs(Collection<BenthosBatch> childBatchs) {
        return false;
    }

    @Override
    public boolean containsChildBatchs(BenthosBatch childBatchs) {
        return false;
    }

    @Override
    public boolean containsAllChildBatchs(Collection<BenthosBatch> childBatchs) {
        return false;
    }

    @Override
    public List<BenthosBatch> getChildBatchs() {
        return null;
    }

    @Override
    public void setChildBatchs(List<BenthosBatch> childBatchs) {
    }

    @Override
    public void setParentBatch(BenthosBatch parentBatch) {
    }

    @Override
    public FishingOperation getFishingOperation() {
        return null;
    }

    @Override
    public void setFishingOperation(FishingOperation fishingOperation) {
    }

    public void collectShell(Set<BenthosBatchRowModel> collectedRows) {
        if (!this.isBatchLeaf()) {
            for (BenthosBatchRowModel batchChild : this.getChildBatch()) {
                collectedRows.add(batchChild);
                batchChild.collectShell(collectedRows);
            }
        }
    }

    @Override
    public Integer getRankOrder() {
        return null;
    }

    @Override
    public void setRankOrder(Integer rankOrder) {
    }
}

