/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.tutti.ui.swing.content.operation.catches.species.frequency;

import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import fr.ifremer.tutti.ui.swing.content.operation.catches.EditCatchesUI;
import fr.ifremer.tutti.ui.swing.content.operation.catches.species.SpeciesBatchRowModel;
import fr.ifremer.tutti.ui.swing.content.operation.catches.species.SpeciesBatchTableModel;
import fr.ifremer.tutti.ui.swing.content.operation.catches.species.SpeciesBatchUI;
import fr.ifremer.tutti.ui.swing.content.operation.catches.species.frequency.SpeciesFrequencyRowModel;
import fr.ifremer.tutti.ui.swing.content.operation.catches.species.frequency.SpeciesFrequencyUIModel;
import fr.ifremer.tutti.ui.swing.util.TuttiComputedOrNotData;
import fr.ifremer.tutti.ui.swing.util.table.AbstractSelectTableAction;
import fr.ifremer.tutti.ui.swing.util.table.ColumnIdentifier;
import java.awt.Color;
import java.awt.Component;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import javax.swing.AbstractCellEditor;
import javax.swing.JTable;
import javax.swing.border.LineBorder;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import jaxx.runtime.SwingUtil;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class SpeciesFrequencyCellComponent
extends DefaultTableCellRenderer {
    private static final long serialVersionUID = 1L;
    protected Color computedDataColor;
    private static final Log log = LogFactory.getLog(SpeciesFrequencyCellComponent.class);

    public SpeciesFrequencyCellComponent(Color computedDataColor) {
        this.setHorizontalAlignment(0);
        this.setIcon(SwingUtil.createActionIcon((String)"show-frequency"));
        this.computedDataColor = computedDataColor;
    }

    public void setComputedOrNotText(TuttiComputedOrNotData<Integer> data) {
        String text;
        if (data != null && data.getData() != null) {
            text = String.valueOf(data.getData());
        } else if (data != null && data.getComputedData() != null && data.getComputedData() != 0) {
            String blue = Integer.toHexString(this.computedDataColor.getRGB()).substring(2);
            text = "<html><em style='color: #" + blue + "'>" + data.getComputedData() + "</em></html>";
        } else {
            text = " - ";
        }
        this.setText(text);
        this.setToolTipText(text);
    }

    public static TableCellRenderer newRender(Color computedDataColor) {
        return new FrequencyCellRenderer(computedDataColor);
    }

    public static TableCellEditor newEditor(SpeciesBatchUI ui, Color computedDataColor) {
        return new FrequencyCellEditor(ui, computedDataColor);
    }

    public static class FrequencyCellRenderer
    implements TableCellRenderer {
        protected final SpeciesFrequencyCellComponent component;

        public FrequencyCellRenderer(Color computedDataColor) {
            this.component = new SpeciesFrequencyCellComponent(computedDataColor);
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            TuttiComputedOrNotData data = (TuttiComputedOrNotData)((Object)value);
            SpeciesFrequencyCellComponent result = (SpeciesFrequencyCellComponent)this.component.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
            boolean editable = table.isCellEditable(row, column);
            result.setEnabled(editable);
            result.setComputedOrNotText(data);
            return result;
        }
    }

    public static class FrequencyCellEditor
    extends AbstractCellEditor
    implements TableCellEditor {
        private static final long serialVersionUID = 1L;
        protected final SpeciesFrequencyCellComponent component;
        protected final SpeciesBatchUI ui;
        protected JTable table;
        protected SpeciesBatchTableModel tableModel;
        protected ColumnIdentifier<SpeciesBatchRowModel> columnIdentifier;
        protected SpeciesBatchRowModel editRow;
        protected Integer rowIndex;
        protected Integer columnIndex;

        public FrequencyCellEditor(SpeciesBatchUI ui, Color computedDataColor) {
            this.ui = ui;
            this.component = new SpeciesFrequencyCellComponent(computedDataColor);
            this.component.setBorder(new LineBorder(Color.BLACK));
            this.component.addKeyListener(new KeyAdapter(){

                @Override
                public void keyReleased(KeyEvent e) {
                    if (e.getKeyCode() == 10 || e.getKeyCode() == 32) {
                        e.consume();
                        FrequencyCellEditor.this.startEdit();
                    }
                }
            });
            this.component.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent e) {
                    e.consume();
                    FrequencyCellEditor.this.startEdit();
                }
            });
        }

        public void startEdit() {
            Preconditions.checkNotNull((Object)this.tableModel, (Object)"No table model assigned.");
            Preconditions.checkNotNull((Object)this.editRow, (Object)"No editRow found.");
            if (log.isDebugEnabled()) {
                log.debug((Object)("Will edit frequencies for row: " + this.rowIndex));
            }
            EditCatchesUI parent = (EditCatchesUI)SwingUtil.getParentContainer((Object)this.ui, EditCatchesUI.class);
            parent.getHandler().editSpeciesFrequencies(this.editRow, this);
        }

        public void validateEdition(SpeciesFrequencyUIModel frequencyModel) {
            if (frequencyModel.isValid()) {
                ArrayList frequency = Lists.newArrayList();
                if (frequencyModel.isSimpleCountingMode()) {
                    this.editRow.setNumber(frequencyModel.getSimpleCount());
                } else {
                    for (SpeciesFrequencyRowModel row : frequencyModel.getRows()) {
                        if (!row.isValid() || row.getNumber() == null && row.getWeight() == null) continue;
                        frequency.add(row);
                    }
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("Push back " + frequency.size() + " frequency to batch " + frequencyModel.getBatch()));
                    }
                    this.editRow.setNumber(null);
                }
                this.editRow.setFrequency(frequency);
                this.ui.getHandler().updateTotalFromFrequencies(this.editRow);
            }
            int r = this.rowIndex;
            int c = this.columnIndex;
            this.stopCellEditing();
            AbstractSelectTableAction.doSelectCell(this.table, r, c);
            this.table.requestFocus();
        }

        @Override
        public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
            this.tableModel = (SpeciesBatchTableModel)table.getModel();
            this.table = table;
            this.columnIdentifier = SpeciesBatchTableModel.COMPUTED_NUMBER;
            if (log.isDebugEnabled()) {
                log.debug((Object)("Set columnIdentifier (" + column + ") :: " + this.columnIdentifier.getPropertyName()));
            }
            TuttiComputedOrNotData data = (TuttiComputedOrNotData)((Object)value);
            this.component.setComputedOrNotText(data);
            this.rowIndex = row;
            this.columnIndex = column;
            this.editRow = (SpeciesBatchRowModel)this.tableModel.getEntry(row);
            return this.component;
        }

        @Override
        public Object getCellEditorValue() {
            Preconditions.checkNotNull((Object)this.editRow, (Object)"No editRow found in editor.");
            TuttiComputedOrNotData<Integer> result = null;
            if (this.columnIdentifier == SpeciesBatchTableModel.COMPUTED_NUMBER) {
                result = this.editRow.getComputedOrNotNumber();
            }
            if (log.isDebugEnabled()) {
                log.debug((Object)("editor value (" + this.columnIdentifier + "): " + result));
            }
            return result;
        }

        @Override
        public void cancelCellEditing() {
            super.cancelCellEditing();
            this.rowIndex = null;
            this.columnIndex = null;
            this.editRow = null;
        }
    }
}

