/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.tutti.ui.swing.content.operation.catches.benthos.split;

import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import fr.ifremer.tutti.persistence.entities.data.SampleCategory;
import fr.ifremer.tutti.persistence.entities.data.SampleCategoryModel;
import fr.ifremer.tutti.persistence.entities.data.SampleCategoryModelEntry;
import fr.ifremer.tutti.persistence.entities.referential.Caracteristic;
import fr.ifremer.tutti.persistence.entities.referential.CaracteristicQualitativeValue;
import fr.ifremer.tutti.persistence.entities.referential.Species;
import fr.ifremer.tutti.ui.swing.content.operation.catches.EditCatchesUI;
import fr.ifremer.tutti.ui.swing.content.operation.catches.benthos.BenthosBatchRowModel;
import fr.ifremer.tutti.ui.swing.content.operation.catches.benthos.split.SplitBenthosBatchRowModel;
import fr.ifremer.tutti.ui.swing.content.operation.catches.benthos.split.SplitBenthosBatchTableModel;
import fr.ifremer.tutti.ui.swing.content.operation.catches.benthos.split.SplitBenthosBatchUI;
import fr.ifremer.tutti.ui.swing.content.operation.catches.benthos.split.SplitBenthosBatchUIModel;
import fr.ifremer.tutti.ui.swing.content.operation.catches.species.split.SplitSpeciesBatchTableModel;
import fr.ifremer.tutti.ui.swing.util.Cancelable;
import fr.ifremer.tutti.ui.swing.util.TuttiBeanMonitor;
import fr.ifremer.tutti.ui.swing.util.table.AbstractTuttiTableUIHandler;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JTable;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableModel;
import jaxx.runtime.SwingUtil;
import jaxx.runtime.validator.swing.SwingValidator;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jdesktop.swingx.JXTable;
import org.jdesktop.swingx.table.DefaultTableColumnModelExt;
import org.jdesktop.swingx.table.TableColumnModelExt;
import org.nuiton.validator.bean.simple.SimpleBeanValidator;

public class SplitBenthosBatchUIHandler
extends AbstractTuttiTableUIHandler<SplitBenthosBatchRowModel, SplitBenthosBatchUIModel, SplitBenthosBatchUI>
implements Cancelable {
    private static final Log log = LogFactory.getLog(SplitBenthosBatchUIHandler.class);

    public SplitBenthosBatchUIHandler(EditCatchesUI parentUi, SplitBenthosBatchUI ui) {
        super(parentUi.getHandler().getContext(), ui, "categoryValue", "weight");
    }

    public SplitBenthosBatchTableModel getTableModel() {
        return (SplitBenthosBatchTableModel)this.getTable().getModel();
    }

    @Override
    public JXTable getTable() {
        return ((SplitBenthosBatchUI)this.ui).getTable();
    }

    @Override
    protected boolean isRowValid(SplitBenthosBatchRowModel row) {
        return row.isValid();
    }

    @Override
    protected void saveSelectedRowIfRequired(TuttiBeanMonitor<SplitBenthosBatchRowModel> rowMonitor, SplitBenthosBatchRowModel row) {
        if (rowMonitor.wasModified()) {
            if (row.isValid() && log.isInfoEnabled()) {
                log.info((Object)"Change row that was modified and valid");
            }
            rowMonitor.clearModified();
        }
    }

    @Override
    protected void onRowModified(int rowIndex, SplitBenthosBatchRowModel row, String propertyName, Object oldValue, Object newValue) {
        this.recomputeRowValidState(row);
        if ("weight".equals(propertyName)) {
            this.computeSampleWeight(row);
        }
    }

    @Override
    public SwingValidator<SplitBenthosBatchUIModel> getValidator() {
        return ((SplitBenthosBatchUI)this.ui).getValidator();
    }

    @Override
    public void beforeInitUI() {
        SampleCategoryModel sampleCategoryModel = this.getDataContext().getSampleCategoryModel();
        SplitBenthosBatchUIModel model = new SplitBenthosBatchUIModel(sampleCategoryModel);
        ((SplitBenthosBatchUI)this.ui).setContextValue(model);
    }

    @Override
    public void afterInitUI() {
        this.initUI(this.ui);
        SplitBenthosBatchUIModel model = (SplitBenthosBatchUIModel)this.getModel();
        model.addPropertyChangeListener("category", new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                SplitBenthosBatchUIModel source = (SplitBenthosBatchUIModel)evt.getSource();
                source.setSelectedCategory(null);
                List data = (List)evt.getNewValue();
                ((SplitBenthosBatchUI)SplitBenthosBatchUIHandler.this.ui).getCategoryComboBox().setModel(new DefaultComboBoxModel<Object>(data.toArray()));
            }
        });
        model.addPropertyChangeListener("selectedCategory", new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                SplitBenthosBatchUIModel source = (SplitBenthosBatchUIModel)evt.getSource();
                source.setSampleWeight(null);
                SampleCategoryModelEntry newValue = (SampleCategoryModelEntry)evt.getNewValue();
                SplitBenthosBatchUIHandler.this.generateTableModel(newValue);
            }
        });
        ((SplitBenthosBatchUI)this.ui).getCategoryComboBox().setRenderer(this.newListCellRender(SampleCategoryModelEntry.class));
        ((SplitBenthosBatchUI)this.ui).getCategoryComboBox().addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                JComboBox comboBox = (JComboBox)e.getSource();
                ((SplitBenthosBatchUIModel)SplitBenthosBatchUIHandler.this.getModel()).setSelectedCategory((SampleCategoryModelEntry)comboBox.getSelectedItem());
            }
        });
        this.generateTableModel(null);
        this.initTable(this.getTable());
        this.listenValidatorValid((SimpleBeanValidator)((SplitBenthosBatchUI)this.ui).getValidator(), model);
    }

    @Override
    protected JComponent getComponentToFocus() {
        return ((SplitBenthosBatchUI)this.getUI()).getCategoryComboBox();
    }

    @Override
    public void onCloseUI() {
        if (log.isDebugEnabled()) {
            log.debug((Object)("closing: " + this.ui));
        }
        ((SplitBenthosBatchUI)this.ui).getValidator().setBean(null);
        ((SplitBenthosBatchUIModel)this.getModel()).setValid(false);
        ((SplitBenthosBatchUIModel)this.getModel()).setSelectedCategory(null);
        EditCatchesUI parent = (EditCatchesUI)SwingUtil.getParentContainer((Object)this.ui, EditCatchesUI.class);
        parent.getHandler().setBenthosSelectedCard("main");
    }

    @Override
    public void cancel() {
        if (log.isDebugEnabled()) {
            log.debug((Object)("Cancel UI " + this.ui));
        }
        this.closeUI(this.ui);
    }

    public String decorateSpecies(Species object) {
        String result = object == null ? "" : super.decorate(object);
        return result;
    }

    public void editBatch(BenthosBatchRowModel batch) {
        ArrayList categories = Lists.newArrayList();
        if (batch != null) {
            SampleCategoryModel sampleCategoryModel = ((SplitBenthosBatchUIModel)this.getModel()).getSampleCategoryModel();
            categories.addAll(sampleCategoryModel.getCategory());
            SampleCategory lastCategory = batch.getFinestCategory();
            Preconditions.checkNotNull((Object)lastCategory, (Object)"Can't split a benthos batch with no sample category.");
            int firstOrder = lastCategory.getCategoryDef().getOrder();
            for (Integer sampleCategoryId : sampleCategoryModel.getSamplingOrder()) {
                SampleCategory<?> sampleCategory = batch.getSampleCategoryById(sampleCategoryId);
                int order = sampleCategory.getCategoryDef().getOrder();
                if (order >= firstOrder && !sampleCategory.isValid()) continue;
                categories.remove(sampleCategory.getCategoryDef());
            }
        }
        SplitBenthosBatchUIModel model = (SplitBenthosBatchUIModel)this.getModel();
        ((SplitBenthosBatchUI)this.ui).getValidator().setBean((Object)model);
        model.setSampleWeight(null);
        model.setCategory(categories);
        if (CollectionUtils.isNotEmpty((Collection)categories)) {
            model.setSelectedCategory((SampleCategoryModelEntry)categories.get(0));
        }
        model.setBatch(batch);
    }

    public void save() {
        if (log.isDebugEnabled()) {
            log.debug((Object)("Save UI " + this.ui));
        }
        EditCatchesUI parent = (EditCatchesUI)SwingUtil.getParentContainer((Object)this.ui, EditCatchesUI.class);
        parent.getBenthosTabContent().getHandler().splitBatch((SplitBenthosBatchUIModel)this.getModel());
        this.closeUI(this.ui);
    }

    protected void computeSampleWeight(SplitBenthosBatchRowModel row) {
        if (log.isDebugEnabled()) {
            log.debug((Object)("Will recompute sample weight from row: " + row));
        }
        Float result = null;
        List rows = this.getTableModel().getRows();
        for (SplitBenthosBatchRowModel rowModel : rows) {
            Float weight = rowModel.getWeight();
            if (weight == null) continue;
            if (result == null) {
                result = Float.valueOf(0.0f);
            }
            result = Float.valueOf(result.floatValue() + weight.floatValue());
        }
        ((SplitBenthosBatchUIModel)this.getModel()).setSampleWeight(result);
    }

    protected void generateTableModel(SampleCategoryModelEntry category) {
        ((SplitBenthosBatchUIModel)this.getModel()).setRows(null);
        Caracteristic data = null;
        DefaultTableColumnModelExt columnModel = new DefaultTableColumnModelExt();
        this.addBooleanColumnToModel((TableColumnModel)columnModel, SplitBenthosBatchTableModel.SELECTED, (JTable)this.getTable());
        boolean editableCategoryValue = false;
        if (category != null) {
            if (!category.getCaracteristic().isQualitativeValueEmpty()) {
                data = category.getCaracteristic();
            } else {
                editableCategoryValue = true;
                this.addFloatColumnToModel((TableColumnModel)columnModel, SplitSpeciesBatchTableModel.EDITABLE_CATEGORY_VALUE, "\\d{0,6}(\\.\\d{0,1})?");
            }
            if (data != null) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Got " + data.sizeQualitativeValue() + " qualitative data to add"));
                }
                this.addColumnToModel((TableColumnModel)columnModel, null, this.newTableCellRender(CaracteristicQualitativeValue.class), SplitSpeciesBatchTableModel.READ_ONLY_CATEGORY_VALUE);
            }
            this.addFloatColumnToModel((TableColumnModel)columnModel, SplitSpeciesBatchTableModel.WEIGHT, "\\d{0,6}(\\.\\d{0,3})?");
        }
        SplitBenthosBatchTableModel tableModel = new SplitBenthosBatchTableModel((TableColumnModelExt)columnModel, (SplitBenthosBatchUIModel)this.getModel(), editableCategoryValue);
        JXTable table = this.getTable();
        this.uninstallTableSaveOnRowChangedSelectionListener();
        this.uninstallTableKeyListener();
        if (log.isDebugEnabled()) {
            log.debug((Object)("Install new table model " + tableModel));
        }
        table.setModel((TableModel)tableModel);
        table.setColumnModel((TableColumnModel)columnModel);
        this.installTableSaveOnRowChangedSelectionListener();
        this.installTableKeyListener((TableColumnModel)columnModel, (JTable)table);
        ArrayList rows = Lists.newArrayList();
        if (data != null) {
            for (CaracteristicQualitativeValue qualitativeValue : data.getQualitativeValue()) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Add QV: " + qualitativeValue));
                }
                SplitBenthosBatchRowModel newRow = tableModel.createNewRow();
                newRow.setCategoryValue(qualitativeValue);
                rows.add(newRow);
            }
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("Will add " + rows.size() + " rows in table model " + "(can add a first empty row? " + editableCategoryValue + ")."));
        }
        ((SplitBenthosBatchUIModel)this.getModel()).setRows(rows);
    }
}

