/*
 * Decompiled with CFR 0.152.
 */
package org.andromda.utils;

import org.apache.commons.lang.time.DateUtils;

public class DateUtilsHelper
extends DateUtils {
    private static final FormatPattern[] JAVA2PERL_FORMAT_PATTERNS = new FormatPattern[]{new FormatPattern("y{4,}", "%Y"), new FormatPattern("y{1,3}", "%y"), new FormatPattern("M{4,}", "%B"), new FormatPattern("M{3}", "%b"), new FormatPattern("M{1,2}", "%m"), new FormatPattern("d{4,}", "%A"), new FormatPattern("d{3,}", "%a"), new FormatPattern("d{2}", "%d"), new FormatPattern("d{1}", "%e"), new FormatPattern("E{4,}", "%A"), new FormatPattern("E{1,3}", "%a"), new FormatPattern("H{2,}", "%H"), new FormatPattern("H{1}", "%k"), new FormatPattern("h{2,}", "%I"), new FormatPattern("h{1}", "%l"), new FormatPattern("D{3}", "%j"), new FormatPattern("s{2,}", "%S"), new FormatPattern("s{1}", "%s"), new FormatPattern("m{2,}", "%M")};
    private static final String[] PERL_TIME_FORMATS = new String[]{"%H", "%I", "%k", "%l", "%p", "%P", "%s", "%S"};

    public static String formatJavaToPerl(String javaFormat) {
        String perlFormat = null;
        if (javaFormat != null) {
            FormatPattern formatPattern;
            int i;
            perlFormat = javaFormat;
            for (i = 0; i < JAVA2PERL_FORMAT_PATTERNS.length; ++i) {
                formatPattern = JAVA2PERL_FORMAT_PATTERNS[i];
                perlFormat = perlFormat.replaceAll(formatPattern.getPattern(), "%%%" + i + "%%%");
            }
            for (i = 0; i < JAVA2PERL_FORMAT_PATTERNS.length; ++i) {
                formatPattern = JAVA2PERL_FORMAT_PATTERNS[i];
                perlFormat = perlFormat.replaceAll("%%%" + i + "%%%", formatPattern.getReplacement());
            }
        }
        return perlFormat;
    }

    public static boolean containsTimeFormat(String perlFormat) {
        boolean containsTimeFormat = false;
        for (int i = 0; i < PERL_TIME_FORMATS.length && !containsTimeFormat; ++i) {
            String timeFormatPattern = PERL_TIME_FORMATS[i];
            containsTimeFormat = perlFormat.indexOf(timeFormatPattern) > -1;
        }
        return containsTimeFormat;
    }

    private static final class FormatPattern {
        private final String pattern;
        private final String replacement;

        public FormatPattern(String formatPattern, String replacement) {
            this.pattern = formatPattern;
            this.replacement = replacement;
        }

        public String getPattern() {
            return this.pattern;
        }

        public String getReplacement() {
            return this.replacement;
        }
    }
}

