/*
 * Decompiled with CFR 0.152.
 */
package org.andromda.core.common;

import java.io.File;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.andromda.core.common.AndroMDALogger;
import org.andromda.core.common.ComponentContainer;
import org.andromda.core.common.Plugin;
import org.andromda.core.common.ResourceUtils;
import org.andromda.core.common.TemplateObject;
import org.andromda.core.configuration.Namespaces;
import org.andromda.core.configuration.Property;
import org.andromda.core.namespace.BaseNamespaceComponent;
import org.andromda.core.templateengine.TemplateEngine;
import org.apache.log4j.Logger;

public abstract class BasePlugin
extends BaseNamespaceComponent
implements Plugin {
    private final Collection propertyReferences = new ArrayList();
    private final Collection templateObjects = new ArrayList();
    private URL mergeLocation;
    private String templateEngineClass;
    private TemplateEngine templateEngine = null;
    private List contents = null;
    static /* synthetic */ Class class$org$andromda$core$templateengine$TemplateEngine;

    public void initialize() throws Exception {
        Property mergeProperty = Namespaces.instance().getProperty(this.getNamespace(), "mergeLocation", false);
        URL uRL = this.mergeLocation = mergeProperty != null ? new File(mergeProperty.getValue()).toURI().toURL() : null;
        if (this.mergeLocation != null) {
            this.getTemplateEngine().setMergeLocation(this.getMergeLocation().getFile());
        }
        this.getTemplateEngine().initialize(this.getNamespace());
        Iterator iterator = this.templateObjects.iterator();
        while (iterator.hasNext()) {
            TemplateObject templateObject = (TemplateObject)iterator.next();
            templateObject.setResource(this.getResource());
            templateObject.setNamespace(this.getNamespace());
        }
    }

    protected URL getMergeLocation() {
        return this.mergeLocation;
    }

    public void shutdown() {
        this.getTemplateEngine().shutdown();
    }

    public void addTemplateObject(TemplateObject templateObject) {
        if (templateObject != null) {
            this.templateObjects.add(templateObject);
        }
    }

    public void addMacrolibrary(String macrolibrary) {
        this.getTemplateEngine().addMacroLibrary(macrolibrary);
    }

    public Collection getTemplateObjects() {
        return this.templateObjects;
    }

    public void setTemplateEngineClass(String templateEngineClass) {
        this.templateEngineClass = templateEngineClass;
    }

    public TemplateEngine getTemplateEngine() {
        if (this.templateEngine == null) {
            this.templateEngine = (TemplateEngine)ComponentContainer.instance().newComponent(this.templateEngineClass, class$org$andromda$core$templateengine$TemplateEngine == null ? (class$org$andromda$core$templateengine$TemplateEngine = BasePlugin.class$("org.andromda.core.templateengine.TemplateEngine")) : class$org$andromda$core$templateengine$TemplateEngine);
        }
        return this.templateEngine;
    }

    public String[] getPropertyReferences() {
        return this.propertyReferences.toArray(new String[0]);
    }

    public void addPropertyReference(String reference) {
        this.propertyReferences.add(reference);
    }

    protected void populateTemplateContext(Map templateContext) {
        if (templateContext == null) {
            templateContext = new LinkedHashMap();
        }
        this.addTemplateObjectsToContext(templateContext);
        this.addPropertyReferencesToContext(templateContext);
    }

    private void addTemplateObjectsToContext(Map templateContext) {
        Collection templateObjects = this.getTemplateObjects();
        if (templateObjects != null && !templateObjects.isEmpty()) {
            Iterator iterator = templateObjects.iterator();
            while (iterator.hasNext()) {
                TemplateObject templateObject = (TemplateObject)iterator.next();
                templateContext.put(templateObject.getName(), templateObject.getObject());
            }
        }
    }

    private void addPropertyReferencesToContext(Map templateContext) {
        String[] propertyReferences = this.getPropertyReferences();
        if (propertyReferences != null && propertyReferences.length > 0) {
            Namespaces namespaces = Namespaces.instance();
            for (int ctr = 0; ctr < propertyReferences.length; ++ctr) {
                String reference = propertyReferences[ctr];
                templateContext.put(reference, namespaces.getPropertyValue(this.getNamespace(), reference));
            }
        }
    }

    public List getContents() {
        if (this.contents == null) {
            if (ResourceUtils.isArchive(this.getResource())) {
                List mergeContents;
                this.contents = ResourceUtils.getClassPathArchiveContents(this.getResource());
                if (this.getMergeLocation() != null && (mergeContents = ResourceUtils.getDirectoryContents(this.getMergeLocation(), 0)) != null && !mergeContents.isEmpty()) {
                    this.contents.addAll(mergeContents);
                }
            } else {
                this.contents = ResourceUtils.getDirectoryContents(this.getResource(), 2);
            }
        }
        return this.contents;
    }

    protected Logger getLogger() {
        return AndroMDALogger.getNamespaceLogger(this.getNamespace());
    }

    public String toString() {
        return super.toString() + "[" + this.getNamespace() + "]";
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

