package fr.ifremer.tutti.ui.swing.content.operation.catches.species.split;

/*
 * #%L
 * Tutti :: UI
 * $Id:$
 * $HeadURL:$
 * %%
 * Copyright (C) 2012 - 2013 Ifremer
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 3 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-3.0.html>.
 * #L%
 */

import fr.ifremer.tutti.ui.swing.TuttiHelpBroker;
import fr.ifremer.tutti.ui.swing.content.operation.catches.EditCatchesUI;
import fr.ifremer.tutti.ui.swing.util.TuttiUI;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.GridBagConstraints;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JTextField;
import javax.swing.ListSelectionModel;
import javax.swing.border.TitledBorder;
import jaxx.runtime.JAXXBinding;
import jaxx.runtime.JAXXContext;
import jaxx.runtime.JAXXObject;
import jaxx.runtime.JAXXObjectDescriptor;
import jaxx.runtime.JAXXUtil;
import jaxx.runtime.JAXXValidator;
import jaxx.runtime.SwingUtil;
import jaxx.runtime.binding.DefaultJAXXBinding;
import jaxx.runtime.context.DefaultJAXXContext;
import jaxx.runtime.swing.Table;
import jaxx.runtime.swing.help.JAXXHelpUI;
import jaxx.runtime.validator.swing.SwingValidator;
import jaxx.runtime.validator.swing.SwingValidatorUtil;
import jaxx.runtime.validator.swing.meta.Validator;
import jaxx.runtime.validator.swing.meta.ValidatorField;
import jaxx.runtime.validator.swing.ui.ImageValidationUI;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jdesktop.swingx.JXTable;
import static jaxx.runtime.SwingUtil.getStringValue;
import static org.nuiton.i18n.I18n._;

public class SplitSpeciesBatchUI extends JPanel implements JAXXHelpUI<TuttiHelpBroker>, TuttiUI<SplitSpeciesBatchUIModel, SplitSpeciesBatchUIHandler>, JAXXObject, JAXXValidator {

    /*-----------------------------------------------------------------------*/
    /*------------------ Constants for all public bindings ------------------*/
    /*-----------------------------------------------------------------------*/

    public static final String BINDING_BATCH_WEIGHT_FIELD_TEXT = "batchWeightField.text";
    public static final String BINDING_CATEGORY_COMBO_BOX_SELECTED_ITEM = "categoryComboBox.selectedItem";
    public static final String BINDING_SAMPLE_WEIGHT_FIELD_TEXT = "sampleWeightField.text";
    public static final String BINDING_SAVE_BUTTON_ENABLED = "saveButton.enabled";
    public static final String BINDING_SPECIES_FIELD_TEXT = "speciesField.text";
    public static final String BINDING_TABLE_ENABLED = "table.enabled";

    /*-----------------------------------------------------------------------*/
    /*------------------------- Other static fields -------------------------*/
    /*-----------------------------------------------------------------------*/

    private static final String $jaxxObjectDescriptor = "H4sIAAAAAAAAALVXzW8bRRSfpLHz3TQJDanaojSlEEOZUIrUSi3Q2k1IgpMi7ELVIJXx7sSedryz7I5bR1YQfwJ/Aty5IHHjhDhw5sAFcYUbQhy4It7MrvfD3vU6qprDKp55v/fevN+b9958+xfKuQ668Ii029hpWZI1Kd65ff/+3dojasg71DUcZkvhIO9vZBSN7qNpM1h3Jbq4X1bwdR++XhJNW1jUiqBvlNGUKw85dRuUSonOxxGG665Xgu0bbbvldLUGTiVp/fqfv0e/Mr/8ZhShtg3evQBHWclChScZK6NRZkq0AJaekHVOrDq44TCrDv7OqrUSJ667R5r0c/QFGi+jvE0cUCbR6vBH1jo0vm1LdMa1OZMVmxqMukUijUZV2B8Si3KJ7h04mB04tEkdLFtSMtxi2H0K/mBDWBLUY2FTh0gmLGwoLHWx66nCWi+u9Gq/t23b2npeovEGsUxOHYk+fS6Wtjz1ocFcU5jqYA+ei7ldpTw0NvmEcGYSCL1Er8eSINjwbVbU9+PuYqghX3PEYxWeQrq/VfVzC+wWtWwIXoCTHLB6yzuFz+hyzA9fA6lxnU+TAXYWzkzrwjksk5qCLajca/vyO3pRSS4HgFNdACReTRRFW6LTMUx3PQ6beXmnQiGF1bHflGgpBgl2ejA+D4EX55P3NxnlZq/OKm1LvdHjfk0x+All9YZM0xuVCVSsxWXmXdK0OR2sKCaUpmlOKlYqhiM4V9xJ9GI8OMFOnLmcxkl0Vjh1/AjK4mMpbA/Uxjv3A66vBIhpYkQSJM60XowbmDGIZVBehLSDm4IWY/LeqpK8FgCmXPKEhhs3/V0HnY3lIpRcHJbcsCaO7KOc04JlSN79/ir9EWx59Xm5pz4rhXr3v6XFX3/4/fvNblGeA9unE0UjPQWKpe2oGiCZMj3nVeSWZHx9l9g39tGkSzk0JN1wziU4VvG3wTmwN6/gWMHxFnEboCI3/tuPPy199ssJNLqJprgg5iZR8ttoUjYciILgZtt+75b2aObpBHxPKd+A4ocNuO4SrXRWvVrQV8GxElg9akNUziVEJXCtNvnzv4uV7251IzMCnp5JFQ+jk3uA8szizKK6Yfm9KLFBTdsubZki7DlJXQgNakO2X9Lu6O9WUkTyNeGYqk6+1LHo05Uqk5yaRb22ZrU4v7yivgUIiFJR1idV/+2hxDKZZXFMogmuLvemKu0Lnd7adyRBBAqNRK+kEXSgrj3uAuESSiF4ldlVDVsfDqZrB5bQ3YOceDs9J5Kw3TzpD0u8AwzBwYx3H6i5LWkTBqqObrW4TmXF3yj5GteSiehrIcej4WQnWvdDCi4NjocP6mUAD4VKIOBqFgExaHr8Y10uKxInYJSilirt0PByB4S7NDj/Gx1/yMImNQRkOfWdWgsJ8hcKBQjbBDWZ30M8TYO806c47nXp7aMhV4XBoYsAe/l6a2hkAmfXsjjrg6fz1jdJPAt3ax3Fjn4AwHTYoiFlxdDKMWjrG2GOR91ip29yCbl7LSPtI8he8q4OD01g73rmjevDp9PXP8A9C3+FVP4qETPHILB/dMxyLxd179Kgorxy4R3dJsGXWa+WQz9UTxqFKzPXh/iLHFe2994vbzysbJQ3StXtu3vqDC6kSfQMkDOBKkghWndEywJHZjslweH5UyzfLn1wFJUqEuNxVyrf0f4kBcIbc4c4fFYX8IZf7A21MKx6v7fVKxDlu6sz7Mp1a9eiTWExY0BziCnDzQAQT/fUKheHx5Icpyd5HDWgo0QH96zI5aNpM++nDXP1G3WtEN76ixleqdm/J6pj3lpPTC8PoSg1oq8OA47F83JmPDUmPZqRV80wAyonhwKE0cmb8MQnKzVmmVAU3u3TPKK+U5ka1fIf6vNnsobroOF/4BYtNEoTAAA=";
    private static final Log log = LogFactory.getLog(SplitSpeciesBatchUI.class);
    private static final long serialVersionUID = 1L;

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Internal states ---------------------------*/
    /*-----------------------------------------------------------------------*/

    protected List<Object> $activeBindings = new ArrayList<Object>();
    protected Map<String, Object> $bindingSources = new HashMap<String, Object>();
    protected final Map<String, JAXXBinding> $bindings = new TreeMap<String, JAXXBinding>();
    protected Map<String, Object> $objectMap = new HashMap<String, Object>();
    protected Map<?, ?> $previousValues = new HashMap<Object, Object>();
    private boolean allComponentsCreated;
    protected final JAXXContext delegateContext = new DefaultJAXXContext();

    /*-----------------------------------------------------------------------*/
    /*------------------------ Protected components  ------------------------*/
    /*-----------------------------------------------------------------------*/

    protected JPanel actionPanel;
    protected JTextField batchWeightField;
    protected JLabel batchWeightLabel;
    protected TuttiHelpBroker broker;
    protected JButton cancelButton;
    @ValidatorField( validatorId = "validator",  propertyName = "selectedCategory",  editorName = "categoryComboBox")
    protected JComboBox categoryComboBox;
    protected JLabel categoryLabel;
    protected Table configurationPanel;
    protected SplitSpeciesBatchUIHandler handler;
    protected SplitSpeciesBatchUIModel model;
    @ValidatorField( validatorId = "validator",  propertyName = "sampleWeight",  editorName = "sampleWeightField")
    protected JTextField sampleWeightField;
    protected JLabel sampleWeightLabel;
    protected JButton saveButton;
    protected JTextField speciesField;
    protected JLabel speciesLabel;
    protected SplitSpeciesBatchUI splitSpeciesBatchTopPanel = this;
    protected JXTable table;
    protected JScrollPane tableScrollPane;
    @Validator( validatorId = "validator")
    protected SwingValidator<SplitSpeciesBatchUIModel> validator;
    protected List<String> validatorIds = new ArrayList<String>();

    /*-----------------------------------------------------------------------*/
    /*------------------------- Private components  -------------------------*/
    /*-----------------------------------------------------------------------*/

    private JSeparator $JSeparator0;

    /*-----------------------------------------------------------------------*/
    /*---------------------- Raw body code from script ----------------------*/
    /*-----------------------------------------------------------------------*/
    
    
    protected void $afterCompleteSetup() { handler.afterInitUI(); }

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Constructors  ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public SplitSpeciesBatchUI(EditCatchesUI parentUI) {
        JAXXUtil.initContext(this, parentUI);
            SplitSpeciesBatchUIHandler handler = new SplitSpeciesBatchUIHandler(parentUI, this);
            setContextValue(handler);
            handler.beforeInitUI();
            $initialize();
    }

    public SplitSpeciesBatchUI(LayoutManager param0, boolean param1) {
        super(param0 ,param1);
        $initialize();
    }

    public SplitSpeciesBatchUI(JAXXContext parentContext, LayoutManager param1, boolean param2) {
        super(param1 ,param2);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public SplitSpeciesBatchUI() {
        $initialize();
    }

    public SplitSpeciesBatchUI(JAXXContext parentContext) {
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public SplitSpeciesBatchUI(LayoutManager param0) {
        super(param0);
        $initialize();
    }

    public SplitSpeciesBatchUI(JAXXContext parentContext, LayoutManager param1) {
        super(param1);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public SplitSpeciesBatchUI(boolean param0) {
        super(param0);
        $initialize();
    }

    public SplitSpeciesBatchUI(JAXXContext parentContext, boolean param1) {
        super(param1);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Statics methods ---------------------------*/
    /*-----------------------------------------------------------------------*/

    public static JAXXObjectDescriptor $getJAXXObjectDescriptor() {
        return JAXXUtil.decodeCompressedJAXXObjectDescriptor($jaxxObjectDescriptor);
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------- JAXXObject implementation ----------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    public void applyDataBinding(String $binding) {
        if (allComponentsCreated && $bindings.containsKey($binding)) {
            getDataBinding($binding).applyDataBinding();
        }
        processDataBinding($binding);
    }

    @Override
    public void firePropertyChange(String propertyName, Object oldValue, Object newValue) {
        super.firePropertyChange(propertyName, oldValue, newValue);
    }

    @Override
    public Map<String, Object> get$objectMap() {
        return $objectMap;
    }

    @Override
    public JAXXBinding getDataBinding(String bindingId) {
        return $bindings.get(bindingId);
    }

    @Override
    public JAXXBinding[] getDataBindings() {
        return $bindings.values().toArray(new JAXXBinding[$bindings.size()]);
    }

    @Override
    public Object getObjectById(String id) {
        return $objectMap.get(id);
    }

    @Override
    public void processDataBinding(String $binding, boolean $force) {
        if (!$force && $activeBindings.contains($binding)) { 
            return;
        }
        $activeBindings.add($binding);
        try {
            if (allComponentsCreated && $bindings.containsKey($binding)) {
                getDataBinding($binding).processDataBinding();
            }
        } finally {
            $activeBindings.remove($binding);
        }
    }

    @Override
    public void processDataBinding(String $binding) {
        processDataBinding($binding, false);
    }

    @Override
    public void registerDataBinding(JAXXBinding binding) {
        $bindings.put(binding.getId(), binding);
    }

    @Override
    public void removeDataBinding(String $binding) {
        if (allComponentsCreated && $bindings.containsKey($binding)) {
            getDataBinding($binding).removeDataBinding();
        }
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- JAXXContext implementation  ---------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    public <T> T getContextValue(Class<T> clazz) {
        return delegateContext.getContextValue(clazz, null);
    }

    @Override
    public <T> T getContextValue(Class<T> clazz, String name) {
        return delegateContext.getContextValue(clazz, name);
    }

    @Override
    public JAXXContext getDelegateContext() {
        return delegateContext;
    }

    @Override
    public <O extends Container> O getParentContainer(Class<O> clazz) {
        return SwingUtil.getParentContainer(this, clazz);
    }

    @Override
    public <O extends Container> O getParentContainer(Object source, Class<O> clazz) {
        return SwingUtil.getParentContainer(source, clazz);
    }

    @Override
    public <T> void removeContextValue(Class<T> clazz) {
        delegateContext.removeContextValue(clazz, null);
    }

    @Override
    public <T> void removeContextValue(Class<T> clazz, String name) {
        delegateContext.removeContextValue(clazz, name);
    }

    @Override
    public <T> void setContextValue(T o) {
        delegateContext.setContextValue(o, null);
    }

    @Override
    public <T> void setContextValue(T o, String name) {
        delegateContext.setContextValue(o, name);
    }

    /*-----------------------------------------------------------------------*/
    /*-------------------- JAXXValidator implementation  --------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    public SwingValidator<?> getValidator(String validatorId) {
        return (SwingValidator<?>) (validatorIds.contains(validatorId) ? getObjectById(validatorId) : null);
    }

    @Override
    public List<String> getValidatorIds() {
        return validatorIds;
    }

    @Override
    public void registerValidatorFields() {
        SwingValidatorUtil.detectValidatorFields(this);
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Event methods ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public void doActionPerformed__on__cancelButton(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        handler.cancel();
    }

    public void doActionPerformed__on__saveButton(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        handler.save();
    }

    /*-----------------------------------------------------------------------*/
    /*----------------------- Public acessor methods  -----------------------*/
    /*-----------------------------------------------------------------------*/

    public JPanel getActionPanel() {
        return actionPanel;
    }

    public JTextField getBatchWeightField() {
        return batchWeightField;
    }

    public JLabel getBatchWeightLabel() {
        return batchWeightLabel;
    }

    public TuttiHelpBroker getBroker() {
        return broker;
    }

    public JButton getCancelButton() {
        return cancelButton;
    }

    public JComboBox getCategoryComboBox() {
        return categoryComboBox;
    }

    public JLabel getCategoryLabel() {
        return categoryLabel;
    }

    public Table getConfigurationPanel() {
        return configurationPanel;
    }

    public SplitSpeciesBatchUIHandler getHandler() {
        return handler;
    }

    public SplitSpeciesBatchUIModel getModel() {
        return model;
    }

    public JTextField getSampleWeightField() {
        return sampleWeightField;
    }

    public JLabel getSampleWeightLabel() {
        return sampleWeightLabel;
    }

    public JButton getSaveButton() {
        return saveButton;
    }

    public JTextField getSpeciesField() {
        return speciesField;
    }

    public JLabel getSpeciesLabel() {
        return speciesLabel;
    }

    public JXTable getTable() {
        return table;
    }

    public JScrollPane getTableScrollPane() {
        return tableScrollPane;
    }

    public SwingValidator<SplitSpeciesBatchUIModel> getValidator() {
        return validator;
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Other methods ----------------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    public void registerHelpId(TuttiHelpBroker broker, Component component, String helpId) {
        broker.installUI(component, helpId);
    }

    @Override
    public void showHelp(String helpId) {
        getBroker().showHelp(this, helpId);
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Protected acessors methods  ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected JSeparator get$JSeparator0() {
        return $JSeparator0;
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Components creation methods ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected void addChildrenToActionPanel() {
        if (!allComponentsCreated) {
            return;
        }
        actionPanel.add(cancelButton);
        actionPanel.add(saveButton);
    }

    protected void addChildrenToConfigurationPanel() {
        if (!allComponentsCreated) {
            return;
        }
        configurationPanel.add(categoryLabel, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 1, new Insets(3, 3, 3, 3), 0, 0));
        configurationPanel.add(SwingUtil.boxComponentWithJxLayer(categoryComboBox), new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        configurationPanel.add($JSeparator0, new GridBagConstraints(0, 1, 2, 1, 0.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        configurationPanel.add(speciesLabel, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 17, 1, new Insets(3, 3, 3, 3), 0, 0));
        configurationPanel.add(speciesField, new GridBagConstraints(1, 2, 1, 1, 1.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        configurationPanel.add(batchWeightLabel, new GridBagConstraints(0, 3, 1, 1, 0.0, 0.0, 17, 1, new Insets(3, 3, 3, 3), 0, 0));
        configurationPanel.add(batchWeightField, new GridBagConstraints(1, 3, 1, 1, 1.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        configurationPanel.add(sampleWeightLabel, new GridBagConstraints(0, 4, 1, 1, 0.0, 0.0, 17, 1, new Insets(3, 3, 3, 3), 0, 0));
        configurationPanel.add(SwingUtil.boxComponentWithJxLayer(sampleWeightField), new GridBagConstraints(1, 4, 1, 1, 1.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
    }

    protected void addChildrenToSplitSpeciesBatchTopPanel() {
        if (!allComponentsCreated) {
            return;
        }
        add(configurationPanel, BorderLayout.NORTH);
        add(tableScrollPane, BorderLayout.CENTER);
        add(actionPanel, BorderLayout.SOUTH);
    }

    protected void addChildrenToTableScrollPane() {
        if (!allComponentsCreated) {
            return;
        }
        tableScrollPane.getViewport().add(table);
    }

    protected void addChildrenToValidator() {
        if (!allComponentsCreated) {
            return;
        }
        validator.setUiClass(ImageValidationUI.class);
        validator.setBean(model);
    }

    protected void createActionPanel() {
        $objectMap.put("actionPanel", actionPanel = new JPanel());
        
        actionPanel.setName("actionPanel");
        actionPanel.setLayout(new GridLayout(1, 0));
    }

    protected void createBatchWeightField() {
        $objectMap.put("batchWeightField", batchWeightField = new JTextField());
        
        batchWeightField.setName("batchWeightField");
        batchWeightField.setColumns(15);
        batchWeightField.setEnabled(false);
        batchWeightField.setEditable(false);
    }

    protected void createBatchWeightLabel() {
        $objectMap.put("batchWeightLabel", batchWeightLabel = new JLabel());
        
        batchWeightLabel.setName("batchWeightLabel");
        batchWeightLabel.setText(_("tutti.splitSpeciesBatch.field.batchWeight"));
        batchWeightLabel.setToolTipText(_("tutti.splitSpeciesBatch.field.batchWeightField.tip"));
        batchWeightLabel.putClientProperty("help", "tutti.splitSpeciesBatch.field.batchWeightField.help");
    }

    protected void createBroker() {
        $objectMap.put("broker", broker = new TuttiHelpBroker("tutti.splitSpeciesBatch.help"));
    }

    protected void createCancelButton() {
        $objectMap.put("cancelButton", cancelButton = new JButton());
        
        cancelButton.setName("cancelButton");
        cancelButton.setText(_("tutti.splitSpeciesBatch.action.cancel"));
        cancelButton.setToolTipText(_("tutti.splitSpeciesBatch.action.cancel.tip"));
        cancelButton.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__cancelButton"));
        cancelButton.putClientProperty("help", "tutti.splitSpeciesBatch.action.cancel.help");
    }

    protected void createCategoryComboBox() {
        $objectMap.put("categoryComboBox", categoryComboBox = new JComboBox());
        
        categoryComboBox.setName("categoryComboBox");
    }

    protected void createCategoryLabel() {
        $objectMap.put("categoryLabel", categoryLabel = new JLabel());
        
        categoryLabel.setName("categoryLabel");
        categoryLabel.setText(_("tutti.splitSpeciesBatch.field.category"));
        categoryLabel.setToolTipText(_("tutti.splitSpeciesBatch.field.categoryField.tip"));
        categoryLabel.putClientProperty("help", "tutti.splitSpeciesBatch.field.categoryField.help");
    }

    protected void createConfigurationPanel() {
        $objectMap.put("configurationPanel", configurationPanel = new Table());
        
        configurationPanel.setName("configurationPanel");
    }

    protected void createHandler() {
        $objectMap.put("handler", handler = getContextValue(SplitSpeciesBatchUIHandler.class));
    }

    protected void createModel() {
        $objectMap.put("model", model = getContextValue(SplitSpeciesBatchUIModel.class));
    }

    protected void createSampleWeightField() {
        $objectMap.put("sampleWeightField", sampleWeightField = new JTextField());
        
        sampleWeightField.setName("sampleWeightField");
        sampleWeightField.setColumns(15);
        sampleWeightField.setEnabled(false);
        sampleWeightField.setEditable(false);
    }

    protected void createSampleWeightLabel() {
        $objectMap.put("sampleWeightLabel", sampleWeightLabel = new JLabel());
        
        sampleWeightLabel.setName("sampleWeightLabel");
        sampleWeightLabel.setText(_("tutti.splitSpeciesBatch.field.sampleWeight"));
        sampleWeightLabel.setToolTipText(_("tutti.splitSpeciesBatch.field.sampleWeightField.tip"));
        sampleWeightLabel.putClientProperty("help", "tutti.splitSpeciesBatch.field.sampleWeightField.help");
    }

    protected void createSaveButton() {
        $objectMap.put("saveButton", saveButton = new JButton());
        
        saveButton.setName("saveButton");
        saveButton.setText(_("tutti.splitSpeciesBatch.action.save"));
        saveButton.setToolTipText(_("tutti.splitSpeciesBatch.action.save.tip"));
        saveButton.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__saveButton"));
        saveButton.putClientProperty("help", "tutti.splitSpeciesBatch.action.save.help");
    }

    protected void createSpeciesField() {
        $objectMap.put("speciesField", speciesField = new JTextField());
        
        speciesField.setName("speciesField");
        speciesField.setColumns(15);
        speciesField.setEnabled(false);
        speciesField.setEditable(false);
    }

    protected void createSpeciesLabel() {
        $objectMap.put("speciesLabel", speciesLabel = new JLabel());
        
        speciesLabel.setName("speciesLabel");
        speciesLabel.setText(_("tutti.splitSpeciesBatch.field.species"));
        speciesLabel.setToolTipText(_("tutti.splitSpeciesBatch.field.speciesField.tip"));
        speciesLabel.putClientProperty("help", "tutti.splitSpeciesBatch.field.speciesField.help");
    }

    protected void createTable() {
        $objectMap.put("table", table = new JXTable());
        
        table.setName("table");
        table.setSortable(false);
    }

    protected void createTableScrollPane() {
        $objectMap.put("tableScrollPane", tableScrollPane = new JScrollPane());
        
        tableScrollPane.setName("tableScrollPane");
    }

    protected void createValidator() {
        $objectMap.put("validator", validator = SwingValidator.newValidator(SplitSpeciesBatchUIModel.class, null));
    }

    /*-----------------------------------------------------------------------*/
    /*------------------------ Internal jaxx methods ------------------------*/
    /*-----------------------------------------------------------------------*/

    private void $completeSetup() {
        allComponentsCreated = true;
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        addChildrenToSplitSpeciesBatchTopPanel();
        addChildrenToValidator();
        addChildrenToConfigurationPanel();
        addChildrenToTableScrollPane();
        addChildrenToActionPanel();
        
        // apply 6 data bindings
        JAXXUtil.applyDataBinding(this, $bindings.keySet());
        
        // apply 14 property setters
        configurationPanel.setBorder(new TitledBorder(null, null));
        categoryLabel.setLabelFor(categoryComboBox);
        speciesLabel.setLabelFor(speciesField);
        batchWeightLabel.setLabelFor(batchWeightField);
        sampleWeightLabel.setLabelFor(sampleWeightField);
        table.setSelectionMode(ListSelectionModel.SINGLE_SELECTION);
        table.setSelectionForeground(Color.BLACK);
        table.setSelectionBackground(null);
        cancelButton.setIcon(SwingUtil.createActionIcon("cancel"));
        cancelButton.setMnemonic(SwingUtil.getFirstCharAt(_("tutti.splitSpeciesBatch.action.cancel.mnemonic"),'Z'));
        saveButton.setIcon(SwingUtil.createActionIcon("save"));
        saveButton.setMnemonic(SwingUtil.getFirstCharAt(_("tutti.splitSpeciesBatch.action.save.mnemonic"),'Z'));
        // late initializer
        // help broker setup
        TuttiHelpBroker _broker = getBroker();
        registerHelpId(_broker, splitSpeciesBatchTopPanel, "tutti.splitSpeciesBatch.help");
        registerHelpId(_broker, categoryLabel, "tutti.splitSpeciesBatch.field.categoryField.help");
        registerHelpId(_broker, speciesLabel, "tutti.splitSpeciesBatch.field.speciesField.help");
        registerHelpId(_broker, batchWeightLabel, "tutti.splitSpeciesBatch.field.batchWeightField.help");
        registerHelpId(_broker, sampleWeightLabel, "tutti.splitSpeciesBatch.field.sampleWeightField.help");
        registerHelpId(_broker, cancelButton, "tutti.splitSpeciesBatch.action.cancel.help");
        registerHelpId(_broker, saveButton, "tutti.splitSpeciesBatch.action.save.help");
        _broker.prepareUI(this);
        // register 1 validator(s)
        validatorIds = SwingValidatorUtil.detectValidators(this);
        SwingValidatorUtil.installUI(this);
        
        $afterCompleteSetup();
    }

    private void $initialize() {
        if (allComponentsCreated) {
            return;
        }
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        $objectMap.put("splitSpeciesBatchTopPanel", splitSpeciesBatchTopPanel);
        createHandler();
        createModel();
        createValidator();
        createBroker();
        createConfigurationPanel();
        createCategoryLabel();
        createCategoryComboBox();
        // inline creation of $JSeparator0
        $objectMap.put("$JSeparator0", $JSeparator0 = new JSeparator());
        
        $JSeparator0.setName("$JSeparator0");
        createSpeciesLabel();
        createSpeciesField();
        createBatchWeightLabel();
        createBatchWeightField();
        createSampleWeightLabel();
        createSampleWeightField();
        createTableScrollPane();
        createTable();
        createActionPanel();
        createCancelButton();
        createSaveButton();
        // inline creation of splitSpeciesBatchTopPanel
        setName("splitSpeciesBatchTopPanel");
        setLayout(new BorderLayout());
        splitSpeciesBatchTopPanel.putClientProperty("help", "tutti.splitSpeciesBatch.help");
        
        // registers 6 data bindings
        $registerDefaultBindings();
        $completeSetup();
    }

    private void $registerDefaultBindings() {
        // register 6 data bindings
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_CATEGORY_COMBO_BOX_SELECTED_ITEM, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("selectedCategory", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    categoryComboBox.setSelectedItem(model.getSelectedCategory());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("selectedCategory", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_SPECIES_FIELD_TEXT, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("species", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    SwingUtil.setText(speciesField, handler.decorateSpecies(model.getSpecies()));
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("species", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_BATCH_WEIGHT_FIELD_TEXT, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("batchWeight", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    SwingUtil.setText(batchWeightField, getStringValue(model.getBatchWeight()));
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("batchWeight", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_SAMPLE_WEIGHT_FIELD_TEXT, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("sampleWeight", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    SwingUtil.setText(sampleWeightField, getStringValue(model.getSampleWeight()));
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("sampleWeight", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_TABLE_ENABLED, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("selectedCategory", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    table.setEnabled(model.getSelectedCategory() != null);
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("selectedCategory", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_SAVE_BUTTON_ENABLED, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("valid", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    saveButton.setEnabled(model.isValid());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("valid", this);
                }
            }
        });
    }

}