/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.exception;

import java.lang.reflect.Constructor;
import java.sql.SQLException;
import java.util.Properties;
import org.hibernate.HibernateException;
import org.hibernate.JDBCException;
import org.hibernate.dialect.Dialect;
import org.hibernate.exception.Configurable;
import org.hibernate.exception.GenericJDBCException;
import org.hibernate.exception.SQLExceptionConverter;
import org.hibernate.exception.ViolatedConstraintNameExtracter;
import org.hibernate.util.ReflectHelper;
import org.hibernate.util.StringHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SQLExceptionConverterFactory {
    private static final Logger log = LoggerFactory.getLogger(SQLExceptionConverterFactory.class);

    private SQLExceptionConverterFactory() {
    }

    public static SQLExceptionConverter buildSQLExceptionConverter(Dialect dialect, Properties properties) throws HibernateException {
        SQLExceptionConverter converter = null;
        String converterClassName = (String)properties.get("hibernate.jdbc.sql_exception_converter");
        if (StringHelper.isNotEmpty(converterClassName)) {
            converter = SQLExceptionConverterFactory.constructConverter(converterClassName, dialect.getViolatedConstraintNameExtracter());
        }
        if (converter == null) {
            log.trace("Using dialect defined converter");
            converter = dialect.buildSQLExceptionConverter();
        }
        if (converter instanceof Configurable) {
            try {
                ((Configurable)((Object)converter)).configure(properties);
            }
            catch (HibernateException e) {
                log.warn("Unable to configure SQLExceptionConverter", (Throwable)e);
                throw e;
            }
        }
        return converter;
    }

    public static SQLExceptionConverter buildMinimalSQLExceptionConverter() {
        return new SQLExceptionConverter(){

            public JDBCException convert(SQLException sqlException, String message, String sql) {
                return new GenericJDBCException(message, sqlException, sql);
            }
        };
    }

    private static SQLExceptionConverter constructConverter(String converterClassName, ViolatedConstraintNameExtracter violatedConstraintNameExtracter) {
        try {
            log.trace("Attempting to construct instance of specified SQLExceptionConverter [" + converterClassName + "]");
            Class converterClass = ReflectHelper.classForName(converterClassName);
            Constructor<?>[] ctors = converterClass.getDeclaredConstructors();
            for (int i = 0; i < ctors.length; ++i) {
                if (ctors[i].getParameterTypes() == null || ctors[i].getParameterTypes().length != 1 || !ViolatedConstraintNameExtracter.class.isAssignableFrom(ctors[i].getParameterTypes()[0])) continue;
                try {
                    return (SQLExceptionConverter)ctors[i].newInstance(violatedConstraintNameExtracter);
                }
                catch (Throwable t) {
                    // empty catch block
                }
            }
            return (SQLExceptionConverter)converterClass.newInstance();
        }
        catch (Throwable t) {
            log.warn("Unable to construct instance of specified SQLExceptionConverter", t);
            return null;
        }
    }
}

