/*
 * Decompiled with CFR 0.152.
 */
package org.andromda.cartridges.spring;

public class SpringHibernateUtils {
    private String hibernateVersion = "3";
    private String hibernateXmlPersistence;
    private String hibernateMappingStrategy;

    public void setHibernateVersion(String hibernateVersion) {
        this.hibernateVersion = hibernateVersion;
    }

    public String getBasePackage() {
        return this.isVersion3() ? "org.hibernate" : "net.sf.hibernate";
    }

    public String getCriterionPackage() {
        return this.getBasePackage() + (this.isVersion3() ? ".criterion" : ".expression");
    }

    public String getSpringHibernatePackage() {
        return this.isVersion3() ? "org.springframework.orm.hibernate3" : "org.springframework.orm.hibernate";
    }

    public String getEagerFetchMode() {
        return this.isVersion3() ? "JOIN" : "EAGER";
    }

    public String getDisjunctionClassName() {
        return this.getCriterionPackage() + (this.isVersion3() ? ".Restrictions" : ".Expression");
    }

    public boolean isVersion3() {
        return SpringHibernateUtils.isVersion3(this.hibernateVersion);
    }

    public static boolean isVersion3(String hibernateVersionPropertyValue) {
        return "3".equals(hibernateVersionPropertyValue);
    }

    public void setHibernateXMLPersistence(String hibernateXmlPersistence) {
        this.hibernateXmlPersistence = hibernateXmlPersistence;
    }

    public boolean isXmlPersistenceActive() {
        return SpringHibernateUtils.isXmlPersistenceActive(this.hibernateVersion, this.hibernateXmlPersistence);
    }

    public static boolean isXmlPersistenceActive(String hibernateVersionPropertyValue, String hibernateXMLPersistencePropertyValue) {
        return SpringHibernateUtils.isVersion3(hibernateVersionPropertyValue) && "true".equalsIgnoreCase(hibernateXMLPersistencePropertyValue);
    }

    public void setHibernateMappingStrategy(String hibernateMappingStrategy) {
        this.hibernateMappingStrategy = hibernateMappingStrategy;
    }

    public boolean isMapSubclassesInSeparateFile() {
        return SpringHibernateUtils.mapSubclassesInSeparateFile(this.hibernateMappingStrategy);
    }

    public static boolean mapSubclassesInSeparateFile(String hibernateMappingStrategy) {
        return "subclass".equalsIgnoreCase(hibernateMappingStrategy);
    }
}

