package fr.ifremer.tutti.ui.swing.content.operation.catches.benthos.create;

/*
 * #%L
 * Tutti :: UI
 * $Id:$
 * $HeadURL:$
 * %%
 * Copyright (C) 2012 - 2013 Ifremer
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 3 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-3.0.html>.
 * #L%
 */

import fr.ifremer.tutti.persistence.entities.referential.CaracteristicQualitativeValue;
import fr.ifremer.tutti.persistence.entities.referential.Species;
import fr.ifremer.tutti.ui.swing.TuttiHelpBroker;
import fr.ifremer.tutti.ui.swing.content.operation.catches.EditCatchesUI;
import fr.ifremer.tutti.ui.swing.util.TuttiUI;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.GridBagConstraints;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import jaxx.runtime.JAXXBinding;
import jaxx.runtime.JAXXContext;
import jaxx.runtime.JAXXObject;
import jaxx.runtime.JAXXObjectDescriptor;
import jaxx.runtime.JAXXUtil;
import jaxx.runtime.JAXXValidator;
import jaxx.runtime.SwingUtil;
import jaxx.runtime.binding.DefaultJAXXBinding;
import jaxx.runtime.binding.SimpleJAXXObjectBinding;
import jaxx.runtime.context.DefaultJAXXContext;
import jaxx.runtime.swing.Table;
import jaxx.runtime.swing.editor.NumberEditor;
import jaxx.runtime.swing.editor.bean.BeanFilterableComboBox;
import jaxx.runtime.swing.help.JAXXHelpUI;
import jaxx.runtime.validator.swing.SwingValidator;
import jaxx.runtime.validator.swing.SwingValidatorUtil;
import jaxx.runtime.validator.swing.meta.Validator;
import jaxx.runtime.validator.swing.meta.ValidatorField;
import jaxx.runtime.validator.swing.ui.ImageValidationUI;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jdesktop.swingx.JXTable;
import static jaxx.runtime.SwingUtil.getStringValue;
import static org.nuiton.i18n.I18n._;

public class CreateBenthosBatchUI extends JPanel implements JAXXHelpUI<TuttiHelpBroker>, TuttiUI<CreateBenthosBatchUIModel, CreateBenthosBatchUIHandler>, JAXXObject, JAXXValidator {

    /*-----------------------------------------------------------------------*/
    /*------------------ Constants for all public bindings ------------------*/
    /*-----------------------------------------------------------------------*/

    public static final String BINDING_BATCH_WEIGHT_FIELD_MODEL = "batchWeightField.model";
    public static final String BINDING_BATCH_WEIGHT_FIELD_NUMBER_PATTERN = "batchWeightField.numberPattern";
    public static final String BINDING_SAVE_BUTTON_ENABLED = "saveButton.enabled";
    public static final String BINDING_SORTED_UNSORTED_CATEGORY_COMBO_BOX_SELECTED_ITEM = "sortedUnsortedCategoryComboBox.selectedItem";
    public static final String BINDING_SPECIES_COMBO_BOX_DATA = "speciesComboBox.data";
    public static final String BINDING_SPECIES_COMBO_BOX_SELECTED_ITEM = "speciesComboBox.selectedItem";

    /*-----------------------------------------------------------------------*/
    /*------------------------- Other static fields -------------------------*/
    /*-----------------------------------------------------------------------*/

    private static final String $jaxxObjectDescriptor = "H4sIAAAAAAAAALVX3W/cRBDfXL4/StoEokBbSJOqSoHsFVWVqAKluTRHEiUhSq60Ioiwd97ktvhsY6+Ti05B/An8CfDOCxJvPCEeeOYBgRD8CQjxwCtiZu07f5x9dpEaKU68O/Ob2d/Mzoy//pMMOja59oQ1m9R2DSkanG6uPH78XvUJr8kH3KnZwpKmTbyfvgIpHJBxrbPuSLJwsIXqRV+9uGo2LNPgRkh7eYuMOfJM506dcynJ1ahGzXGK+53t5abl2m3UjlNJqF/+/VfhC+3zrwqENC3w7iIcZS5LKzjJwBYpCE2SKbB0woo6M47BDVsYx+DvBVxb1Znj7LAG/5R8Roa3yJDFbACTZD7/kRWG0m9akrxUszmTvASyddMpMVmrV0xrlxlcl+TRkU3Fkc0b3KbSlVJQV1DnFByiNdOQoENNi9tMCtOgNdTlDq16UNQDpqtd+A83LEs5MCTJcJ0Zms5tST56RrbWPQOBycGGqeHhPnxGBrcRPjA3esJ0oTGIgCSvRXKhs+Fb3cfn++3FAGGoapufIEU30z2u4Os62C0p2UB5Cs5yJI5d7xx+XGcjfvgIrKqrtBrt6E44Fq8J7myxKmpNYQY2ffFNtYiCsx35SV8esq9qlsymJHcSDHFN4JmrnBm0BI+y0CXQDNbbelHUi0zT9j3gEpwSQkOmI554qzGlKgbjERfHddnx9Gq6TFlwHW7ejXR/d9xGldtr6iWKc9mB2HLtoeH9XYWMODbtszSzLyeLhw8/F9UYub6pAncrHgO1GotZjRk1rgecLOBjqbM/5rAT3r1rk8uRo0MFpEEFDEpU3wEZtF1YhiQ66C6ae7DllcvZWLlEQLX778z0z9/9/m05XCNfSBQNlXioXZaNt1EKND3pFUhXCr24zazlAzLqcB36g6r/VxIc2/e3wTmwdwnVKarTdebUAWJw+Lfvf5j5+Kd+UiiTMd1kWpmh/AYZlXUbWDB1rWm9c195NHE6go7Db78kA5jIUMhaqqycA8PijTeNXZsfCbgAk9499Z0/o1APAOt0jzvYdgak7fImsHUlga2Oy9XRH/+Z3v/mfpuxPjjBi6niAWuDH5AhYejC4Kqv+C0jsY+MWw53NTNoDUnNgkC7mEm+sX69uauebyfRNMpcae6algsgxZZf9ekxl6uqPi3epMJZaYuE79rizfME0rDYwJKSbleFWymw+yAYRvTkAbfportrilL871084URYNONcfdBNDutQdSW51pr3Qt3dTylKzCdY69l9rQzbA1AXdCwxZewsl1qx2nuORPEm8HUj1a8jLHrUV5RkXJqmXhFWRam9mk+NSpguOiwUe7AQVUvnJNJ1sljoR3mV+VzbkLwhyfPeRcQc8LuGyqABaKoMBr1gd+WECR2TOCw20r6pcKN9P5J8jHe6pwvWXKt3CwhidyeLzUSceCjv/i+UaGTvZUc2GSU90L36Zhahha64L4Tinogbj+9MsvkkTzNa9tNFf6oVnzuCeGddupBmPMg0v2o0srczIxtWTQ9n18iVRctgMIvPBsErBSjexY331wuGKtC7TEITMpDPB2urG9srW7cPd1cqlbW9HYyz6/AytPGgX4QiPx7yNOskKkA5TpIZQBgn8EMiGGYhgw+V9IraAd2W18P9fUiWMIAnRWvYkOGAEzhlbBu8YRqiBkHMb5c2Olp5M6gbI3cGdav2yKD4pJ/FO35AcgNruIYt0Msh4ahvKC95vKhcz3IPh2KY3Ly3Dfz8IwPeWoznpTxIqQwv5tKOcLuUza1SSmc1NPHnz+P0ocE36n1mxDgbaq/GWCvmQ0vlLfNW+fq5Z5GoWo9ZJPw1lcUeTINDOjszQZg89xbOG3NVYWjwpXavC7sPn2M5EEew/FXOLDWp/5qM80omDi7/0QPh9VwIv/RAoIDwH+0IS0W9EwAA";
    private static final Log log = LogFactory.getLog(CreateBenthosBatchUI.class);
    private static final long serialVersionUID = 1L;

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Internal states ---------------------------*/
    /*-----------------------------------------------------------------------*/

    protected List<Object> $activeBindings = new ArrayList<Object>();
    protected Map<String, Object> $bindingSources = new HashMap<String, Object>();
    protected final Map<String, JAXXBinding> $bindings = new TreeMap<String, JAXXBinding>();
    protected Map<String, Object> $objectMap = new HashMap<String, Object>();
    protected Map<?, ?> $previousValues = new HashMap<Object, Object>();
    private boolean allComponentsCreated;
    protected final JAXXContext delegateContext = new DefaultJAXXContext();

    /*-----------------------------------------------------------------------*/
    /*------------------------ Protected components  ------------------------*/
    /*-----------------------------------------------------------------------*/

    protected JButton addSpeciesButton;
    @ValidatorField( validatorId = "validator",  propertyName = "batchWeight",  editorName = "batchWeightField")
    protected NumberEditor batchWeightField;
    protected JLabel batchWeightLabel;
    protected TuttiHelpBroker broker;
    protected JButton cancelButton;
    protected Table configurationPanel;
    protected CreateBenthosBatchUI createBenthosBatchTopPanel = this;
    protected CreateBenthosBatchUIHandler handler;
    protected CreateBenthosBatchUIModel model;
    protected JButton saveButton;
    @ValidatorField( validatorId = "validator",  propertyName = "sortedUnsortedCategory",  editorName = "sortedUnsortedCategoryComboBox")
    protected BeanFilterableComboBox<CaracteristicQualitativeValue> sortedUnsortedCategoryComboBox;
    protected JLabel sortedUnsortedCategoryLabel;
    @ValidatorField( validatorId = "validator",  propertyName = "species",  editorName = "speciesComboBox")
    protected BeanFilterableComboBox<Species> speciesComboBox;
    protected JLabel speciesLabel;
    @Validator( validatorId = "validator")
    protected SwingValidator<CreateBenthosBatchUIModel> validator;
    protected List<String> validatorIds = new ArrayList<String>();

    /*-----------------------------------------------------------------------*/
    /*------------------------- Private components  -------------------------*/
    /*-----------------------------------------------------------------------*/

    private JPanel $JPanel0;

    /*-----------------------------------------------------------------------*/
    /*---------------------- Raw body code from script ----------------------*/
    /*-----------------------------------------------------------------------*/
    
    
    protected void $afterCompleteSetup() { handler.afterInitUI(); }

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Constructors  ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public CreateBenthosBatchUI(EditCatchesUI parentUI) {
        JAXXUtil.initContext(this, parentUI);
            CreateBenthosBatchUIHandler handler = new CreateBenthosBatchUIHandler(parentUI, this);
            setContextValue(handler);
            handler.beforeInitUI();
            $initialize();
    }

    public CreateBenthosBatchUI(LayoutManager param0) {
        super(param0);
        $initialize();
    }

    public CreateBenthosBatchUI(JAXXContext parentContext, LayoutManager param1) {
        super(param1);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public CreateBenthosBatchUI(LayoutManager param0, boolean param1) {
        super(param0 ,param1);
        $initialize();
    }

    public CreateBenthosBatchUI(JAXXContext parentContext, LayoutManager param1, boolean param2) {
        super(param1 ,param2);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public CreateBenthosBatchUI(boolean param0) {
        super(param0);
        $initialize();
    }

    public CreateBenthosBatchUI(JAXXContext parentContext, boolean param1) {
        super(param1);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public CreateBenthosBatchUI() {
        $initialize();
    }

    public CreateBenthosBatchUI(JAXXContext parentContext) {
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Statics methods ---------------------------*/
    /*-----------------------------------------------------------------------*/

    public static JAXXObjectDescriptor $getJAXXObjectDescriptor() {
        return JAXXUtil.decodeCompressedJAXXObjectDescriptor($jaxxObjectDescriptor);
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------- JAXXObject implementation ----------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    public void applyDataBinding(String $binding) {
        if (allComponentsCreated && $bindings.containsKey($binding)) {
            getDataBinding($binding).applyDataBinding();
        }
        processDataBinding($binding);
    }

    @Override
    public void firePropertyChange(String propertyName, Object oldValue, Object newValue) {
        super.firePropertyChange(propertyName, oldValue, newValue);
    }

    @Override
    public Map<String, Object> get$objectMap() {
        return $objectMap;
    }

    @Override
    public JAXXBinding getDataBinding(String bindingId) {
        return $bindings.get(bindingId);
    }

    @Override
    public JAXXBinding[] getDataBindings() {
        return $bindings.values().toArray(new JAXXBinding[$bindings.size()]);
    }

    @Override
    public Object getObjectById(String id) {
        return $objectMap.get(id);
    }

    @Override
    public void processDataBinding(String $binding, boolean $force) {
        if (!$force && $activeBindings.contains($binding)) { 
            return;
        }
        $activeBindings.add($binding);
        try {
            if (allComponentsCreated && $bindings.containsKey($binding)) {
                getDataBinding($binding).processDataBinding();
            }
        } finally {
            $activeBindings.remove($binding);
        }
    }

    @Override
    public void processDataBinding(String $binding) {
        processDataBinding($binding, false);
    }

    @Override
    public void registerDataBinding(JAXXBinding binding) {
        $bindings.put(binding.getId(), binding);
    }

    @Override
    public void removeDataBinding(String $binding) {
        if (allComponentsCreated && $bindings.containsKey($binding)) {
            getDataBinding($binding).removeDataBinding();
        }
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- JAXXContext implementation  ---------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    public <T> T getContextValue(Class<T> clazz) {
        return delegateContext.getContextValue(clazz, null);
    }

    @Override
    public <T> T getContextValue(Class<T> clazz, String name) {
        return delegateContext.getContextValue(clazz, name);
    }

    @Override
    public JAXXContext getDelegateContext() {
        return delegateContext;
    }

    @Override
    public <O extends Container> O getParentContainer(Class<O> clazz) {
        return SwingUtil.getParentContainer(this, clazz);
    }

    @Override
    public <O extends Container> O getParentContainer(Object source, Class<O> clazz) {
        return SwingUtil.getParentContainer(source, clazz);
    }

    @Override
    public <T> void removeContextValue(Class<T> clazz) {
        delegateContext.removeContextValue(clazz, null);
    }

    @Override
    public <T> void removeContextValue(Class<T> clazz, String name) {
        delegateContext.removeContextValue(clazz, name);
    }

    @Override
    public <T> void setContextValue(T o) {
        delegateContext.setContextValue(o, null);
    }

    @Override
    public <T> void setContextValue(T o, String name) {
        delegateContext.setContextValue(o, name);
    }

    /*-----------------------------------------------------------------------*/
    /*-------------------- JAXXValidator implementation  --------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    public SwingValidator<?> getValidator(String validatorId) {
        return (SwingValidator<?>) (validatorIds.contains(validatorId) ? getObjectById(validatorId) : null);
    }

    @Override
    public List<String> getValidatorIds() {
        return validatorIds;
    }

    @Override
    public void registerValidatorFields() {
        SwingValidatorUtil.detectValidatorFields(this);
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Event methods ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public void doActionPerformed__on__cancelButton(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        handler.cancel();
    }

    public void doActionPerformed__on__saveButton(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        handler.save();
    }

    /*-----------------------------------------------------------------------*/
    /*----------------------- Public acessor methods  -----------------------*/
    /*-----------------------------------------------------------------------*/

    public JButton getAddSpeciesButton() {
        return addSpeciesButton;
    }

    public NumberEditor getBatchWeightField() {
        return batchWeightField;
    }

    public JLabel getBatchWeightLabel() {
        return batchWeightLabel;
    }

    public TuttiHelpBroker getBroker() {
        return broker;
    }

    public JButton getCancelButton() {
        return cancelButton;
    }

    public Table getConfigurationPanel() {
        return configurationPanel;
    }

    public CreateBenthosBatchUIHandler getHandler() {
        return handler;
    }

    public CreateBenthosBatchUIModel getModel() {
        return model;
    }

    public JButton getSaveButton() {
        return saveButton;
    }

    public BeanFilterableComboBox<CaracteristicQualitativeValue> getSortedUnsortedCategoryComboBox() {
        return sortedUnsortedCategoryComboBox;
    }

    public JLabel getSortedUnsortedCategoryLabel() {
        return sortedUnsortedCategoryLabel;
    }

    public BeanFilterableComboBox<Species> getSpeciesComboBox() {
        return speciesComboBox;
    }

    public JLabel getSpeciesLabel() {
        return speciesLabel;
    }

    public SwingValidator<CreateBenthosBatchUIModel> getValidator() {
        return validator;
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Other methods ----------------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    public void registerHelpId(TuttiHelpBroker broker, Component component, String helpId) {
        broker.installUI(component, helpId);
    }

    @Override
    public void showHelp(String helpId) {
        getBroker().showHelp(this, helpId);
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Protected acessors methods  ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected JPanel get$JPanel0() {
        return $JPanel0;
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Components creation methods ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected void addChildrenToConfigurationPanel() {
        if (!allComponentsCreated) {
            return;
        }
        configurationPanel.add(speciesLabel, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 1, new Insets(3, 3, 3, 3), 0, 0));
        configurationPanel.add(SwingUtil.boxComponentWithJxLayer(speciesComboBox), new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        configurationPanel.add(addSpeciesButton, new GridBagConstraints(2, 0, 1, 1, 0.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        configurationPanel.add(batchWeightLabel, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 17, 1, new Insets(3, 3, 3, 3), 0, 0));
        configurationPanel.add(SwingUtil.boxComponentWithJxLayer(batchWeightField), new GridBagConstraints(1, 1, 2, 1, 1.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        configurationPanel.add(sortedUnsortedCategoryLabel, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 17, 1, new Insets(3, 3, 3, 3), 0, 0));
        configurationPanel.add(SwingUtil.boxComponentWithJxLayer(sortedUnsortedCategoryComboBox), new GridBagConstraints(1, 2, 2, 1, 1.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
    }

    protected void addChildrenToCreateBenthosBatchTopPanel() {
        if (!allComponentsCreated) {
            return;
        }
        add(configurationPanel, BorderLayout.CENTER);
        add($JPanel0, BorderLayout.SOUTH);
    }

    protected void addChildrenToValidator() {
        if (!allComponentsCreated) {
            return;
        }
        validator.setUiClass(ImageValidationUI.class);
        validator.setBean(model);
    }

    protected void createAddSpeciesButton() {
        $objectMap.put("addSpeciesButton", addSpeciesButton = new JButton());
        
        addSpeciesButton.setName("addSpeciesButton");
        addSpeciesButton.setText(_("tutti.createBenthosBatch.action.addSpecies"));
        addSpeciesButton.setToolTipText(_("tutti.createBenthosBatch.action.addSpecies.tip"));
        addSpeciesButton.putClientProperty("help", "tutti.createBenthosBatch.action.addSpecies.help");
        addSpeciesButton.putClientProperty("tuttiAction", SelectSpeciesForBenthosBatchAction.class);
    }

    protected void createBatchWeightField() {
        $objectMap.put("batchWeightField", batchWeightField = new NumberEditor(this));
        
        batchWeightField.setName("batchWeightField");
        batchWeightField.setProperty("batchWeight");
        batchWeightField.setUseFloat(true);
        batchWeightField.setShowReset(true);
    }

    protected void createBatchWeightLabel() {
        $objectMap.put("batchWeightLabel", batchWeightLabel = new JLabel());
        
        batchWeightLabel.setName("batchWeightLabel");
        batchWeightLabel.setText(_("tutti.createBenthosBatch.field.batchWeight"));
        batchWeightLabel.setToolTipText(_("tutti.createBenthosBatch.field.batchWeight.tip"));
        batchWeightLabel.putClientProperty("help", "tutti.createBenthosBatch.field.batchWeight.help");
    }

    protected void createBroker() {
        $objectMap.put("broker", broker = new TuttiHelpBroker("tutti.createBenthosBatch.help"));
    }

    protected void createCancelButton() {
        $objectMap.put("cancelButton", cancelButton = new JButton());
        
        cancelButton.setName("cancelButton");
        cancelButton.setText(_("tutti.createBenthosBatch.action.cancel"));
        cancelButton.setToolTipText(_("tutti.createBenthosBatch.action.cancel.tip"));
        cancelButton.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__cancelButton"));
        cancelButton.putClientProperty("help", "tutti.createBenthosBatch.action.cancel.help");
    }

    protected void createConfigurationPanel() {
        $objectMap.put("configurationPanel", configurationPanel = new Table());
        
        configurationPanel.setName("configurationPanel");
    }

    protected void createHandler() {
        $objectMap.put("handler", handler = getContextValue(CreateBenthosBatchUIHandler.class));
    }

    protected void createModel() {
        $objectMap.put("model", model = getContextValue(CreateBenthosBatchUIModel.class));
    }

    protected void createSaveButton() {
        $objectMap.put("saveButton", saveButton = new JButton());
        
        saveButton.setName("saveButton");
        saveButton.setText(_("tutti.createBenthosBatch.action.save"));
        saveButton.setToolTipText(_("tutti.createBenthosBatch.action.save.tip"));
        saveButton.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__saveButton"));
        saveButton.putClientProperty("help", "tutti.createBenthosBatch.action.save.help");
    }

    protected void createSortedUnsortedCategoryComboBox() {
        $objectMap.put("sortedUnsortedCategoryComboBox", sortedUnsortedCategoryComboBox = new BeanFilterableComboBox<CaracteristicQualitativeValue>(this));
        
        sortedUnsortedCategoryComboBox.setName("sortedUnsortedCategoryComboBox");
        sortedUnsortedCategoryComboBox.setI18nPrefix("tutti.property.");
        sortedUnsortedCategoryComboBox.setProperty("sortedUnsortedCategory");
        sortedUnsortedCategoryComboBox.setShowReset(true);
    }

    protected void createSortedUnsortedCategoryLabel() {
        $objectMap.put("sortedUnsortedCategoryLabel", sortedUnsortedCategoryLabel = new JLabel());
        
        sortedUnsortedCategoryLabel.setName("sortedUnsortedCategoryLabel");
        sortedUnsortedCategoryLabel.setText(_("tutti.createBenthosBatch.field.sortedUnsortedCategory"));
        sortedUnsortedCategoryLabel.setToolTipText(_("tutti.createBenthosBatch.field.sortedUnsortedCategory.tip"));
        sortedUnsortedCategoryLabel.putClientProperty("help", "tutti.createBenthosBatch.field.sortedUnsortedCategory.help");
    }

    protected void createSpeciesComboBox() {
        $objectMap.put("speciesComboBox", speciesComboBox = new BeanFilterableComboBox<Species>(this));
        
        speciesComboBox.setName("speciesComboBox");
        speciesComboBox.setI18nPrefix("tutti.property.");
        speciesComboBox.setProperty("species");
        speciesComboBox.setShowReset(true);
    }

    protected void createSpeciesLabel() {
        $objectMap.put("speciesLabel", speciesLabel = new JLabel());
        
        speciesLabel.setName("speciesLabel");
        speciesLabel.setText(_("tutti.createBenthosBatch.field.species"));
        speciesLabel.setToolTipText(_("tutti.createBenthosBatch.field.species.tip"));
        speciesLabel.putClientProperty("help", "tutti.createBenthosBatch.field.species.help");
    }

    protected void createValidator() {
        $objectMap.put("validator", validator = SwingValidator.newValidator(CreateBenthosBatchUIModel.class, null));
    }

    /*-----------------------------------------------------------------------*/
    /*------------------------ Internal jaxx methods ------------------------*/
    /*-----------------------------------------------------------------------*/

    private void $completeSetup() {
        allComponentsCreated = true;
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        addChildrenToCreateBenthosBatchTopPanel();
        addChildrenToValidator();
        addChildrenToConfigurationPanel();
        // inline complete setup of $JPanel0
        $JPanel0.add(cancelButton);
        $JPanel0.add(saveButton);
        
        // apply 6 data bindings
        JAXXUtil.applyDataBinding(this, $bindings.keySet());
        
        // apply 17 property setters
        speciesComboBox.setBeanType(Species.class);
        sortedUnsortedCategoryComboBox.setBeanType(CaracteristicQualitativeValue.class);
        speciesLabel.setLabelFor(speciesComboBox);
        speciesComboBox.setBean(model);
        addSpeciesButton.setMnemonic(SwingUtil.getFirstCharAt(_("tutti.createBenthosBatch.action.addSpecies.mnemonic"),'Z'));
        batchWeightLabel.setLabelFor(batchWeightField);
        batchWeightField.setBean(model);
        batchWeightField.setAutoPopup(handler.getConfig().isAutoPopupNumberEditor());
        batchWeightField.setShowPopupButton(handler.getConfig().isShowNumberEditorButton());
        sortedUnsortedCategoryLabel.setLabelFor(sortedUnsortedCategoryComboBox);
        sortedUnsortedCategoryComboBox.setBean(model);
        cancelButton.setIcon(SwingUtil.createActionIcon("cancel"));
        cancelButton.setMnemonic(SwingUtil.getFirstCharAt(_("tutti.createBenthosBatch.action.cancel.mnemonic"),'Z'));
        saveButton.setIcon(SwingUtil.createActionIcon("save"));
        saveButton.setMnemonic(SwingUtil.getFirstCharAt(_("tutti.createBenthosBatch.action.save.mnemonic"),'Z'));
        // late initializer
        // help broker setup
        TuttiHelpBroker _broker = getBroker();
        registerHelpId(_broker, createBenthosBatchTopPanel, "tutti.createBenthosBatch.help");
        registerHelpId(_broker, speciesLabel, "tutti.createBenthosBatch.field.species.help");
        registerHelpId(_broker, addSpeciesButton, "tutti.createBenthosBatch.action.addSpecies.help");
        registerHelpId(_broker, batchWeightLabel, "tutti.createBenthosBatch.field.batchWeight.help");
        registerHelpId(_broker, sortedUnsortedCategoryLabel, "tutti.createBenthosBatch.field.sortedUnsortedCategory.help");
        registerHelpId(_broker, cancelButton, "tutti.createBenthosBatch.action.cancel.help");
        registerHelpId(_broker, saveButton, "tutti.createBenthosBatch.action.save.help");
        _broker.prepareUI(this);
        // register 1 validator(s)
        validatorIds = SwingValidatorUtil.detectValidators(this);
        SwingValidatorUtil.installUI(this);
        
        $afterCompleteSetup();
    }

    private void $initialize() {
        if (allComponentsCreated) {
            return;
        }
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        $objectMap.put("createBenthosBatchTopPanel", createBenthosBatchTopPanel);
        createHandler();
        createModel();
        createValidator();
        createBroker();
        createConfigurationPanel();
        createSpeciesLabel();
        createSpeciesComboBox();
        createAddSpeciesButton();
        createBatchWeightLabel();
        createBatchWeightField();
        createSortedUnsortedCategoryLabel();
        createSortedUnsortedCategoryComboBox();
        // inline creation of $JPanel0
        $objectMap.put("$JPanel0", $JPanel0 = new JPanel());
        
        $JPanel0.setName("$JPanel0");
        $JPanel0.setLayout(new GridLayout(1, 0));
        createCancelButton();
        createSaveButton();
        // inline creation of createBenthosBatchTopPanel
        setName("createBenthosBatchTopPanel");
        setLayout(new BorderLayout());
        createBenthosBatchTopPanel.putClientProperty("help", "tutti.createBenthosBatch.help");
        
        // registers 6 data bindings
        $registerDefaultBindings();
        $completeSetup();
    }

    private void $registerDefaultBindings() {
        // register 6 data bindings
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_SPECIES_COMBO_BOX_SELECTED_ITEM, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("species", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    speciesComboBox.setSelectedItem(model.getSpecies());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("species", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_SPECIES_COMBO_BOX_DATA, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("availableSpecies", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    speciesComboBox.setData(model.getAvailableSpecies());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("availableSpecies", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_BATCH_WEIGHT_FIELD_MODEL, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("batchWeight", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    batchWeightField.setModel(model.getBatchWeight());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("batchWeight", this);
                }
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_BATCH_WEIGHT_FIELD_NUMBER_PATTERN, true ,"DECIMAL3_PATTERN") {
        
            @Override
            public void processDataBinding() {
                batchWeightField.setNumberPattern(DECIMAL3_PATTERN);
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_SORTED_UNSORTED_CATEGORY_COMBO_BOX_SELECTED_ITEM, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("sortedUnsortedCategory", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    sortedUnsortedCategoryComboBox.setSelectedItem(model.getSortedUnsortedCategory());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("sortedUnsortedCategory", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_SAVE_BUTTON_ENABLED, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("valid", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    saveButton.setEnabled(model.isValid());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("valid", this);
                }
            }
        });
    }

}