package fr.ifremer.tutti.ui.swing.content.operation.catches.marinelitter;

/*
 * #%L
 * Tutti :: UI
 * $Id:$
 * $HeadURL:$
 * %%
 * Copyright (C) 2012 - 2013 Ifremer
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 3 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-3.0.html>.
 * #L%
 */

import fr.ifremer.tutti.ui.swing.TuttiHelpBroker;
import fr.ifremer.tutti.ui.swing.TuttiUIContext;
import fr.ifremer.tutti.ui.swing.util.TuttiUI;
import fr.ifremer.tutti.ui.swing.util.editor.TuttiComputedOrNotDataEditor;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.GridBagConstraints;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JToolBar;
import javax.swing.ListSelectionModel;
import jaxx.runtime.JAXXBinding;
import jaxx.runtime.JAXXContext;
import jaxx.runtime.JAXXObject;
import jaxx.runtime.JAXXObjectDescriptor;
import jaxx.runtime.JAXXUtil;
import jaxx.runtime.JAXXValidator;
import jaxx.runtime.SwingUtil;
import jaxx.runtime.binding.DefaultJAXXBinding;
import jaxx.runtime.binding.SimpleJAXXObjectBinding;
import jaxx.runtime.context.DefaultJAXXContext;
import jaxx.runtime.swing.Table;
import jaxx.runtime.swing.help.JAXXHelpUI;
import jaxx.runtime.validator.swing.SwingValidator;
import jaxx.runtime.validator.swing.SwingValidatorUtil;
import jaxx.runtime.validator.swing.meta.Validator;
import jaxx.runtime.validator.swing.meta.ValidatorField;
import jaxx.runtime.validator.swing.ui.ImageValidationUI;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jdesktop.swingx.JXTable;
import static org.nuiton.i18n.I18n._;

public class MarineLitterBatchUI extends JPanel implements JAXXHelpUI<TuttiHelpBroker>, TuttiUI<MarineLitterBatchUIModel, MarineLitterBatchUIHandler>, JAXXObject, JAXXValidator {

    /*-----------------------------------------------------------------------*/
    /*------------------ Constants for all public bindings ------------------*/
    /*-----------------------------------------------------------------------*/

    public static final String BINDING_MARINE_LITTER_TOTAL_WEIGHT_FIELD_BEAN = "marineLitterTotalWeightField.bean";
    public static final String BINDING_MARINE_LITTER_TOTAL_WEIGHT_FIELD_MODEL = "marineLitterTotalWeightField.model";
    public static final String BINDING_MARINE_LITTER_TOTAL_WEIGHT_FIELD_NUMBER_PATTERN = "marineLitterTotalWeightField.numberPattern";
    public static final String BINDING_REMOVE_MARINE_LITTER_BATCH_MENU_ENABLED = "removeMarineLitterBatchMenu.enabled";

    /*-----------------------------------------------------------------------*/
    /*------------------------- Other static fields -------------------------*/
    /*-----------------------------------------------------------------------*/

    private static final String $jaxxObjectDescriptor = "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";
    private static final Log log = LogFactory.getLog(MarineLitterBatchUI.class);
    private static final long serialVersionUID = 1L;

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Internal states ---------------------------*/
    /*-----------------------------------------------------------------------*/

    protected List<Object> $activeBindings = new ArrayList<Object>();
    protected Map<String, Object> $bindingSources = new HashMap<String, Object>();
    protected final Map<String, JAXXBinding> $bindings = new TreeMap<String, JAXXBinding>();
    protected Map<String, Object> $objectMap = new HashMap<String, Object>();
    protected Map<?, ?> $previousValues = new HashMap<Object, Object>();
    private boolean allComponentsCreated;
    protected final JAXXContext delegateContext = new DefaultJAXXContext();

    /*-----------------------------------------------------------------------*/
    /*------------------------ Protected components  ------------------------*/
    /*-----------------------------------------------------------------------*/

    protected TuttiHelpBroker broker;
    protected JButton createMarineLitterBatchButton;
    protected MarineLitterBatchUI editMarineLitterBatchTopPanel = this;
    protected JButton exportMultiPostButton;
    protected Table form;
    protected MarineLitterBatchUIHandler handler;
    protected JButton importMultiPostButton;
    protected JToolBar marineLitterBatchTabToolBar;
    @ValidatorField( validatorId = "validator",  propertyName = "marineLitterTotalWeight",  editorName = "marineLitterTotalWeightField")
    protected TuttiComputedOrNotDataEditor marineLitterTotalWeightField;
    protected JLabel marineLitterTotalWeightLabel;
    protected MarineLitterBatchUIModel model;
    protected JMenuItem removeMarineLitterBatchMenu;
    protected JXTable table;
    protected JPopupMenu tablePopup;
    protected JScrollPane tableScrollPane;
    protected JPanel tableToolbar;
    @Validator( validatorId = "validator")
    protected SwingValidator<MarineLitterBatchUIModel> validator;
    protected List<String> validatorIds = new ArrayList<String>();

    /*-----------------------------------------------------------------------*/
    /*------------------------- Private components  -------------------------*/
    /*-----------------------------------------------------------------------*/

    private JPanel $JPanel0;

    /*-----------------------------------------------------------------------*/
    /*---------------------- Raw body code from script ----------------------*/
    /*-----------------------------------------------------------------------*/
    
    
    protected void $afterCompleteSetup() { handler.afterInitUI(); }

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Constructors  ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public MarineLitterBatchUI(TuttiUI parentUI) {
        JAXXUtil.initContext(this, parentUI);
            MarineLitterBatchUIHandler handler = new MarineLitterBatchUIHandler(parentUI, this);
            setContextValue(handler);
            handler.beforeInitUI();
            $initialize();
    }

    public MarineLitterBatchUI() {
        $initialize();
    }

    public MarineLitterBatchUI(JAXXContext parentContext) {
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public MarineLitterBatchUI(boolean param0) {
        super(param0);
        $initialize();
    }

    public MarineLitterBatchUI(JAXXContext parentContext, boolean param1) {
        super(param1);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public MarineLitterBatchUI(LayoutManager param0) {
        super(param0);
        $initialize();
    }

    public MarineLitterBatchUI(JAXXContext parentContext, LayoutManager param1) {
        super(param1);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public MarineLitterBatchUI(LayoutManager param0, boolean param1) {
        super(param0 ,param1);
        $initialize();
    }

    public MarineLitterBatchUI(JAXXContext parentContext, LayoutManager param1, boolean param2) {
        super(param1 ,param2);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Statics methods ---------------------------*/
    /*-----------------------------------------------------------------------*/

    public static JAXXObjectDescriptor $getJAXXObjectDescriptor() {
        return JAXXUtil.decodeCompressedJAXXObjectDescriptor($jaxxObjectDescriptor);
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------- JAXXObject implementation ----------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    public void applyDataBinding(String $binding) {
        if (allComponentsCreated && $bindings.containsKey($binding)) {
            getDataBinding($binding).applyDataBinding();
        }
        processDataBinding($binding);
    }

    @Override
    public void firePropertyChange(String propertyName, Object oldValue, Object newValue) {
        super.firePropertyChange(propertyName, oldValue, newValue);
    }

    @Override
    public Map<String, Object> get$objectMap() {
        return $objectMap;
    }

    @Override
    public JAXXBinding getDataBinding(String bindingId) {
        return $bindings.get(bindingId);
    }

    @Override
    public JAXXBinding[] getDataBindings() {
        return $bindings.values().toArray(new JAXXBinding[$bindings.size()]);
    }

    @Override
    public Object getObjectById(String id) {
        return $objectMap.get(id);
    }

    @Override
    public void processDataBinding(String $binding, boolean $force) {
        if (!$force && $activeBindings.contains($binding)) { 
            return;
        }
        $activeBindings.add($binding);
        try {
            if (allComponentsCreated && $bindings.containsKey($binding)) {
                getDataBinding($binding).processDataBinding();
            }
        } finally {
            $activeBindings.remove($binding);
        }
    }

    @Override
    public void processDataBinding(String $binding) {
        processDataBinding($binding, false);
    }

    @Override
    public void registerDataBinding(JAXXBinding binding) {
        $bindings.put(binding.getId(), binding);
    }

    @Override
    public void removeDataBinding(String $binding) {
        if (allComponentsCreated && $bindings.containsKey($binding)) {
            getDataBinding($binding).removeDataBinding();
        }
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- JAXXContext implementation  ---------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    public <T> T getContextValue(Class<T> clazz) {
        return delegateContext.getContextValue(clazz, null);
    }

    @Override
    public <T> T getContextValue(Class<T> clazz, String name) {
        return delegateContext.getContextValue(clazz, name);
    }

    @Override
    public JAXXContext getDelegateContext() {
        return delegateContext;
    }

    @Override
    public <O extends Container> O getParentContainer(Class<O> clazz) {
        return SwingUtil.getParentContainer(this, clazz);
    }

    @Override
    public <O extends Container> O getParentContainer(Object source, Class<O> clazz) {
        return SwingUtil.getParentContainer(source, clazz);
    }

    @Override
    public <T> void removeContextValue(Class<T> clazz) {
        delegateContext.removeContextValue(clazz, null);
    }

    @Override
    public <T> void removeContextValue(Class<T> clazz, String name) {
        delegateContext.removeContextValue(clazz, name);
    }

    @Override
    public <T> void setContextValue(T o) {
        delegateContext.setContextValue(o, null);
    }

    @Override
    public <T> void setContextValue(T o, String name) {
        delegateContext.setContextValue(o, name);
    }

    /*-----------------------------------------------------------------------*/
    /*-------------------- JAXXValidator implementation  --------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    public SwingValidator<?> getValidator(String validatorId) {
        return (SwingValidator<?>) (validatorIds.contains(validatorId) ? getObjectById(validatorId) : null);
    }

    @Override
    public List<String> getValidatorIds() {
        return validatorIds;
    }

    @Override
    public void registerValidatorFields() {
        SwingValidatorUtil.detectValidatorFields(this);
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Event methods ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public void doActionPerformed__on__createMarineLitterBatchButton(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        handler.createBatch();
    }

    public void doKeyPressed__on__table(KeyEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        handler.openRowMenu(event, tablePopup);
    }

    public void doMouseClicked__on__table(MouseEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        handler.autoSelectRowInTable(event, tablePopup);
    }

    /*-----------------------------------------------------------------------*/
    /*----------------------- Public acessor methods  -----------------------*/
    /*-----------------------------------------------------------------------*/

    public TuttiHelpBroker getBroker() {
        return broker;
    }

    public JButton getCreateMarineLitterBatchButton() {
        return createMarineLitterBatchButton;
    }

    public JButton getExportMultiPostButton() {
        return exportMultiPostButton;
    }

    public Table getForm() {
        return form;
    }

    public MarineLitterBatchUIHandler getHandler() {
        return handler;
    }

    public JButton getImportMultiPostButton() {
        return importMultiPostButton;
    }

    public JToolBar getMarineLitterBatchTabToolBar() {
        return marineLitterBatchTabToolBar;
    }

    public TuttiComputedOrNotDataEditor getMarineLitterTotalWeightField() {
        return marineLitterTotalWeightField;
    }

    public JLabel getMarineLitterTotalWeightLabel() {
        return marineLitterTotalWeightLabel;
    }

    public MarineLitterBatchUIModel getModel() {
        return model;
    }

    public JMenuItem getRemoveMarineLitterBatchMenu() {
        return removeMarineLitterBatchMenu;
    }

    public JXTable getTable() {
        return table;
    }

    public JPopupMenu getTablePopup() {
        return tablePopup;
    }

    public JScrollPane getTableScrollPane() {
        return tableScrollPane;
    }

    public JPanel getTableToolbar() {
        return tableToolbar;
    }

    public SwingValidator<MarineLitterBatchUIModel> getValidator() {
        return validator;
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Other methods ----------------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    public void registerHelpId(TuttiHelpBroker broker, Component component, String helpId) {
        broker.installUI(component, helpId);
    }

    @Override
    public void showHelp(String helpId) {
        getBroker().showHelp(this, helpId);
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Protected acessors methods  ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected JPanel get$JPanel0() {
        return $JPanel0;
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Components creation methods ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected void addChildrenToEditMarineLitterBatchTopPanel() {
        if (!allComponentsCreated) {
            return;
        }
        add(marineLitterBatchTabToolBar);
        add(form, BorderLayout.NORTH);
        add(tableScrollPane, BorderLayout.CENTER);
    }

    protected void addChildrenToForm() {
        if (!allComponentsCreated) {
            return;
        }
        form.add(marineLitterTotalWeightLabel, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 1, new Insets(3, 3, 3, 3), 0, 0));
        form.add(SwingUtil.boxComponentWithJxLayer(marineLitterTotalWeightField), new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        form.add(tableToolbar, new GridBagConstraints(0, 1, 2, 1, 0.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
    }

    protected void addChildrenToMarineLitterBatchTabToolBar() {
        if (!allComponentsCreated) {
            return;
        }
        marineLitterBatchTabToolBar.add(importMultiPostButton);
        marineLitterBatchTabToolBar.add(exportMultiPostButton);
    }

    protected void addChildrenToTablePopup() {
        if (!allComponentsCreated) {
            return;
        }
        tablePopup.add(removeMarineLitterBatchMenu);
    }

    protected void addChildrenToTableScrollPane() {
        if (!allComponentsCreated) {
            return;
        }
        tableScrollPane.getViewport().add(table);
    }

    protected void addChildrenToTableToolbar() {
        if (!allComponentsCreated) {
            return;
        }
        tableToolbar.add($JPanel0, BorderLayout.WEST);
    }

    protected void addChildrenToValidator() {
        if (!allComponentsCreated) {
            return;
        }
        validator.setUiClass(ImageValidationUI.class);
        validator.setBean(model);
    }

    protected void createBroker() {
        $objectMap.put("broker", broker = new TuttiHelpBroker("tutti.editMarineLitterBatch.help"));
    }

    protected void createCreateMarineLitterBatchButton() {
        $objectMap.put("createMarineLitterBatchButton", createMarineLitterBatchButton = new JButton());
        
        createMarineLitterBatchButton.setName("createMarineLitterBatchButton");
        createMarineLitterBatchButton.setText(_("tutti.editMarineLitterBatch.action.createBatch"));
        createMarineLitterBatchButton.setToolTipText(_("tutti.editMarineLitterBatch.action.createBatch.tip"));
        createMarineLitterBatchButton.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__createMarineLitterBatchButton"));
        createMarineLitterBatchButton.putClientProperty("help", "tutti.editMarineLitterBatch.action.createBatch.help");
    }

    protected void createExportMultiPostButton() {
        $objectMap.put("exportMultiPostButton", exportMultiPostButton = new JButton());
        
        exportMultiPostButton.setName("exportMultiPostButton");
        exportMultiPostButton.setText(_("tutti.editMarineLitterBatch.action.exportMultiPost"));
        exportMultiPostButton.setToolTipText(_("tutti.editMarineLitterBatch.action.exportMultiPost.tip"));
        exportMultiPostButton.putClientProperty("help", "tutti.editMarineLitterBatch.action.exportMultiPost.help");
        exportMultiPostButton.putClientProperty("tuttiAction", ExportMultiPostAction.class);
    }

    protected void createForm() {
        $objectMap.put("form", form = new Table());
        
        form.setName("form");
    }

    protected void createHandler() {
        $objectMap.put("handler", handler = getContextValue(MarineLitterBatchUIHandler.class));
    }

    protected void createImportMultiPostButton() {
        $objectMap.put("importMultiPostButton", importMultiPostButton = new JButton());
        
        importMultiPostButton.setName("importMultiPostButton");
        importMultiPostButton.setText(_("tutti.editMarineLitterBatch.action.importMultiPost"));
        importMultiPostButton.setToolTipText(_("tutti.editMarineLitterBatch.action.importMultiPost.tip"));
        importMultiPostButton.putClientProperty("help", "tutti.editMarineLitterBatch.action.importMultiPost.help");
        importMultiPostButton.putClientProperty("tuttiAction", ImportMultiPostAction.class);
    }

    protected void createMarineLitterBatchTabToolBar() {
        $objectMap.put("marineLitterBatchTabToolBar", marineLitterBatchTabToolBar = new JToolBar());
        
        marineLitterBatchTabToolBar.setName("marineLitterBatchTabToolBar");
        marineLitterBatchTabToolBar.setFloatable(false);
        marineLitterBatchTabToolBar.setOpaque(false);
        marineLitterBatchTabToolBar.setBorderPainted(false);
    }

    protected void createMarineLitterTotalWeightField() {
        $objectMap.put("marineLitterTotalWeightField", marineLitterTotalWeightField = new TuttiComputedOrNotDataEditor(this));
        
        marineLitterTotalWeightField.setName("marineLitterTotalWeightField");
        marineLitterTotalWeightField.setDecimalNumber(3);
        marineLitterTotalWeightField.setUseFloat(true);
        marineLitterTotalWeightField.setShowReset(true);
    }

    protected void createMarineLitterTotalWeightLabel() {
        $objectMap.put("marineLitterTotalWeightLabel", marineLitterTotalWeightLabel = new JLabel());
        
        marineLitterTotalWeightLabel.setName("marineLitterTotalWeightLabel");
        marineLitterTotalWeightLabel.setText(_("tutti.editMarineLitterBatch.field.marineLitterTotalWeight"));
        marineLitterTotalWeightLabel.setToolTipText(_("tutti.editMarineLitterBatch.field.marineLitterTotalWeight.tip"));
        marineLitterTotalWeightLabel.putClientProperty("help", "tutti.editMarineLitterBatch.field.marineLitterTotalWeight.help");
    }

    protected void createModel() {
        $objectMap.put("model", model = getContextValue(MarineLitterBatchUIModel.class));
    }

    protected void createRemoveMarineLitterBatchMenu() {
        $objectMap.put("removeMarineLitterBatchMenu", removeMarineLitterBatchMenu = new JMenuItem());
        
        removeMarineLitterBatchMenu.setName("removeMarineLitterBatchMenu");
        removeMarineLitterBatchMenu.setText(_("tutti.editMarineLitterBatch.action.removeBatch"));
        removeMarineLitterBatchMenu.setToolTipText(_("tutti.editMarineLitterBatch.action.removeBatch.tip"));
        removeMarineLitterBatchMenu.putClientProperty("help", "tutti.editMarineLitterBatch.action.removeBatch.help");
        removeMarineLitterBatchMenu.putClientProperty("tuttiAction", RemoveMarineLitterBatchAction.class);
    }

    protected void createTable() {
        $objectMap.put("table", table = new JXTable());
        
        table.setName("table");
        table.setSortable(false);
        table.addKeyListener(JAXXUtil.getEventListener(KeyListener.class, "keyPressed", this, "doKeyPressed__on__table"));
        table.addMouseListener(JAXXUtil.getEventListener(MouseListener.class, "mouseClicked", this, "doMouseClicked__on__table"));
    }

    protected void createTablePopup() {
        $objectMap.put("tablePopup", tablePopup = new JPopupMenu());
        
        tablePopup.setName("tablePopup");
        tablePopup.setLabel("tutti.editMarineLitterBatch.title.batchActions");
    }

    protected void createTableScrollPane() {
        $objectMap.put("tableScrollPane", tableScrollPane = new JScrollPane());
        
        tableScrollPane.setName("tableScrollPane");
    }

    protected void createTableToolbar() {
        $objectMap.put("tableToolbar", tableToolbar = new JPanel());
        
        tableToolbar.setName("tableToolbar");
        tableToolbar.setLayout(new BorderLayout());
    }

    protected void createValidator() {
        $objectMap.put("validator", validator = SwingValidator.newValidator(MarineLitterBatchUIModel.class, null));
    }

    /*-----------------------------------------------------------------------*/
    /*------------------------ Internal jaxx methods ------------------------*/
    /*-----------------------------------------------------------------------*/

    private void $completeSetup() {
        allComponentsCreated = true;
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        addChildrenToEditMarineLitterBatchTopPanel();
        addChildrenToValidator();
        addChildrenToMarineLitterBatchTabToolBar();
        addChildrenToTablePopup();
        addChildrenToForm();
        addChildrenToTableToolbar();
        // inline complete setup of $JPanel0
        $JPanel0.add(createMarineLitterBatchButton);
        addChildrenToTableScrollPane();
        
        // apply 4 data bindings
        JAXXUtil.applyDataBinding(this, $bindings.keySet());
        
        // apply 18 property setters
        importMultiPostButton.setIcon(SwingUtil.createActionIcon("import"));
        importMultiPostButton.setMnemonic(SwingUtil.getFirstCharAt(_("tutti.editMarineLitterBatch.action.importMultiPost.mnemonic"),'Z'));
        exportMultiPostButton.setIcon(SwingUtil.createActionIcon("export"));
        exportMultiPostButton.setMnemonic(SwingUtil.getFirstCharAt(_("tutti.editMarineLitterBatch.action.exportMultiPost.mnemonic"),'Z'));
        removeMarineLitterBatchMenu.setIcon(SwingUtil.createActionIcon("batch-delete"));
        removeMarineLitterBatchMenu.setMnemonic(SwingUtil.getFirstCharAt(_("tutti.editMarineLitterBatch.action.removeBatch.mnemonic"),'Z'));
        marineLitterTotalWeightLabel.setLabelFor(marineLitterTotalWeightField);
        marineLitterTotalWeightField.setAutoPopup(handler.getConfig().isAutoPopupNumberEditor());
        marineLitterTotalWeightField.setComputedDataColor(handler.getConfig().getColorComputedWeights());
        marineLitterTotalWeightField.setShowPopupButton(handler.getConfig().isShowNumberEditorButton());
        createMarineLitterBatchButton.setIcon(SwingUtil.createActionIcon("batch-create"));
        createMarineLitterBatchButton.setMnemonic(SwingUtil.getFirstCharAt(_("tutti.editMarineLitterBatch.action.createBatch.mnemonic"),'Z'));
        table.setSelectionMode(ListSelectionModel.SINGLE_SELECTION);
        table.setSelectionForeground(Color.BLACK);
        table.setSelectionBackground(null);
        // late initializer
        // help broker setup
        TuttiHelpBroker _broker = getBroker();
        registerHelpId(_broker, editMarineLitterBatchTopPanel, "tutti.editMarineLitterBatch.help");
        registerHelpId(_broker, importMultiPostButton, "tutti.editMarineLitterBatch.action.importMultiPost.help");
        registerHelpId(_broker, exportMultiPostButton, "tutti.editMarineLitterBatch.action.exportMultiPost.help");
        registerHelpId(_broker, removeMarineLitterBatchMenu, "tutti.editMarineLitterBatch.action.removeBatch.help");
        registerHelpId(_broker, marineLitterTotalWeightLabel, "tutti.editMarineLitterBatch.field.marineLitterTotalWeight.help");
        registerHelpId(_broker, createMarineLitterBatchButton, "tutti.editMarineLitterBatch.action.createBatch.help");
        _broker.prepareUI(this);
        // register 1 validator(s)
        validatorIds = SwingValidatorUtil.detectValidators(this);
        SwingValidatorUtil.installUI(this);
        
        $afterCompleteSetup();
    }

    private void $initialize() {
        if (allComponentsCreated) {
            return;
        }
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        $objectMap.put("editMarineLitterBatchTopPanel", editMarineLitterBatchTopPanel);
        createHandler();
        createModel();
        createValidator();
        createBroker();
        createMarineLitterBatchTabToolBar();
        createImportMultiPostButton();
        createExportMultiPostButton();
        createTablePopup();
        createRemoveMarineLitterBatchMenu();
        createForm();
        createMarineLitterTotalWeightLabel();
        createMarineLitterTotalWeightField();
        createTableToolbar();
        // inline creation of $JPanel0
        $objectMap.put("$JPanel0", $JPanel0 = new JPanel());
        
        $JPanel0.setName("$JPanel0");
        $JPanel0.setLayout(new GridLayout(1,0));
        createCreateMarineLitterBatchButton();
        createTableScrollPane();
        createTable();
        // inline creation of editMarineLitterBatchTopPanel
        setName("editMarineLitterBatchTopPanel");
        setLayout(new BorderLayout());
        editMarineLitterBatchTopPanel.putClientProperty("help", "tutti.editMarineLitterBatch.help");
        
        // registers 4 data bindings
        $registerDefaultBindings();
        $completeSetup();
    }

    private void $registerDefaultBindings() {
        // register 4 data bindings
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_REMOVE_MARINE_LITTER_BATCH_MENU_ENABLED, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("removeBatchEnabled", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    removeMarineLitterBatchMenu.setEnabled(model.isRemoveBatchEnabled());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("removeBatchEnabled", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_MARINE_LITTER_TOTAL_WEIGHT_FIELD_MODEL, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("marineLitterTotalWeight", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    marineLitterTotalWeightField.setModel(model.getMarineLitterTotalWeight());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("marineLitterTotalWeight", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_MARINE_LITTER_TOTAL_WEIGHT_FIELD_BEAN, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("marineLitterTotalComputedOrNotWeight", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    marineLitterTotalWeightField.setBean(model.getMarineLitterTotalComputedOrNotWeight());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("marineLitterTotalComputedOrNotWeight", this);
                }
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_MARINE_LITTER_TOTAL_WEIGHT_FIELD_NUMBER_PATTERN, true ,"DECIMAL3_PATTERN") {
        
            @Override
            public void processDataBinding() {
                marineLitterTotalWeightField.setNumberPattern(DECIMAL3_PATTERN);
            }
        });
    }

}