package fr.ifremer.tutti.ui.swing.content.operation.catches.benthos.frequency;

/*
 * #%L
 * Tutti :: UI
 * $Id: BenthosFrequencyRowModel.java 935 2013-05-11 15:53:26Z tchemit $
 * $HeadURL: http://svn.forge.codelutin.com/svn/tutti/tags/tutti-2.3.2/tutti-ui-swing/src/main/java/fr/ifremer/tutti/ui/swing/content/operation/catches/benthos/frequency/BenthosFrequencyRowModel.java $
 * %%
 * Copyright (C) 2012 Ifremer
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 3 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-3.0.html>.
 * #L%
 */

import com.google.common.collect.Lists;
import com.google.common.collect.Ordering;
import fr.ifremer.tutti.persistence.entities.TuttiBeanFactory;
import fr.ifremer.tutti.persistence.entities.data.BenthosBatch;
import fr.ifremer.tutti.persistence.entities.data.BenthosBatchFrequency;
import fr.ifremer.tutti.persistence.entities.referential.Caracteristic;
import fr.ifremer.tutti.ui.swing.util.AbstractTuttiBeanUIModel;
import org.nuiton.util.beans.Binder;
import org.nuiton.util.beans.BinderFactory;

import java.util.List;

/**
 * Represents a batch frequency row.
 *
 * @author tchemit <chemit@codelutin.com>
 * @since 0.2
 */
public class BenthosFrequencyRowModel extends AbstractTuttiBeanUIModel<BenthosBatchFrequency, BenthosFrequencyRowModel> implements Comparable<BenthosFrequencyRowModel>, BenthosBatchFrequency {

    private static final long serialVersionUID = 1L;

    public static final String PROPERTY_LENGTH_STEP = "lengthStep";

    public static final String PROPERTY_NUMBER = "number";

    public static final String PROPERTY_WEIGHT = "weight";

    public static final String PROPERTY_LENGHT_STEP_CARACTERISTIC = "lengthStepCaracteristic";

    /**
     * Length step.
     *
     * @since 0.2
     */
    protected Float lengthStep;

    /**
     * Count of fishes for this lengthStep.
     *
     * @since 0.2
     */
    protected Integer number;

    /**
     * Weight of fishes observed.
     *
     * @since 0.2
     */
    protected Float weight;

    /**
     * Length step caracteristic.
     *
     * @since 0.3
     */
    protected Caracteristic lengthStepCaracteristic;

    protected static final Binder<BenthosBatchFrequency, BenthosFrequencyRowModel> fromBeanBinder =
            BinderFactory.newBinder(BenthosBatchFrequency.class,
                                    BenthosFrequencyRowModel.class);

    protected static final Binder<BenthosFrequencyRowModel, BenthosBatchFrequency> toBeanBinder =
            BinderFactory.newBinder(BenthosFrequencyRowModel.class,
                                    BenthosBatchFrequency.class);

    private static final Ordering<Float> ordering = Ordering.natural().nullsFirst();

    public static List<BenthosFrequencyRowModel> fromBeans(List<BenthosBatchFrequency> frequency) {
        List<BenthosFrequencyRowModel> result = Lists.newArrayList();
        for (BenthosBatchFrequency b : frequency) {
            BenthosFrequencyRowModel model = new BenthosFrequencyRowModel();
            fromBeanBinder.copy(b, model);
            result.add(model);
        }
        return result;
    }

    public static List<BenthosBatchFrequency> toBeans(List<BenthosFrequencyRowModel> frequency, BenthosBatch batch) {
        List<BenthosBatchFrequency> result = Lists.newArrayList();
        for (BenthosFrequencyRowModel b : frequency) {
            BenthosBatchFrequency model =
                    TuttiBeanFactory.newBenthosBatchFrequency();
            toBeanBinder.copy(b, model);
            model.setBatch(batch);
            result.add(model);
        }
        return result;
    }

    public BenthosFrequencyRowModel() {
        super(BenthosBatchFrequency.class, fromBeanBinder, toBeanBinder);
    }

    @Override
    public Float getLengthStep() {
        return lengthStep;
    }

    @Override
    public void setLengthStep(Float lengthStep) {
        Object oldValue = getLengthStep();
        this.lengthStep = lengthStep;
        firePropertyChange(PROPERTY_LENGTH_STEP, oldValue, lengthStep);
    }

    @Override
    public Integer getNumber() {
        return number;
    }

    @Override
    public void setNumber(Integer number) {
        Object oldValue = getNumber();
        this.number = number;
        firePropertyChange(PROPERTY_NUMBER, oldValue, number);
    }

    @Override
    public Float getWeight() {
        return weight;
    }

    @Override
    public void setWeight(Float weight) {
        Object oldValue = getWeight();
        this.weight = weight;
        firePropertyChange(PROPERTY_WEIGHT, oldValue, weight);
    }

    @Override
    public Caracteristic getLengthStepCaracteristic() {
        return lengthStepCaracteristic;
    }

    @Override
    public void setLengthStepCaracteristic(Caracteristic lengthStepCaracteristic) {
        Object oldValue = getLengthStepCaracteristic();
        this.lengthStepCaracteristic = lengthStepCaracteristic;
        firePropertyChange(PROPERTY_LENGHT_STEP_CARACTERISTIC, oldValue, lengthStepCaracteristic);
    }

    @Override
    public BenthosBatch getBatch() {
        return null;
    }

    @Override
    public void setBatch(BenthosBatch batch) {
    }

    @Override
    public int compareTo(BenthosFrequencyRowModel o) {
        int result = ordering.compare(lengthStep, o.lengthStep);
        return result;
    }

    @Override
    protected BenthosBatchFrequency newEntity() {
        return TuttiBeanFactory.newBenthosBatchFrequency();
    }

    @Override
    public Integer getRankOrder() {
        return null;
    }

    @Override
    public void setRankOrder(Integer rankOrder) {
    }
}
