/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.tutti.ui.swing.content.config;

import fr.ifremer.tutti.persistence.entities.referential.Caracteristic;
import fr.ifremer.tutti.persistence.entities.referential.CaracteristicBean;
import fr.ifremer.tutti.ui.swing.TuttiUIContext;
import fr.ifremer.tutti.ui.swing.content.config.SampleOrderEditorUI;
import java.awt.Component;
import java.awt.Container;
import java.awt.event.ActionEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.JRootPane;
import javax.swing.JToolBar;
import javax.swing.KeyStroke;
import jaxx.runtime.SwingUtil;
import jaxx.runtime.swing.ComponentMover;
import jaxx.runtime.swing.ComponentResizer;
import jaxx.runtime.swing.model.JaxxDefaultListModel;
import jaxx.runtime.swing.renderer.MultiDecoratorListCellRenderer;
import org.nuiton.i18n.I18n;
import org.nuiton.util.decorator.JXPathDecorator;

public class SampleOrderEditorUIHandler {
    private static final int DEFAULT_EDITOR_WIDTH = 300;
    private static final int DEFAULT_EDITOR_HEIGHT = 200;
    public static final String CLOSE_DIALOG_ACTION = "closeDialog";
    public static final String SHOW_DIALOG_ACTION = "showDialog";
    protected final TuttiUIContext context;
    private final SampleOrderEditorUI ui;
    protected Action closeAction;
    protected Action openAction;

    public SampleOrderEditorUIHandler(TuttiUIContext context, SampleOrderEditorUI ui) {
        this.context = context;
        this.ui = ui;
    }

    protected void beforeInitUI() {
    }

    protected void afterInitUI() {
        this.ui.setResizable(true);
        this.ui.setSize(300, 200);
        this.ui.pack();
        ComponentResizer cr = new ComponentResizer();
        cr.registerComponent(new Component[]{this.ui});
        ComponentMover cm = new ComponentMover();
        cm.setDragInsets(cr.getDragInsets());
        cm.registerComponent(new Component[]{this.ui});
        JRootPane rootPane = this.ui.getRootPane();
        KeyStroke shortcutClosePopup = KeyStroke.getKeyStroke(27, 0);
        rootPane.getInputMap(2).put(shortcutClosePopup, CLOSE_DIALOG_ACTION);
        this.closeAction = new AbstractAction(){
            private static final long serialVersionUID = 1L;

            @Override
            public void actionPerformed(ActionEvent e) {
                SampleOrderEditorUIHandler.this.ui.dispose();
                SampleOrderEditorUIHandler.this.ui.setVisible(false);
            }
        };
        this.openAction = new AbstractAction(){
            private static final long serialVersionUID = 1L;

            @Override
            public void actionPerformed(ActionEvent e) {
                SampleOrderEditorUIHandler.this.ui.setVisible(true);
            }
        };
        ImageIcon actionIcon = SwingUtil.createActionIcon((String)"close-dialog");
        this.closeAction.putValue("SmallIcon", actionIcon);
        this.closeAction.putValue("SwingLargeIconKey", actionIcon);
        this.closeAction.putValue("ActionCommandKey", "close");
        this.closeAction.putValue("Name", "close");
        this.closeAction.putValue("ShortDescription", I18n._((String)"tutti.commentEditor.action.close.tip", (Object[])new Object[0]));
        rootPane.getActionMap().put(CLOSE_DIALOG_ACTION, this.closeAction);
        rootPane.getActionMap().put(SHOW_DIALOG_ACTION, this.openAction);
        JButton closeButton = new JButton(this.closeAction);
        closeButton.setText(null);
        closeButton.setFocusPainted(false);
        closeButton.setRequestFocusEnabled(false);
        closeButton.setFocusable(false);
        JToolBar jToolBar = new JToolBar();
        jToolBar.setOpaque(false);
        jToolBar.add(this.closeAction);
        jToolBar.setBorderPainted(false);
        jToolBar.setFloatable(false);
        this.ui.getSampleOrderEditorTopPanel().setRightDecoration((JComponent)jToolBar);
        JXPathDecorator decorator = (JXPathDecorator)this.context.getDecoratorService().getDecoratorByType(CaracteristicBean.class, "parameterOnly");
        this.ui.getList().setCellRenderer(new MultiDecoratorListCellRenderer(new JXPathDecorator[]{decorator}));
        this.ui.getList().addKeyListener(new KeyAdapter(){
            JaxxDefaultListModel<Caracteristic> listModel;
            {
                this.listModel = SampleOrderEditorUIHandler.this.ui.getListModel();
            }

            @Override
            public void keyReleased(KeyEvent e) {
                super.keyReleased(e);
                JList list = (JList)e.getSource();
                if (!list.isSelectionEmpty()) {
                    int selectedIndex = list.getSelectedIndex();
                    Integer newSelectedIndex = null;
                    if (e.getKeyCode() == 40) {
                        if (selectedIndex < this.listModel.size()) {
                            newSelectedIndex = selectedIndex - 1;
                            Caracteristic remove = (Caracteristic)this.listModel.remove(newSelectedIndex.intValue());
                            this.listModel.insertElementAt((Object)remove, selectedIndex);
                        }
                    } else if (e.getKeyCode() == 38 && selectedIndex >= 0) {
                        newSelectedIndex = selectedIndex + 1;
                        Caracteristic remove = (Caracteristic)this.listModel.remove(newSelectedIndex.intValue());
                        this.listModel.insertElementAt((Object)remove, selectedIndex);
                    }
                    if (newSelectedIndex != null) {
                        list.setSelectedIndex(selectedIndex);
                    }
                }
            }
        });
    }

    public void closeEditor() {
        this.closeAction.actionPerformed(null);
    }

    public void openEditor(JComponent component) {
        if (component != null) {
            this.place(component);
        }
        this.openAction.actionPerformed(null);
    }

    public void init() {
        List<Caracteristic> bean = this.ui.getBean();
        this.ui.getListModel().setAllElements(bean);
    }

    public void place(JComponent component) {
        int x = 0;
        int y = component.getHeight();
        for (Container comp = component; comp != null; comp = comp.getParent()) {
            x += ((Component)comp).getX();
            y += ((Component)comp).getY();
        }
        if (x + this.ui.getWidth() > this.ui.getOwner().getX() + this.ui.getOwner().getWidth()) {
            x = x - this.ui.getWidth() + component.getWidth();
        }
        this.ui.setLocation(x, y);
    }
}

