package fr.ifremer.tutti.ui.swing.content.operation.catches.species;

/*
 * #%L
 * Tutti :: UI
 * $Id: ImportPupitriPopupUIHandler.java 991 2013-05-23 11:28:29Z tchemit $
 * $HeadURL: http://svn.forge.codelutin.com/svn/tutti/tags/tutti-2.3.1/tutti-ui-swing/src/main/java/fr/ifremer/tutti/ui/swing/content/operation/catches/species/ImportPupitriPopupUIHandler.java $
 * %%
 * Copyright (C) 2012 Ifremer
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 3 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-3.0.html>.
 * #L%
 */

import fr.ifremer.tutti.ui.swing.TuttiUIContext;
import jaxx.runtime.SwingUtil;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

import javax.swing.JOptionPane;

import static org.nuiton.i18n.I18n._;

/**
 * @author kmorin <morin@codelutin.com>
 * @author tchemit <chemit@codelutin.com>
 * @since 0.2
 */
public class ImportPupitriPopupUIHandler {

    /** Logger. */
    private static final Log log =
            LogFactory.getLog(ImportPupitriPopupUIHandler.class);

    protected final ImportPupitriPopupUI ui;

    protected final TuttiUIContext context;

    public ImportPupitriPopupUIHandler(TuttiUIContext context,
                                       ImportPupitriPopupUI ui) {
        this.context = context;
        this.ui = ui;
    }

    protected void beforeInitUI() {
    }

    protected void afterInitUI() {
        ui.getTrunkFile().setDialogOwner(ui);
        ui.getCarrouselFile().setDialogOwner(ui);
        ui.pack();
        ui.setResizable(true);
    }

    protected void resetFields() {
        ui.getTrunkFile().setSelectedFile((String) null);
        ui.getCarrouselFile().setSelectedFile((String) null);
    }

    public void open() {
        resetFields();
        SwingUtil.center(context.getMainUI(), ui);
        ui.setVisible(true);
    }

    public void cancel() {
        resetFields();
        ui.dispose();
    }

    public void validate() {
        if (ui.getTrunkFile().getSelectedFile() != null
            && ui.getCarrouselFile().getSelectedFile() != null) {
            ui.dispose();

        } else {
            JOptionPane.showMessageDialog(ui,
                                          _("tutti.importPupitri.error.fileMissing.message"),
                                          _("tutti.importPupitri.error.fileMissing.title"),
                                          JOptionPane.ERROR_MESSAGE);
        }
    }

}
