package fr.ifremer.tutti.ui.swing.content.operation.catches.individualobservation.create;

/*
 * #%L
 * Tutti :: UI
 * %%
 * Copyright (C) 2012 - 2013 Ifremer
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 3 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-3.0.html>.
 * #L%
 */

import fr.ifremer.tutti.persistence.entities.TuttiBeanFactory;
import fr.ifremer.tutti.persistence.entities.data.IndividualObservationBatch;
import fr.ifremer.tutti.persistence.entities.referential.Caracteristic;
import fr.ifremer.tutti.persistence.entities.referential.Species;
import fr.ifremer.tutti.ui.swing.util.AbstractTuttiBeanUIModel;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

import java.util.List;

/**
 * @author kmorin <kmorin@codelutin.com>
 * @since 1.4
 */
public class CreateIndividualObservationBatchUIModel extends AbstractTuttiBeanUIModel<CreateIndividualObservationBatchUIModel, CreateIndividualObservationBatchUIModel> {

    private static final long serialVersionUID = 1L;

    private static final Log log = LogFactory.getLog(CreateIndividualObservationBatchUIModel.class);

    public static final String PROPERTY_AVAILABLE_SPECIES = "availableSpecies";

    /**
     * All available species (sets by protocol).
     *
     * @since 2.0
     */
    protected List<Species> availableSpecies;

    /**
     * Delegate edit object.
     *
     * @since 1.3
     */
    protected final IndividualObservationBatch editObject =
            TuttiBeanFactory.newIndividualObservationBatch();

    public CreateIndividualObservationBatchUIModel() {
        super(CreateIndividualObservationBatchUIModel.class, null, null);
    }

    public Species getSpecies() {
        return editObject.getSpecies();
    }

    public void setSpecies(Species individualObservationSpecies) {
        Object oldValue = getSpecies();
        editObject.setSpecies(individualObservationSpecies);
        firePropertyChange(IndividualObservationBatch.PROPERTY_SPECIES, oldValue, individualObservationSpecies);
    }

    public Float getWeight() {
        return editObject.getWeight();
    }

    public void setWeight(Float individualObservationWeight) {
        Object oldValue = getWeight();
        editObject.setWeight(individualObservationWeight);
        firePropertyChange(IndividualObservationBatch.PROPERTY_WEIGHT, oldValue, individualObservationWeight);
    }

    public Float getSize() {
        return editObject.getSize();
    }

    public void setSize(Float individualObservationSize) {
        Object oldValue = getSize();
        editObject.setSize(individualObservationSize);
        firePropertyChange(IndividualObservationBatch.PROPERTY_SIZE, oldValue, individualObservationSize);
    }

    public Caracteristic getLengthStepCaracteristic() {
        return editObject.getLengthStepCaracteristic();
    }

    public void setLengthStepCaracteristic(Caracteristic individualObservationLengthStepCaracteristic) {
        Object oldValue = getLengthStepCaracteristic();
        editObject.setLengthStepCaracteristic(individualObservationLengthStepCaracteristic);
        firePropertyChange(IndividualObservationBatch.PROPERTY_LENGTH_STEP_CARACTERISTIC, oldValue, individualObservationLengthStepCaracteristic);
    }

    public List<Species> getAvailableSpecies() {
        if (log.isDebugEnabled()) {
            log.debug("getAvailableSpecies " + availableSpecies);
        }
        return availableSpecies;
    }

    public void setAvailableSpecies(List<Species> availableSpecies) {

        if (log.isDebugEnabled()) {
            log.debug("setAvailableSpecies " + availableSpecies);
        }
        Object oldValue = getAvailableSpecies();
        this.availableSpecies = availableSpecies;
        firePropertyChange(PROPERTY_AVAILABLE_SPECIES, oldValue, availableSpecies);
    }

    @Override
    protected CreateIndividualObservationBatchUIModel newEntity() {
        return new CreateIndividualObservationBatchUIModel();
    }

    public void reset() {
        setSpecies(null);
        setWeight(null);
        setSize(null);
        setLengthStepCaracteristic(null);
    }
}
