package fr.ifremer.tutti.ui.swing.content.db;

/*
 * #%L
 * Tutti :: UI
 * $Id: DbManagerUIHandler.java 931 2013-05-08 15:45:54Z tchemit $
 * $HeadURL: http://svn.forge.codelutin.com/svn/tutti/tags/tutti-2.3.1/tutti-ui-swing/src/main/java/fr/ifremer/tutti/ui/swing/content/db/DbManagerUIHandler.java $
 * %%
 * Copyright (C) 2012 - 2013 Ifremer
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 3 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-3.0.html>.
 * #L%
 */

import fr.ifremer.tutti.ui.swing.TuttiUIContext;
import fr.ifremer.tutti.ui.swing.util.AbstractTuttiUIHandler;
import jaxx.runtime.validator.swing.SwingValidator;

import javax.swing.JComponent;
import javax.swing.SwingUtilities;

import static org.nuiton.i18n.I18n._;

/**
 * @author tchemit <chemit@codelutin.com>
 * @since 1.0
 */
public class DbManagerUIHandler extends AbstractTuttiUIHandler<TuttiUIContext, DbManagerUI> {

    public DbManagerUIHandler(TuttiUIContext context, DbManagerUI ui) {
        super(context, ui);
    }

    @Override
    public void beforeInitUI() {
    }

    public String updateMessage(boolean dbExist, boolean dbLoaded) {
        String message;

        if (dbExist) {

            String jdbcUrl = getConfig().getServiceConfig().getPersistenceConfig().getJdbcUrl();

            if (dbLoaded) {

                // db loaded
                message = _("tutti.dbManager.info.db.loaded", jdbcUrl);

            } else {

                // no db loaded
                message = _("tutti.dbManager.info.no.db.loaded", jdbcUrl);
            }
        } else {

            // db does not exist
            message = _("tutti.dbManager.info.no.db.exist");
//            ui.getInformationLabel().setText(_(message));
        }
        return "<html><body>" + message + "</body></html>";
    }

    @Override
    public void afterInitUI() {

        initUI(ui);

        ui.applyDataBinding(DbManagerUI.BINDING_UPGRADE_DB_BUTTON_ENABLED);
        ui.applyDataBinding(DbManagerUI.BINDING_EXPORT_DB_BUTTON_ENABLED);
        ui.applyDataBinding(DbManagerUI.BINDING_EXPORT_AND_CLEAN_DB_BUTTON_ENABLED);

        SwingUtilities.invokeLater(
                new Runnable() {
                    @Override
                    public void run() {
                        getContext().getMainUI().getBody().repaint();
                    }
                }
        );
    }

    @Override
    protected JComponent getComponentToFocus() {
        return getUI().getUpgradeDbButton();
    }

    @Override
    public void onCloseUI() {
    }

    @Override
    public SwingValidator<TuttiUIContext> getValidator() {
        return null;
    }

}
