package fr.ifremer.tutti.ui.swing.content.operation.catches.marinelitter.create;

/*
 * #%L
 * Tutti :: UI
 * $Id:$
 * $HeadURL:$
 * %%
 * Copyright (C) 2012 - 2013 Ifremer
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 3 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-3.0.html>.
 * #L%
 */

import fr.ifremer.tutti.persistence.entities.referential.CaracteristicQualitativeValue;
import fr.ifremer.tutti.ui.swing.TuttiHelpBroker;
import fr.ifremer.tutti.ui.swing.content.operation.catches.EditCatchesUI;
import fr.ifremer.tutti.ui.swing.util.TuttiUI;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.GridBagConstraints;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import jaxx.runtime.JAXXBinding;
import jaxx.runtime.JAXXContext;
import jaxx.runtime.JAXXObject;
import jaxx.runtime.JAXXObjectDescriptor;
import jaxx.runtime.JAXXUtil;
import jaxx.runtime.JAXXValidator;
import jaxx.runtime.SwingUtil;
import jaxx.runtime.binding.DefaultJAXXBinding;
import jaxx.runtime.binding.SimpleJAXXObjectBinding;
import jaxx.runtime.context.DefaultJAXXContext;
import jaxx.runtime.swing.Table;
import jaxx.runtime.swing.editor.NumberEditor;
import jaxx.runtime.swing.editor.bean.BeanFilterableComboBox;
import jaxx.runtime.swing.help.JAXXHelpUI;
import jaxx.runtime.validator.swing.SwingValidator;
import jaxx.runtime.validator.swing.SwingValidatorUtil;
import jaxx.runtime.validator.swing.meta.Validator;
import jaxx.runtime.validator.swing.meta.ValidatorField;
import jaxx.runtime.validator.swing.ui.ImageValidationUI;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import static org.nuiton.i18n.I18n._;

public class CreateMarineLitterBatchUI extends JPanel implements JAXXHelpUI<TuttiHelpBroker>, TuttiUI<CreateMarineLitterBatchUIModel, CreateMarineLitterBatchUIHandler>, JAXXObject, JAXXValidator {

    /*-----------------------------------------------------------------------*/
    /*------------------ Constants for all public bindings ------------------*/
    /*-----------------------------------------------------------------------*/

    public static final String BINDING_MARINE_LITTER_CATEGORY_COMBO_BOX_SELECTED_ITEM = "marineLitterCategoryComboBox.selectedItem";
    public static final String BINDING_MARINE_LITTER_SIZE_CATEGORY_COMBO_BOX_SELECTED_ITEM = "marineLitterSizeCategoryComboBox.selectedItem";
    public static final String BINDING_NUMBER_FIELD_MODEL = "numberField.model";
    public static final String BINDING_NUMBER_FIELD_NUMBER_PATTERN = "numberField.numberPattern";
    public static final String BINDING_SAVE_BUTTON_ENABLED = "saveButton.enabled";

    /*-----------------------------------------------------------------------*/
    /*------------------------- Other static fields -------------------------*/
    /*-----------------------------------------------------------------------*/

    private static final String $jaxxObjectDescriptor = "H4sIAAAAAAAAALVXT28bRRSfuLET5w+hCUSpSGgaCmoaMS5tEZVSQRI3VhLZwYoNqsihjL3jeMp6d5mdTRysID4CHwHuXJC4cUKAkLhx4IL4Cghx4Ip4M7v27jq7XhvUSl3FM+/93pvfe/Pem6/+QGmboxtPSbuNuWMI1qL4YPvx43drT2ldPKJ2nTNLmBy5/8ZSKHWMprXeui3QK8dFqZ7z1HN5s2WZBjUC2ptFNGWLc53aTUqFQCthjbpt5yq97c225fAuas+pKNQv/voz9bn22ZcphNoWeDcHR1lN0vJPMl5EKaYJNA+WTklOJ8YJuMGZcQL+zsq1vE5s+5C06MfoUzRRRBmLcAATaG34IysMpd+2BLpe55QIWiJghhaZEJTvEFFvVk2rTAyqC0QaHLMGpy3KsXCEYNhh2D4Dr3DdNAQYwaZFORHMNHBd6lIbtxServCwawLnoy29t29Zyp+MQBNNYmg65QI1n7nVPdeUbzzdMjV54MYzN12ShnzD2VOiM41AkATaCKVLb8OzX5Hf97uLPkKmxs2PJG3r8b5X5c89sLujZH3leThVg5047om8qC+F/PAQSE1XmZft6V5rBU6Xh9OemPy8SGoSYl5mbNvTPVCLUmupp7wcpQypWzN3zLZAb0a4QDUm2ahRYuAd+BSYDrrSr65e2MRK0ESFfUJDPkqhlbDCapxCEH81rDNtOK0a5XGQ3naBUR0u92vxpzpUcrvqRxhi8uaBisudflbVajgkM3Vi1Km+A+GGbEULIXl3VUre7ilM2eSU+hs5b5ejl0KuQlHEflH0q9bYMUpzB5YhaY4v19Ej2HIr6FJfBZWAavefxYVfv/39m0KwbL4YKRqo+lDOLC7voWDS9JxbMx3B9FyJWJvHKGtTHVqGagnLEY5VvG1wDuxdlepYquM9YjcBIj3x23ffL374yxWUKqAp3SRagUj5fZQVTQ4smLrWtt7ZUh7NnE3C93n4f0WgcZmeUMw6qqBcAMPsjQdGmdMGg7Sec++l5/w5hvsPWGdH1JadaFxwh7aBreUItnou17I//b1Q+Xqry9gYnOBarLjPWvoDlGGGLhNcthqvi0S2lmnLpo5m+t0iqn8g6CCL0ffQqy9vqe9mFE1Z4gizbFoOgOQ6XuXHJ1TkVT26tY6Zvd0VCd6NW+sXEaQBs3JJSXeT/04MbAUEg4iuPOC2HeluXlEq/9qVJ5wJiiacawz6yJMmVFm46Z01N9QxLRZLsbUIk8ld2UrwYhxKhi7LUUH2lJc7gwrtheSPtoHGB4PdbcgChqOgoMYJ09SrzKoqoIf/FQgLmFV6BG4nETgAKJ7b+JaVxGoKUsEtKlTbF7Ql0A33isvsKkWgqkSd7N50gV6IMh3l48DOOFrw1zpJHc1PgJHjFoTrT4Kt/wMWToTd0RMhBBafDIPng9ET4tXohAgi9yfFUpwLUf4mjiejJcdsJzCb+Hlwexi2Xc3+qOPhVcMxvjdcjD3V+IgGh7EkMtL+0L/gB86t9ipMlzr5rIteJtIv2JnvPNrN75e2i/eelLer1d2jQxlcx6YFGBj8zhQId8ZFGOC6CkaS6/KxRA3ZcGGmvOo5z2z1NnBdd0O5PphUmGjkK0ZOgDCmuL/25SsHjbtrM3J0KRm0ZRqsLtDdoeFwq6cUzpDXh4cIJcjdpAQJasbnR2DaHSI9PBY3hrLsDt59PGa6q31M3h8BMpbL3CggITbvD8mmpxvPZ+i5kcQoTEcZnZybIIyeewiPWLJaY4YGT5O3L2GPye/UEIiT8pJWzy01uf4YjXM9EUcu/zwA4eZQCD8MQNgAhH8Bv/fUG+ASAAA=";
    private static final Log log = LogFactory.getLog(CreateMarineLitterBatchUI.class);
    private static final long serialVersionUID = 1L;

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Internal states ---------------------------*/
    /*-----------------------------------------------------------------------*/

    protected List<Object> $activeBindings = new ArrayList<Object>();
    protected Map<String, Object> $bindingSources = new HashMap<String, Object>();
    protected final Map<String, JAXXBinding> $bindings = new TreeMap<String, JAXXBinding>();
    protected Map<String, Object> $objectMap = new HashMap<String, Object>();
    protected Map<?, ?> $previousValues = new HashMap<Object, Object>();
    private boolean allComponentsCreated;
    protected final JAXXContext delegateContext = new DefaultJAXXContext();

    /*-----------------------------------------------------------------------*/
    /*------------------------ Protected components  ------------------------*/
    /*-----------------------------------------------------------------------*/

    protected TuttiHelpBroker broker;
    protected JButton cancelButton;
    protected Table configurationPanel;
    protected CreateMarineLitterBatchUI createMarineLitterBatchTopPanel = this;
    protected CreateMarineLitterBatchUIHandler handler;
    @ValidatorField( validatorId = "validator",  propertyName = "marineLitterCategory",  editorName = "marineLitterCategoryComboBox")
    protected BeanFilterableComboBox<CaracteristicQualitativeValue> marineLitterCategoryComboBox;
    protected JLabel marineLitterCategoryLabel;
    @ValidatorField( validatorId = "validator",  propertyName = "marineLitterSizeCategory",  editorName = "marineLitterSizeCategoryComboBox")
    protected BeanFilterableComboBox<CaracteristicQualitativeValue> marineLitterSizeCategoryComboBox;
    protected JLabel marineLitterSizeCategoryLabel;
    protected CreateMarineLitterBatchUIModel model;
    @ValidatorField( validatorId = "validator",  propertyName = "number",  editorName = "numberField")
    protected NumberEditor numberField;
    protected JLabel numberLabel;
    protected JButton saveButton;
    @Validator( validatorId = "validator")
    protected SwingValidator<CreateMarineLitterBatchUIModel> validator;
    protected List<String> validatorIds = new ArrayList<String>();

    /*-----------------------------------------------------------------------*/
    /*------------------------- Private components  -------------------------*/
    /*-----------------------------------------------------------------------*/

    private JPanel $JPanel0;

    /*-----------------------------------------------------------------------*/
    /*---------------------- Raw body code from script ----------------------*/
    /*-----------------------------------------------------------------------*/
    
    
    protected void $afterCompleteSetup() { handler.afterInitUI(); }

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Constructors  ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public CreateMarineLitterBatchUI(EditCatchesUI parentUI) {
        JAXXUtil.initContext(this, parentUI);
            CreateMarineLitterBatchUIHandler handler = new CreateMarineLitterBatchUIHandler(parentUI, this);
            setContextValue(handler);
            handler.beforeInitUI();
            $initialize();
    }

    public CreateMarineLitterBatchUI() {
        $initialize();
    }

    public CreateMarineLitterBatchUI(JAXXContext parentContext) {
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public CreateMarineLitterBatchUI(boolean param0) {
        super(param0);
        $initialize();
    }

    public CreateMarineLitterBatchUI(JAXXContext parentContext, boolean param1) {
        super(param1);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public CreateMarineLitterBatchUI(LayoutManager param0) {
        super(param0);
        $initialize();
    }

    public CreateMarineLitterBatchUI(JAXXContext parentContext, LayoutManager param1) {
        super(param1);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public CreateMarineLitterBatchUI(LayoutManager param0, boolean param1) {
        super(param0 ,param1);
        $initialize();
    }

    public CreateMarineLitterBatchUI(JAXXContext parentContext, LayoutManager param1, boolean param2) {
        super(param1 ,param2);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Statics methods ---------------------------*/
    /*-----------------------------------------------------------------------*/

    public static JAXXObjectDescriptor $getJAXXObjectDescriptor() {
        return JAXXUtil.decodeCompressedJAXXObjectDescriptor($jaxxObjectDescriptor);
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------- JAXXObject implementation ----------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    public void applyDataBinding(String $binding) {
        if (allComponentsCreated && $bindings.containsKey($binding)) {
            getDataBinding($binding).applyDataBinding();
        }
        processDataBinding($binding);
    }

    @Override
    public void firePropertyChange(String propertyName, Object oldValue, Object newValue) {
        super.firePropertyChange(propertyName, oldValue, newValue);
    }

    @Override
    public Map<String, Object> get$objectMap() {
        return $objectMap;
    }

    @Override
    public JAXXBinding getDataBinding(String bindingId) {
        return $bindings.get(bindingId);
    }

    @Override
    public JAXXBinding[] getDataBindings() {
        return $bindings.values().toArray(new JAXXBinding[$bindings.size()]);
    }

    @Override
    public Object getObjectById(String id) {
        return $objectMap.get(id);
    }

    @Override
    public void processDataBinding(String $binding, boolean $force) {
        if (!$force && $activeBindings.contains($binding)) { 
            return;
        }
        $activeBindings.add($binding);
        try {
            if (allComponentsCreated && $bindings.containsKey($binding)) {
                getDataBinding($binding).processDataBinding();
            }
        } finally {
            $activeBindings.remove($binding);
        }
    }

    @Override
    public void processDataBinding(String $binding) {
        processDataBinding($binding, false);
    }

    @Override
    public void registerDataBinding(JAXXBinding binding) {
        $bindings.put(binding.getId(), binding);
    }

    @Override
    public void removeDataBinding(String $binding) {
        if (allComponentsCreated && $bindings.containsKey($binding)) {
            getDataBinding($binding).removeDataBinding();
        }
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- JAXXContext implementation  ---------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    public <T> T getContextValue(Class<T> clazz) {
        return delegateContext.getContextValue(clazz, null);
    }

    @Override
    public <T> T getContextValue(Class<T> clazz, String name) {
        return delegateContext.getContextValue(clazz, name);
    }

    @Override
    public JAXXContext getDelegateContext() {
        return delegateContext;
    }

    @Override
    public <O extends Container> O getParentContainer(Class<O> clazz) {
        return SwingUtil.getParentContainer(this, clazz);
    }

    @Override
    public <O extends Container> O getParentContainer(Object source, Class<O> clazz) {
        return SwingUtil.getParentContainer(source, clazz);
    }

    @Override
    public <T> void removeContextValue(Class<T> clazz) {
        delegateContext.removeContextValue(clazz, null);
    }

    @Override
    public <T> void removeContextValue(Class<T> clazz, String name) {
        delegateContext.removeContextValue(clazz, name);
    }

    @Override
    public <T> void setContextValue(T o) {
        delegateContext.setContextValue(o, null);
    }

    @Override
    public <T> void setContextValue(T o, String name) {
        delegateContext.setContextValue(o, name);
    }

    /*-----------------------------------------------------------------------*/
    /*-------------------- JAXXValidator implementation  --------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    public SwingValidator<?> getValidator(String validatorId) {
        return (SwingValidator<?>) (validatorIds.contains(validatorId) ? getObjectById(validatorId) : null);
    }

    @Override
    public List<String> getValidatorIds() {
        return validatorIds;
    }

    @Override
    public void registerValidatorFields() {
        SwingValidatorUtil.detectValidatorFields(this);
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Event methods ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public void doActionPerformed__on__cancelButton(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        handler.cancel();
    }

    public void doActionPerformed__on__saveButton(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        handler.save();
    }

    /*-----------------------------------------------------------------------*/
    /*----------------------- Public acessor methods  -----------------------*/
    /*-----------------------------------------------------------------------*/

    public TuttiHelpBroker getBroker() {
        return broker;
    }

    public JButton getCancelButton() {
        return cancelButton;
    }

    public Table getConfigurationPanel() {
        return configurationPanel;
    }

    public CreateMarineLitterBatchUIHandler getHandler() {
        return handler;
    }

    public BeanFilterableComboBox<CaracteristicQualitativeValue> getMarineLitterCategoryComboBox() {
        return marineLitterCategoryComboBox;
    }

    public JLabel getMarineLitterCategoryLabel() {
        return marineLitterCategoryLabel;
    }

    public BeanFilterableComboBox<CaracteristicQualitativeValue> getMarineLitterSizeCategoryComboBox() {
        return marineLitterSizeCategoryComboBox;
    }

    public JLabel getMarineLitterSizeCategoryLabel() {
        return marineLitterSizeCategoryLabel;
    }

    public CreateMarineLitterBatchUIModel getModel() {
        return model;
    }

    public NumberEditor getNumberField() {
        return numberField;
    }

    public JLabel getNumberLabel() {
        return numberLabel;
    }

    public JButton getSaveButton() {
        return saveButton;
    }

    public SwingValidator<CreateMarineLitterBatchUIModel> getValidator() {
        return validator;
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Other methods ----------------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    public void registerHelpId(TuttiHelpBroker broker, Component component, String helpId) {
        broker.installUI(component, helpId);
    }

    @Override
    public void showHelp(String helpId) {
        getBroker().showHelp(this, helpId);
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Protected acessors methods  ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected JPanel get$JPanel0() {
        return $JPanel0;
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Components creation methods ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected void addChildrenToConfigurationPanel() {
        if (!allComponentsCreated) {
            return;
        }
        configurationPanel.add(marineLitterCategoryLabel, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 1, new Insets(3, 3, 3, 3), 0, 0));
        configurationPanel.add(SwingUtil.boxComponentWithJxLayer(marineLitterCategoryComboBox), new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        configurationPanel.add(marineLitterSizeCategoryLabel, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 17, 1, new Insets(3, 3, 3, 3), 0, 0));
        configurationPanel.add(SwingUtil.boxComponentWithJxLayer(marineLitterSizeCategoryComboBox), new GridBagConstraints(1, 1, 1, 1, 1.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        configurationPanel.add(numberLabel, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 17, 1, new Insets(3, 3, 3, 3), 0, 0));
        configurationPanel.add(SwingUtil.boxComponentWithJxLayer(numberField), new GridBagConstraints(1, 2, 2, 1, 1.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
    }

    protected void addChildrenToCreateMarineLitterBatchTopPanel() {
        if (!allComponentsCreated) {
            return;
        }
        add(configurationPanel, BorderLayout.CENTER);
        add($JPanel0, BorderLayout.SOUTH);
    }

    protected void addChildrenToValidator() {
        if (!allComponentsCreated) {
            return;
        }
        validator.setUiClass(ImageValidationUI.class);
        validator.setBean(model);
    }

    protected void createBroker() {
        $objectMap.put("broker", broker = new TuttiHelpBroker("tutti.createMarineLitterBatch.help"));
    }

    protected void createCancelButton() {
        $objectMap.put("cancelButton", cancelButton = new JButton());
        
        cancelButton.setName("cancelButton");
        cancelButton.setText(_("tutti.createMarineLitterBatch.action.cancel"));
        cancelButton.setToolTipText(_("tutti.createMarineLitterBatch.action.cancel.tip"));
        cancelButton.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__cancelButton"));
        cancelButton.putClientProperty("help", "tutti.createMarineLitterBatch.action.cancel.help");
    }

    protected void createConfigurationPanel() {
        $objectMap.put("configurationPanel", configurationPanel = new Table());
        
        configurationPanel.setName("configurationPanel");
    }

    protected void createHandler() {
        $objectMap.put("handler", handler = getContextValue(CreateMarineLitterBatchUIHandler.class));
    }

    protected void createMarineLitterCategoryComboBox() {
        $objectMap.put("marineLitterCategoryComboBox", marineLitterCategoryComboBox = new BeanFilterableComboBox<CaracteristicQualitativeValue>(this));
        
        marineLitterCategoryComboBox.setName("marineLitterCategoryComboBox");
        marineLitterCategoryComboBox.setI18nPrefix("tutti.property.");
        marineLitterCategoryComboBox.setProperty("marineLitterCategory");
        marineLitterCategoryComboBox.setShowReset(true);
    }

    protected void createMarineLitterCategoryLabel() {
        $objectMap.put("marineLitterCategoryLabel", marineLitterCategoryLabel = new JLabel());
        
        marineLitterCategoryLabel.setName("marineLitterCategoryLabel");
        marineLitterCategoryLabel.setText(_("tutti.createMarineLitterBatch.field.marineLitterCategory"));
        marineLitterCategoryLabel.setToolTipText(_("tutti.createMarineLitterBatch.field.marineLitterCategory.tip"));
        marineLitterCategoryLabel.putClientProperty("help", "tutti.createMarineLitterBatch.field.marineLitterCategory.help");
    }

    protected void createMarineLitterSizeCategoryComboBox() {
        $objectMap.put("marineLitterSizeCategoryComboBox", marineLitterSizeCategoryComboBox = new BeanFilterableComboBox<CaracteristicQualitativeValue>(this));
        
        marineLitterSizeCategoryComboBox.setName("marineLitterSizeCategoryComboBox");
        marineLitterSizeCategoryComboBox.setI18nPrefix("tutti.property.");
        marineLitterSizeCategoryComboBox.setProperty("marineLitterSizeCategory");
        marineLitterSizeCategoryComboBox.setShowReset(true);
    }

    protected void createMarineLitterSizeCategoryLabel() {
        $objectMap.put("marineLitterSizeCategoryLabel", marineLitterSizeCategoryLabel = new JLabel());
        
        marineLitterSizeCategoryLabel.setName("marineLitterSizeCategoryLabel");
        marineLitterSizeCategoryLabel.setText(_("tutti.createMarineLitterBatch.field.marineLitterSizeCategory"));
        marineLitterSizeCategoryLabel.setToolTipText(_("tutti.createMarineLitterBatch.field.marineLitterSizeCategory.tip"));
        marineLitterSizeCategoryLabel.putClientProperty("help", "tutti.createMarineLitterBatch.field.marineLitterSizeCategory.help");
    }

    protected void createModel() {
        $objectMap.put("model", model = getContextValue(CreateMarineLitterBatchUIModel.class));
    }

    protected void createNumberField() {
        $objectMap.put("numberField", numberField = new NumberEditor(this));
        
        numberField.setName("numberField");
        numberField.setProperty("number");
        numberField.setUseFloat(true);
        numberField.setShowReset(true);
    }

    protected void createNumberLabel() {
        $objectMap.put("numberLabel", numberLabel = new JLabel());
        
        numberLabel.setName("numberLabel");
        numberLabel.setText(_("tutti.createMarineLitterBatch.field.number"));
        numberLabel.setToolTipText(_("tutti.createMarineLitterBatch.field.number.tip"));
        numberLabel.putClientProperty("help", "tutti.createMarineLitterBatch.field.number.help");
    }

    protected void createSaveButton() {
        $objectMap.put("saveButton", saveButton = new JButton());
        
        saveButton.setName("saveButton");
        saveButton.setText(_("tutti.createMarineLitterBatch.action.save"));
        saveButton.setToolTipText(_("tutti.createMarineLitterBatch.action.save.tip"));
        saveButton.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__saveButton"));
        saveButton.putClientProperty("help", "tutti.createMarineLitterBatch.action.save.help");
    }

    protected void createValidator() {
        $objectMap.put("validator", validator = SwingValidator.newValidator(CreateMarineLitterBatchUIModel.class, null));
    }

    /*-----------------------------------------------------------------------*/
    /*------------------------ Internal jaxx methods ------------------------*/
    /*-----------------------------------------------------------------------*/

    private void $completeSetup() {
        allComponentsCreated = true;
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        addChildrenToCreateMarineLitterBatchTopPanel();
        addChildrenToValidator();
        addChildrenToConfigurationPanel();
        // inline complete setup of $JPanel0
        $JPanel0.add(cancelButton);
        $JPanel0.add(saveButton);
        
        // apply 5 data bindings
        JAXXUtil.applyDataBinding(this, $bindings.keySet());
        
        // apply 16 property setters
        marineLitterCategoryComboBox.setBeanType(CaracteristicQualitativeValue.class);
        marineLitterSizeCategoryComboBox.setBeanType(CaracteristicQualitativeValue.class);
        marineLitterCategoryLabel.setLabelFor(marineLitterCategoryComboBox);
        marineLitterCategoryComboBox.setBean(model);
        marineLitterSizeCategoryLabel.setLabelFor(marineLitterSizeCategoryComboBox);
        marineLitterSizeCategoryComboBox.setBean(model);
        numberLabel.setLabelFor(numberField);
        numberField.setBean(model);
        numberField.setAutoPopup(handler.getConfig().isAutoPopupNumberEditor());
        numberField.setShowPopupButton(handler.getConfig().isShowNumberEditorButton());
        cancelButton.setIcon(SwingUtil.createActionIcon("cancel"));
        cancelButton.setMnemonic(SwingUtil.getFirstCharAt(_("tutti.createMarineLitterBatch.action.cancel.mnemonic"),'Z'));
        saveButton.setIcon(SwingUtil.createActionIcon("save"));
        saveButton.setMnemonic(SwingUtil.getFirstCharAt(_("tutti.createMarineLitterBatch.action.save.mnemonic"),'Z'));
        // late initializer
        // help broker setup
        TuttiHelpBroker _broker = getBroker();
        registerHelpId(_broker, createMarineLitterBatchTopPanel, "tutti.createMarineLitterBatch.help");
        registerHelpId(_broker, marineLitterCategoryLabel, "tutti.createMarineLitterBatch.field.marineLitterCategory.help");
        registerHelpId(_broker, marineLitterSizeCategoryLabel, "tutti.createMarineLitterBatch.field.marineLitterSizeCategory.help");
        registerHelpId(_broker, numberLabel, "tutti.createMarineLitterBatch.field.number.help");
        registerHelpId(_broker, cancelButton, "tutti.createMarineLitterBatch.action.cancel.help");
        registerHelpId(_broker, saveButton, "tutti.createMarineLitterBatch.action.save.help");
        _broker.prepareUI(this);
        // register 1 validator(s)
        validatorIds = SwingValidatorUtil.detectValidators(this);
        SwingValidatorUtil.installUI(this);
        
        $afterCompleteSetup();
    }

    private void $initialize() {
        if (allComponentsCreated) {
            return;
        }
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        $objectMap.put("createMarineLitterBatchTopPanel", createMarineLitterBatchTopPanel);
        createHandler();
        createModel();
        createValidator();
        createBroker();
        createConfigurationPanel();
        createMarineLitterCategoryLabel();
        createMarineLitterCategoryComboBox();
        createMarineLitterSizeCategoryLabel();
        createMarineLitterSizeCategoryComboBox();
        createNumberLabel();
        createNumberField();
        // inline creation of $JPanel0
        $objectMap.put("$JPanel0", $JPanel0 = new JPanel());
        
        $JPanel0.setName("$JPanel0");
        $JPanel0.setLayout(new GridLayout(1, 0));
        createCancelButton();
        createSaveButton();
        // inline creation of createMarineLitterBatchTopPanel
        setName("createMarineLitterBatchTopPanel");
        setLayout(new BorderLayout());
        createMarineLitterBatchTopPanel.putClientProperty("help", "tutti.createMarineLitterBatch.help");
        
        // registers 5 data bindings
        $registerDefaultBindings();
        $completeSetup();
    }

    private void $registerDefaultBindings() {
        // register 5 data bindings
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_MARINE_LITTER_CATEGORY_COMBO_BOX_SELECTED_ITEM, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("marineLitterCategory", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    marineLitterCategoryComboBox.setSelectedItem(model.getMarineLitterCategory());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("marineLitterCategory", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_MARINE_LITTER_SIZE_CATEGORY_COMBO_BOX_SELECTED_ITEM, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("marineLitterSizeCategory", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    marineLitterSizeCategoryComboBox.setSelectedItem(model.getMarineLitterSizeCategory());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("marineLitterSizeCategory", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_NUMBER_FIELD_MODEL, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("number", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    numberField.setModel(model.getNumber());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("number", this);
                }
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_NUMBER_FIELD_NUMBER_PATTERN, true ,"DECIMAL3_PATTERN") {
        
            @Override
            public void processDataBinding() {
                numberField.setNumberPattern(DECIMAL3_PATTERN);
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_SAVE_BUTTON_ENABLED, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("valid", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    saveButton.setEnabled(model.isValid());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("valid", this);
                }
            }
        });
    }

}