/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.tutti.ui.swing.content.db;

import com.google.common.base.Preconditions;
import fr.ifremer.tutti.persistence.ProgressionModel;
import fr.ifremer.tutti.persistence.config.TuttiPersistenceConfig;
import fr.ifremer.tutti.ui.swing.content.AbstractMainUITuttiAction;
import fr.ifremer.tutti.ui.swing.content.MainUIHandler;
import fr.ifremer.tutti.ui.swing.content.db.OpenDbAction;
import fr.ifremer.tutti.ui.swing.util.TuttiUIUtil;
import fr.ifremer.tutti.ui.swing.util.action.TuttiActionHelper;
import java.io.File;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.i18n.I18n;

public class ImportDbAction
extends AbstractMainUITuttiAction {
    private static final Log log = LogFactory.getLog(ImportDbAction.class);
    protected File file;

    public ImportDbAction(MainUIHandler handler) {
        super(handler, true);
    }

    @Override
    protected boolean prepareAction() throws Exception {
        boolean doAction = super.prepareAction();
        if (doAction) {
            this.file = TuttiUIUtil.chooseFile(this.getContext().getMainUI(), I18n._((String)"tutti.dbManager.title.choose.dbImportFile", (Object[])new Object[0]), I18n._((String)"tutti.dbManager.action.chooseDbFile", (Object[])new Object[0]), "^.*\\.zip", I18n._((String)"tutti.common.file.zip", (Object[])new Object[0]));
            boolean bl = doAction = this.file != null;
            if (doAction) {
                this.getContext().getPersistenceService().checkImportStructure(this.file);
            }
        }
        return doAction;
    }

    @Override
    protected void releaseAction() {
        this.file = null;
        super.releaseAction();
    }

    @Override
    protected void doAction() throws Exception {
        Preconditions.checkNotNull((Object)this.file);
        if (log.isInfoEnabled()) {
            log.info((Object)("Will import db: " + this.file));
        }
        ProgressionModel progressionModel = new ProgressionModel();
        progressionModel.setTotal(3);
        this.setProgressionModel(progressionModel);
        progressionModel.setMessage(I18n._((String)"tutti.importDb.unzipArchive", (Object[])new Object[0]));
        this.getContext().getPersistenceService().importDb(this.file);
        this.getContext().setDbExist(true);
        progressionModel.increments(1);
        progressionModel.setMessage(I18n._((String)"tutti.importDb.openDb", (Object[])new Object[0]));
        TuttiActionHelper.runInternalAction(this.getHandler(), OpenDbAction.class);
    }

    @Override
    public void postSuccessAction() {
        super.postSuccessAction();
        String jdbcUrl = TuttiPersistenceConfig.getInstance().getJdbcUrl();
        this.sendMessage(I18n._((String)"tutti.flash.info.db.imported", (Object[])new Object[]{jdbcUrl}));
    }
}

