package fr.ifremer.tutti.ui.swing.content.db;

/*
 * #%L
 * Tutti :: UI
 * $Id: ImportDbAction.java 898 2013-04-30 14:31:18Z kmorin $
 * $HeadURL: http://svn.forge.codelutin.com/svn/tutti/tags/tutti-2.1/tutti-ui-swing/src/main/java/fr/ifremer/tutti/ui/swing/content/db/ImportDbAction.java $
 * %%
 * Copyright (C) 2012 - 2013 Ifremer
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 3 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-3.0.html>.
 * #L%
 */

import com.google.common.base.Preconditions;
import fr.ifremer.tutti.persistence.ProgressionModel;
import fr.ifremer.tutti.persistence.config.TuttiPersistenceConfig;
import fr.ifremer.tutti.ui.swing.content.AbstractMainUITuttiAction;
import fr.ifremer.tutti.ui.swing.content.MainUIHandler;
import fr.ifremer.tutti.ui.swing.util.TuttiUIUtil;
import fr.ifremer.tutti.ui.swing.util.action.TuttiActionHelper;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

import java.io.File;

import static org.nuiton.i18n.I18n._;

/**
 * To import a db and use it.
 *
 * @author tchemit <chemit@codelutin.com>
 * @since 1.1
 */
public class ImportDbAction extends AbstractMainUITuttiAction {

    /** Logger. */
    private static final Log log = LogFactory.getLog(ImportDbAction.class);

    protected File file;

    public ImportDbAction(MainUIHandler handler) {
        super(handler, true);
    }

    @Override
    protected boolean prepareAction() throws Exception {

        boolean doAction = super.prepareAction();

        if (doAction) {

            // choose file to import
            file = TuttiUIUtil.chooseFile(
                    getContext().getMainUI(),
                    _("tutti.dbManager.title.choose.dbImportFile"),
                    _("tutti.dbManager.action.chooseDbFile"),
                    "^.*\\.zip", _("tutti.common.file.zip")
            );

            doAction = file != null;

            if (doAction) {

                getContext().getPersistenceService().checkImportStructure(file);
            }
        }
        return doAction;
    }

    @Override
    protected void releaseAction() {
        file = null;
        super.releaseAction();
    }

    @Override
    protected void doAction() throws Exception {
        Preconditions.checkNotNull(file);

        if (log.isInfoEnabled()) {
            log.info("Will import db: " + file);
        }

        ProgressionModel progressionModel = new ProgressionModel();
        progressionModel.setTotal(3);
        setProgressionModel(progressionModel);

        // import db

        progressionModel.setMessage(_("tutti.importDb.unzipArchive"));

        getContext().getPersistenceService().importDb(file);
        getContext().setDbExist(true);

        // open db

        progressionModel.increments(1);
        progressionModel.setMessage(_("tutti.importDb.openDb"));
        TuttiActionHelper.runInternalAction(getHandler(), OpenDbAction.class);
    }

    @Override
    public void postSuccessAction() {
        super.postSuccessAction();
        String jdbcUrl = TuttiPersistenceConfig.getInstance().getJdbcUrl();

        sendMessage(_("tutti.flash.info.db.imported", jdbcUrl));
    }
}