/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.tutti.ui.swing.content.db;

import fr.ifremer.tutti.persistence.config.TuttiPersistenceConfig;
import fr.ifremer.tutti.ui.swing.TuttiScreen;
import fr.ifremer.tutti.ui.swing.content.AbstractChangeScreenAction;
import fr.ifremer.tutti.ui.swing.content.MainUI;
import fr.ifremer.tutti.ui.swing.content.MainUIHandler;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.i18n.I18n;

public class OpenDbAction
extends AbstractChangeScreenAction {
    private static final Log log = LogFactory.getLog(OpenDbAction.class);

    public OpenDbAction(MainUIHandler handler) {
        super(handler, true, TuttiScreen.SELECT_CRUISE);
        this.setActionDescription(I18n._((String)"tutti.dbManager.action.openDb.tip", (Object[])new Object[0]));
    }

    @Override
    public void doAction() throws Exception {
        if (log.isDebugEnabled()) {
            log.debug((Object)"Will open db...");
        }
        this.getContext().setDbLoaded(true);
        ((MainUIHandler)this.getHandler()).reloadPersistenceService();
        if (log.isDebugEnabled()) {
            log.debug((Object)"Check db context");
        }
        this.getContext().checkDbContext();
        super.doAction();
    }

    @Override
    public void postSuccessAction() {
        String jdbcUrl = TuttiPersistenceConfig.getInstance().getJdbcUrl();
        this.sendMessage(I18n._((String)"tutti.flash.info.db.opened", (Object[])new Object[]{jdbcUrl}));
        ((MainUI)this.getUI()).getHandler().changeTitle();
    }
}

