package fr.ifremer.tutti.ui.swing.util.action;

/*
 * #%L
 * Tutti :: UI
 * $Id: TuttiActionUIModel.java 581 2013-03-12 09:10:25Z tchemit $
 * $HeadURL: http://svn.forge.codelutin.com/svn/tutti/tags/tutti-2.0/tutti-ui-swing/src/main/java/fr/ifremer/tutti/ui/swing/util/action/TuttiActionUIModel.java $
 * %%
 * Copyright (C) 2012 - 2013 Ifremer
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 3 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-3.0.html>.
 * #L%
 */

import com.google.common.base.Preconditions;
import fr.ifremer.tutti.persistence.ProgressionModel;
import org.jdesktop.beans.AbstractSerializableBean;

/**
 * @author tchemit <chemit@codelutin.com>
 * @since 1.0
 */
public class TuttiActionUIModel extends AbstractSerializableBean {

    private static final long serialVersionUID = 1L;

    public static final String PROPERTY_ACTION = "action";

    public static final String PROPERTY_PROGRESSION_MODEL = "progressionModel";

    protected AbstractTuttiAction action;

    protected ProgressionModel progressionModel;

    public ProgressionModel getProgressionModel() {
        return progressionModel;
    }

    public void setProgressionModel(ProgressionModel progressionModel) {
        Object oldValue = getProgressionModel();
        this.progressionModel = progressionModel;
        firePropertyChange(PROPERTY_PROGRESSION_MODEL, oldValue, progressionModel);
    }

    public AbstractTuttiAction getAction() {
        return action;
    }

    public void setAction(AbstractTuttiAction action) {
        Preconditions.checkNotNull(action, "action can not be null");
        Object oldValue = getAction();
        this.action = action;
        firePropertyChange(PROPERTY_ACTION, oldValue, action);
    }

    public void clear() {
        setProgressionModel(null);

        Object oldValue = getAction();
        action = null;
        firePropertyChange(PROPERTY_ACTION, oldValue, null);
    }
}
