/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.adagio.core.dao;

import java.io.File;
import java.io.IOException;
import java.lang.reflect.Method;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import java.util.jar.JarEntry;
import java.util.jar.JarInputStream;

public class EnumerationsInitializationHelper {
    private static Boolean enumerationsHasErrors = null;

    public static boolean checkEnumerations() {
        if (enumerationsHasErrors == null) {
            Collection<Class> enumClasses = EnumerationsInitializationHelper.getEnumsForPackage("fr.ifremer.adagio.core.dao");
            for (Class enumClazz : enumClasses) {
                try {
                    Method hasInitErrorMethod = enumClazz.getMethod("hasInitError", null);
                    Method getNameMethod = enumClazz.getMethod("getName", null);
                    T[] enums = enumClazz.getEnumConstants();
                    for (int i = 0; i < enums.length; ++i) {
                        Object aEnum = enums[i];
                        Boolean hasInitError = (Boolean)hasInitErrorMethod.invoke(aEnum, null);
                        if (!hasInitError.booleanValue()) continue;
                        enumerationsHasErrors = true;
                        break;
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
                if (enumerationsHasErrors == null || !enumerationsHasErrors.booleanValue()) continue;
                break;
            }
            if (enumerationsHasErrors == null) {
                enumerationsHasErrors = false;
            }
        }
        return enumerationsHasErrors == false;
    }

    public static Collection<Class> getEnumsForPackage(String packageName) {
        String packagePath = packageName.replace(".", "/");
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        HashSet<Class> classes = new HashSet<Class>();
        EnumerationsInitializationHelper.getEnumsForPackage(packageName, packagePath, classes, classLoader);
        return classes;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void getEnumsForPackage(String packageName, String packagePath, Set<Class> classes, ClassLoader classLoader) {
        HashSet<URL> jarUrls = new HashSet<URL>();
        HashSet<URL> directoryUrls = new HashSet<URL>();
        while (classLoader != null) {
            if (classLoader instanceof URLClassLoader) {
                for (URL url : ((URLClassLoader)classLoader).getURLs()) {
                    if (url.getFile().endsWith(".jar")) {
                        jarUrls.add(url);
                        continue;
                    }
                    directoryUrls.add(url);
                }
            }
            classLoader = classLoader.getParent();
        }
        for (URL url : directoryUrls) {
            try {
                File directory = new File(url.toURI());
                EnumerationsInitializationHelper.getEnumsForPackage(packagePath, classes, new File(directory, packagePath));
            }
            catch (URISyntaxException e1) {}
        }
        for (URL url : jarUrls) {
            JarInputStream stream = null;
            try {
                stream = new JarInputStream(url.openStream());
                JarEntry entry = stream.getNextJarEntry();
                while (entry != null) {
                    String name = entry.getName();
                    if (name.startsWith(packagePath + "/") && name.endsWith(".class")) {
                        try {
                            Class<?> clazz = Class.forName(name.substring(0, name.length() - 6).replace("/", "."));
                            if (clazz.isEnum()) {
                                classes.add(clazz);
                            }
                        }
                        catch (ClassNotFoundException e) {
                            // empty catch block
                        }
                    }
                    entry = stream.getNextJarEntry();
                }
            }
            catch (IOException e) {}
            continue;
            finally {
                if (stream == null) continue;
                try {
                    stream.close();
                }
                catch (IOException e) {}
            }
        }
    }

    private static void getEnumsForPackage(String packagePath, Set<Class> classes, File packageDirectory) {
        if (!packageDirectory.isDirectory()) {
            return;
        }
        String[] files = packageDirectory.list();
        for (int i = 0; i < files.length; ++i) {
            if (files[i].endsWith(".class")) {
                String name = packagePath + "/" + files[i];
                try {
                    Class<?> clazz = Class.forName(name.substring(0, name.length() - 6).replace("/", "."));
                    if (!clazz.isEnum()) continue;
                    classes.add(clazz);
                }
                catch (ClassNotFoundException e) {}
                continue;
            }
            EnumerationsInitializationHelper.getEnumsForPackage(packagePath + "/" + files[i], classes, new File(packageDirectory, files[i]));
        }
    }
}

