/*
 * Decompiled with CFR 0.152.
 */
package org.jdesktop.swingx.auth;

import java.awt.EventQueue;
import java.util.logging.Logger;
import javax.swing.SwingUtilities;
import javax.swing.SwingWorker;
import javax.swing.event.EventListenerList;
import org.jdesktop.beans.AbstractBean;
import org.jdesktop.swingx.auth.LoginEvent;
import org.jdesktop.swingx.auth.LoginListener;

public abstract class LoginService
extends AbstractBean {
    private Logger LOG = Logger.getLogger(LoginService.class.getName());
    private EventListenerList listenerList = new EventListenerList();
    private SwingWorker<Boolean, Void> loginWorker;
    private boolean synchronous;
    private String server;

    public LoginService() {
    }

    public LoginService(String server) {
        this.setServer(server);
    }

    public abstract boolean authenticate(String var1, char[] var2, String var3) throws Exception;

    public String[] getUserRoles() {
        return null;
    }

    public void cancelAuthentication() {
        if (this.loginWorker != null) {
            this.loginWorker.cancel(true);
        }
    }

    public void startAuthentication(final String user, final char[] password, final String server) throws Exception {
        block5: {
            if (this.getSynchronous()) {
                try {
                    if (this.authenticate(user, password, server)) {
                        this.fireLoginSucceeded(new LoginEvent((Object)this));
                        break block5;
                    }
                    this.fireLoginFailed(new LoginEvent((Object)this));
                }
                catch (Throwable e) {
                    this.fireLoginFailed(new LoginEvent((Object)this, e));
                }
            } else {
                this.loginWorker = new SwingWorker<Boolean, Void>(){

                    @Override
                    protected Boolean doInBackground() throws Exception {
                        try {
                            final boolean result = LoginService.this.authenticate(user, password, server);
                            if (this.isCancelled()) {
                                EventQueue.invokeLater(new Runnable(){

                                    @Override
                                    public void run() {
                                        LoginService.this.fireLoginCanceled(new LoginEvent(this));
                                    }
                                });
                                return false;
                            }
                            EventQueue.invokeLater(new Runnable(){

                                @Override
                                public void run() {
                                    if (result) {
                                        LoginService.this.fireLoginSucceeded(new LoginEvent((Object)LoginService.this));
                                    } else {
                                        LoginService.this.fireLoginFailed(new LoginEvent((Object)LoginService.this));
                                    }
                                }
                            });
                            return result;
                        }
                        catch (Throwable failed) {
                            if (!this.isCancelled()) {
                                SwingUtilities.invokeLater(new Runnable(){

                                    @Override
                                    public void run() {
                                        LoginService.this.fireLoginFailed(new LoginEvent((Object)LoginService.this, failed));
                                    }
                                });
                            } else {
                                EventQueue.invokeLater(new Runnable(){

                                    @Override
                                    public void run() {
                                        LoginService.this.fireLoginCanceled(new LoginEvent(this));
                                    }
                                });
                            }
                            return false;
                        }
                    }
                };
                this.loginWorker.execute();
                this.fireLoginStarted(new LoginEvent((Object)this));
            }
        }
    }

    public boolean getSynchronous() {
        return this.synchronous;
    }

    public void setSynchronous(boolean synchronous) {
        boolean old = this.getSynchronous();
        this.synchronous = synchronous;
        this.firePropertyChange("synchronous", old, this.getSynchronous());
    }

    public void addLoginListener(LoginListener listener) {
        this.listenerList.add(LoginListener.class, listener);
    }

    public void removeLoginListener(LoginListener listener) {
        this.listenerList.remove(LoginListener.class, listener);
    }

    void fireLoginStarted(LoginEvent source) {
        Object[] listeners = this.listenerList.getListenerList();
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != LoginListener.class) continue;
            ((LoginListener)listeners[i + 1]).loginStarted(source);
        }
    }

    void fireLoginSucceeded(LoginEvent source) {
        Object[] listeners = this.listenerList.getListenerList();
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != LoginListener.class) continue;
            ((LoginListener)listeners[i + 1]).loginSucceeded(source);
        }
    }

    void fireLoginFailed(LoginEvent source) {
        Object[] listeners = this.listenerList.getListenerList();
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != LoginListener.class) continue;
            ((LoginListener)listeners[i + 1]).loginFailed(source);
        }
    }

    void fireLoginCanceled(LoginEvent source) {
        Object[] listeners = this.listenerList.getListenerList();
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != LoginListener.class) continue;
            ((LoginListener)listeners[i + 1]).loginCanceled(source);
        }
    }

    public String getServer() {
        return this.server;
    }

    public void setServer(String server) {
        String old = this.getServer();
        this.server = server;
        this.firePropertyChange("server", old, this.getServer());
    }
}

