/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.tutti.ui.swing.util.attachment;

import fr.ifremer.tutti.TuttiIOUtil;
import fr.ifremer.tutti.TuttiTechnicalException;
import fr.ifremer.tutti.persistence.entities.TuttiBeanFactory;
import fr.ifremer.tutti.persistence.entities.data.Attachment;
import fr.ifremer.tutti.service.PersistenceService;
import fr.ifremer.tutti.ui.swing.TuttiUIContext;
import fr.ifremer.tutti.ui.swing.util.AbstractTuttiUIHandler;
import fr.ifremer.tutti.ui.swing.util.TuttiUIUtil;
import fr.ifremer.tutti.ui.swing.util.attachment.AttachmentEditorUI;
import fr.ifremer.tutti.ui.swing.util.attachment.AttachmentItem;
import fr.ifremer.tutti.ui.swing.util.attachment.AttachmentModelAware;
import java.awt.Component;
import java.awt.Container;
import java.awt.event.ActionEvent;
import java.io.File;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JOptionPane;
import javax.swing.JRootPane;
import javax.swing.JToolBar;
import javax.swing.KeyStroke;
import jaxx.runtime.SwingUtil;
import jaxx.runtime.swing.ComponentMover;
import jaxx.runtime.swing.ComponentResizer;
import jaxx.runtime.validator.swing.SwingValidator;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.i18n.I18n;

public class AttachmentEditorUIHandler
extends AbstractTuttiUIHandler<TuttiUIContext, AttachmentEditorUI> {
    private static final Log log = LogFactory.getLog(AttachmentEditorUIHandler.class);
    public static final String CLOSE_DIALOG_ACTION = "closeDialog";
    public static final String SHOW_DIALOG_ACTION = "showDialog";
    protected final AttachmentEditorUI ui;
    protected final PersistenceService persistenceService;
    protected final TuttiUIContext context;
    protected Action closeAction;
    protected Action openAction;

    public AttachmentEditorUIHandler(TuttiUIContext context, AttachmentEditorUI ui) {
        super(context, ui);
        this.context = context;
        this.ui = ui;
        this.persistenceService = context.getPersistenceService();
    }

    @Override
    public void beforeInitUI() {
    }

    @Override
    public void afterInitUI() {
        this.ui.getFile().setDialogOwner((JDialog)this.ui);
        this.ui.pack();
        this.ui.setResizable(true);
        ComponentResizer cr = new ComponentResizer();
        cr.registerComponent(new Component[]{this.ui});
        ComponentMover cm = new ComponentMover();
        cm.setDragInsets(cr.getDragInsets());
        cm.registerComponent(new Component[]{this.ui});
        JRootPane rootPane = this.ui.getRootPane();
        KeyStroke shortcutClosePopup = KeyStroke.getKeyStroke(27, 0);
        rootPane.getInputMap(2).put(shortcutClosePopup, CLOSE_DIALOG_ACTION);
        this.closeAction = new AbstractAction(){
            private static final long serialVersionUID = 1L;

            @Override
            public void actionPerformed(ActionEvent e) {
                AttachmentEditorUIHandler.this.ui.dispose();
                AttachmentEditorUIHandler.this.ui.setVisible(false);
            }
        };
        this.openAction = new AbstractAction(){
            private static final long serialVersionUID = 1L;

            @Override
            public void actionPerformed(ActionEvent e) {
                AttachmentEditorUIHandler.this.ui.setVisible(true);
            }
        };
        ImageIcon actionIcon = SwingUtil.createActionIcon((String)"close-dialog");
        this.closeAction.putValue("SmallIcon", actionIcon);
        this.closeAction.putValue("SwingLargeIconKey", actionIcon);
        this.closeAction.putValue("ActionCommandKey", "close");
        this.closeAction.putValue("Name", "close");
        this.closeAction.putValue("ShortDescription", I18n._((String)"tutti.attachmentEditor.action.closeAttachment.tip", (Object[])new Object[0]));
        rootPane.getActionMap().put(CLOSE_DIALOG_ACTION, this.closeAction);
        rootPane.getActionMap().put(SHOW_DIALOG_ACTION, this.openAction);
        JButton closeButton = new JButton(this.closeAction);
        closeButton.setText(null);
        closeButton.setFocusPainted(false);
        closeButton.setRequestFocusEnabled(false);
        closeButton.setFocusable(false);
        JToolBar jToolBar = new JToolBar();
        jToolBar.setOpaque(false);
        jToolBar.add(this.closeAction);
        jToolBar.setBorderPainted(false);
        jToolBar.setFloatable(false);
        this.ui.getAttachmentBody().setRightDecoration((JComponent)jToolBar);
    }

    @Override
    public void onCloseUI() {
    }

    @Override
    public SwingValidator<TuttiUIContext> getValidator() {
        return null;
    }

    public void closeEditor() {
        this.closeAction.actionPerformed(null);
    }

    public void openEditor(JComponent component) {
        if (component != null) {
            this.place(component);
        }
        this.openAction.actionPerformed(null);
    }

    public void init() {
        List<Attachment> list;
        this.resetFields();
        this.ui.getAttachments().removeAll();
        AttachmentModelAware bean = this.ui.getBean();
        if (bean != null && (list = bean.getAttachment()) != null) {
            for (Attachment attachment : list) {
                this.addAttachment(attachment);
            }
        }
    }

    public void place(JComponent component) {
        int x = 0;
        int y = component.getHeight();
        for (Container comp = component; comp != null; comp = comp.getParent()) {
            x += ((Component)comp).getX();
            y += ((Component)comp).getY();
        }
        this.ui.pack();
        if (x + this.ui.getWidth() > this.ui.getOwner().getX() + this.ui.getOwner().getWidth()) {
            x = x - this.ui.getWidth() + component.getWidth();
        }
        this.ui.setLocation(x, y);
    }

    public void addAttachment() {
        AttachmentModelAware bean = this.ui.getBean();
        Attachment attachment = TuttiBeanFactory.newAttachment();
        File file = this.ui.getFile().getSelectedFile();
        if (file != null) {
            String name = this.ui.getFileName().getText();
            if (StringUtils.isEmpty((CharSequence)name)) {
                name = file.getName();
            }
            attachment.setObjectType(bean.getObjectType());
            attachment.setObjectId(Integer.valueOf(bean.getObjectId()));
            attachment.setName(name);
            attachment.setComment(this.ui.getFileComment().getText());
            attachment = this.persistenceService.createAttachment(attachment, file);
            bean.addAttachment(attachment);
            this.resetFields();
            this.addAttachment(attachment);
            this.ui.pack();
        }
    }

    protected void addAttachment(Attachment attachment) {
        AttachmentItem item = new AttachmentItem();
        item.setAttachment(attachment);
        item.setHandler(this);
        this.ui.getAttachments().add(item);
    }

    protected void resetFields() {
        this.ui.getFile().setSelectedFile((File)null);
        this.ui.getFile().setSelectedFile((String)null);
        this.ui.getFileName().setText("");
        this.ui.getFileComment().setText("");
    }

    public void openAttachment(Attachment attachment) {
        File file = this.persistenceService.getAttachmentFile(attachment.getId());
        try {
            TuttiUIUtil.openLink(file.toURI());
        }
        catch (TuttiTechnicalException e) {
            String message = e.getCause() instanceof TuttiTechnicalException ? e.getCause().getMessage() : I18n._((String)"swing.error.cannot.open.file", (Object[])new Object[0]);
            TuttiUIContext.getErrorHelper().showErrorDialog(message, e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void saveAttachment(Attachment attachment) {
        boolean hackDialog = this.ui.isAlwaysOnTop();
        if (hackDialog) {
            this.ui.setAlwaysOnTop(false);
        }
        try {
            boolean checkOverwrite;
            File attachmentFile = this.persistenceService.getAttachmentFile(attachment.getId());
            File file = TuttiUIUtil.saveFile(attachment.getName(), this.ui, I18n._((String)"tutti.attachmentEditor.saveAttachment.title", (Object[])new Object[0]), I18n._((String)"tutti.attachmentEditor.saveAttachment.button", (Object[])new Object[0]), new String[0]);
            if (file != null && (checkOverwrite = this.askOverwriteFile(file))) {
                TuttiIOUtil.copyFile((File)attachmentFile, (File)file, (String)"Error while saving attachment");
                this.context.showInformationMessage(I18n._((String)"tutti.attachmentEditor.saveAttachment.success.message", (Object[])new Object[]{file.getName()}));
            }
            if (hackDialog) {
                this.ui.setAlwaysOnTop(true);
            }
        }
        finally {
            if (hackDialog) {
                this.ui.setAlwaysOnTop(true);
            }
        }
    }

    public void removeAttachment(AttachmentItem attachmentItem) {
        Attachment attachment = attachmentItem.getAttachment();
        boolean hackDialog = this.ui.isAlwaysOnTop();
        if (hackDialog) {
            this.ui.setAlwaysOnTop(false);
        }
        int answer = JOptionPane.showConfirmDialog(this.ui, I18n._((String)"tutti.attachmentEditor.deleteAttachment.message", (Object[])new Object[]{attachment.getName()}), I18n._((String)"tutti.attachmentEditor.deleteAttachment.title", (Object[])new Object[0]), 0);
        if (hackDialog) {
            this.ui.setAlwaysOnTop(true);
        }
        if (answer == 0) {
            AttachmentModelAware bean = this.ui.getBean();
            this.persistenceService.deleteAttachment(attachment.getId());
            bean.removeAttachment(attachment);
            this.ui.getAttachments().remove(attachmentItem);
            this.ui.pack();
        }
    }
}

