/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.tutti.service;

import fr.ifremer.tutti.TuttiTechnicalException;
import fr.ifremer.tutti.persistence.entities.TuttiEntity;
import fr.ifremer.tutti.persistence.entities.referential.CaracteristicQualitativeValue;
import java.io.Serializable;
import java.io.Writer;
import java.text.ParseException;
import java.util.Collections;
import java.util.Date;
import java.util.Map;
import java.util.Set;
import org.apache.commons.beanutils.BeanUtilsBean;
import org.apache.commons.lang3.StringUtils;
import org.nuiton.util.csv.Common;
import org.nuiton.util.csv.ExportModel;
import org.nuiton.util.csv.ExportableColumn;
import org.nuiton.util.csv.ValueFormatter;
import org.nuiton.util.csv.ValueParser;
import org.nuiton.util.csv.ValueParserFormatter;
import org.nuiton.util.csv.ext.AbstractExportModel;
import org.nuiton.util.csv.ext.AbstractImportExportModel;
import org.nuiton.util.csv.ext.RepeatableExport;
import org.nuiton.util.decorator.Decorator;

public class TuttiCsvUtil
extends Common {
    public static final ValueParserFormatter<Date> YEAR = new Common.DateValue("yyyy");
    public static final ValueParserFormatter<Date> DAY_EMPTY_TIME = new Common.DateValue("dd/MM/yyyy 00:00:00");
    public static final ValueParserFormatter<Date> TIME = new Common.DateValue("HH:mm:ss");
    public static final ValueFormatter<Serializable> CARACTERISTIC_VALUE_FORMATTER = new CaracteristicValueFormatter();

    public static <E> BeanPropertyFormatter<E> newBeanFormatter(String propertyName, String defaultNullValue) {
        return new BeanPropertyFormatter(propertyName, defaultNullValue);
    }

    public static <E> DecoatorPropertyFormatter<E> newDecoratorFormatter(Decorator<E> decorator, String defaultNullValue) {
        return new DecoatorPropertyFormatter<E>(decorator, defaultNullValue);
    }

    public static <E> TuttiRepeatableExport<E> newRepeatableExport(ExportModel<E> model) {
        return new TuttiRepeatableExport<E>(model);
    }

    protected TuttiCsvUtil() {
    }

    protected static class CaracteristicValueFormatter
    implements ValueFormatter<Serializable> {
        ValueParserFormatter<Integer> integerDelegate = Common.INTEGER;
        ValueParserFormatter<Float> floatDelegate = Common.FLOAT;
        ValueParserFormatter<String> textDelegate = Common.STRING;

        protected CaracteristicValueFormatter() {
        }

        public String format(Serializable value) {
            if (value instanceof Float) {
                return this.floatDelegate.format((Object)((Float)value));
            }
            if (value instanceof Integer) {
                return this.integerDelegate.format((Object)((Integer)value));
            }
            if (value instanceof String) {
                return this.textDelegate.format((Object)((String)((Object)value)));
            }
            CaracteristicQualitativeValue qv = (CaracteristicQualitativeValue)value;
            return qv.getName();
        }
    }

    public static class TuttiRepeatableExport<E>
    extends RepeatableExport<E> {
        public TuttiRepeatableExport(ExportModel<E> model) {
            super(model, Collections.emptyList(), true);
        }

        public void write(Iterable<E> data, Writer writer) throws Exception {
            this.data = data;
            this.write(writer);
        }
    }

    public static class DecoatorPropertyFormatter<E>
    implements ValueFormatter<E> {
        protected final String defaultNullValue;
        protected Decorator<E> decorator;

        DecoatorPropertyFormatter(Decorator<E> decorator, String defaultNullValue) {
            this.decorator = decorator;
            this.defaultNullValue = defaultNullValue;
        }

        public String format(E value) {
            if (value == null) {
                return this.defaultNullValue;
            }
            try {
                return this.decorator.toString(value);
            }
            catch (Exception e) {
                throw new TuttiTechnicalException("Could not format value", (Throwable)e);
            }
        }
    }

    public static class BeanPropertyFormatter<E>
    implements ValueFormatter<E> {
        protected final String defaultNullValue;
        protected String propertyName;

        BeanPropertyFormatter(String propertyName, String defaultNullValue) {
            this.propertyName = propertyName;
            this.defaultNullValue = defaultNullValue;
        }

        public String format(E value) {
            if (value == null) {
                return this.defaultNullValue;
            }
            try {
                return (String)BeanUtilsBean.getInstance().getPropertyUtils().getNestedProperty(value, this.propertyName);
            }
            catch (Exception e) {
                throw new TuttiTechnicalException("Could not format value", (Throwable)e);
            }
        }
    }

    public static class NotExistingKeyValue
    implements ValueParserFormatter<String> {
        protected final String propertyName;
        protected final Set<String> existingValues;

        public NotExistingKeyValue(String propertyName, Set<String> universe) {
            this.propertyName = propertyName;
            this.existingValues = universe;
        }

        public String parse(String value) throws ParseException {
            if (StringUtils.isNotBlank((CharSequence)value) && this.existingValues.contains(value)) {
                throw new RuntimeException("Property '" + this.propertyName + "' with value " + value + " is already defined.");
            }
            return value;
        }

        public String format(String e) {
            return e;
        }
    }

    public static class ForeignKeyValue<E extends TuttiEntity>
    implements ValueParserFormatter<E> {
        protected final String propertyName;
        protected final Class<E> entityType;
        protected final Map<String, E> universe;

        public ForeignKeyValue(Class<E> entityType, String propertyName, Map<String, E> universe) {
            this.entityType = entityType;
            this.propertyName = propertyName;
            this.universe = universe;
        }

        public E parse(String value) throws ParseException {
            TuttiEntity result = null;
            if (StringUtils.isNotBlank((CharSequence)value) && (result = (TuttiEntity)this.universe.get(value)) == null) {
                throw new RuntimeException("Could not find entity of type " + this.entityType.getSimpleName() + " with '" + this.propertyName + "' = " + value);
            }
            return (E)result;
        }

        public String format(E e) {
            String value = "";
            if (e != null) {
                value = e.getId();
            }
            return value;
        }
    }

    public static class StringParserFormatter
    extends Common.NullableParserFormatter<String> {
        public StringParserFormatter(String defaultValue, boolean nullAllowed) {
            super((Object)defaultValue, nullAllowed);
        }

        public String format(String value) {
            String str = "";
            if (value != null) {
                str = String.valueOf(value);
            }
            return str;
        }

        protected String parseNoneEmptyValue(String value) {
            return value;
        }
    }

    public static abstract class AbstractTuttiExportModel<M>
    extends AbstractExportModel<M> {
        public AbstractTuttiExportModel(char separator) {
            super(separator);
        }

        public <T> ExportableColumn<M, T> newColumnForExportByDecorator(String headerName, String propertyName, Decorator<T> decorator) {
            return this.newColumnForExportByDecorator(headerName, propertyName, decorator, null);
        }

        public <T> ExportableColumn<M, T> newColumnForExportByDecorator(String headerName, String propertyName, Decorator<T> decorator, String defaultNullValue) {
            DecoatorPropertyFormatter<T> valueFormatter = TuttiCsvUtil.newDecoratorFormatter(decorator, defaultNullValue);
            return this.modelBuilder.newColumnForExport(headerName, propertyName, valueFormatter);
        }

        public <T> ExportableColumn<M, T> newColumnForExport(String headerName, String propertyName, String formatterPropertyName) {
            return this.newColumnForExport(headerName, propertyName, formatterPropertyName, null);
        }

        public <T> ExportableColumn<M, T> newColumnForExport(String headerName, String propertyName, String formatterPropertyName, String defaultNullValue) {
            BeanPropertyFormatter valueFormatter = TuttiCsvUtil.newBeanFormatter(formatterPropertyName, defaultNullValue);
            return this.modelBuilder.newColumnForExport(headerName, propertyName, valueFormatter);
        }

        public <E extends TuttiEntity> ForeignKeyValue<E> newForeignKeyValue(Class<E> type, String propertyName, Map<String, E> universe) {
            return new ForeignKeyValue<E>(type, propertyName, universe);
        }
    }

    public static abstract class AbstractTuttiImportExportModel<M>
    extends AbstractImportExportModel<M> {
        public AbstractTuttiImportExportModel(char separator) {
            super(separator);
        }

        public <T> ExportableColumn<M, T> newColumnForExportByDecorator(String headerName, String propertyName, Decorator<T> decorator) {
            return this.newColumnForExportByDecorator(headerName, propertyName, decorator, null);
        }

        public <T> ExportableColumn<M, T> newColumnForExportByDecorator(String headerName, String propertyName, Decorator<T> decorator, String defaultNullValue) {
            DecoatorPropertyFormatter<T> valueFormatter = TuttiCsvUtil.newDecoratorFormatter(decorator, defaultNullValue);
            return this.modelBuilder.newColumnForExport(headerName, propertyName, valueFormatter);
        }

        public <T> ExportableColumn<M, T> newColumnForExport(String headerName, String propertyName, String formatterPropertyName) {
            return this.newColumnForExport(headerName, propertyName, formatterPropertyName, null);
        }

        public <T> ExportableColumn<M, T> newColumnForExport(String headerName, String propertyName, String formatterPropertyName, String defaultNullValue) {
            BeanPropertyFormatter valueFormatter = TuttiCsvUtil.newBeanFormatter(formatterPropertyName, defaultNullValue);
            return this.modelBuilder.newColumnForExport(headerName, propertyName, valueFormatter);
        }

        public <E extends TuttiEntity> void newForeignKeyColumn(String headerName, String propertyName, Class<E> entityType, String foreignKeyName, Map<String, E> universe) {
            this.newMandatoryColumn(headerName, propertyName, (ValueParser)this.newForeignKeyValue(entityType, foreignKeyName, universe));
        }

        public <E extends TuttiEntity> void newForeignKeyColumn(String propertyName, Class<E> entityType, String foreignKeyName, Map<String, E> universe) {
            this.newMandatoryColumn(propertyName, propertyName, (ValueParser)this.newForeignKeyValue(entityType, foreignKeyName, universe));
        }

        public <E extends TuttiEntity> ForeignKeyValue<E> newForeignKeyValue(Class<E> type, String propertyName, Map<String, E> universe) {
            return new ForeignKeyValue<E>(type, propertyName, universe);
        }

        public void newNotExistingValueColumn(String propertyName, Set<String> universe) {
            this.newNotExistingValueColumn(propertyName, propertyName, universe);
        }

        public void newNotExistingValueColumn(String headerName, String propertyName, Set<String> universe) {
            this.newMandatoryColumn(headerName, propertyName, (ValueParser)new NotExistingKeyValue(propertyName, universe));
        }
    }
}

