package fr.ifremer.tutti.ui.swing.content.operation.catches.plankton;

/*
 * #%L
 * Tutti :: UI
 * $Id: PlanktonBatchRowModel.java 723 2013-04-03 18:25:40Z tchemit $
 * $HeadURL: http://svn.forge.codelutin.com/svn/tutti/tags/tutti-1.3/tutti-ui-swing/src/main/java/fr/ifremer/tutti/ui/swing/content/operation/catches/plankton/PlanktonBatchRowModel.java $
 * %%
 * Copyright (C) 2012 Ifremer
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 3 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-3.0.html>.
 * #L%
 */

import com.google.common.collect.Lists;
import fr.ifremer.tutti.persistence.entities.TuttiBeanFactory;
import fr.ifremer.tutti.persistence.entities.data.AttachementObjectTypeEnum;
import fr.ifremer.tutti.persistence.entities.data.Attachment;
import fr.ifremer.tutti.persistence.entities.data.FishingOperation;
import fr.ifremer.tutti.persistence.entities.data.PlanktonBatch;
import fr.ifremer.tutti.persistence.entities.referential.Species;
import fr.ifremer.tutti.ui.swing.util.AbstractTuttiBeanUIModel;
import fr.ifremer.tutti.ui.swing.util.attachment.AttachmentModelAware;
import org.nuiton.util.beans.Binder;
import org.nuiton.util.beans.BinderFactory;

import java.util.Collection;
import java.util.List;

/**
 * Define a benthos batch row.
 *
 * @author tchemit <chemit@codelutin.com>
 * @since 0.2
 */
public class PlanktonBatchRowModel extends AbstractTuttiBeanUIModel<PlanktonBatch, PlanktonBatchRowModel> implements AttachmentModelAware, PlanktonBatch {

    private static final long serialVersionUID = 1L;

    public static final String PROPERTY_SPECIES = "species";

    public static final String PROPERTY_SPECIES_TO_CONFIRM = "speciesToConfirm";

    public static final String PROPERTY_WEIGHT = "weight";

    public static final String PROPERTY_SAMPLE_WEIGHT = "sampleWeight";

    /**
     * Delegate edit object.
     *
     * @since 1.3
     */
    protected final PlanktonBatch editObject =
            TuttiBeanFactory.newPlanktonBatch();

    /**
     * Is the species need to be confirmed?.
     *
     * @since 0.2
     */
    protected boolean speciesToConfirm;

    /**
     * Attachments (should never be null).
     *
     * @since 0.2
     */
    protected final List<Attachment> attachment = Lists.newArrayList();

    protected static final Binder<PlanktonBatch, PlanktonBatchRowModel> fromBeanBinder =
            BinderFactory.newBinder(PlanktonBatch.class,
                                    PlanktonBatchRowModel.class);

    protected static final Binder<PlanktonBatchRowModel, PlanktonBatch> toBeanBinder =
            BinderFactory.newBinder(PlanktonBatchRowModel.class,
                                    PlanktonBatch.class);

    public PlanktonBatchRowModel() {
        super(PlanktonBatch.class, fromBeanBinder, toBeanBinder);
    }

    public PlanktonBatchRowModel(PlanktonBatch aBatch) {
        this();
        fromBean(aBatch);
    }

    @Override
    protected PlanktonBatch newEntity() {
        return TuttiBeanFactory.newPlanktonBatch();
    }

    public boolean isSpeciesToConfirm() {
        return speciesToConfirm;
    }

    public void setSpeciesToConfirm(boolean speciesToConfirm) {
        Object oldValue = isSpeciesToConfirm();
        this.speciesToConfirm = speciesToConfirm;
        firePropertyChange(PROPERTY_SPECIES_TO_CONFIRM, oldValue, speciesToConfirm);
    }

    //------------------------------------------------------------------------//
    //-- PlanktonBatch                                                      --//
    //------------------------------------------------------------------------//

    @Override
    public Species getSpecies() {
        return editObject.getSpecies();
    }

    @Override
    public void setSpecies(Species species) {
        Object oldValue = getSpecies();
        editObject.setSpecies(species);
        firePropertyChange(PROPERTY_SPECIES, oldValue, species);
    }

    @Override
    public FishingOperation getFishingOperation() {
        return editObject.getFishingOperation();
    }

    @Override
    public void setFishingOperation(FishingOperation fishingOperation) {
        editObject.setFishingOperation(fishingOperation);
    }

    @Override
    public Float getWeight() {
        return editObject.getWeight();
    }

    @Override
    public void setWeight(Float weight) {
        Object oldValue = getWeight();
        editObject.setWeight(weight);
        firePropertyChange(PROPERTY_WEIGHT, oldValue, weight);
    }

    @Override
    public Float getSampleWeight() {
        return editObject.getSampleWeight();
    }

    @Override
    public void setSampleWeight(Float sampleWeight) {
        Object oldValue = getSampleWeight();
        editObject.setSampleWeight(sampleWeight);
        firePropertyChange(PROPERTY_SAMPLE_WEIGHT, oldValue, sampleWeight);
    }

    @Override
    public String getComment() {
        return editObject.getComment();
    }

    @Override
    public void setComment(String comment) {
        Object oldValue = getComment();
        editObject.setComment(comment);
        firePropertyChange(PROPERTY_COMMENT, oldValue, comment);
    }

    //------------------------------------------------------------------------//
    //-- AttachmentModelAware                                               --//
    //------------------------------------------------------------------------//

    @Override
    public AttachementObjectTypeEnum getObjectType() {
        return AttachementObjectTypeEnum.SAMPLE;
    }

    @Override
    public String getObjectId() {
        return getId();
    }

    @Override
    public List<Attachment> getAttachment() {
        return attachment;
    }

    @Override
    public void addAllAttachment(Collection<Attachment> attachments) {
        this.attachment.addAll(attachments);
        firePropertyChange(PROPERTY_ATTACHMENT, null, getAttachment());
    }

    @Override
    public void addAttachment(Attachment attachment) {
        this.attachment.add(attachment);
        firePropertyChange(PROPERTY_ATTACHMENT, null, getAttachment());
    }

    @Override
    public void removeAllAttachment(Collection<Attachment> attachments) {
        this.attachment.removeAll(attachments);
        firePropertyChange(PROPERTY_ATTACHMENT, null, getAttachment());
    }

    @Override
    public void removeAttachment(Attachment attachment) {
        this.attachment.remove(attachment);
        firePropertyChange(PROPERTY_ATTACHMENT, null, getAttachment());
    }
}
