/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.tutti.ui.swing.content.operation.catches.plankton;

import com.google.common.collect.Lists;
import fr.ifremer.tutti.persistence.entities.data.AttachementObjectTypeEnum;
import fr.ifremer.tutti.persistence.entities.data.Attachment;
import fr.ifremer.tutti.persistence.entities.data.PlanktonBatch;
import fr.ifremer.tutti.persistence.entities.referential.Species;
import fr.ifremer.tutti.ui.swing.util.AbstractTuttiBeanUIModel;
import fr.ifremer.tutti.ui.swing.util.attachment.AttachmentModelAware;
import fr.ifremer.tutti.ui.swing.util.comment.CommentModelAware;
import java.util.Collection;
import java.util.List;
import org.nuiton.util.beans.Binder;
import org.nuiton.util.beans.BinderFactory;

public class PlanktonBatchRowModel
extends AbstractTuttiBeanUIModel<PlanktonBatch, PlanktonBatchRowModel>
implements AttachmentModelAware,
CommentModelAware {
    private static final long serialVersionUID = 1L;
    public static final String PROPERTY_SPECIES = "species";
    public static final String PROPERTY_SPECIES_TO_CONFIRM = "speciesToConfirm";
    public static final String PROPERTY_WEIGHT = "weight";
    public static final String PROPERTY_SAMPLE_WEIGHT = "sampleWeight";
    protected Species species;
    protected boolean speciesToConfirm;
    protected Float weight;
    protected Float sampleWeight;
    protected String comment;
    protected final List<Attachment> attachment = Lists.newArrayList();
    protected static final Binder<PlanktonBatch, PlanktonBatchRowModel> fromBeanBinder = BinderFactory.newBinder(PlanktonBatch.class, PlanktonBatchRowModel.class);
    protected static final Binder<PlanktonBatchRowModel, PlanktonBatch> toBeanBinder = BinderFactory.newBinder(PlanktonBatchRowModel.class, PlanktonBatch.class);

    public PlanktonBatchRowModel() {
        super(PlanktonBatch.class, fromBeanBinder, toBeanBinder);
    }

    public PlanktonBatchRowModel(PlanktonBatch aBatch) {
        this();
        this.fromBean(aBatch);
    }

    public Species getSpecies() {
        return this.species;
    }

    public void setSpecies(Species species) {
        Species oldValue = this.getSpecies();
        this.species = species;
        this.firePropertyChange(PROPERTY_SPECIES, oldValue, species);
    }

    public Boolean getSpeciesToConfirm() {
        return this.speciesToConfirm;
    }

    public void setSpeciesToConfirm(Boolean speciesToConfirm) {
        Boolean oldValue = this.getSpeciesToConfirm();
        this.speciesToConfirm = speciesToConfirm;
        this.firePropertyChange(PROPERTY_SPECIES_TO_CONFIRM, oldValue, speciesToConfirm);
    }

    public Float getWeight() {
        return this.weight;
    }

    public void setWeight(Float weight) {
        Float oldValue = this.getWeight();
        this.weight = weight;
        this.firePropertyChange(PROPERTY_WEIGHT, oldValue, weight);
    }

    public Float getSampleWeight() {
        return this.sampleWeight;
    }

    public void setSampleWeight(Float sampleWeight) {
        Float oldValue = this.getSampleWeight();
        this.sampleWeight = sampleWeight;
        this.firePropertyChange(PROPERTY_SAMPLE_WEIGHT, oldValue, sampleWeight);
    }

    @Override
    public String getComment() {
        return this.comment;
    }

    @Override
    public void setComment(String comment) {
        String oldValue = this.getComment();
        this.comment = comment;
        this.firePropertyChange("comment", oldValue, comment);
    }

    @Override
    public AttachementObjectTypeEnum getObjectType() {
        return AttachementObjectTypeEnum.SAMPLE;
    }

    @Override
    public String getObjectId() {
        return this.getId();
    }

    @Override
    public List<Attachment> getAttachment() {
        return this.attachment;
    }

    @Override
    public void addAllAttachment(Collection<Attachment> attachments) {
        this.attachment.addAll(attachments);
        this.firePropertyChange("attachment", null, this.getAttachment());
    }

    @Override
    public void addAttachment(Attachment attachment) {
        this.attachment.add(attachment);
        this.firePropertyChange("attachment", null, this.getAttachment());
    }

    @Override
    public void removeAllAttachment(Collection<Attachment> attachments) {
        this.attachment.removeAll(attachments);
        this.firePropertyChange("attachment", null, this.getAttachment());
    }

    @Override
    public void removeAttachment(Attachment attachment) {
        this.attachment.remove(attachment);
        this.firePropertyChange("attachment", null, this.getAttachment());
    }
}

