/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.adagio.core.dao.referential.seller;

import fr.ifremer.adagio.core.dao.PaginationResult;
import fr.ifremer.adagio.core.dao.PrincipalStore;
import fr.ifremer.adagio.core.dao.PropertySearch;
import fr.ifremer.adagio.core.dao.Search;
import fr.ifremer.adagio.core.dao.referential.location.Location;
import fr.ifremer.adagio.core.dao.referential.seller.Seller;
import fr.ifremer.adagio.core.dao.referential.seller.SellerDao;
import fr.ifremer.adagio.core.dao.referential.seller.SellerImpl;
import fr.ifremer.adagio.core.dao.referential.seller.SellerType;
import fr.ifremer.adagio.core.dao.technical.hibernate.HibernateDaoSupport;
import java.io.Serializable;
import java.security.Principal;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.hibernate.Criteria;
import org.hibernate.HibernateException;
import org.hibernate.Session;
import org.springframework.orm.hibernate3.HibernateCallback;

public abstract class SellerDaoBase
extends HibernateDaoSupport
implements SellerDao {
    @Override
    public Object load(int transform, Integer id) {
        if (id == null) {
            throw new IllegalArgumentException("Seller.load - 'id' can not be null");
        }
        Integer entityPk = id;
        Object entity = this.getHibernateTemplate().get(SellerImpl.class, (Serializable)entityPk);
        return this.transformEntity(transform, (Seller)entity);
    }

    @Override
    public Seller load(Integer id) {
        return (Seller)this.load(0, id);
    }

    @Override
    public Collection<Seller> loadAll() {
        return this.loadAll(0);
    }

    @Override
    public Collection<?> loadAll(int transform) {
        return this.loadAll(transform, -1, -1);
    }

    @Override
    public Collection<?> loadAll(int pageNumber, int pageSize) {
        return this.loadAll(0, pageNumber, pageSize);
    }

    @Override
    public Collection<?> loadAll(int transform, int pageNumber, int pageSize) {
        try {
            Criteria criteria = this.getSession(false).createCriteria(SellerImpl.class);
            if (pageNumber > 0 && pageSize > 0) {
                criteria.setFirstResult(this.calculateFirstResult(pageNumber, pageSize));
                criteria.setMaxResults(pageSize);
            }
            List results = criteria.list();
            this.transformEntities(transform, results);
            return results;
        }
        catch (HibernateException ex) {
            throw super.convertHibernateAccessException(ex);
        }
    }

    private int calculateFirstResult(int pageNumber, int pageSize) {
        int firstResult = 0;
        if (pageNumber > 0) {
            firstResult = (pageNumber - 1) * pageSize;
        }
        return firstResult;
    }

    @Override
    public Seller create(Seller seller) {
        return (Seller)this.create(0, seller);
    }

    @Override
    public Object create(int transform, Seller seller) {
        if (seller == null) {
            throw new IllegalArgumentException("Seller.create - 'seller' can not be null");
        }
        this.getHibernateTemplate().save((Object)seller);
        return this.transformEntity(transform, seller);
    }

    @Override
    public Collection<Seller> create(Collection<Seller> entities) {
        return this.create(0, entities);
    }

    @Override
    public Collection<?> create(final int transform, final Collection<Seller> entities) {
        if (entities == null) {
            throw new IllegalArgumentException("Seller.create - 'entities' can not be null");
        }
        this.getHibernateTemplate().execute(new HibernateCallback(){

            public Object doInHibernate(Session session) throws HibernateException {
                Iterator entityIterator = entities.iterator();
                while (entityIterator.hasNext()) {
                    SellerDaoBase.this.create(transform, (Seller)entityIterator.next());
                }
                return null;
            }
        });
        return entities;
    }

    @Override
    public Seller create(String registrationCode, String name, SellerType sellerType, Location baseSaleLocation) {
        return (Seller)this.create(0, registrationCode, name, sellerType, baseSaleLocation);
    }

    @Override
    public Object create(int transform, String registrationCode, String name, SellerType sellerType, Location baseSaleLocation) {
        SellerImpl entity = new SellerImpl();
        entity.setRegistrationCode(registrationCode);
        entity.setName(name);
        entity.setSellerType(sellerType);
        entity.setBaseSaleLocation(baseSaleLocation);
        return this.create(transform, entity);
    }

    @Override
    public Seller create(SellerType sellerType) {
        return (Seller)this.create(0, sellerType);
    }

    @Override
    public Object create(int transform, SellerType sellerType) {
        SellerImpl entity = new SellerImpl();
        entity.setSellerType(sellerType);
        return this.create(transform, entity);
    }

    @Override
    public void update(Seller seller) {
        if (seller == null) {
            throw new IllegalArgumentException("Seller.update - 'seller' can not be null");
        }
        this.getHibernateTemplate().update((Object)seller);
    }

    @Override
    public void update(final Collection<Seller> entities) {
        if (entities == null) {
            throw new IllegalArgumentException("Seller.update - 'entities' can not be null");
        }
        this.getHibernateTemplate().execute(new HibernateCallback(){

            public Object doInHibernate(Session session) throws HibernateException {
                Iterator entityIterator = entities.iterator();
                while (entityIterator.hasNext()) {
                    SellerDaoBase.this.update((Seller)entityIterator.next());
                }
                return null;
            }
        });
    }

    @Override
    public void remove(Seller seller) {
        if (seller == null) {
            throw new IllegalArgumentException("Seller.remove - 'seller' can not be null");
        }
        this.getHibernateTemplate().delete((Object)seller);
    }

    @Override
    public void remove(Integer id) {
        if (id == null) {
            throw new IllegalArgumentException("Seller.remove - 'id' can not be null");
        }
        Integer entityPk = id;
        Seller entity = this.load(id);
        if (entity != null) {
            this.remove(entity);
        }
    }

    @Override
    public void remove(Collection<Seller> entities) {
        if (entities == null) {
            throw new IllegalArgumentException("Seller.remove - 'entities' can not be null");
        }
        this.getHibernateTemplate().deleteAll(entities);
    }

    protected Object transformEntity(int transform, Seller entity) {
        Seller target = null;
        if (entity != null) {
            switch (transform) {
                default: 
            }
            target = entity;
        }
        return target;
    }

    protected void transformEntities(int transform, Collection<?> entities) {
        switch (transform) {
            default: 
        }
    }

    protected Seller toEntity(Object[] row) {
        Seller target = null;
        if (row != null) {
            for (Object object : row) {
                if (!(object instanceof Seller)) continue;
                target = (Seller)object;
                break;
            }
        }
        return target;
    }

    protected Principal getPrincipal() {
        return PrincipalStore.get();
    }

    @Override
    public PaginationResult search(int transform, int pageNumber, int pageSize, Search search) {
        try {
            search.setPageNumber(pageNumber);
            search.setPageSize(pageSize);
            PropertySearch propertySearch = new PropertySearch(this.getSession(false), SellerImpl.class, search);
            List results = propertySearch.executeAsList();
            this.transformEntities(transform, results);
            return new PaginationResult(results.toArray(new Object[0]), propertySearch.getTotalCount());
        }
        catch (HibernateException ex) {
            throw super.convertHibernateAccessException(ex);
        }
    }

    @Override
    public PaginationResult search(int pageNumber, int pageSize, Search search) {
        return this.search(0, pageNumber, pageSize, search);
    }

    @Override
    public Set<?> search(int transform, Search search) {
        try {
            PropertySearch propertySearch = new PropertySearch(this.getSession(false), SellerImpl.class, search);
            Set results = propertySearch.executeAsSet();
            this.transformEntities(transform, results);
            return results;
        }
        catch (HibernateException ex) {
            throw super.convertHibernateAccessException(ex);
        }
    }

    @Override
    public Set<Seller> search(Search search) {
        return this.search(0, search);
    }
}

