/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.adagio.core.dao.data.batch;

import fr.ifremer.adagio.core.dao.data.batch.Batch;
import fr.ifremer.adagio.core.dao.data.batch.CatchBatch;
import fr.ifremer.adagio.core.dao.data.batch.CatchBatchDao;
import fr.ifremer.adagio.core.dao.data.batch.SortingBatch;
import fr.ifremer.adagio.core.dao.data.batch.validator.CatchBatchValidationError;
import fr.ifremer.adagio.core.dao.data.batch.validator.CatchBatchValidationException;
import fr.ifremer.adagio.core.dao.data.batch.validator.CatchBatchValidator;
import fr.ifremer.adagio.core.dao.data.measure.QuantificationMeasurement;
import fr.ifremer.adagio.core.dao.data.measure.SortingMeasurement;
import java.util.Collection;
import java.util.List;
import org.springframework.cache.annotation.CacheEvict;
import org.springframework.cache.annotation.Cacheable;
import org.springframework.dao.DataRetrievalFailureException;

public interface CatchBatchExtendDao
extends CatchBatchDao {
    public void registerCatchBatchValidator(CatchBatchValidator var1);

    public void unregisterCatchBatchValidator(CatchBatchValidator var1);

    public CatchBatch loadFullTree(Integer var1);

    public CatchBatch loadFullTree(Integer var1, boolean var2, boolean var3) throws CatchBatchValidationException;

    @Cacheable(value={"fr.ifremer.adagio.core.dao.data.batch.CatchBatchCache"}, key="#catchBatchId", condition="#useCache == true")
    @CacheEvict(value={"fr.ifremer.adagio.core.dao.data.batch.CatchBatchCache"}, beforeInvocation=true, key="#catchBatchId", condition="#useCache==true and #forceReload==true")
    public CatchBatch loadFullTreeWithCache(Integer var1, boolean var2, boolean var3);

    public List<CatchBatchValidationError> validate(CatchBatch var1);

    public SortingBatch getSortingBatch(Collection<Batch> var1, Object ... var2);

    public SortingBatch getSortingBatchById(CatchBatch var1, Integer var2);

    public Integer getIdByFishingOperationId(Integer var1) throws DataRetrievalFailureException;

    public Integer getIdBySortingBatchId(Integer var1) throws DataRetrievalFailureException;

    @CacheEvict(value={"fr.ifremer.adagio.core.dao.data.batch.CatchBatchCache"}, key="#parentCatchBatch.id")
    public void removeWithChildren(Integer var1, CatchBatch var2);

    @CacheEvict(value={"fr.ifremer.adagio.core.dao.data.batch.CatchBatchCache"}, allEntries=true)
    public void removeWithChildren(Integer var1);

    public SortingMeasurement getSortingMeasurement(SortingBatch var1, Integer var2, Integer var3, boolean var4);

    public QuantificationMeasurement getQuantificationMeasurement(Batch var1, Integer var2, Integer var3, boolean var4);

    public QuantificationMeasurement setQuantificationMeasurement(Batch var1, Integer var2, Integer var3, Float var4, boolean var5);

    public SortingMeasurement getInheritedSortingMeasurement(SortingBatch var1, Integer var2);

    @CacheEvict(value={"fr.ifremer.adagio.core.dao.data.batch.CatchBatchCache"}, allEntries=true)
    public void setSortingBatchReferenceTaxon(String var1, Integer var2);

    @Override
    @CacheEvict(value={"fr.ifremer.adagio.core.dao.data.batch.CatchBatchCache"}, key="#catchBatch.id")
    public void update(CatchBatch var1);

    @CacheEvict(value={"fr.ifremer.adagio.core.dao.data.batch.CatchBatchCache"}, key="#parentCatchBatch.id")
    public SortingBatch createSortingBatch(SortingBatch var1, CatchBatch var2);

    public SortingBatch loadSortingBatch(Integer var1, CatchBatch var2);

    @CacheEvict(value={"fr.ifremer.adagio.core.dao.data.batch.CatchBatchCache"}, key="#parentCatchBatch.id")
    public void updateSortingBatch(SortingBatch var1, CatchBatch var2);

    @CacheEvict(value={"fr.ifremer.adagio.core.dao.data.batch.CatchBatchCache"}, key="#parentCatchBatch.id")
    public void updateSortingBatch(List<SortingBatch> var1, CatchBatch var2);
}

