/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.tutti.persistence.service;

import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import fr.ifremer.adagio.core.dao.data.batch.Batch;
import fr.ifremer.adagio.core.dao.data.batch.CatchBatch;
import fr.ifremer.adagio.core.dao.data.batch.CatchBatchExtendDao;
import fr.ifremer.adagio.core.dao.data.batch.SortingBatch;
import fr.ifremer.adagio.core.dao.data.batch.validator.CatchBatchValidationException;
import fr.ifremer.adagio.core.dao.data.batch.validator.CatchBatchValidator;
import fr.ifremer.adagio.core.dao.data.measure.QuantificationMeasurement;
import fr.ifremer.adagio.core.dao.data.measure.SortingMeasurement;
import fr.ifremer.adagio.core.dao.data.operation.FishingOperation;
import fr.ifremer.adagio.core.dao.data.operation.FishingOperationImpl;
import fr.ifremer.adagio.core.dao.referential.QualityFlag;
import fr.ifremer.adagio.core.dao.referential.QualityFlagImpl;
import fr.ifremer.adagio.core.dao.referential.taxon.ReferenceTaxon;
import fr.ifremer.adagio.core.dao.referential.taxon.ReferenceTaxonImpl;
import fr.ifremer.adagio.core.dao.technical.synchronization.SynchronizationStatus;
import fr.ifremer.tutti.persistence.entities.data.CatchBatch;
import fr.ifremer.tutti.persistence.service.AbstractPersistenceService;
import fr.ifremer.tutti.persistence.service.CatchBatchPersistenceService;
import fr.ifremer.tutti.persistence.service.ReferentialPersistenceService;
import fr.ifremer.tutti.persistence.service.batch.BatchPersistenceHelper;
import java.io.Serializable;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import javax.annotation.Resource;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.hibernate.FlushMode;
import org.hibernate.type.IntegerType;
import org.springframework.dao.DataIntegrityViolationException;
import org.springframework.dao.DataRetrievalFailureException;
import org.springframework.stereotype.Service;

@Service(value="batchPersistenceService")
public class CatchBatchPersistenceServiceImpl
extends AbstractPersistenceService
implements CatchBatchPersistenceService {
    private static final Log log = LogFactory.getLog(CatchBatchPersistenceServiceImpl.class);
    @Resource(name="referentialPersistenceService")
    protected ReferentialPersistenceService referentialService;
    @Resource(name="catchBatchDao")
    protected CatchBatchExtendDao catchBatchDao;
    @Resource(name="scientificCruiseCatchBatchValidator")
    protected CatchBatchValidator catchBatchValidator;
    @Resource(name="batchPersistenceHelper")
    protected BatchPersistenceHelper batchHelper;

    @Override
    public void init() {
        super.init();
        this.catchBatchDao.registerCatchBatchValidator(this.catchBatchValidator);
    }

    @Override
    public void close() {
        this.catchBatchDao.unregisterCatchBatchValidator(this.catchBatchValidator);
        super.close();
    }

    @Override
    public CatchBatch getCatchBatchFromFishingOperation(String fishingOperationId) throws CatchBatchValidationException {
        SortingBatch horsVracBatch;
        Preconditions.checkNotNull((Object)fishingOperationId);
        Integer catchBatchId = this.catchBatchDao.getIdByFishingOperationId(Integer.valueOf(fishingOperationId));
        Preconditions.checkNotNull((Object)catchBatchId);
        fr.ifremer.adagio.core.dao.data.batch.CatchBatch source = this.catchBatchDao.loadFullTree(catchBatchId, true, false);
        CatchBatch result = new CatchBatch();
        result.setId(source.getId());
        result.setCatchTotalWeight(source.getWeight());
        if (log.isInfoEnabled()) {
            log.info((Object)("Loaded CatchBatch: " + result.getId()));
        }
        SortingBatch vracBatch = this.catchBatchDao.getSortingBatch(source.getChildBatchs(), new Object[]{"pmfmId", this.enumeration.PMFM_ID_SORTED_UNSORTED, this.enumeration.QUALITATIVE_VRAC_ID});
        if (log.isInfoEnabled()) {
            log.info((Object)("Loaded CatchBatch Vrac: " + vracBatch.getId()));
        }
        result.setCatchTotalSortedCarousselWeight(vracBatch.getWeight());
        result.setCatchTotalSortedTremisWeight(vracBatch.getWeightBeforeSampling());
        SortingBatch speciesBatch = this.catchBatchDao.getSortingBatch(vracBatch.getChildBatchs(), new Object[]{"pmfmId", this.enumeration.PMFM_ID_SORTING_TYPE, this.enumeration.QUALITATIVE_ID_SORTING_TYPE_SPECIES});
        if (log.isInfoEnabled()) {
            log.info((Object)("Loaded CatchBatch Vrac > Species : " + speciesBatch.getId()));
        }
        result.setSpeciesTotalSortedWeight(speciesBatch.getWeight());
        SortingBatch inertBatch = this.catchBatchDao.getSortingBatch(speciesBatch.getChildBatchs(), new Object[]{"referenceTaxonId", this.enumeration.REFERENCE_TAXON_ID_INERT});
        if (log.isInfoEnabled()) {
            log.info((Object)("Loaded CatchBatch Vrac > Species > Inert: " + inertBatch.getId()));
        }
        if (inertBatch != null) {
            result.setSpeciesTotalInertWeight(inertBatch.getWeight());
        }
        SortingBatch livingNotItemizedBatch = this.catchBatchDao.getSortingBatch(speciesBatch.getChildBatchs(), new Object[]{"referenceTaxonId", this.enumeration.REFERENCE_TAXON_ID_LIFE});
        if (log.isInfoEnabled()) {
            log.info((Object)("Loaded CatchBatch Vrac > Species > Alive not itemized: " + livingNotItemizedBatch.getId()));
        }
        if (livingNotItemizedBatch != null) {
            result.setSpeciesTotalLivingNotItemizedWeight(livingNotItemizedBatch.getWeight());
        }
        SortingBatch benthosBatch = this.catchBatchDao.getSortingBatch(vracBatch.getChildBatchs(), new Object[]{"pmfmId", this.enumeration.PMFM_ID_SORTING_TYPE, this.enumeration.QUALITATIVE_ID_SORTING_TYPE_BENTHOS});
        if (log.isInfoEnabled()) {
            log.info((Object)("Loaded CatchBatch Vrac > Benthos: " + benthosBatch.getId()));
        }
        result.setBenthosTotalSortedWeight(benthosBatch.getWeight());
        SortingBatch inertBatch2 = this.catchBatchDao.getSortingBatch(benthosBatch.getChildBatchs(), new Object[]{"referenceTaxonId", this.enumeration.REFERENCE_TAXON_ID_INERT});
        if (log.isInfoEnabled()) {
            log.info((Object)("Loaded CatchBatch Vrac > Benthos > Inert: " + inertBatch2.getId()));
        }
        if (inertBatch2 != null) {
            result.setBenthosTotalInertWeight(inertBatch2.getWeight());
        }
        SortingBatch livingNotItemizedBatch2 = this.catchBatchDao.getSortingBatch(benthosBatch.getChildBatchs(), new Object[]{"referenceTaxonId", this.enumeration.REFERENCE_TAXON_ID_LIFE});
        if (log.isInfoEnabled()) {
            log.info((Object)("Loaded CatchBatch Vrac > Benthos > Alive not itemized: " + livingNotItemizedBatch2.getId()));
        }
        if (livingNotItemizedBatch2 != null) {
            result.setBenthosTotalLivingNotItemizedWeight(livingNotItemizedBatch2.getWeight());
        }
        if ((horsVracBatch = this.catchBatchDao.getSortingBatch(source.getChildBatchs(), new Object[]{"pmfmId", this.enumeration.PMFM_ID_SORTED_UNSORTED, this.enumeration.QUALITATIVE_HORS_VRAC_ID})) != null) {
            SortingBatch benthosBatch2;
            SortingBatch speciesBatch2;
            if (log.isInfoEnabled()) {
                log.info((Object)("Loaded CatchBatch Hors Vrac: " + horsVracBatch.getId()));
            }
            if ((speciesBatch2 = this.catchBatchDao.getSortingBatch(horsVracBatch.getChildBatchs(), new Object[]{"pmfmId", this.enumeration.PMFM_ID_SORTING_TYPE, this.enumeration.QUALITATIVE_ID_SORTING_TYPE_SPECIES})) != null && log.isInfoEnabled()) {
                log.info((Object)("Loaded CatchBatch Hors Vrac> Species: " + speciesBatch2.getId()));
            }
            if ((benthosBatch2 = this.catchBatchDao.getSortingBatch(horsVracBatch.getChildBatchs(), new Object[]{"pmfmId", this.enumeration.PMFM_ID_SORTING_TYPE, this.enumeration.QUALITATIVE_ID_SORTING_TYPE_BENTHOS})) != null && log.isInfoEnabled()) {
                log.info((Object)("Loaded CatchBatch Hors Vrac> Benthos: " + benthosBatch2.getId()));
            }
        }
        SortingBatch unsortedBatch = this.catchBatchDao.getSortingBatch(source.getChildBatchs(), new Object[]{"pmfmId", this.enumeration.PMFM_ID_SORTED_UNSORTED, this.enumeration.QUALITATIVE_UNSORTED_ID});
        if (log.isInfoEnabled()) {
            log.info((Object)("Loaded CatchBatch Unsorted: " + unsortedBatch.getId()));
        }
        if (unsortedBatch != null) {
            result.setCatchTotalRejectedWeight(unsortedBatch.getWeight());
        }
        return result;
    }

    @Override
    public CatchBatch createCatchBatch(CatchBatch bean) {
        Preconditions.checkNotNull((Object)bean);
        Preconditions.checkArgument((bean.getId() == null ? 1 : 0) != 0);
        Preconditions.checkNotNull((Object)bean.getFishingOperation());
        Preconditions.checkNotNull((Object)bean.getFishingOperation().getId());
        fr.ifremer.adagio.core.dao.data.batch.CatchBatch catchBatch = CatchBatch.Factory.newInstance();
        this.catchBatchToEntity(bean, catchBatch);
        catchBatch = this.catchBatchDao.create(catchBatch);
        bean.setId(catchBatch.getId());
        this.getCurrentSession().flush();
        Integer fishingOperationId = bean.getFishingOperation().getIdAsInt();
        int rowUpdated = this.queryUpdate("updateFishingOperationCatchBatch", "fishingOperationId", IntegerType.INSTANCE, fishingOperationId, "catchBatchId", IntegerType.INSTANCE, catchBatch.getId());
        if (rowUpdated == 0) {
            throw new DataIntegrityViolationException("Could not attach catch batch to the given operation : operation was not found.");
        }
        return bean;
    }

    @Override
    public CatchBatch saveCatchBatch(CatchBatch bean) {
        Preconditions.checkNotNull((Object)bean);
        Preconditions.checkNotNull((Object)bean.getId());
        Preconditions.checkNotNull((Object)bean.getFishingOperation());
        Preconditions.checkNotNull((Object)bean.getFishingOperation().getId());
        this.getCurrentSession().enableFetchProfile("batch-with-childs");
        this.getCurrentSession().setFlushMode(FlushMode.COMMIT);
        fr.ifremer.adagio.core.dao.data.batch.CatchBatch catchBatch = this.catchBatchDao.load(bean.getIdAsInt());
        if (catchBatch == null) {
            throw new DataRetrievalFailureException("Could not retrieve catch batch with id=" + bean.getId());
        }
        this.catchBatchToEntity(bean, catchBatch);
        this.catchBatchDao.update(catchBatch);
        this.getCurrentSession().flush();
        return bean;
    }

    protected void catchBatchToEntity(CatchBatch source, fr.ifremer.adagio.core.dao.data.batch.CatchBatch target) {
        SortingBatch aliveNotItemizedBatch;
        SortingBatch aliveNotItemizedBatch2;
        Map<Integer, SortingBatch> batchChilds;
        SortingBatch speciesBatch;
        Map<Integer, SortingBatch> catchBatchChilds;
        SortingBatch batch;
        Preconditions.checkNotNull((Object)source.getFishingOperation());
        Preconditions.checkNotNull((Object)source.getFishingOperation().getId());
        Integer recorderDepartmentId = this.getRecorderDepartmentId();
        Integer fishingOperationId = source.getFishingOperation().getIdAsInt();
        target.setFishingOperation((FishingOperation)this.load(FishingOperationImpl.class, fishingOperationId));
        target.setQualityFlag((QualityFlag)this.load(QualityFlagImpl.class, (Serializable)((Object)this.enumeration.QUALITY_FLAG_CODE_NOT_QUALIFIED)));
        target.setRankOrder(Short.valueOf((short)1));
        target.setSynchronizationStatus(SynchronizationStatus.DIRTY.getValue());
        Collection quantificationMeasurements = target.getQuantificationMeasurements();
        HashSet notChangedQuantificationMeasurements = Sets.newHashSet();
        if (quantificationMeasurements != null) {
            notChangedQuantificationMeasurements.addAll(quantificationMeasurements);
        }
        if (source.getCatchTotalWeight() != null) {
            QuantificationMeasurement quantificationMeasurement = this.catchBatchDao.setQuantificationMeasurement((Batch)target, this.enumeration.PMFM_ID_WEIGHT_MEASURED, recorderDepartmentId, source.getCatchTotalWeight(), true);
            notChangedQuantificationMeasurements.remove(quantificationMeasurement);
        }
        if (quantificationMeasurements != null) {
            quantificationMeasurements.removeAll(notChangedQuantificationMeasurements);
        }
        if ((batch = (catchBatchChilds = this.getChildsMap((Batch)target, this.enumeration.PMFM_ID_SORTED_UNSORTED)).get(this.enumeration.QUALITATIVE_VRAC_ID)) == null) {
            batch = SortingBatch.Factory.newInstance();
            target.getChildBatchs().add(batch);
        }
        this.beanToEntitySortingBatch(target, (Batch)target, batch, recorderDepartmentId, this.enumeration.PMFM_ID_SORTED_UNSORTED, this.enumeration.QUALITATIVE_VRAC_ID, source.getCatchTotalSortedCarousselWeight(), source.getCatchTotalSortedTremisWeight());
        batch.setRankOrder(Short.valueOf((short)1));
        if (batch.getChildBatchs() == null) {
            batch.setChildBatchs((Collection)Lists.newArrayList());
        }
        if ((speciesBatch = (batchChilds = this.getChildsMap((Batch)batch, this.enumeration.PMFM_ID_SORTING_TYPE)).get(this.enumeration.QUALITATIVE_ID_SORTING_TYPE_SPECIES)) == null) {
            speciesBatch = SortingBatch.Factory.newInstance();
            batch.getChildBatchs().add(speciesBatch);
        }
        this.beanToEntitySortingBatch(target, (Batch)batch, speciesBatch, recorderDepartmentId, this.enumeration.PMFM_ID_SORTING_TYPE, this.enumeration.QUALITATIVE_ID_SORTING_TYPE_SPECIES, source.getSpeciesTotalSortedWeight(), null);
        speciesBatch.setRankOrder(Short.valueOf((short)1));
        if (speciesBatch.getChildBatchs() == null) {
            speciesBatch.setChildBatchs((Collection)Lists.newArrayList());
        }
        if ((aliveNotItemizedBatch2 = this.catchBatchDao.getSortingBatch(speciesBatch.getChildBatchs(), new Object[]{"referenceTaxonId", this.enumeration.REFERENCE_TAXON_ID_LIFE})) == null) {
            aliveNotItemizedBatch2 = SortingBatch.Factory.newInstance();
            speciesBatch.getChildBatchs().add(aliveNotItemizedBatch2);
        }
        this.beanToEntityReferenceTaxonBatch(target, (Batch)speciesBatch, aliveNotItemizedBatch2, recorderDepartmentId, this.enumeration.REFERENCE_TAXON_ID_LIFE, source.getSpeciesTotalLivingNotItemizedWeight(), null);
        aliveNotItemizedBatch2.setRankOrder(Short.valueOf((short)1));
        SortingBatch inertBatch = this.catchBatchDao.getSortingBatch(speciesBatch.getChildBatchs(), new Object[]{"referenceTaxonId", this.enumeration.REFERENCE_TAXON_ID_INERT});
        if (inertBatch == null) {
            inertBatch = SortingBatch.Factory.newInstance();
            speciesBatch.getChildBatchs().add(inertBatch);
        }
        this.beanToEntityReferenceTaxonBatch(target, (Batch)speciesBatch, inertBatch, recorderDepartmentId, this.enumeration.REFERENCE_TAXON_ID_INERT, source.getSpeciesTotalInertWeight(), null);
        inertBatch.setRankOrder(Short.valueOf((short)2));
        SortingBatch benthosBatch = batchChilds.get(this.enumeration.QUALITATIVE_ID_SORTING_TYPE_BENTHOS);
        if (benthosBatch == null) {
            benthosBatch = SortingBatch.Factory.newInstance();
            batch.getChildBatchs().add(benthosBatch);
        }
        this.beanToEntitySortingBatch(target, (Batch)batch, benthosBatch, recorderDepartmentId, this.enumeration.PMFM_ID_SORTING_TYPE, this.enumeration.QUALITATIVE_ID_SORTING_TYPE_BENTHOS, source.getBenthosTotalSortedWeight(), null);
        benthosBatch.setRankOrder(Short.valueOf((short)2));
        if (benthosBatch.getChildBatchs() == null) {
            benthosBatch.setChildBatchs((Collection)Lists.newArrayList());
        }
        if ((aliveNotItemizedBatch = this.catchBatchDao.getSortingBatch(benthosBatch.getChildBatchs(), new Object[]{"referenceTaxonId", this.enumeration.REFERENCE_TAXON_ID_LIFE})) == null) {
            aliveNotItemizedBatch = SortingBatch.Factory.newInstance();
            benthosBatch.getChildBatchs().add(aliveNotItemizedBatch);
        }
        this.beanToEntityReferenceTaxonBatch(target, (Batch)benthosBatch, aliveNotItemizedBatch, recorderDepartmentId, this.enumeration.REFERENCE_TAXON_ID_LIFE, source.getBenthosTotalLivingNotItemizedWeight(), null);
        aliveNotItemizedBatch.setRankOrder(Short.valueOf((short)1));
        SortingBatch inertBatch2 = this.catchBatchDao.getSortingBatch(benthosBatch.getChildBatchs(), new Object[]{"referenceTaxonId", this.enumeration.REFERENCE_TAXON_ID_INERT});
        if (inertBatch2 == null) {
            inertBatch2 = SortingBatch.Factory.newInstance();
            benthosBatch.getChildBatchs().add(inertBatch2);
        }
        this.beanToEntityReferenceTaxonBatch(target, (Batch)benthosBatch, inertBatch2, recorderDepartmentId, this.enumeration.REFERENCE_TAXON_ID_INERT, source.getBenthosTotalInertWeight(), null);
        inertBatch2.setRankOrder(Short.valueOf((short)2));
        batch = catchBatchChilds.get(this.enumeration.QUALITATIVE_HORS_VRAC_ID);
        if (batch == null) {
            batch = SortingBatch.Factory.newInstance();
            target.getChildBatchs().add(batch);
        }
        this.beanToEntitySortingBatch(target, (Batch)target, batch, recorderDepartmentId, this.enumeration.PMFM_ID_SORTED_UNSORTED, this.enumeration.QUALITATIVE_HORS_VRAC_ID, null, null);
        batch.setRankOrder(Short.valueOf((short)2));
        batchChilds = this.getChildsMap((Batch)batch, this.enumeration.PMFM_ID_SORTING_TYPE);
        speciesBatch = batchChilds.get(this.enumeration.QUALITATIVE_ID_SORTING_TYPE_SPECIES);
        if (speciesBatch == null) {
            speciesBatch = SortingBatch.Factory.newInstance();
            if (batch.getChildBatchs() == null) {
                batch.setChildBatchs((Collection)Lists.newArrayList((Object[])new Batch[]{speciesBatch}));
            } else {
                batch.getChildBatchs().add(speciesBatch);
            }
        }
        this.beanToEntitySortingBatch(target, (Batch)batch, speciesBatch, recorderDepartmentId, this.enumeration.PMFM_ID_SORTING_TYPE, this.enumeration.QUALITATIVE_ID_SORTING_TYPE_SPECIES, null, null);
        speciesBatch.setRankOrder(Short.valueOf((short)1));
        SortingBatch benthosBatch2 = batchChilds.get(this.enumeration.QUALITATIVE_ID_SORTING_TYPE_BENTHOS);
        if (benthosBatch2 == null) {
            benthosBatch2 = SortingBatch.Factory.newInstance();
            batch.getChildBatchs().add(benthosBatch2);
        }
        this.beanToEntitySortingBatch(target, (Batch)batch, benthosBatch2, recorderDepartmentId, this.enumeration.PMFM_ID_SORTING_TYPE, this.enumeration.QUALITATIVE_ID_SORTING_TYPE_BENTHOS, null, null);
        benthosBatch2.setRankOrder(Short.valueOf((short)2));
        SortingBatch unsortedBatch = catchBatchChilds.get(this.enumeration.QUALITATIVE_UNSORTED_ID);
        if (unsortedBatch == null) {
            unsortedBatch = SortingBatch.Factory.newInstance();
            target.getChildBatchs().add(unsortedBatch);
        }
        this.beanToEntitySortingBatch(target, (Batch)target, unsortedBatch, recorderDepartmentId, this.enumeration.PMFM_ID_SORTED_UNSORTED, this.enumeration.QUALITATIVE_UNSORTED_ID, source.getCatchTotalRejectedWeight(), null);
        unsortedBatch.setRankOrder(Short.valueOf((short)3));
    }

    protected Map<Integer, SortingBatch> getChildsMap(Batch parentBatch, Integer pmfmId) {
        HashMap batchByQualitativeValueId = Maps.newHashMap();
        if (parentBatch.getChildBatchs() == null) {
            return batchByQualitativeValueId;
        }
        for (Batch childBatch : parentBatch.getChildBatchs()) {
            SortingBatch childSortingBatch = (SortingBatch)childBatch;
            SortingMeasurement sm = this.catchBatchDao.getSortingMeasurement((SortingBatch)childBatch, pmfmId, null, false);
            if (sm == null || sm.getQualitativeValue() == null || sm.getQualitativeValue().getId() == null) continue;
            batchByQualitativeValueId.put(sm.getQualitativeValue().getId(), childSortingBatch);
        }
        return batchByQualitativeValueId;
    }

    protected void beanToEntitySortingBatch(fr.ifremer.adagio.core.dao.data.batch.CatchBatch rootBatch, Batch parentBatch, SortingBatch target, Integer recorderDepartmentId, Integer sortingPmfmId, Integer sortingQualitativeValueId, Float weight, Float sampleWeight) {
        Collection quantificationMeasurements = target.getQuantificationMeasurements();
        Collection sortingMeasurements = target.getSortingMeasurements();
        HashSet notChangedQuantificationMeasurements = Sets.newHashSet();
        if (quantificationMeasurements != null) {
            notChangedQuantificationMeasurements.addAll(quantificationMeasurements);
        }
        HashSet notChangedSortingMeasurements = Sets.newHashSet();
        if (sortingMeasurements != null) {
            notChangedSortingMeasurements.addAll(sortingMeasurements);
        }
        target.setQualityFlag((QualityFlag)this.load(QualityFlagImpl.class, (Serializable)((Object)this.enumeration.QUALITY_FLAG_CODE_NOT_QUALIFIED)));
        target.setRootBatch(rootBatch);
        target.setParentBatch(parentBatch);
        target.setExhaustiveInventory(Boolean.valueOf(true));
        target.setReferenceTaxon(null);
        target.setTaxonGroup(null);
        if (sortingPmfmId != null && sortingQualitativeValueId != null) {
            SortingMeasurement sm = this.batchHelper.setSortingMeasurement(target, recorderDepartmentId, sortingPmfmId, (Serializable)sortingQualitativeValueId);
            notChangedSortingMeasurements.remove(sm);
        }
        if (sampleWeight == null || weight == null) {
            target.setSamplingRatio(null);
            target.setSamplingRatioText(null);
        } else {
            String samplingRatioText = weight + "/" + sampleWeight;
            samplingRatioText = samplingRatioText.replaceAll(",", ".");
            target.setSamplingRatioText(samplingRatioText);
            target.setSamplingRatio(Float.valueOf(weight.floatValue() / sampleWeight.floatValue()));
        }
        if (sampleWeight != null || weight != null) {
            Float batchReferenceWeight = weight;
            if (batchReferenceWeight == null) {
                batchReferenceWeight = sampleWeight;
            }
            QuantificationMeasurement quantificationMeasurement = this.catchBatchDao.setQuantificationMeasurement((Batch)target, this.enumeration.PMFM_ID_WEIGHT_MEASURED, recorderDepartmentId, batchReferenceWeight, true);
            notChangedQuantificationMeasurements.remove(quantificationMeasurement);
        }
        if (quantificationMeasurements != null) {
            quantificationMeasurements.removeAll(notChangedQuantificationMeasurements);
        }
        if (sortingMeasurements != null) {
            sortingMeasurements.removeAll(notChangedSortingMeasurements);
        }
    }

    protected void beanToEntityReferenceTaxonBatch(fr.ifremer.adagio.core.dao.data.batch.CatchBatch rootBatch, Batch parentBatch, SortingBatch target, Integer recorderDepartmentId, Integer referenceTaxonId, Float weight, Float sampleWeight) {
        Collection quantificationMeasurements = target.getQuantificationMeasurements();
        Collection sortingMeasurements = target.getSortingMeasurements();
        HashSet notChangedQuantificationMeasurements = Sets.newHashSet();
        if (quantificationMeasurements != null) {
            notChangedQuantificationMeasurements.addAll(quantificationMeasurements);
        }
        HashSet notChangedSortingMeasurements = Sets.newHashSet();
        if (sortingMeasurements != null) {
            notChangedSortingMeasurements.addAll(sortingMeasurements);
        }
        target.setQualityFlag((QualityFlag)this.load(QualityFlagImpl.class, (Serializable)((Object)this.enumeration.QUALITY_FLAG_CODE_NOT_QUALIFIED)));
        target.setRootBatch(rootBatch);
        target.setParentBatch(parentBatch);
        target.setExhaustiveInventory(Boolean.valueOf(true));
        target.setReferenceTaxon((ReferenceTaxon)this.load(ReferenceTaxonImpl.class, referenceTaxonId));
        target.setTaxonGroup(null);
        if (sampleWeight == null || weight == null) {
            target.setSamplingRatio(null);
            target.setSamplingRatioText(null);
        } else {
            String samplingRatioText = weight + "/" + sampleWeight;
            samplingRatioText = samplingRatioText.replaceAll(",", ".");
            target.setSamplingRatioText(samplingRatioText);
            target.setSamplingRatio(Float.valueOf(weight.floatValue() / sampleWeight.floatValue()));
        }
        if (sampleWeight != null || weight != null) {
            Float batchReferenceWeight = weight;
            if (batchReferenceWeight == null) {
                batchReferenceWeight = sampleWeight;
            }
            QuantificationMeasurement quantificationMeasurement = this.catchBatchDao.setQuantificationMeasurement((Batch)target, this.enumeration.PMFM_ID_WEIGHT_MEASURED, recorderDepartmentId, batchReferenceWeight, true);
            notChangedQuantificationMeasurements.remove(quantificationMeasurement);
        }
        if (quantificationMeasurements != null) {
            quantificationMeasurements.removeAll(notChangedQuantificationMeasurements);
        }
        if (sortingMeasurements != null) {
            sortingMeasurements.removeAll(notChangedSortingMeasurements);
        }
    }

    protected Integer getRecorderDepartmentId() {
        return this.enumeration.DEPARTMENT_ID_UNKNOWN_RECORDER_DEPARTMENT;
    }
}

